/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.CreditMemoApplicationRequest;
import org.threeten.bp.LocalDate;

public class ApplyUnapplyCreditMemo {
    public static final String SERIALIZED_NAME_EFFECTIVE_DATE = "effective_date";
    @SerializedName(value="effective_date")
    private LocalDate effectiveDate;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENTS = "billing_documents";
    @SerializedName(value="billing_documents")
    private List<CreditMemoApplicationRequest> billingDocuments = new ArrayList<CreditMemoApplicationRequest>();

    public ApplyUnapplyCreditMemo effectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the credit memo is applied")
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public ApplyUnapplyCreditMemo billingDocuments(List<CreditMemoApplicationRequest> billingDocuments) {
        this.billingDocuments = billingDocuments;
        return this;
    }

    public ApplyUnapplyCreditMemo addBillingDocumentsItem(CreditMemoApplicationRequest billingDocumentsItem) {
        this.billingDocuments.add(billingDocumentsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Array of billing documents to apply this credit memo to.")
    public List<CreditMemoApplicationRequest> getBillingDocuments() {
        return this.billingDocuments;
    }

    public void setBillingDocuments(List<CreditMemoApplicationRequest> billingDocuments) {
        this.billingDocuments = billingDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplyUnapplyCreditMemo applyUnapplyCreditMemo = (ApplyUnapplyCreditMemo)o;
        return Objects.equals(this.effectiveDate, applyUnapplyCreditMemo.effectiveDate) && Objects.equals(this.billingDocuments, applyUnapplyCreditMemo.billingDocuments);
    }

    public int hashCode() {
        return Objects.hash(this.effectiveDate, this.billingDocuments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplyUnapplyCreditMemo {\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    billingDocuments: ").append(this.toIndentedString(this.billingDocuments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

