/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

public class Prepayment {
    public static final String SERIALIZED_NAME_CREDIT_OPTION = "credit_option";
    @SerializedName(value="credit_option")
    private CreditOptionEnum creditOption;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_TOTAL_QUANTITY = "total_quantity";
    @SerializedName(value="total_quantity")
    private BigDecimal totalQuantity;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_VALIDITY_PERIOD = "validity_period";
    @SerializedName(value="validity_period")
    private ValidityPeriodEnum validityPeriod;

    public Prepayment creditOption(CreditOptionEnum creditOption) {
        this.creditOption = creditOption;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The way to calculate credit. See <a href='https://knowledgecenter.zuora.com/Zuora_Billing/Billing_and_Invoicing/JA_Advanced_Consumption_Billing/Prepaid_with_Drawdown/A_Create_prepayment_charge#Credit_Option'  target='_blank'>Credit Option</a> for more information.")
    public CreditOptionEnum getCreditOption() {
        return this.creditOption;
    }

    public void setCreditOption(CreditOptionEnum creditOption) {
        this.creditOption = creditOption;
    }

    public Prepayment quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of units included in a prepayment charge.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public Prepayment totalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount of units that end customers can use during a validity period when they subscribe to a prepayment charge.")
    public BigDecimal getTotalQuantity() {
        return this.totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public Prepayment unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A configured unit of measure. This field is required for per-unit prices.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public Prepayment validityPeriod(ValidityPeriodEnum validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The period in which the prepayment units are valid to use as defined in a prepayment charge.")
    public ValidityPeriodEnum getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(ValidityPeriodEnum validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Prepayment prepayment = (Prepayment)o;
        return Objects.equals((Object)this.creditOption, (Object)prepayment.creditOption) && Objects.equals(this.quantity, prepayment.quantity) && Objects.equals(this.totalQuantity, prepayment.totalQuantity) && Objects.equals(this.unitOfMeasure, prepayment.unitOfMeasure) && Objects.equals((Object)this.validityPeriod, (Object)prepayment.validityPeriod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.creditOption, this.quantity, this.totalQuantity, this.unitOfMeasure, this.validityPeriod});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Prepayment {\n");
        sb.append("    creditOption: ").append(this.toIndentedString((Object)this.creditOption)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    totalQuantity: ").append(this.toIndentedString(this.totalQuantity)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    validityPeriod: ").append(this.toIndentedString((Object)this.validityPeriod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ValidityPeriodEnum {
        SUBSCRIPTION_TERM("subscription_term"),
        ANNUAL("annual"),
        SEMI_ANNUAL("semi_annual"),
        QUARTER("quarter"),
        MONTH("month"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ValidityPeriodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ValidityPeriodEnum fromValue(String value) {
            for (ValidityPeriodEnum b : ValidityPeriodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ValidityPeriodEnum> {
            public void write(JsonWriter jsonWriter, ValidityPeriodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ValidityPeriodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ValidityPeriodEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CreditOptionEnum {
        TIME_BASED("time_based"),
        CONSUMPTION_BASED("consumption_based"),
        FULL_CREDIT("full_credit"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CreditOptionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CreditOptionEnum fromValue(String value) {
            for (CreditOptionEnum b : CreditOptionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CreditOptionEnum> {
            public void write(JsonWriter jsonWriter, CreditOptionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CreditOptionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CreditOptionEnum.fromValue(value);
            }
        }
    }
}

