/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.PaymentScheduleItem;
import org.openapitools.client.model.PaymentScheduleItemCreateRequest;
import org.openapitools.client.model.PaymentScheduleItemPatch;
import org.openapitools.client.model.PaymentScheduleItemRetry;

public class PaymentScheduleItemsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentScheduleItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentScheduleItemsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cancelPaymentScheduleItemCall(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_schedule_items/{payment_schedule_item_id}/cancel".replace("{payment_schedule_item_id}", this.localVarApiClient.escapeString(paymentScheduleItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPaymentScheduleItemValidateBeforeCall(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleItemId == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleItemId' when calling cancelPaymentScheduleItem(Async)");
        }
        return this.cancelPaymentScheduleItemCall(paymentScheduleItemId, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentScheduleItem> cancelPaymentScheduleItemWithHttpInfo(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelPaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelPaymentScheduleItemAsync(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentScheduleItem> _callback) throws ApiException {
        Call localVarCall = this.cancelPaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelPaymentScheduleItemParams cancelPaymentScheduleItemParams(String paymentScheduleItemId) {
        return new CancelPaymentScheduleItemParams(paymentScheduleItemId);
    }

    public PaymentScheduleItem cancelPaymentScheduleItem(String paymentScheduleItemId) throws ApiException {
        CancelPaymentScheduleItemParams params = new CancelPaymentScheduleItemParams(paymentScheduleItemId);
        return this.executeCancelPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem cancelPaymentScheduleItem(String paymentScheduleItemId, List<String> expand) throws ApiException {
        CancelPaymentScheduleItemParams params = new CancelPaymentScheduleItemParams(paymentScheduleItemId);
        params.expand(expand);
        return this.executeCancelPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem cancelPaymentScheduleItem(String paymentScheduleItemId, List<String> expand, Headers headers) throws ApiException {
        CancelPaymentScheduleItemParams params = new CancelPaymentScheduleItemParams(paymentScheduleItemId).expand(expand).headers(headers);
        return this.executeCancelPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem post(CancelPaymentScheduleItemParams params) throws ApiException {
        return this.executeCancelPaymentScheduleItemAPICall(params).getData();
    }

    public ApiResponse<PaymentScheduleItem> postWithHttpInfo(CancelPaymentScheduleItemParams params) throws ApiException {
        return this.executeCancelPaymentScheduleItemAPICall(params);
    }

    ApiResponse<PaymentScheduleItem> executeCancelPaymentScheduleItemAPICall(CancelPaymentScheduleItemParams params) throws ApiException {
        return this.cancelPaymentScheduleItemWithHttpInfo(params.paymentScheduleItemId, params.fields, params.paymentScheduleItemFields, params.paymentScheduleFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call createPaymentScheduleItemCall(PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentScheduleItemCreateRequest localVarPostBody = paymentScheduleItemCreateRequest;
        String localVarPath = "/payment_schedule_items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentScheduleItemValidateBeforeCall(PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleItemCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleItemCreateRequest' when calling createPaymentScheduleItem(Async)");
        }
        return this.createPaymentScheduleItemCall(paymentScheduleItemCreateRequest, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentScheduleItem> createPaymentScheduleItemWithHttpInfo(PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createPaymentScheduleItemValidateBeforeCall(paymentScheduleItemCreateRequest, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createPaymentScheduleItemAsync(PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentScheduleItem> _callback) throws ApiException {
        Call localVarCall = this.createPaymentScheduleItemValidateBeforeCall(paymentScheduleItemCreateRequest, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentScheduleItemParams createPaymentScheduleItemParams(PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest) {
        return new CreatePaymentScheduleItemParams(paymentScheduleItemCreateRequest);
    }

    public PaymentScheduleItem createPaymentScheduleItem(PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest) throws ApiException {
        CreatePaymentScheduleItemParams params = new CreatePaymentScheduleItemParams(paymentScheduleItemCreateRequest);
        return this.executeCreatePaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem createPaymentScheduleItem(PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest, List<String> expand) throws ApiException {
        CreatePaymentScheduleItemParams params = new CreatePaymentScheduleItemParams(paymentScheduleItemCreateRequest);
        params.expand(expand);
        return this.executeCreatePaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem createPaymentScheduleItem(PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreatePaymentScheduleItemParams params = new CreatePaymentScheduleItemParams(paymentScheduleItemCreateRequest).expand(expand).headers(headers);
        return this.executeCreatePaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem create(CreatePaymentScheduleItemParams params) throws ApiException {
        return this.executeCreatePaymentScheduleItemAPICall(params).getData();
    }

    public ApiResponse<PaymentScheduleItem> createWithHttpInfo(CreatePaymentScheduleItemParams params) throws ApiException {
        return this.executeCreatePaymentScheduleItemAPICall(params);
    }

    ApiResponse<PaymentScheduleItem> executeCreatePaymentScheduleItemAPICall(CreatePaymentScheduleItemParams params) throws ApiException {
        return this.createPaymentScheduleItemWithHttpInfo(params.paymentScheduleItemCreateRequest, params.fields, params.paymentScheduleItemFields, params.paymentScheduleFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getPaymentScheduleItemCall(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_schedule_items/{payment_schedule_item_id}".replace("{payment_schedule_item_id}", this.localVarApiClient.escapeString(paymentScheduleItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentScheduleItemValidateBeforeCall(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleItemId == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleItemId' when calling getPaymentScheduleItem(Async)");
        }
        return this.getPaymentScheduleItemCall(paymentScheduleItemId, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentScheduleItem> getPaymentScheduleItemWithHttpInfo(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentScheduleItemAsync(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentScheduleItem> _callback) throws ApiException {
        Call localVarCall = this.getPaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentScheduleItemParams getPaymentScheduleItemParams(String paymentScheduleItemId) {
        return new GetPaymentScheduleItemParams(paymentScheduleItemId);
    }

    public PaymentScheduleItem getPaymentScheduleItem(String paymentScheduleItemId) throws ApiException {
        GetPaymentScheduleItemParams params = new GetPaymentScheduleItemParams(paymentScheduleItemId);
        return this.executeGetPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem getPaymentScheduleItem(String paymentScheduleItemId, List<String> expand) throws ApiException {
        GetPaymentScheduleItemParams params = new GetPaymentScheduleItemParams(paymentScheduleItemId);
        params.expand(expand);
        return this.executeGetPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem getPaymentScheduleItem(String paymentScheduleItemId, List<String> expand, Headers headers) throws ApiException {
        GetPaymentScheduleItemParams params = new GetPaymentScheduleItemParams(paymentScheduleItemId).expand(expand).headers(headers);
        return this.executeGetPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem get(GetPaymentScheduleItemParams params) throws ApiException {
        return this.executeGetPaymentScheduleItemAPICall(params).getData();
    }

    public ApiResponse<PaymentScheduleItem> getWithHttpInfo(GetPaymentScheduleItemParams params) throws ApiException {
        return this.executeGetPaymentScheduleItemAPICall(params);
    }

    ApiResponse<PaymentScheduleItem> executeGetPaymentScheduleItemAPICall(GetPaymentScheduleItemParams params) throws ApiException {
        return this.getPaymentScheduleItemWithHttpInfo(params.paymentScheduleItemId, params.fields, params.paymentScheduleItemFields, params.paymentScheduleFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call retryPaymentScheduleItemCall(String paymentScheduleItemId, PaymentScheduleItemRetry paymentScheduleItemRetry, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentScheduleItemRetry localVarPostBody = paymentScheduleItemRetry;
        String localVarPath = "/payment_schedule_items/{payment_schedule_item_id}/retry".replace("{payment_schedule_item_id}", this.localVarApiClient.escapeString(paymentScheduleItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retryPaymentScheduleItemValidateBeforeCall(String paymentScheduleItemId, PaymentScheduleItemRetry paymentScheduleItemRetry, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleItemId == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleItemId' when calling retryPaymentScheduleItem(Async)");
        }
        if (paymentScheduleItemRetry == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleItemRetry' when calling retryPaymentScheduleItem(Async)");
        }
        return this.retryPaymentScheduleItemCall(paymentScheduleItemId, paymentScheduleItemRetry, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentScheduleItem> retryPaymentScheduleItemWithHttpInfo(String paymentScheduleItemId, PaymentScheduleItemRetry paymentScheduleItemRetry, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.retryPaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, paymentScheduleItemRetry, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call retryPaymentScheduleItemAsync(String paymentScheduleItemId, PaymentScheduleItemRetry paymentScheduleItemRetry, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentScheduleItem> _callback) throws ApiException {
        Call localVarCall = this.retryPaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, paymentScheduleItemRetry, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RetryPaymentScheduleItemParams retryPaymentScheduleItemParams(String paymentScheduleItemId, PaymentScheduleItemRetry paymentScheduleItemRetry) {
        return new RetryPaymentScheduleItemParams(paymentScheduleItemId, paymentScheduleItemRetry);
    }

    public PaymentScheduleItem retryPaymentScheduleItem(String paymentScheduleItemId, PaymentScheduleItemRetry paymentScheduleItemRetry) throws ApiException {
        RetryPaymentScheduleItemParams params = new RetryPaymentScheduleItemParams(paymentScheduleItemId, paymentScheduleItemRetry);
        return this.executeRetryPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem retryPaymentScheduleItem(String paymentScheduleItemId, PaymentScheduleItemRetry paymentScheduleItemRetry, List<String> expand) throws ApiException {
        RetryPaymentScheduleItemParams params = new RetryPaymentScheduleItemParams(paymentScheduleItemId, paymentScheduleItemRetry);
        params.expand(expand);
        return this.executeRetryPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem retryPaymentScheduleItem(String paymentScheduleItemId, PaymentScheduleItemRetry paymentScheduleItemRetry, List<String> expand, Headers headers) throws ApiException {
        RetryPaymentScheduleItemParams params = new RetryPaymentScheduleItemParams(paymentScheduleItemId, paymentScheduleItemRetry).expand(expand).headers(headers);
        return this.executeRetryPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem post(RetryPaymentScheduleItemParams params) throws ApiException {
        return this.executeRetryPaymentScheduleItemAPICall(params).getData();
    }

    public ApiResponse<PaymentScheduleItem> postWithHttpInfo(RetryPaymentScheduleItemParams params) throws ApiException {
        return this.executeRetryPaymentScheduleItemAPICall(params);
    }

    ApiResponse<PaymentScheduleItem> executeRetryPaymentScheduleItemAPICall(RetryPaymentScheduleItemParams params) throws ApiException {
        return this.retryPaymentScheduleItemWithHttpInfo(params.paymentScheduleItemId, params.paymentScheduleItemRetry, params.fields, params.paymentScheduleItemFields, params.paymentScheduleFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call skipPaymentScheduleItemCall(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_schedule_items/{payment_schedule_item_id}/skip".replace("{payment_schedule_item_id}", this.localVarApiClient.escapeString(paymentScheduleItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call skipPaymentScheduleItemValidateBeforeCall(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleItemId == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleItemId' when calling skipPaymentScheduleItem(Async)");
        }
        return this.skipPaymentScheduleItemCall(paymentScheduleItemId, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentScheduleItem> skipPaymentScheduleItemWithHttpInfo(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.skipPaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call skipPaymentScheduleItemAsync(String paymentScheduleItemId, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentScheduleItem> _callback) throws ApiException {
        Call localVarCall = this.skipPaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public SkipPaymentScheduleItemParams skipPaymentScheduleItemParams(String paymentScheduleItemId) {
        return new SkipPaymentScheduleItemParams(paymentScheduleItemId);
    }

    public PaymentScheduleItem skipPaymentScheduleItem(String paymentScheduleItemId) throws ApiException {
        SkipPaymentScheduleItemParams params = new SkipPaymentScheduleItemParams(paymentScheduleItemId);
        return this.executeSkipPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem skipPaymentScheduleItem(String paymentScheduleItemId, List<String> expand) throws ApiException {
        SkipPaymentScheduleItemParams params = new SkipPaymentScheduleItemParams(paymentScheduleItemId);
        params.expand(expand);
        return this.executeSkipPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem skipPaymentScheduleItem(String paymentScheduleItemId, List<String> expand, Headers headers) throws ApiException {
        SkipPaymentScheduleItemParams params = new SkipPaymentScheduleItemParams(paymentScheduleItemId).expand(expand).headers(headers);
        return this.executeSkipPaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem post(SkipPaymentScheduleItemParams params) throws ApiException {
        return this.executeSkipPaymentScheduleItemAPICall(params).getData();
    }

    public ApiResponse<PaymentScheduleItem> postWithHttpInfo(SkipPaymentScheduleItemParams params) throws ApiException {
        return this.executeSkipPaymentScheduleItemAPICall(params);
    }

    ApiResponse<PaymentScheduleItem> executeSkipPaymentScheduleItemAPICall(SkipPaymentScheduleItemParams params) throws ApiException {
        return this.skipPaymentScheduleItemWithHttpInfo(params.paymentScheduleItemId, params.fields, params.paymentScheduleItemFields, params.paymentScheduleFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call updatePaymentScheduleItemCall(String paymentScheduleItemId, PaymentScheduleItemPatch paymentScheduleItemPatch, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentScheduleItemPatch localVarPostBody = paymentScheduleItemPatch;
        String localVarPath = "/payment_schedule_items/{payment_schedule_item_id}".replace("{payment_schedule_item_id}", this.localVarApiClient.escapeString(paymentScheduleItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentScheduleItemValidateBeforeCall(String paymentScheduleItemId, PaymentScheduleItemPatch paymentScheduleItemPatch, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleItemId == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleItemId' when calling updatePaymentScheduleItem(Async)");
        }
        if (paymentScheduleItemPatch == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleItemPatch' when calling updatePaymentScheduleItem(Async)");
        }
        return this.updatePaymentScheduleItemCall(paymentScheduleItemId, paymentScheduleItemPatch, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentScheduleItem> updatePaymentScheduleItemWithHttpInfo(String paymentScheduleItemId, PaymentScheduleItemPatch paymentScheduleItemPatch, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updatePaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, paymentScheduleItemPatch, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updatePaymentScheduleItemAsync(String paymentScheduleItemId, PaymentScheduleItemPatch paymentScheduleItemPatch, List<String> fields, List<String> paymentScheduleItemFields, List<String> paymentScheduleFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentScheduleItem> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentScheduleItemValidateBeforeCall(paymentScheduleItemId, paymentScheduleItemPatch, fields, paymentScheduleItemFields, paymentScheduleFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentScheduleItemParams updatePaymentScheduleItemParams(String paymentScheduleItemId, PaymentScheduleItemPatch paymentScheduleItemPatch) {
        return new UpdatePaymentScheduleItemParams(paymentScheduleItemId, paymentScheduleItemPatch);
    }

    public PaymentScheduleItem updatePaymentScheduleItem(String paymentScheduleItemId, PaymentScheduleItemPatch paymentScheduleItemPatch) throws ApiException {
        UpdatePaymentScheduleItemParams params = new UpdatePaymentScheduleItemParams(paymentScheduleItemId, paymentScheduleItemPatch);
        return this.executeUpdatePaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem updatePaymentScheduleItem(String paymentScheduleItemId, PaymentScheduleItemPatch paymentScheduleItemPatch, List<String> expand) throws ApiException {
        UpdatePaymentScheduleItemParams params = new UpdatePaymentScheduleItemParams(paymentScheduleItemId, paymentScheduleItemPatch);
        params.expand(expand);
        return this.executeUpdatePaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem updatePaymentScheduleItem(String paymentScheduleItemId, PaymentScheduleItemPatch paymentScheduleItemPatch, List<String> expand, Headers headers) throws ApiException {
        UpdatePaymentScheduleItemParams params = new UpdatePaymentScheduleItemParams(paymentScheduleItemId, paymentScheduleItemPatch).expand(expand).headers(headers);
        return this.executeUpdatePaymentScheduleItemAPICall(params).getData();
    }

    public PaymentScheduleItem update(UpdatePaymentScheduleItemParams params) throws ApiException {
        return this.executeUpdatePaymentScheduleItemAPICall(params).getData();
    }

    public ApiResponse<PaymentScheduleItem> updateWithHttpInfo(UpdatePaymentScheduleItemParams params) throws ApiException {
        return this.executeUpdatePaymentScheduleItemAPICall(params);
    }

    ApiResponse<PaymentScheduleItem> executeUpdatePaymentScheduleItemAPICall(UpdatePaymentScheduleItemParams params) throws ApiException {
        return this.updatePaymentScheduleItemWithHttpInfo(params.paymentScheduleItemId, params.paymentScheduleItemPatch, params.fields, params.paymentScheduleItemFields, params.paymentScheduleFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    public static class UpdatePaymentScheduleItemParams {
        private final String paymentScheduleItemId;
        private final PaymentScheduleItemPatch paymentScheduleItemPatch;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleItemFields;
        private List<String> paymentScheduleFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public UpdatePaymentScheduleItemParams(String paymentScheduleItemId, PaymentScheduleItemPatch paymentScheduleItemPatch) {
            this.paymentScheduleItemId = paymentScheduleItemId;
            this.paymentScheduleItemPatch = paymentScheduleItemPatch;
        }

        public UpdatePaymentScheduleItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdatePaymentScheduleItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdatePaymentScheduleItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdatePaymentScheduleItemParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public UpdatePaymentScheduleItemParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public UpdatePaymentScheduleItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdatePaymentScheduleItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdatePaymentScheduleItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class SkipPaymentScheduleItemParams {
        private final String paymentScheduleItemId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleItemFields;
        private List<String> paymentScheduleFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public SkipPaymentScheduleItemParams(String paymentScheduleItemId) {
            this.paymentScheduleItemId = paymentScheduleItemId;
        }

        public SkipPaymentScheduleItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public SkipPaymentScheduleItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public SkipPaymentScheduleItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public SkipPaymentScheduleItemParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public SkipPaymentScheduleItemParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public SkipPaymentScheduleItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public SkipPaymentScheduleItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public SkipPaymentScheduleItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class RetryPaymentScheduleItemParams {
        private final String paymentScheduleItemId;
        private final PaymentScheduleItemRetry paymentScheduleItemRetry;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleItemFields;
        private List<String> paymentScheduleFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public RetryPaymentScheduleItemParams(String paymentScheduleItemId, PaymentScheduleItemRetry paymentScheduleItemRetry) {
            this.paymentScheduleItemId = paymentScheduleItemId;
            this.paymentScheduleItemRetry = paymentScheduleItemRetry;
        }

        public RetryPaymentScheduleItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public RetryPaymentScheduleItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public RetryPaymentScheduleItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public RetryPaymentScheduleItemParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public RetryPaymentScheduleItemParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public RetryPaymentScheduleItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public RetryPaymentScheduleItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public RetryPaymentScheduleItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetPaymentScheduleItemParams {
        private final String paymentScheduleItemId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleItemFields;
        private List<String> paymentScheduleFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetPaymentScheduleItemParams(String paymentScheduleItemId) {
            this.paymentScheduleItemId = paymentScheduleItemId;
        }

        public GetPaymentScheduleItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetPaymentScheduleItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetPaymentScheduleItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetPaymentScheduleItemParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public GetPaymentScheduleItemParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public GetPaymentScheduleItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetPaymentScheduleItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetPaymentScheduleItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CreatePaymentScheduleItemParams {
        private final PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleItemFields;
        private List<String> paymentScheduleFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CreatePaymentScheduleItemParams(PaymentScheduleItemCreateRequest paymentScheduleItemCreateRequest) {
            this.paymentScheduleItemCreateRequest = paymentScheduleItemCreateRequest;
        }

        public CreatePaymentScheduleItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreatePaymentScheduleItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreatePaymentScheduleItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreatePaymentScheduleItemParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public CreatePaymentScheduleItemParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public CreatePaymentScheduleItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreatePaymentScheduleItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreatePaymentScheduleItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelPaymentScheduleItemParams {
        private final String paymentScheduleItemId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleItemFields;
        private List<String> paymentScheduleFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CancelPaymentScheduleItemParams(String paymentScheduleItemId) {
            this.paymentScheduleItemId = paymentScheduleItemId;
        }

        public CancelPaymentScheduleItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelPaymentScheduleItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelPaymentScheduleItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelPaymentScheduleItemParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public CancelPaymentScheduleItemParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public CancelPaymentScheduleItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelPaymentScheduleItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelPaymentScheduleItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

