/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.zuora.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Condition {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<Condition> conditions;
    public static final String SERIALIZED_NAME_FIELD = "field";
    @SerializedName(value="field")
    private String field;
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    private OperatorEnum operator;
    public static final String SERIALIZED_NAME_RELATION = "relation";
    @SerializedName(value="relation")
    private RelationEnum relation;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Condition conditions(List<Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public Condition addConditionsItem(Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public Condition field(String field) {
        this.field = field;
        return this;
    }

    @Nullable
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Condition operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @Nullable
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public Condition relation(RelationEnum relation) {
        this.relation = relation;
        return this;
    }

    @Nullable
    public RelationEnum getRelation() {
        return this.relation;
    }

    public void setRelation(RelationEnum relation) {
        this.relation = relation;
    }

    public Condition value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Condition putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.conditions, condition.conditions) && Objects.equals(this.field, condition.field) && Objects.equals((Object)this.operator, (Object)condition.operator) && Objects.equals((Object)this.relation, (Object)condition.relation) && Objects.equals(this.value, condition.value) && Objects.equals(this.additionalProperties, condition.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditions, this.field, this.operator, this.relation, this.value, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Condition {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString((Object)this.relation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Condition is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                Condition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_FIELD) != null && !jsonObj.get(SERIALIZED_NAME_FIELD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FIELD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `field` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIELD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATOR) != null && !jsonObj.get(SERIALIZED_NAME_OPERATOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPERATOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `operator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATOR) != null && !jsonObj.get(SERIALIZED_NAME_OPERATOR).isJsonNull()) {
            OperatorEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OPERATOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_RELATION) != null && !jsonObj.get(SERIALIZED_NAME_RELATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RELATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `relation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RELATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RELATION) != null && !jsonObj.get(SERIALIZED_NAME_RELATION).isJsonNull()) {
            RelationEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RELATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUE).toString()));
        }
    }

    public static Condition fromJson(String jsonString) throws IOException {
        return (Condition)JSON.getGson().fromJson(jsonString, Condition.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_FIELD);
        openapiFields.add(SERIALIZED_NAME_OPERATOR);
        openapiFields.add(SERIALIZED_NAME_RELATION);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Condition.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Condition.class));
            return new TypeAdapter<Condition>(){

                public void write(JsonWriter out, Condition value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    out.beginObject();
                    for (Map.Entry e : obj.entrySet()) {
                        out.name((String)e.getKey());
                        elementAdapter.write(out, (Object)((JsonElement)e.getValue()));
                    }
                    if (value.getAdditionalProperties() != null) {
                        boolean oldSerializeNulls = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                            } else if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                            } else if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                            } else if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                            } else if (entry.getValue() == null) {
                                obj.add(entry.getKey(), null);
                            } else {
                                JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                                if (jsonElement.isJsonArray()) {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                } else {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                                }
                            }
                            out.name(entry.getKey());
                            elementAdapter.write(out, (Object)obj.get(entry.getKey()));
                        }
                        out.setSerializeNulls(oldSerializeNulls);
                    }
                    out.endObject();
                }

                public Condition read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Condition.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    Condition instance = (Condition)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RelationEnum {
        AND("and"),
        OR("or");

        private String value;

        private RelationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RelationEnum fromValue(String value) {
            for (RelationEnum b : RelationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            RelationEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<RelationEnum> {
            public void write(JsonWriter jsonWriter, RelationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RelationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RelationEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperatorEnum {
        EQ("eq"),
        NEQ("neq"),
        GT("gt"),
        LT("lt"),
        GTE("gte"),
        LTE("lte"),
        LK("lk"),
        IN("in"),
        NL("nl"),
        NNL("nnl");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            OperatorEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<OperatorEnum> {
            public void write(JsonWriter jsonWriter, OperatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperatorEnum.fromValue(value);
            }
        }
    }
}

