/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.GetOrderActionRatePlanResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class RatePlansApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RatePlansApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RatePlansApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getRatePlanCall(String ratePlanId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getPrevRatePlanVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/rateplans/{ratePlanId}".replace("{ratePlanId}", this.localVarApiClient.escapeString(ratePlanId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (getPrevRatePlanVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("getPrevRatePlanVersion", getPrevRatePlanVersion));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRatePlanValidateBeforeCall(String ratePlanId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getPrevRatePlanVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (ratePlanId == null) {
            throw new ApiException("Missing the required parameter 'ratePlanId' when calling getRatePlan(Async)");
        }
        return this.getRatePlanCall(ratePlanId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getPrevRatePlanVersion, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetOrderActionRatePlanResponse getRatePlan(String ratePlanId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getPrevRatePlanVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetOrderActionRatePlanResponse> localVarResp = this.getRatePlanWithHttpInfo(ratePlanId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getPrevRatePlanVersion, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetOrderActionRatePlanResponse> getRatePlanWithHttpInfo(String ratePlanId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getPrevRatePlanVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getRatePlanValidateBeforeCall(ratePlanId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getPrevRatePlanVersion, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetOrderActionRatePlanResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getRatePlanAsync(String ratePlanId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getPrevRatePlanVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetOrderActionRatePlanResponse> _callback) throws ApiException {
        Call localVarCall = this.getRatePlanValidateBeforeCall(ratePlanId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getPrevRatePlanVersion, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetOrderActionRatePlanResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetRatePlanApi getRatePlanApi(String ratePlanId) {
        return new GetRatePlanApi(ratePlanId);
    }

    public class GetRatePlanApi {
        private final String ratePlanId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Boolean getPrevRatePlanVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetRatePlanApi(String ratePlanId) {
            this.ratePlanId = ratePlanId;
        }

        public GetRatePlanApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetRatePlanApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetRatePlanApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetRatePlanApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetRatePlanApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetRatePlanApi getPrevRatePlanVersion(Boolean getPrevRatePlanVersion) {
            this.getPrevRatePlanVersion = getPrevRatePlanVersion;
            return this;
        }

        public GetRatePlanApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetRatePlanApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RatePlansApi.this.getRatePlanCall(this.ratePlanId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getPrevRatePlanVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetOrderActionRatePlanResponse execute() throws ApiException {
            ApiResponse<GetOrderActionRatePlanResponse> localVarResp = RatePlansApi.this.getRatePlanWithHttpInfo(this.ratePlanId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getPrevRatePlanVersion, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetOrderActionRatePlanResponse> executeWithHttpInfo() throws ApiException {
            return RatePlansApi.this.getRatePlanWithHttpInfo(this.ratePlanId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getPrevRatePlanVersion, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetOrderActionRatePlanResponse> _callback) throws ApiException {
            return RatePlansApi.this.getRatePlanAsync(this.ratePlanId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getPrevRatePlanVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

