/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.GetDataLabelingJobResponse;
import com.zuora.model.SubmitDataLabelingJobRequest;
import com.zuora.model.SubmitDataLabelingJobResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DataLabelingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DataLabelingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataLabelingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getDataLabelingJobCall(String authorization, String jobId, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/multi-organizations/data-labeling-job/{job-id}".replace("{job-id}", this.localVarApiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDataLabelingJobValidateBeforeCall(String authorization, String jobId, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId, ApiCallback _callback) throws ApiException {
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling getDataLabelingJob(Async)");
        }
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getDataLabelingJob(Async)");
        }
        return this.getDataLabelingJobCall(authorization, jobId, acceptEncoding, contentEncoding, zuoraEntityIds, zuoraTrackId, _callback);
    }

    protected GetDataLabelingJobResponse getDataLabelingJob(String authorization, String jobId, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId) throws ApiException {
        ApiResponse<GetDataLabelingJobResponse> localVarResp = this.getDataLabelingJobWithHttpInfo(authorization, jobId, acceptEncoding, contentEncoding, zuoraEntityIds, zuoraTrackId);
        return localVarResp.getData();
    }

    private ApiResponse<GetDataLabelingJobResponse> getDataLabelingJobWithHttpInfo(String authorization, String jobId, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId) throws ApiException {
        Call localVarCall = this.getDataLabelingJobValidateBeforeCall(authorization, jobId, acceptEncoding, contentEncoding, zuoraEntityIds, zuoraTrackId, null);
        try {
            Type localVarReturnType = new TypeToken<GetDataLabelingJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getDataLabelingJobAsync(String authorization, String jobId, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId, ApiCallback<GetDataLabelingJobResponse> _callback) throws ApiException {
        Call localVarCall = this.getDataLabelingJobValidateBeforeCall(authorization, jobId, acceptEncoding, contentEncoding, zuoraEntityIds, zuoraTrackId, _callback);
        Type localVarReturnType = new TypeToken<GetDataLabelingJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDataLabelingJobApi getDataLabelingJobApi(String authorization, String jobId) {
        return new GetDataLabelingJobApi(authorization, jobId);
    }

    private Call submitDataLabelingJobCall(String authorization, SubmitDataLabelingJobRequest submitDataLabelingJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubmitDataLabelingJobRequest localVarPostBody = submitDataLabelingJobRequest;
        String localVarPath = "/v1/multi-organizations/data-labeling-job";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitDataLabelingJobValidateBeforeCall(String authorization, SubmitDataLabelingJobRequest submitDataLabelingJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId, ApiCallback _callback) throws ApiException {
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling submitDataLabelingJob(Async)");
        }
        if (submitDataLabelingJobRequest == null) {
            throw new ApiException("Missing the required parameter 'submitDataLabelingJobRequest' when calling submitDataLabelingJob(Async)");
        }
        return this.submitDataLabelingJobCall(authorization, submitDataLabelingJobRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraEntityIds, zuoraTrackId, _callback);
    }

    protected SubmitDataLabelingJobResponse submitDataLabelingJob(String authorization, SubmitDataLabelingJobRequest submitDataLabelingJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId) throws ApiException {
        ApiResponse<SubmitDataLabelingJobResponse> localVarResp = this.submitDataLabelingJobWithHttpInfo(authorization, submitDataLabelingJobRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraEntityIds, zuoraTrackId);
        return localVarResp.getData();
    }

    private ApiResponse<SubmitDataLabelingJobResponse> submitDataLabelingJobWithHttpInfo(String authorization, SubmitDataLabelingJobRequest submitDataLabelingJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId) throws ApiException {
        Call localVarCall = this.submitDataLabelingJobValidateBeforeCall(authorization, submitDataLabelingJobRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraEntityIds, zuoraTrackId, null);
        try {
            Type localVarReturnType = new TypeToken<SubmitDataLabelingJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call submitDataLabelingJobAsync(String authorization, SubmitDataLabelingJobRequest submitDataLabelingJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraEntityIds, String zuoraTrackId, ApiCallback<SubmitDataLabelingJobResponse> _callback) throws ApiException {
        Call localVarCall = this.submitDataLabelingJobValidateBeforeCall(authorization, submitDataLabelingJobRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraEntityIds, zuoraTrackId, _callback);
        Type localVarReturnType = new TypeToken<SubmitDataLabelingJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public SubmitDataLabelingJobApi submitDataLabelingJobApi(String authorization, SubmitDataLabelingJobRequest submitDataLabelingJobRequest) {
        return new SubmitDataLabelingJobApi(authorization, submitDataLabelingJobRequest);
    }

    public class SubmitDataLabelingJobApi {
        private final String authorization;
        private final SubmitDataLabelingJobRequest submitDataLabelingJobRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraEntityIds;
        private String zuoraTrackId;

        private SubmitDataLabelingJobApi(String authorization, SubmitDataLabelingJobRequest submitDataLabelingJobRequest) {
            this.authorization = authorization;
            this.submitDataLabelingJobRequest = submitDataLabelingJobRequest;
        }

        public SubmitDataLabelingJobApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public SubmitDataLabelingJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public SubmitDataLabelingJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public SubmitDataLabelingJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public SubmitDataLabelingJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataLabelingApi.this.submitDataLabelingJobCall(this.authorization, this.submitDataLabelingJobRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraEntityIds, this.zuoraTrackId, _callback);
        }

        public SubmitDataLabelingJobResponse execute() throws ApiException {
            ApiResponse<SubmitDataLabelingJobResponse> localVarResp = DataLabelingApi.this.submitDataLabelingJobWithHttpInfo(this.authorization, this.submitDataLabelingJobRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraEntityIds, this.zuoraTrackId);
            return localVarResp.getData();
        }

        public ApiResponse<SubmitDataLabelingJobResponse> executeWithHttpInfo() throws ApiException {
            return DataLabelingApi.this.submitDataLabelingJobWithHttpInfo(this.authorization, this.submitDataLabelingJobRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraEntityIds, this.zuoraTrackId);
        }

        public Call executeAsync(ApiCallback<SubmitDataLabelingJobResponse> _callback) throws ApiException {
            return DataLabelingApi.this.submitDataLabelingJobAsync(this.authorization, this.submitDataLabelingJobRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraEntityIds, this.zuoraTrackId, _callback);
        }
    }

    public class GetDataLabelingJobApi {
        private final String authorization;
        private final String jobId;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraEntityIds;
        private String zuoraTrackId;

        private GetDataLabelingJobApi(String authorization, String jobId) {
            this.authorization = authorization;
            this.jobId = jobId;
        }

        public GetDataLabelingJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDataLabelingJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDataLabelingJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDataLabelingJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataLabelingApi.this.getDataLabelingJobCall(this.authorization, this.jobId, this.acceptEncoding, this.contentEncoding, this.zuoraEntityIds, this.zuoraTrackId, _callback);
        }

        public GetDataLabelingJobResponse execute() throws ApiException {
            ApiResponse<GetDataLabelingJobResponse> localVarResp = DataLabelingApi.this.getDataLabelingJobWithHttpInfo(this.authorization, this.jobId, this.acceptEncoding, this.contentEncoding, this.zuoraEntityIds, this.zuoraTrackId);
            return localVarResp.getData();
        }

        public ApiResponse<GetDataLabelingJobResponse> executeWithHttpInfo() throws ApiException {
            return DataLabelingApi.this.getDataLabelingJobWithHttpInfo(this.authorization, this.jobId, this.acceptEncoding, this.contentEncoding, this.zuoraEntityIds, this.zuoraTrackId);
        }

        public Call executeAsync(ApiCallback<GetDataLabelingJobResponse> _callback) throws ApiException {
            return DataLabelingApi.this.getDataLabelingJobAsync(this.authorization, this.jobId, this.acceptEncoding, this.contentEncoding, this.zuoraEntityIds, this.zuoraTrackId, _callback);
        }
    }
}

