/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.GetCardList;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="If the `type` of the payment method is `apple_pay`, this hash contains details about the Apple Pay payment method. See [Supported payment methods](https://knowledgecenter.zuora.com/Billing/Billing_and_Payments/L_Payment_Methods/A_Supported_Payment_Methods) for payment gateways that support this type of payment method.")
public class GooglePay {
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private GetCardList card;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;

    public GooglePay card(GetCardList card) {
        this.card = card;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Credit card information. When providing a card number, you must meet the requirements for PCI compliance. We strongly recommend using Zuora.js instead of interacting with this API directly.")
    public GetCardList getCard() {
        return this.card;
    }

    public void setCard(GetCardList card) {
        this.card = card;
    }

    public GooglePay token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A gateway unique identifier that replaces sensitive payment method data or represents a gateway's unique customer profile. When `token` is used to represent a customer profile, `second_token` is conditionally required for representing the underlying tokenized payment method.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GooglePay googlePay = (GooglePay)o;
        return Objects.equals(this.card, googlePay.card) && Objects.equals(this.token, googlePay.token);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.card, this.token);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GooglePay {\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

