/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.Mandate;

@ApiModel(description="If the `type` of the payment method is `ach_debit`, this hash contains details about the ACH bank account.")
public class AchDebit {
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;
    public static final String SERIALIZED_NAME_BANK_ABA_CODE = "bank_aba_code";
    @SerializedName(value="bank_aba_code")
    private String bankAbaCode;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_NAME = "bank_account_name";
    @SerializedName(value="bank_account_name")
    private String bankAccountName;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_TYPE = "bank_account_type";
    @SerializedName(value="bank_account_type")
    private BankAccountTypeEnum bankAccountType;
    public static final String SERIALIZED_NAME_BANK_NAME = "bank_name";
    @SerializedName(value="bank_name")
    private String bankName;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_NUMBER = "bank_account_number";
    @SerializedName(value="bank_account_number")
    private String bankAccountNumber;

    public AchDebit mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public AchDebit bankAbaCode(String bankAbaCode) {
        this.bankAbaCode = bankAbaCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The nine-digit routing number or ABA number used by banks.")
    public String getBankAbaCode() {
        return this.bankAbaCode;
    }

    public void setBankAbaCode(String bankAbaCode) {
        this.bankAbaCode = bankAbaCode;
    }

    public AchDebit bankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the account holder, which can be either a person or a company.")
    public String getBankAccountName() {
        return this.bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public AchDebit bankAccountType(BankAccountTypeEnum bankAccountType) {
        this.bankAccountType = bankAccountType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of bank account associated with the payment method.")
    public BankAccountTypeEnum getBankAccountType() {
        return this.bankAccountType;
    }

    public void setBankAccountType(BankAccountTypeEnum bankAccountType) {
        this.bankAccountType = bankAccountType;
    }

    public AchDebit bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name of the bank associated with this bank account.")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public AchDebit bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank account number of the account holder.")
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AchDebit achDebit = (AchDebit)o;
        return Objects.equals(this.mandate, achDebit.mandate) && Objects.equals(this.bankAbaCode, achDebit.bankAbaCode) && Objects.equals(this.bankAccountName, achDebit.bankAccountName) && Objects.equals((Object)this.bankAccountType, (Object)achDebit.bankAccountType) && Objects.equals(this.bankName, achDebit.bankName) && Objects.equals(this.bankAccountNumber, achDebit.bankAccountNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mandate, this.bankAbaCode, this.bankAccountName, this.bankAccountType, this.bankName, this.bankAccountNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AchDebit {\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    bankAbaCode: ").append(this.toIndentedString(this.bankAbaCode)).append("\n");
        sb.append("    bankAccountName: ").append(this.toIndentedString(this.bankAccountName)).append("\n");
        sb.append("    bankAccountType: ").append(this.toIndentedString((Object)this.bankAccountType)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BankAccountTypeEnum {
        BUSINESS_SAVING("business_saving"),
        BUSINESS_CHECKING("business_checking"),
        CHECKING("checking"),
        SAVING("saving"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BankAccountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BankAccountTypeEnum fromValue(String value) {
            for (BankAccountTypeEnum b : BankAccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BankAccountTypeEnum> {
            public void write(JsonWriter jsonWriter, BankAccountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BankAccountTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BankAccountTypeEnum.fromValue(value);
            }
        }
    }
}

