/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

public class BillRunPreviewCreateRequest {
    public static final String SERIALIZED_NAME_ASSUME_RENEWAL = "assume_renewal";
    @SerializedName(value="assume_renewal")
    private AssumeRenewalEnum assumeRenewal;
    public static final String SERIALIZED_NAME_BATCHES = "batches";
    @SerializedName(value="batches")
    private List<String> batches = null;
    public static final String SERIALIZED_NAME_CHARGES_EXCLUDED = "charges_excluded";
    @SerializedName(value="charges_excluded")
    private List<ChargesExcludedEnum> chargesExcluded = null;
    public static final String SERIALIZED_NAME_INCLUDE_DRAFT_ITEMS = "include_draft_items";
    @SerializedName(value="include_draft_items")
    private Boolean includeDraftItems;
    public static final String SERIALIZED_NAME_INCLUDE_EVERGREEN_SUBSCRIPTIONS = "include_evergreen_subscriptions";
    @SerializedName(value="include_evergreen_subscriptions")
    private Boolean includeEvergreenSubscriptions;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;

    public BillRunPreviewCreateRequest assumeRenewal(AssumeRenewalEnum assumeRenewal) {
        this.assumeRenewal = assumeRenewal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to generate a preview of future invoice items and credit memo items with the assumption that the subscriptions are renewed. **all**: The assumption is applied to all the subscriptions. Zuora generates preview invoice item data and credit memo item data from the first day of the customer's next billing period to the target date. **auto_renew_only**: The assumption is applied to the subscriptions that have auto_renew enabled. Zuora generates preview invoice item data and credit memo item data from the first day of the customer's next billing period to the target date.")
    public AssumeRenewalEnum getAssumeRenewal() {
        return this.assumeRenewal;
    }

    public void setAssumeRenewal(AssumeRenewalEnum assumeRenewal) {
        this.assumeRenewal = assumeRenewal;
    }

    public BillRunPreviewCreateRequest batches(List<String> batches) {
        this.batches = batches;
        return this;
    }

    public BillRunPreviewCreateRequest addBatchesItem(String batchesItem) {
        if (this.batches == null) {
            this.batches = new ArrayList<String>();
        }
        this.batches.add(batchesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifiers of the customer account batches to be included in this bill run preview.")
    public List<String> getBatches() {
        return this.batches;
    }

    public void setBatches(List<String> batches) {
        this.batches = batches;
    }

    public BillRunPreviewCreateRequest chargesExcluded(List<ChargesExcludedEnum> chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
        return this;
    }

    public BillRunPreviewCreateRequest addChargesExcludedItem(ChargesExcludedEnum chargesExcludedItem) {
        if (this.chargesExcluded == null) {
            this.chargesExcluded = new ArrayList<ChargesExcludedEnum>();
        }
        this.chargesExcluded.add(chargesExcludedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Charge type or types to be excluded from this bill run preview.")
    public List<ChargesExcludedEnum> getChargesExcluded() {
        return this.chargesExcluded;
    }

    public void setChargesExcluded(List<ChargesExcludedEnum> chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
    }

    public BillRunPreviewCreateRequest includeDraftItems(Boolean includeDraftItems) {
        this.includeDraftItems = includeDraftItems;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, draft items will be included in this bill run preview.")
    public Boolean getIncludeDraftItems() {
        return this.includeDraftItems;
    }

    public void setIncludeDraftItems(Boolean includeDraftItems) {
        this.includeDraftItems = includeDraftItems;
    }

    public BillRunPreviewCreateRequest includeEvergreenSubscriptions(Boolean includeEvergreenSubscriptions) {
        this.includeEvergreenSubscriptions = includeEvergreenSubscriptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, evergreen subscriptions will be included in this bill run preview.")
    public Boolean getIncludeEvergreenSubscriptions() {
        return this.includeEvergreenSubscriptions;
    }

    public void setIncludeEvergreenSubscriptions(Boolean includeEvergreenSubscriptions) {
        this.includeEvergreenSubscriptions = includeEvergreenSubscriptions;
    }

    public BillRunPreviewCreateRequest targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="All unbilled items on or before this date are included in this bill run.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillRunPreviewCreateRequest billRunPreviewCreateRequest = (BillRunPreviewCreateRequest)o;
        return Objects.equals((Object)this.assumeRenewal, (Object)billRunPreviewCreateRequest.assumeRenewal) && Objects.equals(this.batches, billRunPreviewCreateRequest.batches) && Objects.equals(this.chargesExcluded, billRunPreviewCreateRequest.chargesExcluded) && Objects.equals(this.includeDraftItems, billRunPreviewCreateRequest.includeDraftItems) && Objects.equals(this.includeEvergreenSubscriptions, billRunPreviewCreateRequest.includeEvergreenSubscriptions) && Objects.equals(this.targetDate, billRunPreviewCreateRequest.targetDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assumeRenewal, this.batches, this.chargesExcluded, this.includeDraftItems, this.includeEvergreenSubscriptions, this.targetDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillRunPreviewCreateRequest {\n");
        sb.append("    assumeRenewal: ").append(this.toIndentedString((Object)this.assumeRenewal)).append("\n");
        sb.append("    batches: ").append(this.toIndentedString(this.batches)).append("\n");
        sb.append("    chargesExcluded: ").append(this.toIndentedString(this.chargesExcluded)).append("\n");
        sb.append("    includeDraftItems: ").append(this.toIndentedString(this.includeDraftItems)).append("\n");
        sb.append("    includeEvergreenSubscriptions: ").append(this.toIndentedString(this.includeEvergreenSubscriptions)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChargesExcludedEnum {
        ONE_TIME("one_time"),
        RECURRING("recurring"),
        USAGE("usage"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ChargesExcludedEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChargesExcludedEnum fromValue(String value) {
            for (ChargesExcludedEnum b : ChargesExcludedEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ChargesExcludedEnum> {
            public void write(JsonWriter jsonWriter, ChargesExcludedEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChargesExcludedEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChargesExcludedEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AssumeRenewalEnum {
        ALL("all"),
        AUTO_RENEW_ONLY("auto_renew_only"),
        NONE("none"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private AssumeRenewalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AssumeRenewalEnum fromValue(String value) {
            for (AssumeRenewalEnum b : AssumeRenewalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AssumeRenewalEnum> {
            public void write(JsonWriter jsonWriter, AssumeRenewalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AssumeRenewalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AssumeRenewalEnum.fromValue(value);
            }
        }
    }
}

