/*
 * Decompiled with CFR 0.152.
 */
package com.zuora;

import java.util.List;
import java.util.Map;

public class ApiResponse<T> {
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final T data;
    private final String zuoraRequestId;

    public ApiResponse(int statusCode, Map<String, List<String>> headers) {
        this(statusCode, headers, null);
    }

    public ApiResponse(int statusCode, Map<String, List<String>> headers, T data) {
        this.statusCode = statusCode;
        String zuoraRequestId = "";
        this.headers = headers;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (!entry.getKey().toLowerCase().equals("zuora-request-id")) continue;
            zuoraRequestId = entry.getValue().iterator().next();
        }
        this.zuoraRequestId = zuoraRequestId;
        this.data = data;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getZuoraRequestId() {
        return this.zuoraRequestId;
    }

    public T getData() {
        return this.data;
    }
}

