/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.AuthenticationSuccessResponse;
import com.zuora.model.Bi3ViewsColumnsDescriptionResponse;
import com.zuora.model.Bi3ViewsCountSuccessResponse;
import com.zuora.model.Bi3ViewsTaskStatusResponse;
import com.zuora.model.Bi3ViewsV2SuccessResponse;
import com.zuora.model.BiViews1SelectSuccessResponse;
import com.zuora.model.BiViews1SuccessResponse;
import com.zuora.model.CommonResponse;
import com.zuora.model.GetBIViewStatus200ResponseInner;
import com.zuora.model.MappingResponse;
import com.zuora.model.ReportListResponse;
import com.zuora.model.SignedUrlSuccessResponse;
import com.zuora.model.StageErrorResponse;
import com.zuora.model.UploadCsvResponse;
import com.zuora.model.UploadCsvStatusResponse;
import com.zuora.model.UploadFileResponse;
import com.zuora.model.UploadFileStatusResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class RevenueIntegrationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RevenueIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RevenueIntegrationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call describeViewColumnsCall(String viewName, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v2/biviews/{view_name}/describe-columns".replace("{view_name}", this.localVarApiClient.escapeString(viewName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("Token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call describeViewColumnsValidateBeforeCall(String viewName, String token, ApiCallback _callback) throws ApiException {
        if (viewName == null) {
            throw new ApiException("Missing the required parameter 'viewName' when calling describeViewColumns(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling describeViewColumns(Async)");
        }
        return this.describeViewColumnsCall(viewName, token, _callback);
    }

    protected List<Bi3ViewsColumnsDescriptionResponse> describeViewColumns(String viewName, String token) throws ApiException {
        ApiResponse<List<Bi3ViewsColumnsDescriptionResponse>> localVarResp = this.describeViewColumnsWithHttpInfo(viewName, token);
        return localVarResp.getData();
    }

    private ApiResponse<List<Bi3ViewsColumnsDescriptionResponse>> describeViewColumnsWithHttpInfo(String viewName, String token) throws ApiException {
        Call localVarCall = this.describeViewColumnsValidateBeforeCall(viewName, token, null);
        try {
            Type localVarReturnType = new TypeToken<List<Bi3ViewsColumnsDescriptionResponse>>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call describeViewColumnsAsync(String viewName, String token, ApiCallback<List<Bi3ViewsColumnsDescriptionResponse>> _callback) throws ApiException {
        Call localVarCall = this.describeViewColumnsValidateBeforeCall(viewName, token, _callback);
        Type localVarReturnType = new TypeToken<List<Bi3ViewsColumnsDescriptionResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DescribeViewColumnsApi describeViewColumnsApi(String viewName, String token) {
        return new DescribeViewColumnsApi(viewName, token);
    }

    private Call downloadReportCall(String token, String filename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/reports/download/{filename}".replace("{filename}", this.localVarApiClient.escapeString(filename.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadReportValidateBeforeCall(String token, String filename, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling downloadReport(Async)");
        }
        if (filename == null) {
            throw new ApiException("Missing the required parameter 'filename' when calling downloadReport(Async)");
        }
        return this.downloadReportCall(token, filename, _callback);
    }

    protected void downloadReport(String token, String filename) throws ApiException {
        this.downloadReportWithHttpInfo(token, filename);
    }

    private ApiResponse<Void> downloadReportWithHttpInfo(String token, String filename) throws ApiException {
        Call localVarCall = this.downloadReportValidateBeforeCall(token, filename, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call downloadReportAsync(String token, String filename, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.downloadReportValidateBeforeCall(token, filename, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DownloadReportApi downloadReportApi(String token, String filename) {
        return new DownloadReportApi(token, filename);
    }

    private Call generateJWTTokenCall(String role, String clientname, byte[] authorization, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/authenticate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (role != null) {
            localVarHeaderParams.put("role", this.localVarApiClient.parameterToString(role));
        }
        if (clientname != null) {
            localVarHeaderParams.put("clientname", this.localVarApiClient.parameterToString(clientname));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call generateJWTTokenValidateBeforeCall(String role, String clientname, byte[] authorization, ApiCallback _callback) throws ApiException {
        if (role == null) {
            throw new ApiException("Missing the required parameter 'role' when calling generateJWTToken(Async)");
        }
        if (clientname == null) {
            throw new ApiException("Missing the required parameter 'clientname' when calling generateJWTToken(Async)");
        }
        if (authorization == null) {
            throw new ApiException("Missing the required parameter 'authorization' when calling generateJWTToken(Async)");
        }
        return this.generateJWTTokenCall(role, clientname, authorization, _callback);
    }

    protected AuthenticationSuccessResponse generateJWTToken(String role, String clientname, byte[] authorization) throws ApiException {
        ApiResponse<AuthenticationSuccessResponse> localVarResp = this.generateJWTTokenWithHttpInfo(role, clientname, authorization);
        return localVarResp.getData();
    }

    private ApiResponse<AuthenticationSuccessResponse> generateJWTTokenWithHttpInfo(String role, String clientname, byte[] authorization) throws ApiException {
        Call localVarCall = this.generateJWTTokenValidateBeforeCall(role, clientname, authorization, null);
        try {
            Type localVarReturnType = new TypeToken<AuthenticationSuccessResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call generateJWTTokenAsync(String role, String clientname, byte[] authorization, ApiCallback<AuthenticationSuccessResponse> _callback) throws ApiException {
        Call localVarCall = this.generateJWTTokenValidateBeforeCall(role, clientname, authorization, _callback);
        Type localVarReturnType = new TypeToken<AuthenticationSuccessResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GenerateJWTTokenApi generateJWTTokenApi(String role, String clientname, byte[] authorization) {
        return new GenerateJWTTokenApi(role, clientname, authorization);
    }

    private Call getBIViewCountCall(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v2/biviews/count/{view_name}".replace("{view_name}", this.localVarApiClient.escapeString(viewName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fromDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromDate", fromDate));
        }
        if (toDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("toDate", toDate));
        }
        if (pagenum != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagenum", pagenum));
        }
        if (token != null) {
            localVarHeaderParams.put("Token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBIViewCountValidateBeforeCall(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum, ApiCallback _callback) throws ApiException {
        if (viewName == null) {
            throw new ApiException("Missing the required parameter 'viewName' when calling getBIViewCount(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getBIViewCount(Async)");
        }
        return this.getBIViewCountCall(viewName, token, fromDate, toDate, pagenum, _callback);
    }

    protected Bi3ViewsCountSuccessResponse getBIViewCount(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum) throws ApiException {
        ApiResponse<Bi3ViewsCountSuccessResponse> localVarResp = this.getBIViewCountWithHttpInfo(viewName, token, fromDate, toDate, pagenum);
        return localVarResp.getData();
    }

    private ApiResponse<Bi3ViewsCountSuccessResponse> getBIViewCountWithHttpInfo(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum) throws ApiException {
        Call localVarCall = this.getBIViewCountValidateBeforeCall(viewName, token, fromDate, toDate, pagenum, null);
        try {
            Type localVarReturnType = new TypeToken<Bi3ViewsCountSuccessResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBIViewCountAsync(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum, ApiCallback<Bi3ViewsCountSuccessResponse> _callback) throws ApiException {
        Call localVarCall = this.getBIViewCountValidateBeforeCall(viewName, token, fromDate, toDate, pagenum, _callback);
        Type localVarReturnType = new TypeToken<Bi3ViewsCountSuccessResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBIViewCountApi getBIViewCountApi(String viewName, String token) {
        return new GetBIViewCountApi(viewName, token);
    }

    private Call getBIViewStatusCall(String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v2/biviews-status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("Token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBIViewStatusValidateBeforeCall(String token, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getBIViewStatus(Async)");
        }
        return this.getBIViewStatusCall(token, _callback);
    }

    protected List<GetBIViewStatus200ResponseInner> getBIViewStatus(String token) throws ApiException {
        ApiResponse<List<GetBIViewStatus200ResponseInner>> localVarResp = this.getBIViewStatusWithHttpInfo(token);
        return localVarResp.getData();
    }

    private ApiResponse<List<GetBIViewStatus200ResponseInner>> getBIViewStatusWithHttpInfo(String token) throws ApiException {
        Call localVarCall = this.getBIViewStatusValidateBeforeCall(token, null);
        try {
            Type localVarReturnType = new TypeToken<List<GetBIViewStatus200ResponseInner>>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBIViewStatusAsync(String token, ApiCallback<List<GetBIViewStatus200ResponseInner>> _callback) throws ApiException {
        Call localVarCall = this.getBIViewStatusValidateBeforeCall(token, _callback);
        Type localVarReturnType = new TypeToken<List<GetBIViewStatus200ResponseInner>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBIViewStatusApi getBIViewStatusApi(String token) {
        return new GetBIViewStatusApi(token);
    }

    private Call getBIViewTaskDetailsCall(String taskId, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v2/biviews-status/{task_id}".replace("{task_id}", this.localVarApiClient.escapeString(taskId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("Token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBIViewTaskDetailsValidateBeforeCall(String taskId, String token, ApiCallback _callback) throws ApiException {
        if (taskId == null) {
            throw new ApiException("Missing the required parameter 'taskId' when calling getBIViewTaskDetails(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getBIViewTaskDetails(Async)");
        }
        return this.getBIViewTaskDetailsCall(taskId, token, _callback);
    }

    protected Bi3ViewsTaskStatusResponse getBIViewTaskDetails(String taskId, String token) throws ApiException {
        ApiResponse<Bi3ViewsTaskStatusResponse> localVarResp = this.getBIViewTaskDetailsWithHttpInfo(taskId, token);
        return localVarResp.getData();
    }

    private ApiResponse<Bi3ViewsTaskStatusResponse> getBIViewTaskDetailsWithHttpInfo(String taskId, String token) throws ApiException {
        Call localVarCall = this.getBIViewTaskDetailsValidateBeforeCall(taskId, token, null);
        try {
            Type localVarReturnType = new TypeToken<Bi3ViewsTaskStatusResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBIViewTaskDetailsAsync(String taskId, String token, ApiCallback<Bi3ViewsTaskStatusResponse> _callback) throws ApiException {
        Call localVarCall = this.getBIViewTaskDetailsValidateBeforeCall(taskId, token, _callback);
        Type localVarReturnType = new TypeToken<Bi3ViewsTaskStatusResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBIViewTaskDetailsApi getBIViewTaskDetailsApi(String taskId, String token) {
        return new GetBIViewTaskDetailsApi(taskId, token);
    }

    private Call getBIViewsCall(String viewName, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/biviews/{view_name}".replace("{view_name}", this.localVarApiClient.escapeString(viewName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("Token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBIViewsValidateBeforeCall(String viewName, String token, ApiCallback _callback) throws ApiException {
        if (viewName == null) {
            throw new ApiException("Missing the required parameter 'viewName' when calling getBIViews(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getBIViews(Async)");
        }
        return this.getBIViewsCall(viewName, token, _callback);
    }

    protected BiViews1SuccessResponse getBIViews(String viewName, String token) throws ApiException {
        ApiResponse<BiViews1SuccessResponse> localVarResp = this.getBIViewsWithHttpInfo(viewName, token);
        return localVarResp.getData();
    }

    private ApiResponse<BiViews1SuccessResponse> getBIViewsWithHttpInfo(String viewName, String token) throws ApiException {
        Call localVarCall = this.getBIViewsValidateBeforeCall(viewName, token, null);
        try {
            Type localVarReturnType = new TypeToken<BiViews1SuccessResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBIViewsAsync(String viewName, String token, ApiCallback<BiViews1SuccessResponse> _callback) throws ApiException {
        Call localVarCall = this.getBIViewsValidateBeforeCall(viewName, token, _callback);
        Type localVarReturnType = new TypeToken<BiViews1SuccessResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBIViewsApi getBIViewsApi(String viewName, String token) {
        return new GetBIViewsApi(viewName, token);
    }

    private Call getBIViewsV2Call(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v2/biviews/{view_name}".replace("{view_name}", this.localVarApiClient.escapeString(viewName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fromDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromDate", fromDate));
        }
        if (toDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("toDate", toDate));
        }
        if (pagenum != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagenum", pagenum));
        }
        if (token != null) {
            localVarHeaderParams.put("Token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBIViewsV2ValidateBeforeCall(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum, ApiCallback _callback) throws ApiException {
        if (viewName == null) {
            throw new ApiException("Missing the required parameter 'viewName' when calling getBIViewsV2(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getBIViewsV2(Async)");
        }
        return this.getBIViewsV2Call(viewName, token, fromDate, toDate, pagenum, _callback);
    }

    protected Bi3ViewsV2SuccessResponse getBIViewsV2(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum) throws ApiException {
        ApiResponse<Bi3ViewsV2SuccessResponse> localVarResp = this.getBIViewsV2WithHttpInfo(viewName, token, fromDate, toDate, pagenum);
        return localVarResp.getData();
    }

    private ApiResponse<Bi3ViewsV2SuccessResponse> getBIViewsV2WithHttpInfo(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum) throws ApiException {
        Call localVarCall = this.getBIViewsV2ValidateBeforeCall(viewName, token, fromDate, toDate, pagenum, null);
        try {
            Type localVarReturnType = new TypeToken<Bi3ViewsV2SuccessResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBIViewsV2Async(String viewName, String token, LocalDate fromDate, LocalDate toDate, Integer pagenum, ApiCallback<Bi3ViewsV2SuccessResponse> _callback) throws ApiException {
        Call localVarCall = this.getBIViewsV2ValidateBeforeCall(viewName, token, fromDate, toDate, pagenum, _callback);
        Type localVarReturnType = new TypeToken<Bi3ViewsV2SuccessResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBIViewsV2Api getBIViewsV2Api(String viewName, String token) {
        return new GetBIViewsV2Api(viewName, token);
    }

    private Call getCsvUploadStatusCall(Integer id, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/csv/upload/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCsvUploadStatusValidateBeforeCall(Integer id, String token, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getCsvUploadStatus(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getCsvUploadStatus(Async)");
        }
        return this.getCsvUploadStatusCall(id, token, _callback);
    }

    protected UploadCsvStatusResponse getCsvUploadStatus(Integer id, String token) throws ApiException {
        ApiResponse<UploadCsvStatusResponse> localVarResp = this.getCsvUploadStatusWithHttpInfo(id, token);
        return localVarResp.getData();
    }

    private ApiResponse<UploadCsvStatusResponse> getCsvUploadStatusWithHttpInfo(Integer id, String token) throws ApiException {
        Call localVarCall = this.getCsvUploadStatusValidateBeforeCall(id, token, null);
        try {
            Type localVarReturnType = new TypeToken<UploadCsvStatusResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCsvUploadStatusAsync(Integer id, String token, ApiCallback<UploadCsvStatusResponse> _callback) throws ApiException {
        Call localVarCall = this.getCsvUploadStatusValidateBeforeCall(id, token, _callback);
        Type localVarReturnType = new TypeToken<UploadCsvStatusResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCsvUploadStatusApi getCsvUploadStatusApi(Integer id, String token) {
        return new GetCsvUploadStatusApi(id, token);
    }

    private Call getFileUploadStatusByRequestIdCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/fileupload/status/{file_request_id}".replace("{file_request_id}", this.localVarApiClient.escapeString(fileRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFileUploadStatusByRequestIdValidateBeforeCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getFileUploadStatusByRequestId(Async)");
        }
        if (fileRequestId == null) {
            throw new ApiException("Missing the required parameter 'fileRequestId' when calling getFileUploadStatusByRequestId(Async)");
        }
        return this.getFileUploadStatusByRequestIdCall(token, fileRequestId, _callback);
    }

    protected UploadFileStatusResponse getFileUploadStatusByRequestId(String token, Integer fileRequestId) throws ApiException {
        ApiResponse<UploadFileStatusResponse> localVarResp = this.getFileUploadStatusByRequestIdWithHttpInfo(token, fileRequestId);
        return localVarResp.getData();
    }

    private ApiResponse<UploadFileStatusResponse> getFileUploadStatusByRequestIdWithHttpInfo(String token, Integer fileRequestId) throws ApiException {
        Call localVarCall = this.getFileUploadStatusByRequestIdValidateBeforeCall(token, fileRequestId, null);
        try {
            Type localVarReturnType = new TypeToken<UploadFileStatusResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getFileUploadStatusByRequestIdAsync(String token, Integer fileRequestId, ApiCallback<UploadFileStatusResponse> _callback) throws ApiException {
        Call localVarCall = this.getFileUploadStatusByRequestIdValidateBeforeCall(token, fileRequestId, _callback);
        Type localVarReturnType = new TypeToken<UploadFileStatusResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetFileUploadStatusByRequestIdApi getFileUploadStatusByRequestIdApi(String token, Integer fileRequestId) {
        return new GetFileUploadStatusByRequestIdApi(token, fileRequestId);
    }

    private Call getReportsByIdCall(String reportId, String token, LocalDate createddate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/reports/{report_id}".replace("{report_id}", this.localVarApiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (createddate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createddate", createddate));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReportsByIdValidateBeforeCall(String reportId, String token, LocalDate createddate, ApiCallback _callback) throws ApiException {
        if (reportId == null) {
            throw new ApiException("Missing the required parameter 'reportId' when calling getReportsById(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getReportsById(Async)");
        }
        if (createddate == null) {
            throw new ApiException("Missing the required parameter 'createddate' when calling getReportsById(Async)");
        }
        return this.getReportsByIdCall(reportId, token, createddate, _callback);
    }

    protected ReportListResponse getReportsById(String reportId, String token, LocalDate createddate) throws ApiException {
        ApiResponse<ReportListResponse> localVarResp = this.getReportsByIdWithHttpInfo(reportId, token, createddate);
        return localVarResp.getData();
    }

    private ApiResponse<ReportListResponse> getReportsByIdWithHttpInfo(String reportId, String token, LocalDate createddate) throws ApiException {
        Call localVarCall = this.getReportsByIdValidateBeforeCall(reportId, token, createddate, null);
        try {
            Type localVarReturnType = new TypeToken<ReportListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getReportsByIdAsync(String reportId, String token, LocalDate createddate, ApiCallback<ReportListResponse> _callback) throws ApiException {
        Call localVarCall = this.getReportsByIdValidateBeforeCall(reportId, token, createddate, _callback);
        Type localVarReturnType = new TypeToken<ReportListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetReportsByIdApi getReportsByIdApi(String reportId, String token, LocalDate createddate) {
        return new GetReportsByIdApi(reportId, token, createddate);
    }

    private Call getStageErrorCall(String token, String errortype, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/stage/error/{errortype}".replace("{errortype}", this.localVarApiClient.escapeString(errortype.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStageErrorValidateBeforeCall(String token, String errortype, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getStageError(Async)");
        }
        if (errortype == null) {
            throw new ApiException("Missing the required parameter 'errortype' when calling getStageError(Async)");
        }
        return this.getStageErrorCall(token, errortype, _callback);
    }

    protected StageErrorResponse getStageError(String token, String errortype) throws ApiException {
        ApiResponse<StageErrorResponse> localVarResp = this.getStageErrorWithHttpInfo(token, errortype);
        return localVarResp.getData();
    }

    private ApiResponse<StageErrorResponse> getStageErrorWithHttpInfo(String token, String errortype) throws ApiException {
        Call localVarCall = this.getStageErrorValidateBeforeCall(token, errortype, null);
        try {
            Type localVarReturnType = new TypeToken<StageErrorResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getStageErrorAsync(String token, String errortype, ApiCallback<StageErrorResponse> _callback) throws ApiException {
        Call localVarCall = this.getStageErrorValidateBeforeCall(token, errortype, _callback);
        Type localVarReturnType = new TypeToken<StageErrorResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetStageErrorApi getStageErrorApi(String token, String errortype) {
        return new GetStageErrorApi(token, errortype);
    }

    private Call integrationV2ReportsSignedurlReportIdGetCall(String token, String reportId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v2/reports/signedurl/{report_id}".replace("{report_id}", this.localVarApiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call integrationV2ReportsSignedurlReportIdGetValidateBeforeCall(String token, String reportId, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling integrationV2ReportsSignedurlReportIdGet(Async)");
        }
        if (reportId == null) {
            throw new ApiException("Missing the required parameter 'reportId' when calling integrationV2ReportsSignedurlReportIdGet(Async)");
        }
        return this.integrationV2ReportsSignedurlReportIdGetCall(token, reportId, _callback);
    }

    protected SignedUrlSuccessResponse integrationV2ReportsSignedurlReportIdGet(String token, String reportId) throws ApiException {
        ApiResponse<SignedUrlSuccessResponse> localVarResp = this.integrationV2ReportsSignedurlReportIdGetWithHttpInfo(token, reportId);
        return localVarResp.getData();
    }

    private ApiResponse<SignedUrlSuccessResponse> integrationV2ReportsSignedurlReportIdGetWithHttpInfo(String token, String reportId) throws ApiException {
        Call localVarCall = this.integrationV2ReportsSignedurlReportIdGetValidateBeforeCall(token, reportId, null);
        try {
            Type localVarReturnType = new TypeToken<SignedUrlSuccessResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call integrationV2ReportsSignedurlReportIdGetAsync(String token, String reportId, ApiCallback<SignedUrlSuccessResponse> _callback) throws ApiException {
        Call localVarCall = this.integrationV2ReportsSignedurlReportIdGetValidateBeforeCall(token, reportId, _callback);
        Type localVarReturnType = new TypeToken<SignedUrlSuccessResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public IntegrationV2ReportsSignedurlReportIdGetApi integrationV2ReportsSignedurlReportIdGetApi(String token, String reportId) {
        return new IntegrationV2ReportsSignedurlReportIdGetApi(token, reportId);
    }

    private Call listReportsCall(String token, LocalDate createddate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/reports/list";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (createddate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createddate", createddate));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listReportsValidateBeforeCall(String token, LocalDate createddate, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling listReports(Async)");
        }
        if (createddate == null) {
            throw new ApiException("Missing the required parameter 'createddate' when calling listReports(Async)");
        }
        return this.listReportsCall(token, createddate, _callback);
    }

    protected ReportListResponse listReports(String token, LocalDate createddate) throws ApiException {
        ApiResponse<ReportListResponse> localVarResp = this.listReportsWithHttpInfo(token, createddate);
        return localVarResp.getData();
    }

    private ApiResponse<ReportListResponse> listReportsWithHttpInfo(String token, LocalDate createddate) throws ApiException {
        Call localVarCall = this.listReportsValidateBeforeCall(token, createddate, null);
        try {
            Type localVarReturnType = new TypeToken<ReportListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call listReportsAsync(String token, LocalDate createddate, ApiCallback<ReportListResponse> _callback) throws ApiException {
        Call localVarCall = this.listReportsValidateBeforeCall(token, createddate, _callback);
        Type localVarReturnType = new TypeToken<ReportListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ListReportsApi listReportsApi(String token, LocalDate createddate) {
        return new ListReportsApi(token, createddate);
    }

    private Call selectBIViewCall(String viewName, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/biviews/{view_name}".replace("{view_name}", this.localVarApiClient.escapeString(viewName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("Token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call selectBIViewValidateBeforeCall(String viewName, String token, ApiCallback _callback) throws ApiException {
        if (viewName == null) {
            throw new ApiException("Missing the required parameter 'viewName' when calling selectBIView(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling selectBIView(Async)");
        }
        return this.selectBIViewCall(viewName, token, _callback);
    }

    protected BiViews1SelectSuccessResponse selectBIView(String viewName, String token) throws ApiException {
        ApiResponse<BiViews1SelectSuccessResponse> localVarResp = this.selectBIViewWithHttpInfo(viewName, token);
        return localVarResp.getData();
    }

    private ApiResponse<BiViews1SelectSuccessResponse> selectBIViewWithHttpInfo(String viewName, String token) throws ApiException {
        Call localVarCall = this.selectBIViewValidateBeforeCall(viewName, token, null);
        try {
            Type localVarReturnType = new TypeToken<BiViews1SelectSuccessResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call selectBIViewAsync(String viewName, String token, ApiCallback<BiViews1SelectSuccessResponse> _callback) throws ApiException {
        Call localVarCall = this.selectBIViewValidateBeforeCall(viewName, token, _callback);
        Type localVarReturnType = new TypeToken<BiViews1SelectSuccessResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public SelectBIViewApi selectBIViewApi(String viewName, String token) {
        return new SelectBIViewApi(viewName, token);
    }

    private Call uploadCsvCall(String token, String templatename, String data, String filename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/csv/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (data != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("data", data));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if (templatename != null) {
            localVarHeaderParams.put("templatename", this.localVarApiClient.parameterToString(templatename));
        }
        if (filename != null) {
            localVarHeaderParams.put("filename", this.localVarApiClient.parameterToString(filename));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadCsvValidateBeforeCall(String token, String templatename, String data, String filename, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadCsv(Async)");
        }
        if (templatename == null) {
            throw new ApiException("Missing the required parameter 'templatename' when calling uploadCsv(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling uploadCsv(Async)");
        }
        if (filename == null) {
            throw new ApiException("Missing the required parameter 'filename' when calling uploadCsv(Async)");
        }
        return this.uploadCsvCall(token, templatename, data, filename, _callback);
    }

    protected UploadCsvResponse uploadCsv(String token, String templatename, String data, String filename) throws ApiException {
        ApiResponse<UploadCsvResponse> localVarResp = this.uploadCsvWithHttpInfo(token, templatename, data, filename);
        return localVarResp.getData();
    }

    private ApiResponse<UploadCsvResponse> uploadCsvWithHttpInfo(String token, String templatename, String data, String filename) throws ApiException {
        Call localVarCall = this.uploadCsvValidateBeforeCall(token, templatename, data, filename, null);
        try {
            Type localVarReturnType = new TypeToken<UploadCsvResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call uploadCsvAsync(String token, String templatename, String data, String filename, ApiCallback<UploadCsvResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadCsvValidateBeforeCall(token, templatename, data, filename, _callback);
        Type localVarReturnType = new TypeToken<UploadCsvResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UploadCsvApi uploadCsvApi(String token, String templatename, String data, String filename) {
        return new UploadCsvApi(token, templatename, data, filename);
    }

    private Call uploadFileCall(String token, String templatename, String async, File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/upload/file";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (async != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("async", async));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if (templatename != null) {
            localVarHeaderParams.put("templatename", this.localVarApiClient.parameterToString(templatename));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadFileValidateBeforeCall(String token, String templatename, String async, File _file, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadFile(Async)");
        }
        if (templatename == null) {
            throw new ApiException("Missing the required parameter 'templatename' when calling uploadFile(Async)");
        }
        return this.uploadFileCall(token, templatename, async, _file, _callback);
    }

    protected UploadFileResponse uploadFile(String token, String templatename, String async, File _file) throws ApiException {
        ApiResponse<UploadFileResponse> localVarResp = this.uploadFileWithHttpInfo(token, templatename, async, _file);
        return localVarResp.getData();
    }

    private ApiResponse<UploadFileResponse> uploadFileWithHttpInfo(String token, String templatename, String async, File _file) throws ApiException {
        Call localVarCall = this.uploadFileValidateBeforeCall(token, templatename, async, _file, null);
        try {
            Type localVarReturnType = new TypeToken<UploadFileResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call uploadFileAsync(String token, String templatename, String async, File _file, ApiCallback<UploadFileResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadFileValidateBeforeCall(token, templatename, async, _file, _callback);
        Type localVarReturnType = new TypeToken<UploadFileResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UploadFileApi uploadFileApi(String token, String templatename) {
        return new UploadFileApi(token, templatename);
    }

    private Call uploadMappingCall(String token, String templatename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/upload/mapping";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (templatename != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("templatename", templatename));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadMappingValidateBeforeCall(String token, String templatename, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadMapping(Async)");
        }
        if (templatename == null) {
            throw new ApiException("Missing the required parameter 'templatename' when calling uploadMapping(Async)");
        }
        return this.uploadMappingCall(token, templatename, _callback);
    }

    protected MappingResponse uploadMapping(String token, String templatename) throws ApiException {
        ApiResponse<MappingResponse> localVarResp = this.uploadMappingWithHttpInfo(token, templatename);
        return localVarResp.getData();
    }

    private ApiResponse<MappingResponse> uploadMappingWithHttpInfo(String token, String templatename) throws ApiException {
        Call localVarCall = this.uploadMappingValidateBeforeCall(token, templatename, null);
        try {
            Type localVarReturnType = new TypeToken<MappingResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call uploadMappingAsync(String token, String templatename, ApiCallback<MappingResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadMappingValidateBeforeCall(token, templatename, _callback);
        Type localVarReturnType = new TypeToken<MappingResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UploadMappingApi uploadMappingApi(String token, String templatename) {
        return new UploadMappingApi(token, templatename);
    }

    public class UploadMappingApi {
        private final String token;
        private final String templatename;

        private UploadMappingApi(String token, String templatename) {
            this.token = token;
            this.templatename = templatename;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadMappingCall(this.token, this.templatename, _callback);
        }

        public MappingResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.uploadMappingWithHttpInfo(this.token, this.templatename);
            return (MappingResponse)localVarResp.getData();
        }

        public ApiResponse<MappingResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.uploadMappingWithHttpInfo(this.token, this.templatename);
        }

        public Call executeAsync(ApiCallback<MappingResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadMappingAsync(this.token, this.templatename, _callback);
        }
    }

    public class UploadFileApi {
        private final String token;
        private final String templatename;
        private String async;
        private File _file;

        private UploadFileApi(String token, String templatename) {
            this.token = token;
            this.templatename = templatename;
        }

        public UploadFileApi async(String async) {
            this.async = async;
            return this;
        }

        public UploadFileApi _file(File _file) {
            this._file = _file;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadFileCall(this.token, this.templatename, this.async, this._file, _callback);
        }

        public UploadFileResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.uploadFileWithHttpInfo(this.token, this.templatename, this.async, this._file);
            return (UploadFileResponse)localVarResp.getData();
        }

        public ApiResponse<UploadFileResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.uploadFileWithHttpInfo(this.token, this.templatename, this.async, this._file);
        }

        public Call executeAsync(ApiCallback<UploadFileResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadFileAsync(this.token, this.templatename, this.async, this._file, _callback);
        }
    }

    public class UploadCsvApi {
        private final String token;
        private final String templatename;
        private final String data;
        private final String filename;

        private UploadCsvApi(String token, String templatename, String data, String filename) {
            this.token = token;
            this.templatename = templatename;
            this.data = data;
            this.filename = filename;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadCsvCall(this.token, this.templatename, this.data, this.filename, _callback);
        }

        public UploadCsvResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.uploadCsvWithHttpInfo(this.token, this.templatename, this.data, this.filename);
            return (UploadCsvResponse)localVarResp.getData();
        }

        public ApiResponse<UploadCsvResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.uploadCsvWithHttpInfo(this.token, this.templatename, this.data, this.filename);
        }

        public Call executeAsync(ApiCallback<UploadCsvResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadCsvAsync(this.token, this.templatename, this.data, this.filename, _callback);
        }
    }

    public class SelectBIViewApi {
        private final String viewName;
        private final String token;

        private SelectBIViewApi(String viewName, String token) {
            this.viewName = viewName;
            this.token = token;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.selectBIViewCall(this.viewName, this.token, _callback);
        }

        public BiViews1SelectSuccessResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.selectBIViewWithHttpInfo(this.viewName, this.token);
            return (BiViews1SelectSuccessResponse)localVarResp.getData();
        }

        public ApiResponse<BiViews1SelectSuccessResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.selectBIViewWithHttpInfo(this.viewName, this.token);
        }

        public Call executeAsync(ApiCallback<BiViews1SelectSuccessResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.selectBIViewAsync(this.viewName, this.token, _callback);
        }
    }

    public class ListReportsApi {
        private final String token;
        private final LocalDate createddate;

        private ListReportsApi(String token, LocalDate createddate) {
            this.token = token;
            this.createddate = createddate;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.listReportsCall(this.token, this.createddate, _callback);
        }

        public ReportListResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.listReportsWithHttpInfo(this.token, this.createddate);
            return (ReportListResponse)localVarResp.getData();
        }

        public ApiResponse<ReportListResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.listReportsWithHttpInfo(this.token, this.createddate);
        }

        public Call executeAsync(ApiCallback<ReportListResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.listReportsAsync(this.token, this.createddate, _callback);
        }
    }

    public class IntegrationV2ReportsSignedurlReportIdGetApi {
        private final String token;
        private final String reportId;

        private IntegrationV2ReportsSignedurlReportIdGetApi(String token, String reportId) {
            this.token = token;
            this.reportId = reportId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.integrationV2ReportsSignedurlReportIdGetCall(this.token, this.reportId, _callback);
        }

        public SignedUrlSuccessResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.integrationV2ReportsSignedurlReportIdGetWithHttpInfo(this.token, this.reportId);
            return (SignedUrlSuccessResponse)localVarResp.getData();
        }

        public ApiResponse<SignedUrlSuccessResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.integrationV2ReportsSignedurlReportIdGetWithHttpInfo(this.token, this.reportId);
        }

        public Call executeAsync(ApiCallback<SignedUrlSuccessResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.integrationV2ReportsSignedurlReportIdGetAsync(this.token, this.reportId, _callback);
        }
    }

    public class GetStageErrorApi {
        private final String token;
        private final String errortype;

        private GetStageErrorApi(String token, String errortype) {
            this.token = token;
            this.errortype = errortype;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getStageErrorCall(this.token, this.errortype, _callback);
        }

        public StageErrorResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getStageErrorWithHttpInfo(this.token, this.errortype);
            return (StageErrorResponse)localVarResp.getData();
        }

        public ApiResponse<StageErrorResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getStageErrorWithHttpInfo(this.token, this.errortype);
        }

        public Call executeAsync(ApiCallback<StageErrorResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getStageErrorAsync(this.token, this.errortype, _callback);
        }
    }

    public class GetReportsByIdApi {
        private final String reportId;
        private final String token;
        private final LocalDate createddate;

        private GetReportsByIdApi(String reportId, String token, LocalDate createddate) {
            this.reportId = reportId;
            this.token = token;
            this.createddate = createddate;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getReportsByIdCall(this.reportId, this.token, this.createddate, _callback);
        }

        public ReportListResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getReportsByIdWithHttpInfo(this.reportId, this.token, this.createddate);
            return (ReportListResponse)localVarResp.getData();
        }

        public ApiResponse<ReportListResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getReportsByIdWithHttpInfo(this.reportId, this.token, this.createddate);
        }

        public Call executeAsync(ApiCallback<ReportListResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getReportsByIdAsync(this.reportId, this.token, this.createddate, _callback);
        }
    }

    public class GetFileUploadStatusByRequestIdApi {
        private final String token;
        private final Integer fileRequestId;

        private GetFileUploadStatusByRequestIdApi(String token, Integer fileRequestId) {
            this.token = token;
            this.fileRequestId = fileRequestId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getFileUploadStatusByRequestIdCall(this.token, this.fileRequestId, _callback);
        }

        public UploadFileStatusResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getFileUploadStatusByRequestIdWithHttpInfo(this.token, this.fileRequestId);
            return (UploadFileStatusResponse)localVarResp.getData();
        }

        public ApiResponse<UploadFileStatusResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getFileUploadStatusByRequestIdWithHttpInfo(this.token, this.fileRequestId);
        }

        public Call executeAsync(ApiCallback<UploadFileStatusResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getFileUploadStatusByRequestIdAsync(this.token, this.fileRequestId, _callback);
        }
    }

    public class GetCsvUploadStatusApi {
        private final Integer id;
        private final String token;

        private GetCsvUploadStatusApi(Integer id, String token) {
            this.id = id;
            this.token = token;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getCsvUploadStatusCall(this.id, this.token, _callback);
        }

        public UploadCsvStatusResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getCsvUploadStatusWithHttpInfo(this.id, this.token);
            return (UploadCsvStatusResponse)localVarResp.getData();
        }

        public ApiResponse<UploadCsvStatusResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getCsvUploadStatusWithHttpInfo(this.id, this.token);
        }

        public Call executeAsync(ApiCallback<UploadCsvStatusResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getCsvUploadStatusAsync(this.id, this.token, _callback);
        }
    }

    public class GetBIViewsV2Api {
        private final String viewName;
        private final String token;
        private LocalDate fromDate;
        private LocalDate toDate;
        private Integer pagenum;

        private GetBIViewsV2Api(String viewName, String token) {
            this.viewName = viewName;
            this.token = token;
        }

        public GetBIViewsV2Api fromDate(LocalDate fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public GetBIViewsV2Api toDate(LocalDate toDate) {
            this.toDate = toDate;
            return this;
        }

        public GetBIViewsV2Api pagenum(Integer pagenum) {
            this.pagenum = pagenum;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewsV2Call(this.viewName, this.token, this.fromDate, this.toDate, this.pagenum, _callback);
        }

        public Bi3ViewsV2SuccessResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getBIViewsV2WithHttpInfo(this.viewName, this.token, this.fromDate, this.toDate, this.pagenum);
            return (Bi3ViewsV2SuccessResponse)localVarResp.getData();
        }

        public ApiResponse<Bi3ViewsV2SuccessResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getBIViewsV2WithHttpInfo(this.viewName, this.token, this.fromDate, this.toDate, this.pagenum);
        }

        public Call executeAsync(ApiCallback<Bi3ViewsV2SuccessResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewsV2Async(this.viewName, this.token, this.fromDate, this.toDate, this.pagenum, _callback);
        }
    }

    public class GetBIViewsApi {
        private final String viewName;
        private final String token;

        private GetBIViewsApi(String viewName, String token) {
            this.viewName = viewName;
            this.token = token;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewsCall(this.viewName, this.token, _callback);
        }

        public BiViews1SuccessResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getBIViewsWithHttpInfo(this.viewName, this.token);
            return (BiViews1SuccessResponse)localVarResp.getData();
        }

        public ApiResponse<BiViews1SuccessResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getBIViewsWithHttpInfo(this.viewName, this.token);
        }

        public Call executeAsync(ApiCallback<BiViews1SuccessResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewsAsync(this.viewName, this.token, _callback);
        }
    }

    public class GetBIViewTaskDetailsApi {
        private final String taskId;
        private final String token;

        private GetBIViewTaskDetailsApi(String taskId, String token) {
            this.taskId = taskId;
            this.token = token;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewTaskDetailsCall(this.taskId, this.token, _callback);
        }

        public Bi3ViewsTaskStatusResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getBIViewTaskDetailsWithHttpInfo(this.taskId, this.token);
            return (Bi3ViewsTaskStatusResponse)localVarResp.getData();
        }

        public ApiResponse<Bi3ViewsTaskStatusResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getBIViewTaskDetailsWithHttpInfo(this.taskId, this.token);
        }

        public Call executeAsync(ApiCallback<Bi3ViewsTaskStatusResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewTaskDetailsAsync(this.taskId, this.token, _callback);
        }
    }

    public class GetBIViewStatusApi {
        private final String token;

        private GetBIViewStatusApi(String token) {
            this.token = token;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewStatusCall(this.token, _callback);
        }

        public List<GetBIViewStatus200ResponseInner> execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getBIViewStatusWithHttpInfo(this.token);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<GetBIViewStatus200ResponseInner>> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getBIViewStatusWithHttpInfo(this.token);
        }

        public Call executeAsync(ApiCallback<List<GetBIViewStatus200ResponseInner>> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewStatusAsync(this.token, _callback);
        }
    }

    public class GetBIViewCountApi {
        private final String viewName;
        private final String token;
        private LocalDate fromDate;
        private LocalDate toDate;
        private Integer pagenum;

        private GetBIViewCountApi(String viewName, String token) {
            this.viewName = viewName;
            this.token = token;
        }

        public GetBIViewCountApi fromDate(LocalDate fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public GetBIViewCountApi toDate(LocalDate toDate) {
            this.toDate = toDate;
            return this;
        }

        public GetBIViewCountApi pagenum(Integer pagenum) {
            this.pagenum = pagenum;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewCountCall(this.viewName, this.token, this.fromDate, this.toDate, this.pagenum, _callback);
        }

        public Bi3ViewsCountSuccessResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getBIViewCountWithHttpInfo(this.viewName, this.token, this.fromDate, this.toDate, this.pagenum);
            return (Bi3ViewsCountSuccessResponse)localVarResp.getData();
        }

        public ApiResponse<Bi3ViewsCountSuccessResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getBIViewCountWithHttpInfo(this.viewName, this.token, this.fromDate, this.toDate, this.pagenum);
        }

        public Call executeAsync(ApiCallback<Bi3ViewsCountSuccessResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getBIViewCountAsync(this.viewName, this.token, this.fromDate, this.toDate, this.pagenum, _callback);
        }
    }

    public class GenerateJWTTokenApi {
        private final String role;
        private final String clientname;
        private final byte[] authorization;

        private GenerateJWTTokenApi(String role, String clientname, byte[] authorization) {
            this.role = role;
            this.clientname = clientname;
            this.authorization = authorization;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.generateJWTTokenCall(this.role, this.clientname, this.authorization, _callback);
        }

        public AuthenticationSuccessResponse execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.generateJWTTokenWithHttpInfo(this.role, this.clientname, this.authorization);
            return (AuthenticationSuccessResponse)localVarResp.getData();
        }

        public ApiResponse<AuthenticationSuccessResponse> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.generateJWTTokenWithHttpInfo(this.role, this.clientname, this.authorization);
        }

        public Call executeAsync(ApiCallback<AuthenticationSuccessResponse> _callback) throws ApiException {
            return RevenueIntegrationApi.this.generateJWTTokenAsync(this.role, this.clientname, this.authorization, _callback);
        }
    }

    public class DownloadReportApi {
        private final String token;
        private final String filename;

        private DownloadReportApi(String token, String filename) {
            this.token = token;
            this.filename = filename;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.downloadReportCall(this.token, this.filename, _callback);
        }

        public void execute() throws ApiException {
            RevenueIntegrationApi.this.downloadReportWithHttpInfo(this.token, this.filename);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.downloadReportWithHttpInfo(this.token, this.filename);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return RevenueIntegrationApi.this.downloadReportAsync(this.token, this.filename, _callback);
        }
    }

    public class DescribeViewColumnsApi {
        private final String viewName;
        private final String token;

        private DescribeViewColumnsApi(String viewName, String token) {
            this.viewName = viewName;
            this.token = token;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.describeViewColumnsCall(this.viewName, this.token, _callback);
        }

        public List<Bi3ViewsColumnsDescriptionResponse> execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.describeViewColumnsWithHttpInfo(this.viewName, this.token);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Bi3ViewsColumnsDescriptionResponse>> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.describeViewColumnsWithHttpInfo(this.viewName, this.token);
        }

        public Call executeAsync(ApiCallback<List<Bi3ViewsColumnsDescriptionResponse>> _callback) throws ApiException {
            return RevenueIntegrationApi.this.describeViewColumnsAsync(this.viewName, this.token, _callback);
        }
    }
}

