/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreateProductRatePlanRequest;
import com.zuora.model.GetProductRatePlanResponse;
import com.zuora.model.GetProductRatePlansByExternalIdResponse;
import com.zuora.model.GetProductRatePlansByProductResponse;
import com.zuora.model.ProxyCreateOrModifyResponse;
import com.zuora.model.ProxyDeleteResponse;
import com.zuora.model.UpdateProductRatePlanRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ProductRatePlansApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProductRatePlansApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductRatePlansApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createProductRatePlanCall(CreateProductRatePlanRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateProductRatePlanRequest localVarPostBody = createRequest;
        String localVarPath = "/v1/object/product-rate-plan";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProductRatePlanValidateBeforeCall(CreateProductRatePlanRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (createRequest == null) {
            throw new ApiException("Missing the required parameter 'createRequest' when calling createProductRatePlan(Async)");
        }
        return this.createProductRatePlanCall(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected ProxyCreateOrModifyResponse createProductRatePlan(CreateProductRatePlanRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<ProxyCreateOrModifyResponse> localVarResp = this.createProductRatePlanWithHttpInfo(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyCreateOrModifyResponse> createProductRatePlanWithHttpInfo(CreateProductRatePlanRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createProductRatePlanValidateBeforeCall(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<ProxyCreateOrModifyResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createProductRatePlanAsync(CreateProductRatePlanRequest createRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback<ProxyCreateOrModifyResponse> _callback) throws ApiException {
        Call localVarCall = this.createProductRatePlanValidateBeforeCall(createRequest, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ProxyCreateOrModifyResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateProductRatePlanApi createProductRatePlanApi(CreateProductRatePlanRequest createRequest) {
        return new CreateProductRatePlanApi(createRequest);
    }

    private Call deleteProductRatePlanCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/object/product-rate-plan/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProductRatePlanValidateBeforeCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteProductRatePlan(Async)");
        }
        return this.deleteProductRatePlanCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected ProxyDeleteResponse deleteProductRatePlan(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<ProxyDeleteResponse> localVarResp = this.deleteProductRatePlanWithHttpInfo(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyDeleteResponse> deleteProductRatePlanWithHttpInfo(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteProductRatePlanValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<ProxyDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call deleteProductRatePlanAsync(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback<ProxyDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteProductRatePlanValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ProxyDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteProductRatePlanApi deleteProductRatePlanApi(String id) {
        return new DeleteProductRatePlanApi(id);
    }

    private Call getProductRatePlanCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/product-rate-plans/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductRatePlanValidateBeforeCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProductRatePlan(Async)");
        }
        return this.getProductRatePlanCall(id, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetProductRatePlanResponse getProductRatePlan(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetProductRatePlanResponse> localVarResp = this.getProductRatePlanWithHttpInfo(id, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetProductRatePlanResponse> getProductRatePlanWithHttpInfo(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getProductRatePlanValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetProductRatePlanResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getProductRatePlanAsync(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetProductRatePlanResponse> _callback) throws ApiException {
        Call localVarCall = this.getProductRatePlanValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetProductRatePlanResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetProductRatePlanApi getProductRatePlanApi(String id) {
        return new GetProductRatePlanApi(id);
    }

    private Call getProductRatePlansByExternalIDCall(String externalId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/product-rate-plans/external-id/{externalId}".replace("{externalId}", this.localVarApiClient.escapeString(externalId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProductRatePlansByExternalIDValidateBeforeCall(String externalId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (externalId == null) {
            throw new ApiException("Missing the required parameter 'externalId' when calling getProductRatePlansByExternalID(Async)");
        }
        return this.getProductRatePlansByExternalIDCall(externalId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetProductRatePlansByExternalIdResponse getProductRatePlansByExternalID(String externalId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetProductRatePlansByExternalIdResponse> localVarResp = this.getProductRatePlansByExternalIDWithHttpInfo(externalId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetProductRatePlansByExternalIdResponse> getProductRatePlansByExternalIDWithHttpInfo(String externalId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getProductRatePlansByExternalIDValidateBeforeCall(externalId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetProductRatePlansByExternalIdResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getProductRatePlansByExternalIDAsync(String externalId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetProductRatePlansByExternalIdResponse> _callback) throws ApiException {
        Call localVarCall = this.getProductRatePlansByExternalIDValidateBeforeCall(externalId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetProductRatePlansByExternalIdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetProductRatePlansByExternalIDApi getProductRatePlansByExternalIDApi(String externalId) {
        return new GetProductRatePlansByExternalIDApi(externalId);
    }

    private Call getRatePlansByProductCall(String productKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/rateplan/{product-key}/productRatePlan".replace("{product-key}", this.localVarApiClient.escapeString(productKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRatePlansByProductValidateBeforeCall(String productKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (productKey == null) {
            throw new ApiException("Missing the required parameter 'productKey' when calling getRatePlansByProduct(Async)");
        }
        return this.getRatePlansByProductCall(productKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetProductRatePlansByProductResponse getRatePlansByProduct(String productKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetProductRatePlansByProductResponse> localVarResp = this.getRatePlansByProductWithHttpInfo(productKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetProductRatePlansByProductResponse> getRatePlansByProductWithHttpInfo(String productKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getRatePlansByProductValidateBeforeCall(productKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetProductRatePlansByProductResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getRatePlansByProductAsync(String productKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetProductRatePlansByProductResponse> _callback) throws ApiException {
        Call localVarCall = this.getRatePlansByProductValidateBeforeCall(productKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetProductRatePlansByProductResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetRatePlansByProductApi getRatePlansByProductApi(String productKey) {
        return new GetRatePlansByProductApi(productKey);
    }

    private Call updateProductRatePlanCall(String id, UpdateProductRatePlanRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateProductRatePlanRequest localVarPostBody = modifyRequest;
        String localVarPath = "/v1/object/product-rate-plan/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (xZuoraWSDLVersion != null) {
            localVarHeaderParams.put("X-Zuora-WSDL-Version", this.localVarApiClient.parameterToString(xZuoraWSDLVersion));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductRatePlanValidateBeforeCall(String id, UpdateProductRatePlanRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateProductRatePlan(Async)");
        }
        if (modifyRequest == null) {
            throw new ApiException("Missing the required parameter 'modifyRequest' when calling updateProductRatePlan(Async)");
        }
        return this.updateProductRatePlanCall(id, modifyRequest, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected ProxyCreateOrModifyResponse updateProductRatePlan(String id, UpdateProductRatePlanRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<ProxyCreateOrModifyResponse> localVarResp = this.updateProductRatePlanWithHttpInfo(id, modifyRequest, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyCreateOrModifyResponse> updateProductRatePlanWithHttpInfo(String id, UpdateProductRatePlanRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateProductRatePlanValidateBeforeCall(id, modifyRequest, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<ProxyCreateOrModifyResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateProductRatePlanAsync(String id, UpdateProductRatePlanRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String xZuoraWSDLVersion, String zuoraVersion, String zuoraOrgIds, ApiCallback<ProxyCreateOrModifyResponse> _callback) throws ApiException {
        Call localVarCall = this.updateProductRatePlanValidateBeforeCall(id, modifyRequest, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, xZuoraWSDLVersion, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ProxyCreateOrModifyResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateProductRatePlanApi updateProductRatePlanApi(String id, UpdateProductRatePlanRequest modifyRequest) {
        return new UpdateProductRatePlanApi(id, modifyRequest);
    }

    public class UpdateProductRatePlanApi {
        private final String id;
        private final UpdateProductRatePlanRequest modifyRequest;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateProductRatePlanApi(String id, UpdateProductRatePlanRequest modifyRequest) {
            this.id = id;
            this.modifyRequest = modifyRequest;
        }

        public UpdateProductRatePlanApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateProductRatePlanApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateProductRatePlanApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateProductRatePlanApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public UpdateProductRatePlanApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateProductRatePlanApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateProductRatePlanApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public UpdateProductRatePlanApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateProductRatePlanApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlansApi.this.updateProductRatePlanCall(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public ProxyCreateOrModifyResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlansApi.this.updateProductRatePlanWithHttpInfo(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
            return (ProxyCreateOrModifyResponse)localVarResp.getData();
        }

        public ApiResponse<ProxyCreateOrModifyResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlansApi.this.updateProductRatePlanWithHttpInfo(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<ProxyCreateOrModifyResponse> _callback) throws ApiException {
            return ProductRatePlansApi.this.updateProductRatePlanAsync(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetRatePlansByProductApi {
        private final String productKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetRatePlansByProductApi(String productKey) {
            this.productKey = productKey;
        }

        public GetRatePlansByProductApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetRatePlansByProductApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetRatePlansByProductApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetRatePlansByProductApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetRatePlansByProductApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetRatePlansByProductApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetRatePlansByProductApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetRatePlansByProductApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetRatePlansByProductApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlansApi.this.getRatePlansByProductCall(this.productKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetProductRatePlansByProductResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlansApi.this.getRatePlansByProductWithHttpInfo(this.productKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
            return (GetProductRatePlansByProductResponse)localVarResp.getData();
        }

        public ApiResponse<GetProductRatePlansByProductResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlansApi.this.getRatePlansByProductWithHttpInfo(this.productKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetProductRatePlansByProductResponse> _callback) throws ApiException {
            return ProductRatePlansApi.this.getRatePlansByProductAsync(this.productKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetProductRatePlansByExternalIDApi {
        private final String externalId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetProductRatePlansByExternalIDApi(String externalId) {
            this.externalId = externalId;
        }

        public GetProductRatePlansByExternalIDApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetProductRatePlansByExternalIDApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetProductRatePlansByExternalIDApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetProductRatePlansByExternalIDApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetProductRatePlansByExternalIDApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetProductRatePlansByExternalIDApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetProductRatePlansByExternalIDApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlansApi.this.getProductRatePlansByExternalIDCall(this.externalId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetProductRatePlansByExternalIdResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlansApi.this.getProductRatePlansByExternalIDWithHttpInfo(this.externalId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (GetProductRatePlansByExternalIdResponse)localVarResp.getData();
        }

        public ApiResponse<GetProductRatePlansByExternalIdResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlansApi.this.getProductRatePlansByExternalIDWithHttpInfo(this.externalId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetProductRatePlansByExternalIdResponse> _callback) throws ApiException {
            return ProductRatePlansApi.this.getProductRatePlansByExternalIDAsync(this.externalId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetProductRatePlanApi {
        private final String id;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetProductRatePlanApi(String id) {
            this.id = id;
        }

        public GetProductRatePlanApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetProductRatePlanApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetProductRatePlanApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetProductRatePlanApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetProductRatePlanApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetProductRatePlanApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetProductRatePlanApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlansApi.this.getProductRatePlanCall(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetProductRatePlanResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlansApi.this.getProductRatePlanWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (GetProductRatePlanResponse)localVarResp.getData();
        }

        public ApiResponse<GetProductRatePlanResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlansApi.this.getProductRatePlanWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetProductRatePlanResponse> _callback) throws ApiException {
            return ProductRatePlansApi.this.getProductRatePlanAsync(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class DeleteProductRatePlanApi {
        private final String id;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DeleteProductRatePlanApi(String id) {
            this.id = id;
        }

        public DeleteProductRatePlanApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteProductRatePlanApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteProductRatePlanApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteProductRatePlanApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteProductRatePlanApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteProductRatePlanApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteProductRatePlanApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlansApi.this.deleteProductRatePlanCall(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public ProxyDeleteResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlansApi.this.deleteProductRatePlanWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
            return (ProxyDeleteResponse)localVarResp.getData();
        }

        public ApiResponse<ProxyDeleteResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlansApi.this.deleteProductRatePlanWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<ProxyDeleteResponse> _callback) throws ApiException {
            return ProductRatePlansApi.this.deleteProductRatePlanAsync(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateProductRatePlanApi {
        private final CreateProductRatePlanRequest createRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String xZuoraWSDLVersion;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateProductRatePlanApi(CreateProductRatePlanRequest createRequest) {
            this.createRequest = createRequest;
        }

        public CreateProductRatePlanApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateProductRatePlanApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateProductRatePlanApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateProductRatePlanApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateProductRatePlanApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public CreateProductRatePlanApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateProductRatePlanApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateProductRatePlanApi xZuoraWSDLVersion(String xZuoraWSDLVersion) {
            this.xZuoraWSDLVersion = xZuoraWSDLVersion;
            return this;
        }

        public CreateProductRatePlanApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateProductRatePlanApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ProductRatePlansApi.this.createProductRatePlanCall(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public ProxyCreateOrModifyResponse execute() throws ApiException {
            ApiResponse localVarResp = ProductRatePlansApi.this.createProductRatePlanWithHttpInfo(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
            return (ProxyCreateOrModifyResponse)localVarResp.getData();
        }

        public ApiResponse<ProxyCreateOrModifyResponse> executeWithHttpInfo() throws ApiException {
            return ProductRatePlansApi.this.createProductRatePlanWithHttpInfo(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<ProxyCreateOrModifyResponse> _callback) throws ApiException {
            return ProductRatePlansApi.this.createProductRatePlanAsync(this.createRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.xZuoraWSDLVersion, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

