/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.PrepaidBalanceTransaction;
import org.threeten.bp.LocalDate;

public class PrepaidBalance {
    public static final String SERIALIZED_NAME_PREPAID_U_O_M = "prepaid_UOM";
    @SerializedName(value="prepaid_UOM")
    private String prepaidUOM;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_TOTAL_BALANCE = "total_balance";
    @SerializedName(value="total_balance")
    private BigDecimal totalBalance;
    public static final String SERIALIZED_NAME_REMAINING_BALANCE = "remaining_balance";
    @SerializedName(value="remaining_balance")
    private BigDecimal remainingBalance;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<PrepaidBalanceTransaction> transactions = null;

    public PrepaidBalance() {
    }

    public PrepaidBalance(List<PrepaidBalanceTransaction> transactions) {
        this();
        this.transactions = transactions;
    }

    public PrepaidBalance prepaidUOM(String prepaidUOM) {
        this.prepaidUOM = prepaidUOM;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unit of measure for the prepaid balance.")
    public String getPrepaidUOM() {
        return this.prepaidUOM;
    }

    public void setPrepaidUOM(String prepaidUOM) {
        this.prepaidUOM = prepaidUOM;
    }

    public PrepaidBalance startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="Start date of the fund effective period.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public PrepaidBalance endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="End date of the fund effective period.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public PrepaidBalance totalBalance(BigDecimal totalBalance) {
        this.totalBalance = totalBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The funded balance, which is the total units of the fund. ")
    public BigDecimal getTotalBalance() {
        return this.totalBalance;
    }

    public void setTotalBalance(BigDecimal totalBalance) {
        this.totalBalance = totalBalance;
    }

    public PrepaidBalance remainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remaining balance on the fund, which is the remaining units of the fund. ")
    public BigDecimal getRemainingBalance() {
        return this.remainingBalance;
    }

    public void setRemainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
    }

    @Nullable
    @ApiModelProperty(value="An array of prepaid balance transactions")
    public List<PrepaidBalanceTransaction> getTransactions() {
        return this.transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrepaidBalance prepaidBalance = (PrepaidBalance)o;
        return Objects.equals(this.prepaidUOM, prepaidBalance.prepaidUOM) && Objects.equals(this.startDate, prepaidBalance.startDate) && Objects.equals(this.endDate, prepaidBalance.endDate) && Objects.equals(this.totalBalance, prepaidBalance.totalBalance) && Objects.equals(this.remainingBalance, prepaidBalance.remainingBalance) && Objects.equals(this.transactions, prepaidBalance.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.prepaidUOM, this.startDate, this.endDate, this.totalBalance, this.remainingBalance, this.transactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrepaidBalance {\n");
        sb.append("    prepaidUOM: ").append(this.toIndentedString(this.prepaidUOM)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    totalBalance: ").append(this.toIndentedString(this.totalBalance)).append("\n");
        sb.append("    remainingBalance: ").append(this.toIndentedString(this.remainingBalance)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

