/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.Term;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Term information of the subscription.")
public class SubscriptionTermPatchResponse {
    public static final String SERIALIZED_NAME_CURRENT_TERM = "current_term";
    @SerializedName(value="current_term")
    private Term currentTerm;
    public static final String SERIALIZED_NAME_RENEWAL_TERM = "renewal_term";
    @SerializedName(value="renewal_term")
    private Term renewalTerm;
    public static final String SERIALIZED_NAME_AUTO_RENEW = "auto_renew";
    @SerializedName(value="auto_renew")
    private Boolean autoRenew;

    public SubscriptionTermPatchResponse currentTerm(Term currentTerm) {
        this.currentTerm = currentTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current term information for the subscription.")
    public Term getCurrentTerm() {
        return this.currentTerm;
    }

    public void setCurrentTerm(Term currentTerm) {
        this.currentTerm = currentTerm;
    }

    public SubscriptionTermPatchResponse renewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Renewal term information for the subscription.")
    public Term getRenewalTerm() {
        return this.renewalTerm;
    }

    public void setRenewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
    }

    public SubscriptionTermPatchResponse autoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, the subscription automatically renews at the end of the current term.")
    public Boolean getAutoRenew() {
        return this.autoRenew;
    }

    public void setAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionTermPatchResponse subscriptionTermPatchResponse = (SubscriptionTermPatchResponse)o;
        return Objects.equals(this.currentTerm, subscriptionTermPatchResponse.currentTerm) && Objects.equals(this.renewalTerm, subscriptionTermPatchResponse.renewalTerm) && Objects.equals(this.autoRenew, subscriptionTermPatchResponse.autoRenew);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.currentTerm, this.renewalTerm, this.autoRenew);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionTermPatchResponse {\n");
        sb.append("    currentTerm: ").append(this.toIndentedString(this.currentTerm)).append("\n");
        sb.append("    renewalTerm: ").append(this.toIndentedString(this.renewalTerm)).append("\n");
        sb.append("    autoRenew: ").append(this.toIndentedString(this.autoRenew)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

