/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class BillRun {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private Boolean email;
    public static final String SERIALIZED_NAME_POST = "post";
    @SerializedName(value="post")
    private Boolean post;
    public static final String SERIALIZED_NAME_RENEW = "renew";
    @SerializedName(value="renew")
    private Boolean renew;
    public static final String SERIALIZED_NAME_DAY_OF_MONTH = "day_of_month";
    @SerializedName(value="day_of_month")
    private String dayOfMonth;
    public static final String SERIALIZED_NAME_BILL_RUN_NUMBER = "bill_run_number";
    @SerializedName(value="bill_run_number")
    private String billRunNumber;
    public static final String SERIALIZED_NAME_BILL_RUN_TIME = "bill_run_time";
    @SerializedName(value="bill_run_time")
    private OffsetDateTime billRunTime;
    public static final String SERIALIZED_NAME_INVOICE_DATE = "invoice_date";
    @SerializedName(value="invoice_date")
    private LocalDate invoiceDate;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_BATCHES = "batches";
    @SerializedName(value="batches")
    private String batches;
    public static final String SERIALIZED_NAME_CHARGES_EXCLUDED = "charges_excluded";
    @SerializedName(value="charges_excluded")
    private String chargesExcluded;
    public static final String SERIALIZED_NAME_EMAIL_ZERO_AMOUNT_INVOICES = "email_zero_amount_invoices";
    @SerializedName(value="email_zero_amount_invoices")
    private Boolean emailZeroAmountInvoices;
    public static final String SERIALIZED_NAME_INVOICES_SENT = "invoices_sent";
    @SerializedName(value="invoices_sent")
    private Boolean invoicesSent;
    public static final String SERIALIZED_NAME_LAST_INVOICE_SENT_TIME = "last_invoice_sent_time";
    @SerializedName(value="last_invoice_sent_time")
    private LocalDate lastInvoiceSentTime;
    public static final String SERIALIZED_NAME_ACCOUNTS_PROCESSED = "accounts_processed";
    @SerializedName(value="accounts_processed")
    private Integer accountsProcessed;
    public static final String SERIALIZED_NAME_INVOICES_GENERATED = "invoices_generated";
    @SerializedName(value="invoices_generated")
    private Integer invoicesGenerated;
    public static final String SERIALIZED_NAME_CREDIT_MEMOS_GENERATED = "credit_memos_generated";
    @SerializedName(value="credit_memos_generated")
    private Integer creditMemosGenerated;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public BillRun() {
    }

    public BillRun(String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    public BillRun id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for this object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public BillRun customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public BillRun putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public BillRun accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the customer account to bill.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BillRun email(Boolean email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, invoices will be automatically emailed to customers.")
    public Boolean getEmail() {
        return this.email;
    }

    public void setEmail(Boolean email) {
        this.email = email;
    }

    public BillRun post(Boolean post) {
        this.post = post;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to automatically post a billing document after it is created.")
    public Boolean getPost() {
        return this.post;
    }

    public void setPost(Boolean post) {
        this.post = post;
    }

    public BillRun renew(Boolean renew) {
        this.renew = renew;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, subscriptions will be automatically renewed.")
    public Boolean getRenew() {
        return this.renew;
    }

    public void setRenew(Boolean renew) {
        this.renew = renew;
    }

    public BillRun dayOfMonth(String dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The day of the month to bill multiple customer accounts.")
    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(String dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public BillRun billRunNumber(String billRunNumber) {
        this.billRunNumber = billRunNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier for this object.")
    public String getBillRunNumber() {
        return this.billRunNumber;
    }

    public void setBillRunNumber(String billRunNumber) {
        this.billRunNumber = billRunNumber;
    }

    public BillRun billRunTime(OffsetDateTime billRunTime) {
        this.billRunTime = billRunTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time on which this bill run starts.")
    public OffsetDateTime getBillRunTime() {
        return this.billRunTime;
    }

    public void setBillRunTime(OffsetDateTime billRunTime) {
        this.billRunTime = billRunTime;
    }

    public BillRun invoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date displayed on the invoice.")
    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public BillRun targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="All unbilled items on or before this date are included in this bill run.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public BillRun state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status of the bill run.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public BillRun batches(String batches) {
        this.batches = batches;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the customer account batch to be included in this bill run.")
    public String getBatches() {
        return this.batches;
    }

    public void setBatches(String batches) {
        this.batches = batches;
    }

    public BillRun chargesExcluded(String chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of the charge to be excluded from the bill run.")
    public String getChargesExcluded() {
        return this.chargesExcluded;
    }

    public void setChargesExcluded(String chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
    }

    public BillRun emailZeroAmountInvoices(Boolean emailZeroAmountInvoices) {
        this.emailZeroAmountInvoices = emailZeroAmountInvoices;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `false`, invoices for zero amounts will not be emailed to customers.")
    public Boolean getEmailZeroAmountInvoices() {
        return this.emailZeroAmountInvoices;
    }

    public void setEmailZeroAmountInvoices(Boolean emailZeroAmountInvoices) {
        this.emailZeroAmountInvoices = emailZeroAmountInvoices;
    }

    public BillRun invoicesSent(Boolean invoicesSent) {
        this.invoicesSent = invoicesSent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the invoices have been automatically sent to customers.")
    public Boolean getInvoicesSent() {
        return this.invoicesSent;
    }

    public void setInvoicesSent(Boolean invoicesSent) {
        this.invoicesSent = invoicesSent;
    }

    public BillRun lastInvoiceSentTime(LocalDate lastInvoiceSentTime) {
        this.lastInvoiceSentTime = lastInvoiceSentTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the last invoice was sent.")
    public LocalDate getLastInvoiceSentTime() {
        return this.lastInvoiceSentTime;
    }

    public void setLastInvoiceSentTime(LocalDate lastInvoiceSentTime) {
        this.lastInvoiceSentTime = lastInvoiceSentTime;
    }

    public BillRun accountsProcessed(Integer accountsProcessed) {
        this.accountsProcessed = accountsProcessed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of accounts billed from this bill run.")
    public Integer getAccountsProcessed() {
        return this.accountsProcessed;
    }

    public void setAccountsProcessed(Integer accountsProcessed) {
        this.accountsProcessed = accountsProcessed;
    }

    public BillRun invoicesGenerated(Integer invoicesGenerated) {
        this.invoicesGenerated = invoicesGenerated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of invoices generated from this bill run.")
    public Integer getInvoicesGenerated() {
        return this.invoicesGenerated;
    }

    public void setInvoicesGenerated(Integer invoicesGenerated) {
        this.invoicesGenerated = invoicesGenerated;
    }

    public BillRun creditMemosGenerated(Integer creditMemosGenerated) {
        this.creditMemosGenerated = creditMemosGenerated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of credit memos generated from this bill run.")
    public Integer getCreditMemosGenerated() {
        return this.creditMemosGenerated;
    }

    public void setCreditMemosGenerated(Integer creditMemosGenerated) {
        this.creditMemosGenerated = creditMemosGenerated;
    }

    public BillRun name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the bill run.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillRun billRun = (BillRun)o;
        return Objects.equals(this.id, billRun.id) && Objects.equals(this.updatedById, billRun.updatedById) && Objects.equals(this.updatedTime, billRun.updatedTime) && Objects.equals(this.createdById, billRun.createdById) && Objects.equals(this.createdTime, billRun.createdTime) && Objects.equals(this.customFields, billRun.customFields) && Objects.equals(this.customObjects, billRun.customObjects) && Objects.equals(this.accountId, billRun.accountId) && Objects.equals(this.email, billRun.email) && Objects.equals(this.post, billRun.post) && Objects.equals(this.renew, billRun.renew) && Objects.equals(this.dayOfMonth, billRun.dayOfMonth) && Objects.equals(this.billRunNumber, billRun.billRunNumber) && Objects.equals(this.billRunTime, billRun.billRunTime) && Objects.equals(this.invoiceDate, billRun.invoiceDate) && Objects.equals(this.targetDate, billRun.targetDate) && Objects.equals((Object)this.state, (Object)billRun.state) && Objects.equals(this.batches, billRun.batches) && Objects.equals(this.chargesExcluded, billRun.chargesExcluded) && Objects.equals(this.emailZeroAmountInvoices, billRun.emailZeroAmountInvoices) && Objects.equals(this.invoicesSent, billRun.invoicesSent) && Objects.equals(this.lastInvoiceSentTime, billRun.lastInvoiceSentTime) && Objects.equals(this.accountsProcessed, billRun.accountsProcessed) && Objects.equals(this.invoicesGenerated, billRun.invoicesGenerated) && Objects.equals(this.creditMemosGenerated, billRun.creditMemosGenerated) && Objects.equals(this.name, billRun.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.accountId, this.email, this.post, this.renew, this.dayOfMonth, this.billRunNumber, this.billRunTime, this.invoiceDate, this.targetDate, this.state, this.batches, this.chargesExcluded, this.emailZeroAmountInvoices, this.invoicesSent, this.lastInvoiceSentTime, this.accountsProcessed, this.invoicesGenerated, this.creditMemosGenerated, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillRun {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    post: ").append(this.toIndentedString(this.post)).append("\n");
        sb.append("    renew: ").append(this.toIndentedString(this.renew)).append("\n");
        sb.append("    dayOfMonth: ").append(this.toIndentedString(this.dayOfMonth)).append("\n");
        sb.append("    billRunNumber: ").append(this.toIndentedString(this.billRunNumber)).append("\n");
        sb.append("    billRunTime: ").append(this.toIndentedString(this.billRunTime)).append("\n");
        sb.append("    invoiceDate: ").append(this.toIndentedString(this.invoiceDate)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    batches: ").append(this.toIndentedString(this.batches)).append("\n");
        sb.append("    chargesExcluded: ").append(this.toIndentedString(this.chargesExcluded)).append("\n");
        sb.append("    emailZeroAmountInvoices: ").append(this.toIndentedString(this.emailZeroAmountInvoices)).append("\n");
        sb.append("    invoicesSent: ").append(this.toIndentedString(this.invoicesSent)).append("\n");
        sb.append("    lastInvoiceSentTime: ").append(this.toIndentedString(this.lastInvoiceSentTime)).append("\n");
        sb.append("    accountsProcessed: ").append(this.toIndentedString(this.accountsProcessed)).append("\n");
        sb.append("    invoicesGenerated: ").append(this.toIndentedString(this.invoicesGenerated)).append("\n");
        sb.append("    creditMemosGenerated: ").append(this.toIndentedString(this.creditMemosGenerated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PROCESSING("processing"),
        POSTINPROGRESS("postInProgress"),
        CANCELINPROGRESS("cancelInProgress"),
        REMOVEINPROGRESS("removeInProgress"),
        PAUSED("paused"),
        PROCESSED("processed"),
        PENDING("pending"),
        COMPLETED("completed"),
        CANCELED("canceled"),
        POSTED("posted"),
        FAILED("failed"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

