/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.zuora.JSON;
import com.zuora.model.BillingDocumentItemProcessingType;
import com.zuora.model.BillingDocumentItemSourceType;
import com.zuora.model.CreditMemoItemFinanceInformation;
import com.zuora.model.GetCreditMemoItemTaxationItems;
import com.zuora.model.GetCreditMemoTaxItemResponse;
import com.zuora.model.MemoDetailRevenueImpacting;
import com.zuora.model.TaxMode;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class CreditMemoItem {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_AMOUNT_WITHOUT_TAX = "amountWithoutTax";
    @SerializedName(value="amountWithoutTax")
    private BigDecimal amountWithoutTax;
    public static final String SERIALIZED_NAME_APPLIED_AMOUNT = "appliedAmount";
    @SerializedName(value="appliedAmount")
    private BigDecimal appliedAmount;
    public static final String SERIALIZED_NAME_APPLIED_TO_ITEM_ID = "appliedToItemId";
    @SerializedName(value="appliedToItemId")
    private String appliedToItemId;
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @Deprecated
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_COMMITMENT_ID = "commitmentId";
    @SerializedName(value="commitmentId")
    private String commitmentId;
    public static final String SERIALIZED_NAME_COMMITMENT_PERIOD_ID = "commitmentPeriodId";
    @SerializedName(value="commitmentPeriodId")
    private String commitmentPeriodId;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "createdById";
    @SerializedName(value="createdById")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_DATE = "createdDate";
    @SerializedName(value="createdDate")
    private String createdDate;
    public static final String SERIALIZED_NAME_CREDIT_FROM_ITEM_ID = "creditFromItemId";
    @SerializedName(value="creditFromItemId")
    private String creditFromItemId;
    public static final String SERIALIZED_NAME_CREDIT_FROM_ITEM_SOURCE = "creditFromItemSource";
    @SerializedName(value="creditFromItemSource")
    private CreditFromItemSourceEnum creditFromItemSource;
    public static final String SERIALIZED_NAME_CREDIT_TAX_ITEMS = "creditTaxItems";
    @Deprecated
    @SerializedName(value="creditTaxItems")
    private List<GetCreditMemoTaxItemResponse> creditTaxItems;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXCLUDE_ITEM_BILLING_FROM_REVENUE_ACCOUNTING = "excludeItemBillingFromRevenueAccounting";
    @SerializedName(value="excludeItemBillingFromRevenueAccounting")
    private Boolean excludeItemBillingFromRevenueAccounting;
    public static final String SERIALIZED_NAME_FINANCE_INFORMATION = "financeInformation";
    @SerializedName(value="financeInformation")
    private CreditMemoItemFinanceInformation financeInformation;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INVOICE_SCHEDULE_ID = "invoiceScheduleId";
    @SerializedName(value="invoiceScheduleId")
    private String invoiceScheduleId;
    public static final String SERIALIZED_NAME_INVOICE_SCHEDULE_ITEM_ID = "invoiceScheduleItemId";
    @SerializedName(value="invoiceScheduleItemId")
    private String invoiceScheduleItemId;
    public static final String SERIALIZED_NAME_PROCESSING_TYPE = "processingType";
    @SerializedName(value="processingType")
    private BillingDocumentItemProcessingType processingType;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_REFUND_AMOUNT = "refundAmount";
    @SerializedName(value="refundAmount")
    private BigDecimal refundAmount;
    public static final String SERIALIZED_NAME_SERVICE_END_DATE = "serviceEndDate";
    @SerializedName(value="serviceEndDate")
    private LocalDate serviceEndDate;
    public static final String SERIALIZED_NAME_SERVICE_START_DATE = "serviceStartDate";
    @SerializedName(value="serviceStartDate")
    private LocalDate serviceStartDate;
    public static final String SERIALIZED_NAME_SHIP_TO_CONTACT_ID = "shipToContactId";
    @SerializedName(value="shipToContactId")
    private String shipToContactId;
    public static final String SERIALIZED_NAME_SKU = "sku";
    @SerializedName(value="sku")
    private String sku;
    public static final String SERIALIZED_NAME_SKU_NAME = "skuName";
    @SerializedName(value="skuName")
    private String skuName;
    public static final String SERIALIZED_NAME_SOLD_TO_CONTACT_ID = "soldToContactId";
    @SerializedName(value="soldToContactId")
    private String soldToContactId;
    public static final String SERIALIZED_NAME_SOLD_TO_CONTACT_SNAPSHOT_ID = "soldToContactSnapshotId";
    @SerializedName(value="soldToContactSnapshotId")
    private String soldToContactSnapshotId;
    public static final String SERIALIZED_NAME_SOURCE_ITEM_ID = "sourceItemId";
    @SerializedName(value="sourceItemId")
    private String sourceItemId;
    public static final String SERIALIZED_NAME_SOURCE_ITEM_TYPE = "sourceItemType";
    @SerializedName(value="sourceItemType")
    private BillingDocumentItemSourceType sourceItemType;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ID = "subscriptionId";
    @SerializedName(value="subscriptionId")
    private String subscriptionId;
    public static final String SERIALIZED_NAME_TAX_MODE = "taxMode";
    @SerializedName(value="taxMode")
    private TaxMode taxMode;
    public static final String SERIALIZED_NAME_TAXATION_ITEMS = "taxationItems";
    @SerializedName(value="taxationItems")
    private GetCreditMemoItemTaxationItems taxationItems;
    public static final String SERIALIZED_NAME_UNAPPLIED_AMOUNT = "unappliedAmount";
    @SerializedName(value="unappliedAmount")
    private BigDecimal unappliedAmount;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unitOfMeasure";
    @SerializedName(value="unitOfMeasure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_UNIT_PRICE = "unitPrice";
    @SerializedName(value="unitPrice")
    private BigDecimal unitPrice;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updatedById";
    @SerializedName(value="updatedById")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_DATE = "updatedDate";
    @SerializedName(value="updatedDate")
    private String updatedDate;
    public static final String SERIALIZED_NAME_ORDER_LINE_ITEM_ID = "orderLineItemId";
    @SerializedName(value="orderLineItemId")
    private String orderLineItemId;
    public static final String SERIALIZED_NAME_ITEM_TYPE = "itemType";
    @SerializedName(value="itemType")
    private String itemType;
    public static final String SERIALIZED_NAME_PURCHASE_ORDER_NUMBER = "purchaseOrderNumber";
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber;
    public static final String SERIALIZED_NAME_FULFILLMENT_ID = "fulfillmentId";
    @SerializedName(value="fulfillmentId")
    private String fulfillmentId;
    public static final String SERIALIZED_NAME_NUMBER_OF_DELIVERIES = "numberOfDeliveries";
    @SerializedName(value="numberOfDeliveries")
    private BigDecimal numberOfDeliveries;
    public static final String SERIALIZED_NAME_REFLECT_DISCOUNT_IN_NET_AMOUNT = "reflectDiscountInNetAmount";
    @SerializedName(value="reflectDiscountInNetAmount")
    private Boolean reflectDiscountInNetAmount;
    public static final String SERIALIZED_NAME_REVENUE_IMPACTING = "revenueImpacting";
    @SerializedName(value="revenueImpacting")
    private MemoDetailRevenueImpacting revenueImpacting;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreditMemoItem amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public CreditMemoItem amountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    @Nullable
    public BigDecimal getAmountWithoutTax() {
        return this.amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public CreditMemoItem appliedAmount(BigDecimal appliedAmount) {
        this.appliedAmount = appliedAmount;
        return this;
    }

    @Nullable
    public BigDecimal getAppliedAmount() {
        return this.appliedAmount;
    }

    public void setAppliedAmount(BigDecimal appliedAmount) {
        this.appliedAmount = appliedAmount;
    }

    public CreditMemoItem appliedToItemId(String appliedToItemId) {
        this.appliedToItemId = appliedToItemId;
        return this;
    }

    @Nullable
    public String getAppliedToItemId() {
        return this.appliedToItemId;
    }

    public void setAppliedToItemId(String appliedToItemId) {
        this.appliedToItemId = appliedToItemId;
    }

    @Deprecated
    public CreditMemoItem comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Deprecated
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Deprecated
    public void setComment(String comment) {
        this.comment = comment;
    }

    public CreditMemoItem commitmentId(String commitmentId) {
        this.commitmentId = commitmentId;
        return this;
    }

    @Nullable
    public String getCommitmentId() {
        return this.commitmentId;
    }

    public void setCommitmentId(String commitmentId) {
        this.commitmentId = commitmentId;
    }

    public CreditMemoItem commitmentPeriodId(String commitmentPeriodId) {
        this.commitmentPeriodId = commitmentPeriodId;
        return this;
    }

    @Nullable
    public String getCommitmentPeriodId() {
        return this.commitmentPeriodId;
    }

    public void setCommitmentPeriodId(String commitmentPeriodId) {
        this.commitmentPeriodId = commitmentPeriodId;
    }

    public CreditMemoItem createdById(String createdById) {
        this.createdById = createdById;
        return this;
    }

    @Nullable
    public String getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(String createdById) {
        this.createdById = createdById;
    }

    public CreditMemoItem createdDate(String createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public CreditMemoItem creditFromItemId(String creditFromItemId) {
        this.creditFromItemId = creditFromItemId;
        return this;
    }

    @Nullable
    public String getCreditFromItemId() {
        return this.creditFromItemId;
    }

    public void setCreditFromItemId(String creditFromItemId) {
        this.creditFromItemId = creditFromItemId;
    }

    public CreditMemoItem creditFromItemSource(CreditFromItemSourceEnum creditFromItemSource) {
        this.creditFromItemSource = creditFromItemSource;
        return this;
    }

    @Nullable
    public CreditFromItemSourceEnum getCreditFromItemSource() {
        return this.creditFromItemSource;
    }

    public void setCreditFromItemSource(CreditFromItemSourceEnum creditFromItemSource) {
        this.creditFromItemSource = creditFromItemSource;
    }

    @Deprecated
    public CreditMemoItem creditTaxItems(List<GetCreditMemoTaxItemResponse> creditTaxItems) {
        this.creditTaxItems = creditTaxItems;
        return this;
    }

    public CreditMemoItem addCreditTaxItemsItem(GetCreditMemoTaxItemResponse creditTaxItemsItem) {
        if (this.creditTaxItems == null) {
            this.creditTaxItems = new ArrayList<GetCreditMemoTaxItemResponse>();
        }
        this.creditTaxItems.add(creditTaxItemsItem);
        return this;
    }

    @Deprecated
    @Nullable
    public List<GetCreditMemoTaxItemResponse> getCreditTaxItems() {
        return this.creditTaxItems;
    }

    @Deprecated
    public void setCreditTaxItems(List<GetCreditMemoTaxItemResponse> creditTaxItems) {
        this.creditTaxItems = creditTaxItems;
    }

    public CreditMemoItem description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreditMemoItem excludeItemBillingFromRevenueAccounting(Boolean excludeItemBillingFromRevenueAccounting) {
        this.excludeItemBillingFromRevenueAccounting = excludeItemBillingFromRevenueAccounting;
        return this;
    }

    @Nullable
    public Boolean getExcludeItemBillingFromRevenueAccounting() {
        return this.excludeItemBillingFromRevenueAccounting;
    }

    public void setExcludeItemBillingFromRevenueAccounting(Boolean excludeItemBillingFromRevenueAccounting) {
        this.excludeItemBillingFromRevenueAccounting = excludeItemBillingFromRevenueAccounting;
    }

    public CreditMemoItem financeInformation(CreditMemoItemFinanceInformation financeInformation) {
        this.financeInformation = financeInformation;
        return this;
    }

    @Nullable
    public CreditMemoItemFinanceInformation getFinanceInformation() {
        return this.financeInformation;
    }

    public void setFinanceInformation(CreditMemoItemFinanceInformation financeInformation) {
        this.financeInformation = financeInformation;
    }

    public CreditMemoItem id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CreditMemoItem invoiceScheduleId(String invoiceScheduleId) {
        this.invoiceScheduleId = invoiceScheduleId;
        return this;
    }

    @Nullable
    public String getInvoiceScheduleId() {
        return this.invoiceScheduleId;
    }

    public void setInvoiceScheduleId(String invoiceScheduleId) {
        this.invoiceScheduleId = invoiceScheduleId;
    }

    public CreditMemoItem invoiceScheduleItemId(String invoiceScheduleItemId) {
        this.invoiceScheduleItemId = invoiceScheduleItemId;
        return this;
    }

    @Nullable
    public String getInvoiceScheduleItemId() {
        return this.invoiceScheduleItemId;
    }

    public void setInvoiceScheduleItemId(String invoiceScheduleItemId) {
        this.invoiceScheduleItemId = invoiceScheduleItemId;
    }

    public CreditMemoItem processingType(BillingDocumentItemProcessingType processingType) {
        this.processingType = processingType;
        return this;
    }

    @Nullable
    public BillingDocumentItemProcessingType getProcessingType() {
        return this.processingType;
    }

    public void setProcessingType(BillingDocumentItemProcessingType processingType) {
        this.processingType = processingType;
    }

    public CreditMemoItem quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public CreditMemoItem refundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
        return this;
    }

    @Nullable
    public BigDecimal getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public CreditMemoItem serviceEndDate(LocalDate serviceEndDate) {
        this.serviceEndDate = serviceEndDate;
        return this;
    }

    @Nullable
    public LocalDate getServiceEndDate() {
        return this.serviceEndDate;
    }

    public void setServiceEndDate(LocalDate serviceEndDate) {
        this.serviceEndDate = serviceEndDate;
    }

    public CreditMemoItem serviceStartDate(LocalDate serviceStartDate) {
        this.serviceStartDate = serviceStartDate;
        return this;
    }

    @Nullable
    public LocalDate getServiceStartDate() {
        return this.serviceStartDate;
    }

    public void setServiceStartDate(LocalDate serviceStartDate) {
        this.serviceStartDate = serviceStartDate;
    }

    public CreditMemoItem shipToContactId(String shipToContactId) {
        this.shipToContactId = shipToContactId;
        return this;
    }

    @Nullable
    public String getShipToContactId() {
        return this.shipToContactId;
    }

    public void setShipToContactId(String shipToContactId) {
        this.shipToContactId = shipToContactId;
    }

    public CreditMemoItem sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Nullable
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public CreditMemoItem skuName(String skuName) {
        this.skuName = skuName;
        return this;
    }

    @Nullable
    public String getSkuName() {
        return this.skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public CreditMemoItem soldToContactId(String soldToContactId) {
        this.soldToContactId = soldToContactId;
        return this;
    }

    @Nullable
    public String getSoldToContactId() {
        return this.soldToContactId;
    }

    public void setSoldToContactId(String soldToContactId) {
        this.soldToContactId = soldToContactId;
    }

    public CreditMemoItem soldToContactSnapshotId(String soldToContactSnapshotId) {
        this.soldToContactSnapshotId = soldToContactSnapshotId;
        return this;
    }

    @Nullable
    public String getSoldToContactSnapshotId() {
        return this.soldToContactSnapshotId;
    }

    public void setSoldToContactSnapshotId(String soldToContactSnapshotId) {
        this.soldToContactSnapshotId = soldToContactSnapshotId;
    }

    public CreditMemoItem sourceItemId(String sourceItemId) {
        this.sourceItemId = sourceItemId;
        return this;
    }

    @Nullable
    public String getSourceItemId() {
        return this.sourceItemId;
    }

    public void setSourceItemId(String sourceItemId) {
        this.sourceItemId = sourceItemId;
    }

    public CreditMemoItem sourceItemType(BillingDocumentItemSourceType sourceItemType) {
        this.sourceItemType = sourceItemType;
        return this;
    }

    @Nullable
    public BillingDocumentItemSourceType getSourceItemType() {
        return this.sourceItemType;
    }

    public void setSourceItemType(BillingDocumentItemSourceType sourceItemType) {
        this.sourceItemType = sourceItemType;
    }

    public CreditMemoItem subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @Nullable
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public CreditMemoItem taxMode(TaxMode taxMode) {
        this.taxMode = taxMode;
        return this;
    }

    @Nullable
    public TaxMode getTaxMode() {
        return this.taxMode;
    }

    public void setTaxMode(TaxMode taxMode) {
        this.taxMode = taxMode;
    }

    public CreditMemoItem taxationItems(GetCreditMemoItemTaxationItems taxationItems) {
        this.taxationItems = taxationItems;
        return this;
    }

    @Nullable
    public GetCreditMemoItemTaxationItems getTaxationItems() {
        return this.taxationItems;
    }

    public void setTaxationItems(GetCreditMemoItemTaxationItems taxationItems) {
        this.taxationItems = taxationItems;
    }

    public CreditMemoItem unappliedAmount(BigDecimal unappliedAmount) {
        this.unappliedAmount = unappliedAmount;
        return this;
    }

    @Nullable
    public BigDecimal getUnappliedAmount() {
        return this.unappliedAmount;
    }

    public void setUnappliedAmount(BigDecimal unappliedAmount) {
        this.unappliedAmount = unappliedAmount;
    }

    public CreditMemoItem unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public CreditMemoItem unitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @Nullable
    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public CreditMemoItem updatedById(String updatedById) {
        this.updatedById = updatedById;
        return this;
    }

    @Nullable
    public String getUpdatedById() {
        return this.updatedById;
    }

    public void setUpdatedById(String updatedById) {
        this.updatedById = updatedById;
    }

    public CreditMemoItem updatedDate(String updatedDate) {
        this.updatedDate = updatedDate;
        return this;
    }

    @Nullable
    public String getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(String updatedDate) {
        this.updatedDate = updatedDate;
    }

    public CreditMemoItem orderLineItemId(String orderLineItemId) {
        this.orderLineItemId = orderLineItemId;
        return this;
    }

    @Nullable
    public String getOrderLineItemId() {
        return this.orderLineItemId;
    }

    public void setOrderLineItemId(String orderLineItemId) {
        this.orderLineItemId = orderLineItemId;
    }

    public CreditMemoItem itemType(String itemType) {
        this.itemType = itemType;
        return this;
    }

    @Nullable
    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public CreditMemoItem purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Nullable
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public CreditMemoItem fulfillmentId(String fulfillmentId) {
        this.fulfillmentId = fulfillmentId;
        return this;
    }

    @Nullable
    public String getFulfillmentId() {
        return this.fulfillmentId;
    }

    public void setFulfillmentId(String fulfillmentId) {
        this.fulfillmentId = fulfillmentId;
    }

    public CreditMemoItem numberOfDeliveries(BigDecimal numberOfDeliveries) {
        this.numberOfDeliveries = numberOfDeliveries;
        return this;
    }

    @Nullable
    public BigDecimal getNumberOfDeliveries() {
        return this.numberOfDeliveries;
    }

    public void setNumberOfDeliveries(BigDecimal numberOfDeliveries) {
        this.numberOfDeliveries = numberOfDeliveries;
    }

    public CreditMemoItem reflectDiscountInNetAmount(Boolean reflectDiscountInNetAmount) {
        this.reflectDiscountInNetAmount = reflectDiscountInNetAmount;
        return this;
    }

    @Nullable
    public Boolean getReflectDiscountInNetAmount() {
        return this.reflectDiscountInNetAmount;
    }

    public void setReflectDiscountInNetAmount(Boolean reflectDiscountInNetAmount) {
        this.reflectDiscountInNetAmount = reflectDiscountInNetAmount;
    }

    public CreditMemoItem revenueImpacting(MemoDetailRevenueImpacting revenueImpacting) {
        this.revenueImpacting = revenueImpacting;
        return this;
    }

    @Nullable
    public MemoDetailRevenueImpacting getRevenueImpacting() {
        return this.revenueImpacting;
    }

    public void setRevenueImpacting(MemoDetailRevenueImpacting revenueImpacting) {
        this.revenueImpacting = revenueImpacting;
    }

    public CreditMemoItem putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditMemoItem creditMemoItem = (CreditMemoItem)o;
        return Objects.equals(this.amount, creditMemoItem.amount) && Objects.equals(this.amountWithoutTax, creditMemoItem.amountWithoutTax) && Objects.equals(this.appliedAmount, creditMemoItem.appliedAmount) && Objects.equals(this.appliedToItemId, creditMemoItem.appliedToItemId) && Objects.equals(this.comment, creditMemoItem.comment) && Objects.equals(this.commitmentId, creditMemoItem.commitmentId) && Objects.equals(this.commitmentPeriodId, creditMemoItem.commitmentPeriodId) && Objects.equals(this.createdById, creditMemoItem.createdById) && Objects.equals(this.createdDate, creditMemoItem.createdDate) && Objects.equals(this.creditFromItemId, creditMemoItem.creditFromItemId) && Objects.equals((Object)this.creditFromItemSource, (Object)creditMemoItem.creditFromItemSource) && Objects.equals(this.creditTaxItems, creditMemoItem.creditTaxItems) && Objects.equals(this.description, creditMemoItem.description) && Objects.equals(this.excludeItemBillingFromRevenueAccounting, creditMemoItem.excludeItemBillingFromRevenueAccounting) && Objects.equals(this.financeInformation, creditMemoItem.financeInformation) && Objects.equals(this.id, creditMemoItem.id) && Objects.equals(this.invoiceScheduleId, creditMemoItem.invoiceScheduleId) && Objects.equals(this.invoiceScheduleItemId, creditMemoItem.invoiceScheduleItemId) && Objects.equals((Object)this.processingType, (Object)creditMemoItem.processingType) && Objects.equals(this.quantity, creditMemoItem.quantity) && Objects.equals(this.refundAmount, creditMemoItem.refundAmount) && Objects.equals(this.serviceEndDate, creditMemoItem.serviceEndDate) && Objects.equals(this.serviceStartDate, creditMemoItem.serviceStartDate) && Objects.equals(this.shipToContactId, creditMemoItem.shipToContactId) && Objects.equals(this.sku, creditMemoItem.sku) && Objects.equals(this.skuName, creditMemoItem.skuName) && Objects.equals(this.soldToContactId, creditMemoItem.soldToContactId) && Objects.equals(this.soldToContactSnapshotId, creditMemoItem.soldToContactSnapshotId) && Objects.equals(this.sourceItemId, creditMemoItem.sourceItemId) && Objects.equals((Object)this.sourceItemType, (Object)creditMemoItem.sourceItemType) && Objects.equals(this.subscriptionId, creditMemoItem.subscriptionId) && Objects.equals((Object)this.taxMode, (Object)creditMemoItem.taxMode) && Objects.equals(this.taxationItems, creditMemoItem.taxationItems) && Objects.equals(this.unappliedAmount, creditMemoItem.unappliedAmount) && Objects.equals(this.unitOfMeasure, creditMemoItem.unitOfMeasure) && Objects.equals(this.unitPrice, creditMemoItem.unitPrice) && Objects.equals(this.updatedById, creditMemoItem.updatedById) && Objects.equals(this.updatedDate, creditMemoItem.updatedDate) && Objects.equals(this.orderLineItemId, creditMemoItem.orderLineItemId) && Objects.equals(this.itemType, creditMemoItem.itemType) && Objects.equals(this.purchaseOrderNumber, creditMemoItem.purchaseOrderNumber) && Objects.equals(this.fulfillmentId, creditMemoItem.fulfillmentId) && Objects.equals(this.numberOfDeliveries, creditMemoItem.numberOfDeliveries) && Objects.equals(this.reflectDiscountInNetAmount, creditMemoItem.reflectDiscountInNetAmount) && Objects.equals((Object)this.revenueImpacting, (Object)creditMemoItem.revenueImpacting) && Objects.equals(this.additionalProperties, creditMemoItem.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.amountWithoutTax, this.appliedAmount, this.appliedToItemId, this.comment, this.commitmentId, this.commitmentPeriodId, this.createdById, this.createdDate, this.creditFromItemId, this.creditFromItemSource, this.creditTaxItems, this.description, this.excludeItemBillingFromRevenueAccounting, this.financeInformation, this.id, this.invoiceScheduleId, this.invoiceScheduleItemId, this.processingType, this.quantity, this.refundAmount, this.serviceEndDate, this.serviceStartDate, this.shipToContactId, this.sku, this.skuName, this.soldToContactId, this.soldToContactSnapshotId, this.sourceItemId, this.sourceItemType, this.subscriptionId, this.taxMode, this.taxationItems, this.unappliedAmount, this.unitOfMeasure, this.unitPrice, this.updatedById, this.updatedDate, this.orderLineItemId, this.itemType, this.purchaseOrderNumber, this.fulfillmentId, this.numberOfDeliveries, this.reflectDiscountInNetAmount, this.revenueImpacting, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditMemoItem {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountWithoutTax: ").append(this.toIndentedString(this.amountWithoutTax)).append("\n");
        sb.append("    appliedAmount: ").append(this.toIndentedString(this.appliedAmount)).append("\n");
        sb.append("    appliedToItemId: ").append(this.toIndentedString(this.appliedToItemId)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    commitmentId: ").append(this.toIndentedString(this.commitmentId)).append("\n");
        sb.append("    commitmentPeriodId: ").append(this.toIndentedString(this.commitmentPeriodId)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    creditFromItemId: ").append(this.toIndentedString(this.creditFromItemId)).append("\n");
        sb.append("    creditFromItemSource: ").append(this.toIndentedString((Object)this.creditFromItemSource)).append("\n");
        sb.append("    creditTaxItems: ").append(this.toIndentedString(this.creditTaxItems)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    excludeItemBillingFromRevenueAccounting: ").append(this.toIndentedString(this.excludeItemBillingFromRevenueAccounting)).append("\n");
        sb.append("    financeInformation: ").append(this.toIndentedString(this.financeInformation)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    invoiceScheduleId: ").append(this.toIndentedString(this.invoiceScheduleId)).append("\n");
        sb.append("    invoiceScheduleItemId: ").append(this.toIndentedString(this.invoiceScheduleItemId)).append("\n");
        sb.append("    processingType: ").append(this.toIndentedString((Object)this.processingType)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    refundAmount: ").append(this.toIndentedString(this.refundAmount)).append("\n");
        sb.append("    serviceEndDate: ").append(this.toIndentedString(this.serviceEndDate)).append("\n");
        sb.append("    serviceStartDate: ").append(this.toIndentedString(this.serviceStartDate)).append("\n");
        sb.append("    shipToContactId: ").append(this.toIndentedString(this.shipToContactId)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    skuName: ").append(this.toIndentedString(this.skuName)).append("\n");
        sb.append("    soldToContactId: ").append(this.toIndentedString(this.soldToContactId)).append("\n");
        sb.append("    soldToContactSnapshotId: ").append(this.toIndentedString(this.soldToContactSnapshotId)).append("\n");
        sb.append("    sourceItemId: ").append(this.toIndentedString(this.sourceItemId)).append("\n");
        sb.append("    sourceItemType: ").append(this.toIndentedString((Object)this.sourceItemType)).append("\n");
        sb.append("    subscriptionId: ").append(this.toIndentedString(this.subscriptionId)).append("\n");
        sb.append("    taxMode: ").append(this.toIndentedString((Object)this.taxMode)).append("\n");
        sb.append("    taxationItems: ").append(this.toIndentedString(this.taxationItems)).append("\n");
        sb.append("    unappliedAmount: ").append(this.toIndentedString(this.unappliedAmount)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    unitPrice: ").append(this.toIndentedString(this.unitPrice)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedDate: ").append(this.toIndentedString(this.updatedDate)).append("\n");
        sb.append("    orderLineItemId: ").append(this.toIndentedString(this.orderLineItemId)).append("\n");
        sb.append("    itemType: ").append(this.toIndentedString(this.itemType)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    fulfillmentId: ").append(this.toIndentedString(this.fulfillmentId)).append("\n");
        sb.append("    numberOfDeliveries: ").append(this.toIndentedString(this.numberOfDeliveries)).append("\n");
        sb.append("    reflectDiscountInNetAmount: ").append(this.toIndentedString(this.reflectDiscountInNetAmount)).append("\n");
        sb.append("    revenueImpacting: ").append(this.toIndentedString((Object)this.revenueImpacting)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraycreditTaxItems;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreditMemoItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_APPLIED_TO_ITEM_ID) != null && !jsonObj.get(SERIALIZED_NAME_APPLIED_TO_ITEM_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APPLIED_TO_ITEM_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `appliedToItemId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLIED_TO_ITEM_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMITMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_COMMITMENT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMITMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `commitmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMITMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMITMENT_PERIOD_ID) != null && !jsonObj.get(SERIALIZED_NAME_COMMITMENT_PERIOD_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMITMENT_PERIOD_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `commitmentPeriodId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMITMENT_PERIOD_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATED_BY_ID) != null && !jsonObj.get(SERIALIZED_NAME_CREATED_BY_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATED_BY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `createdById` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED_BY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATED_DATE) != null && !jsonObj.get(SERIALIZED_NAME_CREATED_DATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATED_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `createdDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED_DATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_ID) != null && !jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `creditFromItemId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_SOURCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_SOURCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `creditFromItemSource` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_SOURCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_SOURCE).isJsonNull()) {
            CreditFromItemSourceEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CREDIT_FROM_ITEM_SOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREDIT_TAX_ITEMS) != null && !jsonObj.get(SERIALIZED_NAME_CREDIT_TAX_ITEMS).isJsonNull() && (jsonArraycreditTaxItems = jsonObj.getAsJsonArray(SERIALIZED_NAME_CREDIT_TAX_ITEMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CREDIT_TAX_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `creditTaxItems` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREDIT_TAX_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArraycreditTaxItems.size(); ++i) {
                GetCreditMemoTaxItemResponse.validateJsonElement(jsonArraycreditTaxItems.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FINANCE_INFORMATION) != null && !jsonObj.get(SERIALIZED_NAME_FINANCE_INFORMATION).isJsonNull()) {
            CreditMemoItemFinanceInformation.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FINANCE_INFORMATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ID) != null && !jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `invoiceScheduleId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ITEM_ID) != null && !jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ITEM_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ITEM_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `invoiceScheduleItemId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ITEM_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `processingType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE).isJsonNull()) {
            BillingDocumentItemProcessingType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHIP_TO_CONTACT_ID) != null && !jsonObj.get(SERIALIZED_NAME_SHIP_TO_CONTACT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SHIP_TO_CONTACT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shipToContactId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHIP_TO_CONTACT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SKU) != null && !jsonObj.get(SERIALIZED_NAME_SKU).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SKU).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sku` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SKU).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SKU_NAME) != null && !jsonObj.get(SERIALIZED_NAME_SKU_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SKU_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `skuName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SKU_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOLD_TO_CONTACT_ID) != null && !jsonObj.get(SERIALIZED_NAME_SOLD_TO_CONTACT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SOLD_TO_CONTACT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `soldToContactId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOLD_TO_CONTACT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOLD_TO_CONTACT_SNAPSHOT_ID) != null && !jsonObj.get(SERIALIZED_NAME_SOLD_TO_CONTACT_SNAPSHOT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SOLD_TO_CONTACT_SNAPSHOT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `soldToContactSnapshotId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOLD_TO_CONTACT_SNAPSHOT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_ID) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceItemId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceItemType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_TYPE).isJsonNull()) {
            BillingDocumentItemSourceType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SOURCE_ITEM_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBSCRIPTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_SUBSCRIPTION_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUBSCRIPTION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subscriptionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBSCRIPTION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_MODE) != null && !jsonObj.get(SERIALIZED_NAME_TAX_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAX_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `taxMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_MODE) != null && !jsonObj.get(SERIALIZED_NAME_TAX_MODE).isJsonNull()) {
            TaxMode.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TAX_MODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAXATION_ITEMS) != null && !jsonObj.get(SERIALIZED_NAME_TAXATION_ITEMS).isJsonNull()) {
            GetCreditMemoItemTaxationItems.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TAXATION_ITEMS));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIT_OF_MEASURE) != null && !jsonObj.get(SERIALIZED_NAME_UNIT_OF_MEASURE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNIT_OF_MEASURE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unitOfMeasure` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIT_OF_MEASURE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UPDATED_BY_ID) != null && !jsonObj.get(SERIALIZED_NAME_UPDATED_BY_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPDATED_BY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `updatedById` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPDATED_BY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UPDATED_DATE) != null && !jsonObj.get(SERIALIZED_NAME_UPDATED_DATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPDATED_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `updatedDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPDATED_DATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEM_ID) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEM_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEM_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `orderLineItemId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEM_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ITEM_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ITEM_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ITEM_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `itemType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEM_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PURCHASE_ORDER_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_PURCHASE_ORDER_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PURCHASE_ORDER_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `purchaseOrderNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PURCHASE_ORDER_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FULFILLMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_FULFILLMENT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FULFILLMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fulfillmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FULFILLMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REVENUE_IMPACTING) != null && !jsonObj.get(SERIALIZED_NAME_REVENUE_IMPACTING).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REVENUE_IMPACTING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `revenueImpacting` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REVENUE_IMPACTING).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REVENUE_IMPACTING) != null && !jsonObj.get(SERIALIZED_NAME_REVENUE_IMPACTING).isJsonNull()) {
            MemoDetailRevenueImpacting.validateJsonElement(jsonObj.get(SERIALIZED_NAME_REVENUE_IMPACTING));
        }
    }

    public static CreditMemoItem fromJson(String jsonString) throws IOException {
        return (CreditMemoItem)JSON.getGson().fromJson(jsonString, CreditMemoItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_AMOUNT_WITHOUT_TAX);
        openapiFields.add(SERIALIZED_NAME_APPLIED_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_APPLIED_TO_ITEM_ID);
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_COMMITMENT_ID);
        openapiFields.add(SERIALIZED_NAME_COMMITMENT_PERIOD_ID);
        openapiFields.add(SERIALIZED_NAME_CREATED_BY_ID);
        openapiFields.add(SERIALIZED_NAME_CREATED_DATE);
        openapiFields.add(SERIALIZED_NAME_CREDIT_FROM_ITEM_ID);
        openapiFields.add(SERIALIZED_NAME_CREDIT_FROM_ITEM_SOURCE);
        openapiFields.add(SERIALIZED_NAME_CREDIT_TAX_ITEMS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_EXCLUDE_ITEM_BILLING_FROM_REVENUE_ACCOUNTING);
        openapiFields.add(SERIALIZED_NAME_FINANCE_INFORMATION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INVOICE_SCHEDULE_ID);
        openapiFields.add(SERIALIZED_NAME_INVOICE_SCHEDULE_ITEM_ID);
        openapiFields.add(SERIALIZED_NAME_PROCESSING_TYPE);
        openapiFields.add(SERIALIZED_NAME_QUANTITY);
        openapiFields.add(SERIALIZED_NAME_REFUND_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_SERVICE_END_DATE);
        openapiFields.add(SERIALIZED_NAME_SERVICE_START_DATE);
        openapiFields.add(SERIALIZED_NAME_SHIP_TO_CONTACT_ID);
        openapiFields.add(SERIALIZED_NAME_SKU);
        openapiFields.add(SERIALIZED_NAME_SKU_NAME);
        openapiFields.add(SERIALIZED_NAME_SOLD_TO_CONTACT_ID);
        openapiFields.add(SERIALIZED_NAME_SOLD_TO_CONTACT_SNAPSHOT_ID);
        openapiFields.add(SERIALIZED_NAME_SOURCE_ITEM_ID);
        openapiFields.add(SERIALIZED_NAME_SOURCE_ITEM_TYPE);
        openapiFields.add(SERIALIZED_NAME_SUBSCRIPTION_ID);
        openapiFields.add(SERIALIZED_NAME_TAX_MODE);
        openapiFields.add(SERIALIZED_NAME_TAXATION_ITEMS);
        openapiFields.add(SERIALIZED_NAME_UNAPPLIED_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_UNIT_OF_MEASURE);
        openapiFields.add(SERIALIZED_NAME_UNIT_PRICE);
        openapiFields.add(SERIALIZED_NAME_UPDATED_BY_ID);
        openapiFields.add(SERIALIZED_NAME_UPDATED_DATE);
        openapiFields.add(SERIALIZED_NAME_ORDER_LINE_ITEM_ID);
        openapiFields.add(SERIALIZED_NAME_ITEM_TYPE);
        openapiFields.add(SERIALIZED_NAME_PURCHASE_ORDER_NUMBER);
        openapiFields.add(SERIALIZED_NAME_FULFILLMENT_ID);
        openapiFields.add(SERIALIZED_NAME_NUMBER_OF_DELIVERIES);
        openapiFields.add(SERIALIZED_NAME_REFLECT_DISCOUNT_IN_NET_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_REVENUE_IMPACTING);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CreditMemoItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreditMemoItem.class));
            return new TypeAdapter<CreditMemoItem>(){

                public void write(JsonWriter out, CreditMemoItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    out.beginObject();
                    for (Map.Entry e : obj.entrySet()) {
                        out.name((String)e.getKey());
                        elementAdapter.write(out, (Object)((JsonElement)e.getValue()));
                    }
                    if (value.getAdditionalProperties() != null) {
                        boolean oldSerializeNulls = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                            } else if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                            } else if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                            } else if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                            } else if (entry.getValue() == null) {
                                obj.add(entry.getKey(), null);
                            } else {
                                JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                                if (jsonElement.isJsonArray()) {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                } else {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                                }
                            }
                            out.name(entry.getKey());
                            elementAdapter.write(out, (Object)obj.get(entry.getKey()));
                        }
                        out.setSerializeNulls(oldSerializeNulls);
                    }
                    out.endObject();
                }

                public CreditMemoItem read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CreditMemoItem.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    CreditMemoItem instance = (CreditMemoItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CreditFromItemSourceEnum {
        INVOICEITEM("InvoiceItem"),
        CREDITMEMOITEM("CreditMemoItem"),
        DEBITMEMOITEM("DebitMemoItem");

        private String value;

        private CreditFromItemSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CreditFromItemSourceEnum fromValue(String value) {
            for (CreditFromItemSourceEnum b : CreditFromItemSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            CreditFromItemSourceEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<CreditFromItemSourceEnum> {
            public void write(JsonWriter jsonWriter, CreditFromItemSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CreditFromItemSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CreditFromItemSourceEnum.fromValue(value);
            }
        }
    }
}

