/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum BusinessCategory {
    B2B("B2B"),
    B2C("B2C"),
    B2G("B2G");

    private String value;

    private BusinessCategory(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BusinessCategory fromValue(String value) {
        for (BusinessCategory b : BusinessCategory.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        BusinessCategory.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<BusinessCategory> {
        public void write(JsonWriter jsonWriter, BusinessCategory enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public BusinessCategory read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return BusinessCategory.fromValue(value);
        }
    }
}

