/*
 * Decompiled with CFR 0.152.
 */
package com.zuora;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ZuoraClientConfig {
    public static final String ZUORA_ENTITY_IDS = "Zuora-Entity-Ids";
    public static final String ZUORA_ORG_IDS = "Zuora-Org-Ids";
    public static final String ZUORA_VERSION = "Zuora-Version";
    public static final String USER_AGENT = "User-Agent";
    public static final String Accept_Encoding = "Accept-Encoding";
    public static final String Content_Encoding = "Content-Encoding";
    public static final String Content_Type = "Content-Type";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 65000;
    public static final int DEFAULT_READ_TIMEOUT = 65000;
    public static final int DEFAULT_WRITE_TIMEOUT = 65000;
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final int DEFAULT_RETRY_BASE_DELAY_MS = 1000;
    public static final int DEFAULT_REINIT_INTERVAL_SECONDS = 600;
    private String clientId;
    private String clientSecret;
    private String baseUrl;
    private int connectionTimeout = 65000;
    private int readTimeout = 65000;
    private int writeTimeout = 65000;
    private boolean debugging;
    private String zuoraVersion;
    private String zuoraEntityIds;
    private String zuoraOrgIds;
    private String acceptEncoding;
    private String contentEncoding;
    private boolean retryOnConnectionFailure = true;
    private String userAgent;
    private Map<String, String> defaultHeaders = new HashMap<String, String>();
    private int maxRetries = 3;
    private int retryBaseDelayMs = 1000;
    private int reinitIntervalSeconds = 600;

    public String getClientId() {
        return this.clientId;
    }

    protected void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    protected void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    protected void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    protected void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    protected void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    protected void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public String getZuoraVersion() {
        return this.zuoraVersion;
    }

    protected void setZuoraVersion(String zuoraVersion) {
        this.zuoraVersion = zuoraVersion;
        this.addDefaultHeader(ZUORA_VERSION, zuoraVersion);
    }

    public String getZuoraEntityIds() {
        return this.zuoraEntityIds;
    }

    protected void setZuoraEntityIds(String zuoraEntityIds) {
        this.zuoraEntityIds = zuoraEntityIds;
        this.addDefaultHeader(ZUORA_ENTITY_IDS, zuoraEntityIds);
    }

    public String getZuoraOrgIds() {
        return this.zuoraOrgIds;
    }

    protected void setZuoraOrgIds(String zuoraOrgIds) {
        this.zuoraOrgIds = zuoraOrgIds;
        this.addDefaultHeader(ZUORA_ORG_IDS, zuoraOrgIds);
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    protected void setAcceptEncoding(String acceptEncoding) {
        this.acceptEncoding = acceptEncoding;
        this.addDefaultHeader(Accept_Encoding, acceptEncoding);
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    protected void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        this.addDefaultHeader(Content_Encoding, contentEncoding);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    protected void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    protected void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    protected void setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
        this.retryOnConnectionFailure = retryOnConnectionFailure;
    }

    protected void addDefaultHeaders(Map<String, String> headers) {
        this.defaultHeaders.putAll(headers);
    }

    protected void addDefaultHeader(String key, String value) {
        this.defaultHeaders.put(key, value);
    }

    public Map<String, String> getDefaultHeaders() {
        return Collections.unmodifiableMap(this.defaultHeaders);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries < 1 || maxRetries > 10) {
            throw new IllegalArgumentException("maxRetries must be between 1 and 10");
        }
        this.maxRetries = maxRetries;
    }

    public int getRetryBaseDelayMs() {
        return this.retryBaseDelayMs;
    }

    public void setRetryBaseDelayMs(int retryBaseDelayMs) {
        if (retryBaseDelayMs < 100 || retryBaseDelayMs > 30000) {
            throw new IllegalArgumentException("retryBaseDelayMs must be between 100ms and 30s");
        }
        this.retryBaseDelayMs = retryBaseDelayMs;
    }

    public void setRetryConfig(int maxRetries, int retryBaseDelayMs) {
        this.setMaxRetries(maxRetries);
        this.setRetryBaseDelayMs(retryBaseDelayMs);
    }

    public Map<String, Object> getRetryConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("maxRetries", this.maxRetries);
        config.put("retryBaseDelayMs", this.retryBaseDelayMs);
        return config;
    }

    public int getReinitIntervalSeconds() {
        return this.reinitIntervalSeconds;
    }

    public void setReinitIntervalSeconds(int reinitIntervalSeconds) {
        if (reinitIntervalSeconds < 1 || reinitIntervalSeconds > 3000) {
            throw new IllegalArgumentException("reinitIntervalSeconds must be between 1 and 3000 seconds (50 minutes)");
        }
        this.reinitIntervalSeconds = reinitIntervalSeconds;
    }
}

