/*
 * Decompiled with CFR 0.152.
 */
package com.zuora;

import com.zuora.model.CommonResponse;
import java.util.List;
import java.util.Map;

public class ApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private CommonResponse errorObject = null;
    private String contentEncoding = "";
    private String rateLimitLimit = "";
    private long rateLimitRemaining = 0L;
    private long rateLimitReset = 0L;
    private String zuoraTrackId = "";
    private String zuoraRequestId = "";
    private String concurrencyLimitType = "";
    private int concurrencyLimitLimit = 0;
    private int concurrencyLimitRemaining = 0;

    public ApiException() {
    }

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.parseAndSetResponseHeaders();
    }

    private void parseAndSetResponseHeaders() {
        try {
            if (this.responseHeaders != null) {
                for (Map.Entry<String, List<String>> entry : this.responseHeaders.entrySet()) {
                    String key = entry.getKey().toLowerCase();
                    String value = entry.getValue().iterator().next();
                    switch (key) {
                        case "content-encoding": {
                            this.contentEncoding = value;
                            break;
                        }
                        case "ratelimit-limit": {
                            this.rateLimitLimit = value;
                            break;
                        }
                        case "ratelimit-remaining": {
                            this.rateLimitRemaining = Long.parseLong(value);
                            break;
                        }
                        case "ratelimit-reset": {
                            this.rateLimitReset = Long.parseLong(value);
                            break;
                        }
                        case "zuora-request-id": {
                            this.zuoraRequestId = value;
                            break;
                        }
                        case "zuora-track-id": {
                            this.zuoraTrackId = value;
                            break;
                        }
                        case "concurrency-limit-type": {
                            this.concurrencyLimitType = value;
                            break;
                        }
                        case "concurrency-limit-limit": {
                            this.concurrencyLimitLimit = Integer.parseInt(value);
                            break;
                        }
                        case "concurrency-limit-remaining": {
                            this.concurrencyLimitRemaining = Integer.parseInt(value);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, null, code, responseHeaders, responseBody);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, null);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this("Response Code: " + code + " Response Body: " + responseBody, null, code, responseHeaders, responseBody);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public int getCode() {
        return this.code;
    }

    public String getZuoraRequestId() {
        return this.zuoraRequestId;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getRateLimitLimit() {
        return this.rateLimitLimit;
    }

    public long getRateLimitRemaining() {
        return this.rateLimitRemaining;
    }

    public long getRateLimitReset() {
        return this.rateLimitReset;
    }

    public String getZuoraTrackId() {
        return this.zuoraTrackId;
    }

    public String getConcurrencyLimitType() {
        return this.concurrencyLimitType;
    }

    public int getConcurrencyLimitLimit() {
        return this.concurrencyLimitLimit;
    }

    public int getConcurrencyLimitRemaining() {
        return this.concurrencyLimitRemaining;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public String getMessage() {
        return String.format("Message: %s%nHTTP response code: %s%nHTTP response body: %s%nHTTP response headers: %s", super.getMessage(), this.getCode(), this.getResponseBody(), this.getResponseHeaders());
    }

    public CommonResponse getErrorObject() {
        return this.errorObject;
    }

    public void setErrorObject(CommonResponse errorObject) {
        this.errorObject = errorObject;
    }
}

