/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.PrepaidBalanceTransaction;
import org.threeten.bp.LocalDate;

public class ValidityPeriod {
    public static final String SERIALIZED_NAME_PREPAID_U_O_M = "prepaid_UOM";
    @SerializedName(value="prepaid_UOM")
    private String prepaidUOM;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_TOTAL_BALANCE = "total_balance";
    @SerializedName(value="total_balance")
    private BigDecimal totalBalance;
    public static final String SERIALIZED_NAME_REMAINING_BALANCE = "remaining_balance";
    @SerializedName(value="remaining_balance")
    private BigDecimal remainingBalance;
    public static final String SERIALIZED_NAME_OVERAGE_RATED_AMOUNT = "overage_rated_amount";
    @SerializedName(value="overage_rated_amount")
    private BigDecimal overageRatedAmount;
    public static final String SERIALIZED_NAME_OVERAGE_RATED_QUANTITY = "overage_rated_quantity";
    @SerializedName(value="overage_rated_quantity")
    private BigDecimal overageRatedQuantity;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<PrepaidBalanceTransaction> transactions = null;

    public ValidityPeriod() {
    }

    public ValidityPeriod(List<PrepaidBalanceTransaction> transactions) {
        this();
        this.transactions = transactions;
    }

    public ValidityPeriod prepaidUOM(String prepaidUOM) {
        this.prepaidUOM = prepaidUOM;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unit of measure for the prepaid balance.")
    public String getPrepaidUOM() {
        return this.prepaidUOM;
    }

    public void setPrepaidUOM(String prepaidUOM) {
        this.prepaidUOM = prepaidUOM;
    }

    public ValidityPeriod startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="Start date of the fund effective period.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public ValidityPeriod endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="End date of the fund effective period.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public ValidityPeriod totalBalance(BigDecimal totalBalance) {
        this.totalBalance = totalBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The funded balance, which is the total units of the fund. ")
    public BigDecimal getTotalBalance() {
        return this.totalBalance;
    }

    public void setTotalBalance(BigDecimal totalBalance) {
        this.totalBalance = totalBalance;
    }

    public ValidityPeriod remainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remaining balance on the fund, which is the remaining units of the fund. ")
    public BigDecimal getRemainingBalance() {
        return this.remainingBalance;
    }

    public void setRemainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
    }

    public ValidityPeriod overageRatedAmount(BigDecimal overageRatedAmount) {
        this.overageRatedAmount = overageRatedAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BigDecimal getOverageRatedAmount() {
        return this.overageRatedAmount;
    }

    public void setOverageRatedAmount(BigDecimal overageRatedAmount) {
        this.overageRatedAmount = overageRatedAmount;
    }

    public ValidityPeriod overageRatedQuantity(BigDecimal overageRatedQuantity) {
        this.overageRatedQuantity = overageRatedQuantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BigDecimal getOverageRatedQuantity() {
        return this.overageRatedQuantity;
    }

    public void setOverageRatedQuantity(BigDecimal overageRatedQuantity) {
        this.overageRatedQuantity = overageRatedQuantity;
    }

    @Nullable
    @ApiModelProperty(value="An array of prepaid balance transactions for a specific validity period")
    public List<PrepaidBalanceTransaction> getTransactions() {
        return this.transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidityPeriod validityPeriod = (ValidityPeriod)o;
        return Objects.equals(this.prepaidUOM, validityPeriod.prepaidUOM) && Objects.equals(this.startDate, validityPeriod.startDate) && Objects.equals(this.endDate, validityPeriod.endDate) && Objects.equals(this.totalBalance, validityPeriod.totalBalance) && Objects.equals(this.remainingBalance, validityPeriod.remainingBalance) && Objects.equals(this.overageRatedAmount, validityPeriod.overageRatedAmount) && Objects.equals(this.overageRatedQuantity, validityPeriod.overageRatedQuantity) && Objects.equals(this.transactions, validityPeriod.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.prepaidUOM, this.startDate, this.endDate, this.totalBalance, this.remainingBalance, this.overageRatedAmount, this.overageRatedQuantity, this.transactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidityPeriod {\n");
        sb.append("    prepaidUOM: ").append(this.toIndentedString(this.prepaidUOM)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    totalBalance: ").append(this.toIndentedString(this.totalBalance)).append("\n");
        sb.append("    remainingBalance: ").append(this.toIndentedString(this.remainingBalance)).append("\n");
        sb.append("    overageRatedAmount: ").append(this.toIndentedString(this.overageRatedAmount)).append("\n");
        sb.append("    overageRatedQuantity: ").append(this.toIndentedString(this.overageRatedQuantity)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

