/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.SubscriptionItemPreviewResponse;

public class SubscriptionPreviewActionsResponse {
    public static final String SERIALIZED_NAME_ACTION_ID = "action_id";
    @SerializedName(value="action_id")
    private String actionId;
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private ActionEnum action;
    public static final String SERIALIZED_NAME_SEQUENCE = "sequence";
    @SerializedName(value="sequence")
    private Integer sequence;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEMS = "subscription_items";
    @SerializedName(value="subscription_items")
    private List<SubscriptionItemPreviewResponse> subscriptionItems = null;

    public SubscriptionPreviewActionsResponse actionId(String actionId) {
        this.actionId = actionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the action.")
    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public SubscriptionPreviewActionsResponse action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The action associated with this metric.")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public SubscriptionPreviewActionsResponse sequence(Integer sequence) {
        this.sequence = sequence;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sequence number of the action.")
    public Integer getSequence() {
        return this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public SubscriptionPreviewActionsResponse subscriptionItems(List<SubscriptionItemPreviewResponse> subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
        return this;
    }

    public SubscriptionPreviewActionsResponse addSubscriptionItemsItem(SubscriptionItemPreviewResponse subscriptionItemsItem) {
        if (this.subscriptionItems == null) {
            this.subscriptionItems = new ArrayList<SubscriptionItemPreviewResponse>();
        }
        this.subscriptionItems.add(subscriptionItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<SubscriptionItemPreviewResponse> getSubscriptionItems() {
        return this.subscriptionItems;
    }

    public void setSubscriptionItems(List<SubscriptionItemPreviewResponse> subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionPreviewActionsResponse subscriptionPreviewActionsResponse = (SubscriptionPreviewActionsResponse)o;
        return Objects.equals(this.actionId, subscriptionPreviewActionsResponse.actionId) && Objects.equals((Object)this.action, (Object)subscriptionPreviewActionsResponse.action) && Objects.equals(this.sequence, subscriptionPreviewActionsResponse.sequence) && Objects.equals(this.subscriptionItems, subscriptionPreviewActionsResponse.subscriptionItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionId, this.action, this.sequence, this.subscriptionItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionPreviewActionsResponse {\n");
        sb.append("    actionId: ").append(this.toIndentedString(this.actionId)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    sequence: ").append(this.toIndentedString(this.sequence)).append("\n");
        sb.append("    subscriptionItems: ").append(this.toIndentedString(this.subscriptionItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionEnum {
        CREATE_SUBSCRIPTION("create_subscription"),
        TERMS("terms"),
        ADD_SUBSCRIPTION_PLAN("add_subscription_plan"),
        UPDATE_SUBSCRIPTION_PLAN("update_subscription_plan"),
        REMOVE_SUBSCRIPTION_PLAN("remove_subscription_plan"),
        RENEW("renew"),
        CANCEL("cancel"),
        OWNER_TRANSFER("owner_transfer"),
        PAUSE("pause"),
        RESUME("resume"),
        REPLACE_SUBSCRIPTION_PLAN("replace_subscription_plan"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ActionEnum> {
            public void write(JsonWriter jsonWriter, ActionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionEnum.fromValue(value);
            }
        }
    }
}

