/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.BillingDocument;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreditMemoAppliedToResponse {
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_ID = "billing_document_id";
    @SerializedName(value="billing_document_id")
    private String billingDocumentId;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT = "billing_document";
    @SerializedName(value="billing_document")
    private BillingDocument billingDocument;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_TYPE = "billing_document_type";
    @SerializedName(value="billing_document_type")
    private BillingDocumentTypeEnum billingDocumentType;

    public CreditMemoAppliedToResponse billingDocumentId(String billingDocumentId) {
        this.billingDocumentId = billingDocumentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of an invoice or a debit memo.")
    public String getBillingDocumentId() {
        return this.billingDocumentId;
    }

    public void setBillingDocumentId(String billingDocumentId) {
        this.billingDocumentId = billingDocumentId;
    }

    public CreditMemoAppliedToResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the credit memo application")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CreditMemoAppliedToResponse amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the payment that is applied to the specific billing document item or taxation item.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public CreditMemoAppliedToResponse billingDocument(BillingDocument billingDocument) {
        this.billingDocument = billingDocument;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The related billing document.")
    public BillingDocument getBillingDocument() {
        return this.billingDocument;
    }

    public void setBillingDocument(BillingDocument billingDocument) {
        this.billingDocument = billingDocument;
    }

    public CreditMemoAppliedToResponse billingDocumentType(BillingDocumentTypeEnum billingDocumentType) {
        this.billingDocumentType = billingDocumentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of billing document. Can be one of the debit memo or invoice.")
    public BillingDocumentTypeEnum getBillingDocumentType() {
        return this.billingDocumentType;
    }

    public void setBillingDocumentType(BillingDocumentTypeEnum billingDocumentType) {
        this.billingDocumentType = billingDocumentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditMemoAppliedToResponse creditMemoAppliedToResponse = (CreditMemoAppliedToResponse)o;
        return Objects.equals(this.billingDocumentId, creditMemoAppliedToResponse.billingDocumentId) && Objects.equals(this.id, creditMemoAppliedToResponse.id) && Objects.equals(this.amount, creditMemoAppliedToResponse.amount) && Objects.equals(this.billingDocument, creditMemoAppliedToResponse.billingDocument) && Objects.equals((Object)this.billingDocumentType, (Object)creditMemoAppliedToResponse.billingDocumentType);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.billingDocumentId, this.id, this.amount, this.billingDocument, this.billingDocumentType});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditMemoAppliedToResponse {\n");
        sb.append("    billingDocumentId: ").append(this.toIndentedString(this.billingDocumentId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    billingDocument: ").append(this.toIndentedString(this.billingDocument)).append("\n");
        sb.append("    billingDocumentType: ").append(this.toIndentedString((Object)this.billingDocumentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BillingDocumentTypeEnum {
        DEBIT_MEMO("debit_memo"),
        INVOICE("invoice"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BillingDocumentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BillingDocumentTypeEnum fromValue(String value) {
            for (BillingDocumentTypeEnum b : BillingDocumentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BillingDocumentTypeEnum> {
            public void write(JsonWriter jsonWriter, BillingDocumentTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BillingDocumentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BillingDocumentTypeEnum.fromValue(value);
            }
        }
    }
}

