/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.zuora.JSON;
import com.zuora.model.CreateOrderResponse;
import com.zuora.model.OrderCategory;
import com.zuora.model.OrderExistingAccountDetails;
import com.zuora.model.OrderLineItem;
import com.zuora.model.OrderSchedulingOptions;
import com.zuora.model.OrderStatus;
import com.zuora.model.OrderSubscriptions;
import com.zuora.model.UpsertCommitmentInput;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Order {
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private OrderCategory category = OrderCategory.NEWSALES;
    public static final String SERIALIZED_NAME_CREATED_BY = "createdBy";
    @SerializedName(value="createdBy")
    private String createdBy;
    public static final String SERIALIZED_NAME_CREATED_DATE = "createdDate";
    @SerializedName(value="createdDate")
    private String createdDate;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "customFields";
    @SerializedName(value="customFields")
    private Map<String, Object> customFields;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER = "existingAccountNumber";
    @SerializedName(value="existingAccountNumber")
    private String existingAccountNumber;
    public static final String SERIALIZED_NAME_EXISTING_ACCOUNT_DETAILS = "existingAccountDetails";
    @SerializedName(value="existingAccountDetails")
    private OrderExistingAccountDetails existingAccountDetails;
    public static final String SERIALIZED_NAME_INVOICE_SCHEDULE_ID = "invoiceScheduleId";
    @SerializedName(value="invoiceScheduleId")
    private String invoiceScheduleId;
    public static final String SERIALIZED_NAME_ORDER_DATE = "orderDate";
    @SerializedName(value="orderDate")
    private LocalDate orderDate;
    public static final String SERIALIZED_NAME_ORDER_LINE_ITEMS = "orderLineItems";
    @SerializedName(value="orderLineItems")
    private List<OrderLineItem> orderLineItems;
    public static final String SERIALIZED_NAME_ORDER_NUMBER = "orderNumber";
    @SerializedName(value="orderNumber")
    private String orderNumber;
    public static final String SERIALIZED_NAME_REASON_CODE = "reasonCode";
    @SerializedName(value="reasonCode")
    private String reasonCode;
    public static final String SERIALIZED_NAME_SCHEDULING_OPTIONS = "schedulingOptions";
    @SerializedName(value="schedulingOptions")
    private OrderSchedulingOptions schedulingOptions;
    public static final String SERIALIZED_NAME_SCHEDULED_ORDER_ACTIVATION_RESPONSE = "scheduledOrderActivationResponse";
    @SerializedName(value="scheduledOrderActivationResponse")
    private CreateOrderResponse scheduledOrderActivationResponse;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private OrderStatus status;
    public static final String SERIALIZED_NAME_SUBSCRIPTIONS = "subscriptions";
    @SerializedName(value="subscriptions")
    private List<OrderSubscriptions> subscriptions;
    public static final String SERIALIZED_NAME_COMMITMENTS = "commitments";
    @SerializedName(value="commitments")
    private List<UpsertCommitmentInput> commitments;
    public static final String SERIALIZED_NAME_UPDATED_BY = "updatedBy";
    @SerializedName(value="updatedBy")
    private String updatedBy;
    public static final String SERIALIZED_NAME_UPDATED_DATE = "updatedDate";
    @SerializedName(value="updatedDate")
    private String updatedDate;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Order category(OrderCategory category) {
        this.category = category;
        return this;
    }

    @Nullable
    public OrderCategory getCategory() {
        return this.category;
    }

    public void setCategory(OrderCategory category) {
        this.category = category;
    }

    public Order createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Order createdDate(String createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public Order currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Order customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Order putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public Order description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Order existingAccountNumber(String existingAccountNumber) {
        this.existingAccountNumber = existingAccountNumber;
        return this;
    }

    @Nullable
    public String getExistingAccountNumber() {
        return this.existingAccountNumber;
    }

    public void setExistingAccountNumber(String existingAccountNumber) {
        this.existingAccountNumber = existingAccountNumber;
    }

    public Order existingAccountDetails(OrderExistingAccountDetails existingAccountDetails) {
        this.existingAccountDetails = existingAccountDetails;
        return this;
    }

    @Nullable
    public OrderExistingAccountDetails getExistingAccountDetails() {
        return this.existingAccountDetails;
    }

    public void setExistingAccountDetails(OrderExistingAccountDetails existingAccountDetails) {
        this.existingAccountDetails = existingAccountDetails;
    }

    public Order invoiceScheduleId(String invoiceScheduleId) {
        this.invoiceScheduleId = invoiceScheduleId;
        return this;
    }

    @Nullable
    public String getInvoiceScheduleId() {
        return this.invoiceScheduleId;
    }

    public void setInvoiceScheduleId(String invoiceScheduleId) {
        this.invoiceScheduleId = invoiceScheduleId;
    }

    public Order orderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Nullable
    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public Order orderLineItems(List<OrderLineItem> orderLineItems) {
        this.orderLineItems = orderLineItems;
        return this;
    }

    public Order addOrderLineItemsItem(OrderLineItem orderLineItemsItem) {
        if (this.orderLineItems == null) {
            this.orderLineItems = new ArrayList<OrderLineItem>();
        }
        this.orderLineItems.add(orderLineItemsItem);
        return this;
    }

    @Nullable
    public List<OrderLineItem> getOrderLineItems() {
        return this.orderLineItems;
    }

    public void setOrderLineItems(List<OrderLineItem> orderLineItems) {
        this.orderLineItems = orderLineItems;
    }

    public Order orderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
        return this;
    }

    @Nullable
    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Order reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public Order schedulingOptions(OrderSchedulingOptions schedulingOptions) {
        this.schedulingOptions = schedulingOptions;
        return this;
    }

    @Nullable
    public OrderSchedulingOptions getSchedulingOptions() {
        return this.schedulingOptions;
    }

    public void setSchedulingOptions(OrderSchedulingOptions schedulingOptions) {
        this.schedulingOptions = schedulingOptions;
    }

    public Order scheduledOrderActivationResponse(CreateOrderResponse scheduledOrderActivationResponse) {
        this.scheduledOrderActivationResponse = scheduledOrderActivationResponse;
        return this;
    }

    @Nullable
    public CreateOrderResponse getScheduledOrderActivationResponse() {
        return this.scheduledOrderActivationResponse;
    }

    public void setScheduledOrderActivationResponse(CreateOrderResponse scheduledOrderActivationResponse) {
        this.scheduledOrderActivationResponse = scheduledOrderActivationResponse;
    }

    public Order status(OrderStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public OrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    public Order subscriptions(List<OrderSubscriptions> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public Order addSubscriptionsItem(OrderSubscriptions subscriptionsItem) {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<OrderSubscriptions>();
        }
        this.subscriptions.add(subscriptionsItem);
        return this;
    }

    @Nullable
    public List<OrderSubscriptions> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(List<OrderSubscriptions> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public Order commitments(List<UpsertCommitmentInput> commitments) {
        this.commitments = commitments;
        return this;
    }

    public Order addCommitmentsItem(UpsertCommitmentInput commitmentsItem) {
        if (this.commitments == null) {
            this.commitments = new ArrayList<UpsertCommitmentInput>();
        }
        this.commitments.add(commitmentsItem);
        return this;
    }

    @Nullable
    public List<UpsertCommitmentInput> getCommitments() {
        return this.commitments;
    }

    public void setCommitments(List<UpsertCommitmentInput> commitments) {
        this.commitments = commitments;
    }

    public Order updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Order updatedDate(String updatedDate) {
        this.updatedDate = updatedDate;
        return this;
    }

    @Nullable
    public String getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(String updatedDate) {
        this.updatedDate = updatedDate;
    }

    public Order putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return Objects.equals((Object)this.category, (Object)order.category) && Objects.equals(this.createdBy, order.createdBy) && Objects.equals(this.createdDate, order.createdDate) && Objects.equals(this.currency, order.currency) && Objects.equals(this.customFields, order.customFields) && Objects.equals(this.description, order.description) && Objects.equals(this.existingAccountNumber, order.existingAccountNumber) && Objects.equals(this.existingAccountDetails, order.existingAccountDetails) && Objects.equals(this.invoiceScheduleId, order.invoiceScheduleId) && Objects.equals(this.orderDate, order.orderDate) && Objects.equals(this.orderLineItems, order.orderLineItems) && Objects.equals(this.orderNumber, order.orderNumber) && Objects.equals(this.reasonCode, order.reasonCode) && Objects.equals(this.schedulingOptions, order.schedulingOptions) && Objects.equals(this.scheduledOrderActivationResponse, order.scheduledOrderActivationResponse) && Objects.equals((Object)this.status, (Object)order.status) && Objects.equals(this.subscriptions, order.subscriptions) && Objects.equals(this.commitments, order.commitments) && Objects.equals(this.updatedBy, order.updatedBy) && Objects.equals(this.updatedDate, order.updatedDate) && Objects.equals(this.additionalProperties, order.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.createdBy, this.createdDate, this.currency, this.customFields, this.description, this.existingAccountNumber, this.existingAccountDetails, this.invoiceScheduleId, this.orderDate, this.orderLineItems, this.orderNumber, this.reasonCode, this.schedulingOptions, this.scheduledOrderActivationResponse, this.status, this.subscriptions, this.commitments, this.updatedBy, this.updatedDate, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Order {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    existingAccountNumber: ").append(this.toIndentedString(this.existingAccountNumber)).append("\n");
        sb.append("    existingAccountDetails: ").append(this.toIndentedString(this.existingAccountDetails)).append("\n");
        sb.append("    invoiceScheduleId: ").append(this.toIndentedString(this.invoiceScheduleId)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    orderLineItems: ").append(this.toIndentedString(this.orderLineItems)).append("\n");
        sb.append("    orderNumber: ").append(this.toIndentedString(this.orderNumber)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    schedulingOptions: ").append(this.toIndentedString(this.schedulingOptions)).append("\n");
        sb.append("    scheduledOrderActivationResponse: ").append(this.toIndentedString(this.scheduledOrderActivationResponse)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subscriptions: ").append(this.toIndentedString(this.subscriptions)).append("\n");
        sb.append("    commitments: ").append(this.toIndentedString(this.commitments)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    updatedDate: ").append(this.toIndentedString(this.updatedDate)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraycommitments;
        JsonArray jsonArraysubscriptions;
        int i;
        JsonArray jsonArrayorderLineItems;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Order is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CATEGORY) != null && !jsonObj.get(SERIALIZED_NAME_CATEGORY).isJsonNull()) {
            OrderCategory.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CATEGORY));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATED_BY) != null && !jsonObj.get(SERIALIZED_NAME_CREATED_BY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATED_BY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `createdBy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED_BY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATED_DATE) != null && !jsonObj.get(SERIALIZED_NAME_CREATED_DATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATED_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `createdDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED_DATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `existingAccountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_DETAILS) != null && !jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_DETAILS).isJsonNull()) {
            OrderExistingAccountDetails.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_DETAILS));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ID) != null && !jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `invoiceScheduleId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVOICE_SCHEDULE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEMS) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEMS).isJsonNull() && (jsonArrayorderLineItems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ORDER_LINE_ITEMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `orderLineItems` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEMS).toString()));
            }
            for (i = 0; i < jsonArrayorderLineItems.size(); ++i) {
                OrderLineItem.validateJsonElement(jsonArrayorderLineItems.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORDER_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `orderNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON_CODE) != null && !jsonObj.get(SERIALIZED_NAME_REASON_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REASON_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reasonCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEDULING_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_SCHEDULING_OPTIONS).isJsonNull()) {
            OrderSchedulingOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SCHEDULING_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEDULED_ORDER_ACTIVATION_RESPONSE) != null && !jsonObj.get(SERIALIZED_NAME_SCHEDULED_ORDER_ACTIVATION_RESPONSE).isJsonNull()) {
            CreateOrderResponse.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SCHEDULED_ORDER_ACTIVATION_RESPONSE));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            OrderStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS).isJsonNull() && (jsonArraysubscriptions = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUBSCRIPTIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `subscriptions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS).toString()));
            }
            for (i = 0; i < jsonArraysubscriptions.size(); ++i) {
                OrderSubscriptions.validateJsonElement(jsonArraysubscriptions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMITMENTS) != null && !jsonObj.get(SERIALIZED_NAME_COMMITMENTS).isJsonNull() && (jsonArraycommitments = jsonObj.getAsJsonArray(SERIALIZED_NAME_COMMITMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_COMMITMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `commitments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMITMENTS).toString()));
            }
            for (i = 0; i < jsonArraycommitments.size(); ++i) {
                UpsertCommitmentInput.validateJsonElement(jsonArraycommitments.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_UPDATED_BY) != null && !jsonObj.get(SERIALIZED_NAME_UPDATED_BY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPDATED_BY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `updatedBy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPDATED_BY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UPDATED_DATE) != null && !jsonObj.get(SERIALIZED_NAME_UPDATED_DATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPDATED_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `updatedDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPDATED_DATE).toString()));
        }
    }

    public static Order fromJson(String jsonString) throws IOException {
        return (Order)JSON.getGson().fromJson(jsonString, Order.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CATEGORY);
        openapiFields.add(SERIALIZED_NAME_CREATED_BY);
        openapiFields.add(SERIALIZED_NAME_CREATED_DATE);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_FIELDS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_EXISTING_ACCOUNT_DETAILS);
        openapiFields.add(SERIALIZED_NAME_INVOICE_SCHEDULE_ID);
        openapiFields.add(SERIALIZED_NAME_ORDER_DATE);
        openapiFields.add(SERIALIZED_NAME_ORDER_LINE_ITEMS);
        openapiFields.add(SERIALIZED_NAME_ORDER_NUMBER);
        openapiFields.add(SERIALIZED_NAME_REASON_CODE);
        openapiFields.add(SERIALIZED_NAME_SCHEDULING_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_SCHEDULED_ORDER_ACTIVATION_RESPONSE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_SUBSCRIPTIONS);
        openapiFields.add(SERIALIZED_NAME_COMMITMENTS);
        openapiFields.add(SERIALIZED_NAME_UPDATED_BY);
        openapiFields.add(SERIALIZED_NAME_UPDATED_DATE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Order.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Order.class));
            return new TypeAdapter<Order>(){

                public void write(JsonWriter out, Order value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    out.beginObject();
                    for (Map.Entry e : obj.entrySet()) {
                        out.name((String)e.getKey());
                        elementAdapter.write(out, (Object)((JsonElement)e.getValue()));
                    }
                    if (value.getAdditionalProperties() != null) {
                        boolean oldSerializeNulls = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                            } else if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                            } else if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                            } else if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                            } else if (entry.getValue() == null) {
                                obj.add(entry.getKey(), null);
                            } else {
                                JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                                if (jsonElement.isJsonArray()) {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                } else {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                                }
                            }
                            out.name(entry.getKey());
                            elementAdapter.write(out, (Object)obj.get(entry.getKey()));
                        }
                        out.setSerializeNulls(oldSerializeNulls);
                    }
                    out.endObject();
                }

                public Order read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Order.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    Order instance = (Order)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

