/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.FlexibleBillingDocumentSettings;
import org.openapitools.client.model.StartOn;
import org.openapitools.client.model.Term;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Term information of the subscription.")
public class SubscriptionTermPatchRequest {
    public static final String SERIALIZED_NAME_CURRENT_TERM = "current_term";
    @SerializedName(value="current_term")
    private Term currentTerm;
    public static final String SERIALIZED_NAME_RENEWAL_TERM = "renewal_term";
    @SerializedName(value="renewal_term")
    private Term renewalTerm;
    public static final String SERIALIZED_NAME_AUTO_RENEW = "auto_renew";
    @SerializedName(value="auto_renew")
    private Boolean autoRenew;
    public static final String SERIALIZED_NAME_START_ON = "start_on";
    @SerializedName(value="start_on")
    private StartOn startOn;
    public static final String SERIALIZED_NAME_BILL_TO_ID = "bill_to_id";
    @SerializedName(value="bill_to_id")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String billToId;
    public static final String SERIALIZED_NAME_PAYMENT_TERMS = "payment_terms";
    @SerializedName(value="payment_terms")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String paymentTerms;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_SETTINGS = "billing_document_settings";
    @SerializedName(value="billing_document_settings")
    private FlexibleBillingDocumentSettings billingDocumentSettings;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String soldToId;
    public static final String SERIALIZED_NAME_CHANGE_REASON = "change_reason";
    @SerializedName(value="change_reason")
    private String changeReason;

    public SubscriptionTermPatchRequest currentTerm(Term currentTerm) {
        this.currentTerm = currentTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current term information for the subscription.")
    public Term getCurrentTerm() {
        return this.currentTerm;
    }

    public void setCurrentTerm(Term currentTerm) {
        this.currentTerm = currentTerm;
    }

    public SubscriptionTermPatchRequest renewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Renewal term information for the subscription.")
    public Term getRenewalTerm() {
        return this.renewalTerm;
    }

    public void setRenewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
    }

    public SubscriptionTermPatchRequest autoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, the subscription automatically renews at the end of the current term.")
    public Boolean getAutoRenew() {
        return this.autoRenew;
    }

    public void setAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public SubscriptionTermPatchRequest startOn(StartOn startOn) {
        this.startOn = startOn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StartOn getStartOn() {
        return this.startOn;
    }

    public void setStartOn(StartOn startOn) {
        this.startOn = startOn;
    }

    public SubscriptionTermPatchRequest billToId(String billToId) {
        this.billToId = billToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="ID of the bill-to contact.")
    public String getBillToId() {
        return this.billToId;
    }

    public void setBillToId(String billToId) {
        this.billToId = billToId;
    }

    public SubscriptionTermPatchRequest paymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of payment term associated with the invoice.")
    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public SubscriptionTermPatchRequest billingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing document settings for the customer.")
    public FlexibleBillingDocumentSettings getBillingDocumentSettings() {
        return this.billingDocumentSettings;
    }

    public void setBillingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
    }

    public SubscriptionTermPatchRequest soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="ID of the sold-to contact.")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    public SubscriptionTermPatchRequest changeReason(String changeReason) {
        this.changeReason = changeReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A brief description of the reason for this change.")
    public String getChangeReason() {
        return this.changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionTermPatchRequest subscriptionTermPatchRequest = (SubscriptionTermPatchRequest)o;
        return Objects.equals(this.currentTerm, subscriptionTermPatchRequest.currentTerm) && Objects.equals(this.renewalTerm, subscriptionTermPatchRequest.renewalTerm) && Objects.equals(this.autoRenew, subscriptionTermPatchRequest.autoRenew) && Objects.equals(this.startOn, subscriptionTermPatchRequest.startOn) && Objects.equals(this.billToId, subscriptionTermPatchRequest.billToId) && Objects.equals(this.paymentTerms, subscriptionTermPatchRequest.paymentTerms) && Objects.equals(this.billingDocumentSettings, subscriptionTermPatchRequest.billingDocumentSettings) && Objects.equals(this.soldToId, subscriptionTermPatchRequest.soldToId) && Objects.equals(this.changeReason, subscriptionTermPatchRequest.changeReason);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.currentTerm, this.renewalTerm, this.autoRenew, this.startOn, this.billToId, this.paymentTerms, this.billingDocumentSettings, this.soldToId, this.changeReason);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionTermPatchRequest {\n");
        sb.append("    currentTerm: ").append(this.toIndentedString(this.currentTerm)).append("\n");
        sb.append("    renewalTerm: ").append(this.toIndentedString(this.renewalTerm)).append("\n");
        sb.append("    autoRenew: ").append(this.toIndentedString(this.autoRenew)).append("\n");
        sb.append("    startOn: ").append(this.toIndentedString(this.startOn)).append("\n");
        sb.append("    billToId: ").append(this.toIndentedString(this.billToId)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("    billingDocumentSettings: ").append(this.toIndentedString(this.billingDocumentSettings)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    changeReason: ").append(this.toIndentedString(this.changeReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

