/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Billing document settings for an account")
public class BillingDocumentSettings {
    public static final String SERIALIZED_NAME_CREDIT_MEMO_TEMPLATE_ID = "credit_memo_template_id";
    @SerializedName(value="credit_memo_template_id")
    private String creditMemoTemplateId;
    public static final String SERIALIZED_NAME_DEBIT_MEMO_TEMPLATE_ID = "debit_memo_template_id";
    @SerializedName(value="debit_memo_template_id")
    private String debitMemoTemplateId;
    public static final String SERIALIZED_NAME_EMAIL_DOCUMENTS = "email_documents";
    @SerializedName(value="email_documents")
    private Boolean emailDocuments;
    public static final String SERIALIZED_NAME_PRINT_DOCUMENTS = "print_documents";
    @SerializedName(value="print_documents")
    private Boolean printDocuments;
    public static final String SERIALIZED_NAME_INVOICE_TEMPLATE_ID = "invoice_template_id";
    @SerializedName(value="invoice_template_id")
    private String invoiceTemplateId;
    public static final String SERIALIZED_NAME_ADDITIONAL_EMAIL = "additional_email";
    @SerializedName(value="additional_email")
    private List<String> additionalEmail = null;

    public BillingDocumentSettings creditMemoTemplateId(String creditMemoTemplateId) {
        this.creditMemoTemplateId = creditMemoTemplateId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c08b6a8c978f016a9e0084622b62", value="Identifier of the credit memo template associated with this customer.")
    public String getCreditMemoTemplateId() {
        return this.creditMemoTemplateId;
    }

    public void setCreditMemoTemplateId(String creditMemoTemplateId) {
        this.creditMemoTemplateId = creditMemoTemplateId;
    }

    public BillingDocumentSettings debitMemoTemplateId(String debitMemoTemplateId) {
        this.debitMemoTemplateId = debitMemoTemplateId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c08c6a8c7e08016a9ec8d72f3ab5", value="Identifier of the debit memo template associated with this customer.")
    public String getDebitMemoTemplateId() {
        return this.debitMemoTemplateId;
    }

    public void setDebitMemoTemplateId(String debitMemoTemplateId) {
        this.debitMemoTemplateId = debitMemoTemplateId;
    }

    public BillingDocumentSettings emailDocuments(Boolean emailDocuments) {
        this.emailDocuments = emailDocuments;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether the customer wants to receive email invoices.")
    public Boolean getEmailDocuments() {
        return this.emailDocuments;
    }

    public void setEmailDocuments(Boolean emailDocuments) {
        this.emailDocuments = emailDocuments;
    }

    public BillingDocumentSettings printDocuments(Boolean printDocuments) {
        this.printDocuments = printDocuments;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether the customer wants to receive printed invoices.")
    public Boolean getPrintDocuments() {
        return this.printDocuments;
    }

    public void setPrintDocuments(Boolean printDocuments) {
        this.printDocuments = printDocuments;
    }

    public BillingDocumentSettings invoiceTemplateId(String invoiceTemplateId) {
        this.invoiceTemplateId = invoiceTemplateId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8f64d4d754739d85d0346e00ef77e50d", value="Identifier of the invoice template associated with this customer.")
    public String getInvoiceTemplateId() {
        return this.invoiceTemplateId;
    }

    public void setInvoiceTemplateId(String invoiceTemplateId) {
        this.invoiceTemplateId = invoiceTemplateId;
    }

    public BillingDocumentSettings additionalEmail(List<String> additionalEmail) {
        this.additionalEmail = additionalEmail;
        return this;
    }

    public BillingDocumentSettings addAdditionalEmailItem(String additionalEmailItem) {
        if (this.additionalEmail == null) {
            this.additionalEmail = new ArrayList<String>();
        }
        this.additionalEmail.add(additionalEmailItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="jdoe@zuora.com", value="A list of additional email addresses to receive email notifications.")
    public List<String> getAdditionalEmail() {
        return this.additionalEmail;
    }

    public void setAdditionalEmail(List<String> additionalEmail) {
        this.additionalEmail = additionalEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingDocumentSettings billingDocumentSettings = (BillingDocumentSettings)o;
        return Objects.equals(this.creditMemoTemplateId, billingDocumentSettings.creditMemoTemplateId) && Objects.equals(this.debitMemoTemplateId, billingDocumentSettings.debitMemoTemplateId) && Objects.equals(this.emailDocuments, billingDocumentSettings.emailDocuments) && Objects.equals(this.printDocuments, billingDocumentSettings.printDocuments) && Objects.equals(this.invoiceTemplateId, billingDocumentSettings.invoiceTemplateId) && Objects.equals(this.additionalEmail, billingDocumentSettings.additionalEmail);
    }

    public int hashCode() {
        return Objects.hash(this.creditMemoTemplateId, this.debitMemoTemplateId, this.emailDocuments, this.printDocuments, this.invoiceTemplateId, this.additionalEmail);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingDocumentSettings {\n");
        sb.append("    creditMemoTemplateId: ").append(this.toIndentedString(this.creditMemoTemplateId)).append("\n");
        sb.append("    debitMemoTemplateId: ").append(this.toIndentedString(this.debitMemoTemplateId)).append("\n");
        sb.append("    emailDocuments: ").append(this.toIndentedString(this.emailDocuments)).append("\n");
        sb.append("    printDocuments: ").append(this.toIndentedString(this.printDocuments)).append("\n");
        sb.append("    invoiceTemplateId: ").append(this.toIndentedString(this.invoiceTemplateId)).append("\n");
        sb.append("    additionalEmail: ").append(this.toIndentedString(this.additionalEmail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

