/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.GETDataBackfillJobById200Response;
import com.zuora.model.GETListDataBackfillJobs200Response;
import com.zuora.model.Job;
import com.zuora.model.JobType;
import com.zuora.model.POSTCreateDataBackfillJob200Response;
import com.zuora.model.PUTStopBookingDateBackfillJobByIdRequest;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DataBackfillJobApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DataBackfillJobApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataBackfillJobApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call gETDataBackfillJobByIdCall(String jobId, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/uno/data-backfill/jobs/{jobId}".replace("{jobId}", this.localVarApiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call gETDataBackfillJobByIdValidateBeforeCall(String jobId, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling gETDataBackfillJobById(Async)");
        }
        return this.gETDataBackfillJobByIdCall(jobId, zuoraOrgIds, _callback);
    }

    protected GETDataBackfillJobById200Response gETDataBackfillJobById(String jobId, String zuoraOrgIds) throws ApiException {
        ApiResponse<GETDataBackfillJobById200Response> localVarResp = this.gETDataBackfillJobByIdWithHttpInfo(jobId, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GETDataBackfillJobById200Response> gETDataBackfillJobByIdWithHttpInfo(String jobId, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.gETDataBackfillJobByIdValidateBeforeCall(jobId, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GETDataBackfillJobById200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call gETDataBackfillJobByIdAsync(String jobId, String zuoraOrgIds, ApiCallback<GETDataBackfillJobById200Response> _callback) throws ApiException {
        Call localVarCall = this.gETDataBackfillJobByIdValidateBeforeCall(jobId, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GETDataBackfillJobById200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GETDataBackfillJobByIdApi gETDataBackfillJobByIdApi(String jobId) {
        return new GETDataBackfillJobByIdApi(jobId);
    }

    private Call gETDataBackfillTemplateCall(JobType type, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/uno/data-backfill/jobs/{type}/template".replace("{type}", this.localVarApiClient.escapeString(type.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/csv"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call gETDataBackfillTemplateValidateBeforeCall(JobType type, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling gETDataBackfillTemplate(Async)");
        }
        return this.gETDataBackfillTemplateCall(type, zuoraOrgIds, _callback);
    }

    protected String gETDataBackfillTemplate(JobType type, String zuoraOrgIds) throws ApiException {
        ApiResponse<String> localVarResp = this.gETDataBackfillTemplateWithHttpInfo(type, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<String> gETDataBackfillTemplateWithHttpInfo(JobType type, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.gETDataBackfillTemplateValidateBeforeCall(type, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call gETDataBackfillTemplateAsync(JobType type, String zuoraOrgIds, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.gETDataBackfillTemplateValidateBeforeCall(type, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GETDataBackfillTemplateApi gETDataBackfillTemplateApi(JobType type) {
        return new GETDataBackfillTemplateApi(type);
    }

    private Call gETListDataBackfillJobsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/uno/date-backfill/listjobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call gETListDataBackfillJobsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.gETListDataBackfillJobsCall(_callback);
    }

    protected GETListDataBackfillJobs200Response gETListDataBackfillJobs() throws ApiException {
        ApiResponse<GETListDataBackfillJobs200Response> localVarResp = this.gETListDataBackfillJobsWithHttpInfo();
        return localVarResp.getData();
    }

    private ApiResponse<GETListDataBackfillJobs200Response> gETListDataBackfillJobsWithHttpInfo() throws ApiException {
        Call localVarCall = this.gETListDataBackfillJobsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GETListDataBackfillJobs200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call gETListDataBackfillJobsAsync(ApiCallback<GETListDataBackfillJobs200Response> _callback) throws ApiException {
        Call localVarCall = this.gETListDataBackfillJobsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GETListDataBackfillJobs200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GETListDataBackfillJobsApi gETListDataBackfillJobsApi() {
        return new GETListDataBackfillJobsApi();
    }

    private Call pOSTCreateDataBackfillJobCall(Job type, File _file, String checksum, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/uno/data-backfill/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarFormParams.put("type", type);
        }
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (checksum != null) {
            localVarFormParams.put("checksum", checksum);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call pOSTCreateDataBackfillJobValidateBeforeCall(Job type, File _file, String checksum, ApiCallback _callback) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling pOSTCreateDataBackfillJob(Async)");
        }
        if (_file == null) {
            throw new ApiException("Missing the required parameter '_file' when calling pOSTCreateDataBackfillJob(Async)");
        }
        return this.pOSTCreateDataBackfillJobCall(type, _file, checksum, _callback);
    }

    protected POSTCreateDataBackfillJob200Response pOSTCreateDataBackfillJob(Job type, File _file, String checksum) throws ApiException {
        ApiResponse<POSTCreateDataBackfillJob200Response> localVarResp = this.pOSTCreateDataBackfillJobWithHttpInfo(type, _file, checksum);
        return localVarResp.getData();
    }

    private ApiResponse<POSTCreateDataBackfillJob200Response> pOSTCreateDataBackfillJobWithHttpInfo(Job type, File _file, String checksum) throws ApiException {
        Call localVarCall = this.pOSTCreateDataBackfillJobValidateBeforeCall(type, _file, checksum, null);
        Type localVarReturnType = new TypeToken<POSTCreateDataBackfillJob200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call pOSTCreateDataBackfillJobAsync(Job type, File _file, String checksum, ApiCallback<POSTCreateDataBackfillJob200Response> _callback) throws ApiException {
        Call localVarCall = this.pOSTCreateDataBackfillJobValidateBeforeCall(type, _file, checksum, _callback);
        Type localVarReturnType = new TypeToken<POSTCreateDataBackfillJob200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public POSTCreateDataBackfillJobApi pOSTCreateDataBackfillJobApi(Job type, File _file) {
        return new POSTCreateDataBackfillJobApi(type, _file);
    }

    private Call pUTStopDataBackfillJobByIdCall(String jobId, String zuoraOrgIds, PUTStopBookingDateBackfillJobByIdRequest puTStopBookingDateBackfillJobByIdRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PUTStopBookingDateBackfillJobByIdRequest localVarPostBody = puTStopBookingDateBackfillJobByIdRequest;
        String localVarPath = "/v1/uno/data-backfill/jobs/{jobId}".replace("{jobId}", this.localVarApiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call pUTStopDataBackfillJobByIdValidateBeforeCall(String jobId, String zuoraOrgIds, PUTStopBookingDateBackfillJobByIdRequest puTStopBookingDateBackfillJobByIdRequest, ApiCallback _callback) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling pUTStopDataBackfillJobById(Async)");
        }
        return this.pUTStopDataBackfillJobByIdCall(jobId, zuoraOrgIds, puTStopBookingDateBackfillJobByIdRequest, _callback);
    }

    protected CommonResponse pUTStopDataBackfillJobById(String jobId, String zuoraOrgIds, PUTStopBookingDateBackfillJobByIdRequest puTStopBookingDateBackfillJobByIdRequest) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.pUTStopDataBackfillJobByIdWithHttpInfo(jobId, zuoraOrgIds, puTStopBookingDateBackfillJobByIdRequest);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> pUTStopDataBackfillJobByIdWithHttpInfo(String jobId, String zuoraOrgIds, PUTStopBookingDateBackfillJobByIdRequest puTStopBookingDateBackfillJobByIdRequest) throws ApiException {
        Call localVarCall = this.pUTStopDataBackfillJobByIdValidateBeforeCall(jobId, zuoraOrgIds, puTStopBookingDateBackfillJobByIdRequest, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call pUTStopDataBackfillJobByIdAsync(String jobId, String zuoraOrgIds, PUTStopBookingDateBackfillJobByIdRequest puTStopBookingDateBackfillJobByIdRequest, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.pUTStopDataBackfillJobByIdValidateBeforeCall(jobId, zuoraOrgIds, puTStopBookingDateBackfillJobByIdRequest, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PUTStopDataBackfillJobByIdApi pUTStopDataBackfillJobByIdApi(String jobId) {
        return new PUTStopDataBackfillJobByIdApi(jobId);
    }

    public class PUTStopDataBackfillJobByIdApi {
        private final String jobId;
        private String zuoraOrgIds;
        private PUTStopBookingDateBackfillJobByIdRequest puTStopBookingDateBackfillJobByIdRequest;

        private PUTStopDataBackfillJobByIdApi(String jobId) {
            this.jobId = jobId;
        }

        public PUTStopDataBackfillJobByIdApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public PUTStopDataBackfillJobByIdApi puTStopBookingDateBackfillJobByIdRequest(PUTStopBookingDateBackfillJobByIdRequest puTStopBookingDateBackfillJobByIdRequest) {
            this.puTStopBookingDateBackfillJobByIdRequest = puTStopBookingDateBackfillJobByIdRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataBackfillJobApi.this.pUTStopDataBackfillJobByIdCall(this.jobId, this.zuoraOrgIds, this.puTStopBookingDateBackfillJobByIdRequest, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = DataBackfillJobApi.this.pUTStopDataBackfillJobByIdWithHttpInfo(this.jobId, this.zuoraOrgIds, this.puTStopBookingDateBackfillJobByIdRequest);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return DataBackfillJobApi.this.pUTStopDataBackfillJobByIdWithHttpInfo(this.jobId, this.zuoraOrgIds, this.puTStopBookingDateBackfillJobByIdRequest);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return DataBackfillJobApi.this.pUTStopDataBackfillJobByIdAsync(this.jobId, this.zuoraOrgIds, this.puTStopBookingDateBackfillJobByIdRequest, _callback);
        }
    }

    public class POSTCreateDataBackfillJobApi {
        private final Job type;
        private final File _file;
        private String checksum;

        private POSTCreateDataBackfillJobApi(Job type, File _file) {
            this.type = type;
            this._file = _file;
        }

        public POSTCreateDataBackfillJobApi checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataBackfillJobApi.this.pOSTCreateDataBackfillJobCall(this.type, this._file, this.checksum, _callback);
        }

        public POSTCreateDataBackfillJob200Response execute() throws ApiException {
            ApiResponse localVarResp = DataBackfillJobApi.this.pOSTCreateDataBackfillJobWithHttpInfo(this.type, this._file, this.checksum);
            return (POSTCreateDataBackfillJob200Response)localVarResp.getData();
        }

        private ApiResponse<POSTCreateDataBackfillJob200Response> executeWithHttpInfo() throws ApiException {
            return DataBackfillJobApi.this.pOSTCreateDataBackfillJobWithHttpInfo(this.type, this._file, this.checksum);
        }

        public Call executeAsync(ApiCallback<POSTCreateDataBackfillJob200Response> _callback) throws ApiException {
            return DataBackfillJobApi.this.pOSTCreateDataBackfillJobAsync(this.type, this._file, this.checksum, _callback);
        }
    }

    public class GETListDataBackfillJobsApi {
        private GETListDataBackfillJobsApi() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataBackfillJobApi.this.gETListDataBackfillJobsCall(_callback);
        }

        public GETListDataBackfillJobs200Response execute() throws ApiException {
            ApiResponse localVarResp = DataBackfillJobApi.this.gETListDataBackfillJobsWithHttpInfo();
            return (GETListDataBackfillJobs200Response)localVarResp.getData();
        }

        private ApiResponse<GETListDataBackfillJobs200Response> executeWithHttpInfo() throws ApiException {
            return DataBackfillJobApi.this.gETListDataBackfillJobsWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<GETListDataBackfillJobs200Response> _callback) throws ApiException {
            return DataBackfillJobApi.this.gETListDataBackfillJobsAsync(_callback);
        }
    }

    public class GETDataBackfillTemplateApi {
        private final JobType type;
        private String zuoraOrgIds;

        private GETDataBackfillTemplateApi(JobType type) {
            this.type = type;
        }

        public GETDataBackfillTemplateApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataBackfillJobApi.this.gETDataBackfillTemplateCall(this.type, this.zuoraOrgIds, _callback);
        }

        public String execute() throws ApiException {
            ApiResponse localVarResp = DataBackfillJobApi.this.gETDataBackfillTemplateWithHttpInfo(this.type, this.zuoraOrgIds);
            return (String)localVarResp.getData();
        }

        private ApiResponse<String> executeWithHttpInfo() throws ApiException {
            return DataBackfillJobApi.this.gETDataBackfillTemplateWithHttpInfo(this.type, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<String> _callback) throws ApiException {
            return DataBackfillJobApi.this.gETDataBackfillTemplateAsync(this.type, this.zuoraOrgIds, _callback);
        }
    }

    public class GETDataBackfillJobByIdApi {
        private final String jobId;
        private String zuoraOrgIds;

        private GETDataBackfillJobByIdApi(String jobId) {
            this.jobId = jobId;
        }

        public GETDataBackfillJobByIdApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataBackfillJobApi.this.gETDataBackfillJobByIdCall(this.jobId, this.zuoraOrgIds, _callback);
        }

        public GETDataBackfillJobById200Response execute() throws ApiException {
            ApiResponse localVarResp = DataBackfillJobApi.this.gETDataBackfillJobByIdWithHttpInfo(this.jobId, this.zuoraOrgIds);
            return (GETDataBackfillJobById200Response)localVarResp.getData();
        }

        private ApiResponse<GETDataBackfillJobById200Response> executeWithHttpInfo() throws ApiException {
            return DataBackfillJobApi.this.gETDataBackfillJobByIdWithHttpInfo(this.jobId, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GETDataBackfillJobById200Response> _callback) throws ApiException {
            return DataBackfillJobApi.this.gETDataBackfillJobByIdAsync(this.jobId, this.zuoraOrgIds, _callback);
        }
    }
}

