/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CreateOpenPaymentMethodTypeRequest;
import com.zuora.model.CreateUpdateOpenPaymentMethodTypeResponse;
import com.zuora.model.OpenPaymentMethodTypeResponse;
import com.zuora.model.UpdateOpenPaymentMethodTypeRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CustomPaymentMethodTypesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomPaymentMethodTypesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomPaymentMethodTypesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createOpenPaymentMethodTypeCall(CreateOpenPaymentMethodTypeRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOpenPaymentMethodTypeRequest localVarPostBody = request;
        String localVarPath = "/open-payment-method-types";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOpenPaymentMethodTypeValidateBeforeCall(CreateOpenPaymentMethodTypeRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createOpenPaymentMethodType(Async)");
        }
        return this.createOpenPaymentMethodTypeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public CreateUpdateOpenPaymentMethodTypeResponse createOpenPaymentMethodType(CreateOpenPaymentMethodTypeRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<CreateUpdateOpenPaymentMethodTypeResponse> localVarResp = this.createOpenPaymentMethodTypeWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CreateUpdateOpenPaymentMethodTypeResponse> createOpenPaymentMethodTypeWithHttpInfo(CreateOpenPaymentMethodTypeRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.createOpenPaymentMethodTypeValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CreateUpdateOpenPaymentMethodTypeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createOpenPaymentMethodTypeAsync(CreateOpenPaymentMethodTypeRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<CreateUpdateOpenPaymentMethodTypeResponse> _callback) throws ApiException {
        Call localVarCall = this.createOpenPaymentMethodTypeValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CreateUpdateOpenPaymentMethodTypeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateOpenPaymentMethodTypeApi createOpenPaymentMethodTypeApi(CreateOpenPaymentMethodTypeRequest request) {
        return new CreateOpenPaymentMethodTypeApi(request);
    }

    private Call getOpenPaymentMethodTypeRevisionCall(String paymentMethodTypeName, Integer revisionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/open-payment-method-types/{paymentMethodTypeName}/draft/{revisionNumber}".replace("{paymentMethodTypeName}", this.localVarApiClient.escapeString(paymentMethodTypeName.toString())).replace("{revisionNumber}", this.localVarApiClient.escapeString(revisionNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOpenPaymentMethodTypeRevisionValidateBeforeCall(String paymentMethodTypeName, Integer revisionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentMethodTypeName == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodTypeName' when calling getOpenPaymentMethodTypeRevision(Async)");
        }
        if (revisionNumber == null) {
            throw new ApiException("Missing the required parameter 'revisionNumber' when calling getOpenPaymentMethodTypeRevision(Async)");
        }
        return this.getOpenPaymentMethodTypeRevisionCall(paymentMethodTypeName, revisionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public OpenPaymentMethodTypeResponse getOpenPaymentMethodTypeRevision(String paymentMethodTypeName, Integer revisionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<OpenPaymentMethodTypeResponse> localVarResp = this.getOpenPaymentMethodTypeRevisionWithHttpInfo(paymentMethodTypeName, revisionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<OpenPaymentMethodTypeResponse> getOpenPaymentMethodTypeRevisionWithHttpInfo(String paymentMethodTypeName, Integer revisionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getOpenPaymentMethodTypeRevisionValidateBeforeCall(paymentMethodTypeName, revisionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<OpenPaymentMethodTypeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getOpenPaymentMethodTypeRevisionAsync(String paymentMethodTypeName, Integer revisionNumber, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<OpenPaymentMethodTypeResponse> _callback) throws ApiException {
        Call localVarCall = this.getOpenPaymentMethodTypeRevisionValidateBeforeCall(paymentMethodTypeName, revisionNumber, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<OpenPaymentMethodTypeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOpenPaymentMethodTypeRevisionApi getOpenPaymentMethodTypeRevisionApi(String paymentMethodTypeName, Integer revisionNumber) {
        return new GetOpenPaymentMethodTypeRevisionApi(paymentMethodTypeName, revisionNumber);
    }

    private Call getPublishedOpenPaymentMethodTypeCall(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/open-payment-method-types/{paymentMethodTypeName}/published".replace("{paymentMethodTypeName}", this.localVarApiClient.escapeString(paymentMethodTypeName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPublishedOpenPaymentMethodTypeValidateBeforeCall(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentMethodTypeName == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodTypeName' when calling getPublishedOpenPaymentMethodType(Async)");
        }
        return this.getPublishedOpenPaymentMethodTypeCall(paymentMethodTypeName, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public OpenPaymentMethodTypeResponse getPublishedOpenPaymentMethodType(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<OpenPaymentMethodTypeResponse> localVarResp = this.getPublishedOpenPaymentMethodTypeWithHttpInfo(paymentMethodTypeName, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<OpenPaymentMethodTypeResponse> getPublishedOpenPaymentMethodTypeWithHttpInfo(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getPublishedOpenPaymentMethodTypeValidateBeforeCall(paymentMethodTypeName, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<OpenPaymentMethodTypeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPublishedOpenPaymentMethodTypeAsync(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<OpenPaymentMethodTypeResponse> _callback) throws ApiException {
        Call localVarCall = this.getPublishedOpenPaymentMethodTypeValidateBeforeCall(paymentMethodTypeName, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<OpenPaymentMethodTypeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPublishedOpenPaymentMethodTypeApi getPublishedOpenPaymentMethodTypeApi(String paymentMethodTypeName) {
        return new GetPublishedOpenPaymentMethodTypeApi(paymentMethodTypeName);
    }

    private Call publishOpenPaymentMethodTypeCall(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/open-payment-method-types/publish/{paymentMethodTypeName}".replace("{paymentMethodTypeName}", this.localVarApiClient.escapeString(paymentMethodTypeName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call publishOpenPaymentMethodTypeValidateBeforeCall(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentMethodTypeName == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodTypeName' when calling publishOpenPaymentMethodType(Async)");
        }
        return this.publishOpenPaymentMethodTypeCall(paymentMethodTypeName, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public OpenPaymentMethodTypeResponse publishOpenPaymentMethodType(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<OpenPaymentMethodTypeResponse> localVarResp = this.publishOpenPaymentMethodTypeWithHttpInfo(paymentMethodTypeName, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<OpenPaymentMethodTypeResponse> publishOpenPaymentMethodTypeWithHttpInfo(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.publishOpenPaymentMethodTypeValidateBeforeCall(paymentMethodTypeName, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<OpenPaymentMethodTypeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call publishOpenPaymentMethodTypeAsync(String paymentMethodTypeName, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<OpenPaymentMethodTypeResponse> _callback) throws ApiException {
        Call localVarCall = this.publishOpenPaymentMethodTypeValidateBeforeCall(paymentMethodTypeName, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<OpenPaymentMethodTypeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PublishOpenPaymentMethodTypeApi publishOpenPaymentMethodTypeApi(String paymentMethodTypeName) {
        return new PublishOpenPaymentMethodTypeApi(paymentMethodTypeName);
    }

    private Call updateOpenPaymentMethodTypeCall(String paymentMethodTypeName, UpdateOpenPaymentMethodTypeRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateOpenPaymentMethodTypeRequest localVarPostBody = body;
        String localVarPath = "/open-payment-method-types/{paymentMethodTypeName}".replace("{paymentMethodTypeName}", this.localVarApiClient.escapeString(paymentMethodTypeName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOpenPaymentMethodTypeValidateBeforeCall(String paymentMethodTypeName, UpdateOpenPaymentMethodTypeRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentMethodTypeName == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodTypeName' when calling updateOpenPaymentMethodType(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateOpenPaymentMethodType(Async)");
        }
        return this.updateOpenPaymentMethodTypeCall(paymentMethodTypeName, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public CreateUpdateOpenPaymentMethodTypeResponse updateOpenPaymentMethodType(String paymentMethodTypeName, UpdateOpenPaymentMethodTypeRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<CreateUpdateOpenPaymentMethodTypeResponse> localVarResp = this.updateOpenPaymentMethodTypeWithHttpInfo(paymentMethodTypeName, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CreateUpdateOpenPaymentMethodTypeResponse> updateOpenPaymentMethodTypeWithHttpInfo(String paymentMethodTypeName, UpdateOpenPaymentMethodTypeRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.updateOpenPaymentMethodTypeValidateBeforeCall(paymentMethodTypeName, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CreateUpdateOpenPaymentMethodTypeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateOpenPaymentMethodTypeAsync(String paymentMethodTypeName, UpdateOpenPaymentMethodTypeRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<CreateUpdateOpenPaymentMethodTypeResponse> _callback) throws ApiException {
        Call localVarCall = this.updateOpenPaymentMethodTypeValidateBeforeCall(paymentMethodTypeName, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CreateUpdateOpenPaymentMethodTypeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateOpenPaymentMethodTypeApi updateOpenPaymentMethodTypeApi(String paymentMethodTypeName, UpdateOpenPaymentMethodTypeRequest body) {
        return new UpdateOpenPaymentMethodTypeApi(paymentMethodTypeName, body);
    }

    public class UpdateOpenPaymentMethodTypeApi {
        private final String paymentMethodTypeName;
        private final UpdateOpenPaymentMethodTypeRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private UpdateOpenPaymentMethodTypeApi(String paymentMethodTypeName, UpdateOpenPaymentMethodTypeRequest body) {
            this.paymentMethodTypeName = paymentMethodTypeName;
            this.body = body;
        }

        public UpdateOpenPaymentMethodTypeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateOpenPaymentMethodTypeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateOpenPaymentMethodTypeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateOpenPaymentMethodTypeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateOpenPaymentMethodTypeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateOpenPaymentMethodTypeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.updateOpenPaymentMethodTypeCall(this.paymentMethodTypeName, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public CreateUpdateOpenPaymentMethodTypeResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomPaymentMethodTypesApi.this.updateOpenPaymentMethodTypeWithHttpInfo(this.paymentMethodTypeName, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (CreateUpdateOpenPaymentMethodTypeResponse)localVarResp.getData();
        }

        private ApiResponse<CreateUpdateOpenPaymentMethodTypeResponse> executeWithHttpInfo() throws ApiException {
            return CustomPaymentMethodTypesApi.this.updateOpenPaymentMethodTypeWithHttpInfo(this.paymentMethodTypeName, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CreateUpdateOpenPaymentMethodTypeResponse> _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.updateOpenPaymentMethodTypeAsync(this.paymentMethodTypeName, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class PublishOpenPaymentMethodTypeApi {
        private final String paymentMethodTypeName;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private PublishOpenPaymentMethodTypeApi(String paymentMethodTypeName) {
            this.paymentMethodTypeName = paymentMethodTypeName;
        }

        public PublishOpenPaymentMethodTypeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PublishOpenPaymentMethodTypeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PublishOpenPaymentMethodTypeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PublishOpenPaymentMethodTypeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PublishOpenPaymentMethodTypeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PublishOpenPaymentMethodTypeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.publishOpenPaymentMethodTypeCall(this.paymentMethodTypeName, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public OpenPaymentMethodTypeResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomPaymentMethodTypesApi.this.publishOpenPaymentMethodTypeWithHttpInfo(this.paymentMethodTypeName, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (OpenPaymentMethodTypeResponse)localVarResp.getData();
        }

        private ApiResponse<OpenPaymentMethodTypeResponse> executeWithHttpInfo() throws ApiException {
            return CustomPaymentMethodTypesApi.this.publishOpenPaymentMethodTypeWithHttpInfo(this.paymentMethodTypeName, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<OpenPaymentMethodTypeResponse> _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.publishOpenPaymentMethodTypeAsync(this.paymentMethodTypeName, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class GetPublishedOpenPaymentMethodTypeApi {
        private final String paymentMethodTypeName;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private GetPublishedOpenPaymentMethodTypeApi(String paymentMethodTypeName) {
            this.paymentMethodTypeName = paymentMethodTypeName;
        }

        public GetPublishedOpenPaymentMethodTypeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPublishedOpenPaymentMethodTypeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPublishedOpenPaymentMethodTypeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPublishedOpenPaymentMethodTypeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPublishedOpenPaymentMethodTypeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPublishedOpenPaymentMethodTypeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.getPublishedOpenPaymentMethodTypeCall(this.paymentMethodTypeName, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public OpenPaymentMethodTypeResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomPaymentMethodTypesApi.this.getPublishedOpenPaymentMethodTypeWithHttpInfo(this.paymentMethodTypeName, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (OpenPaymentMethodTypeResponse)localVarResp.getData();
        }

        private ApiResponse<OpenPaymentMethodTypeResponse> executeWithHttpInfo() throws ApiException {
            return CustomPaymentMethodTypesApi.this.getPublishedOpenPaymentMethodTypeWithHttpInfo(this.paymentMethodTypeName, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<OpenPaymentMethodTypeResponse> _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.getPublishedOpenPaymentMethodTypeAsync(this.paymentMethodTypeName, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class GetOpenPaymentMethodTypeRevisionApi {
        private final String paymentMethodTypeName;
        private final Integer revisionNumber;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private GetOpenPaymentMethodTypeRevisionApi(String paymentMethodTypeName, Integer revisionNumber) {
            this.paymentMethodTypeName = paymentMethodTypeName;
            this.revisionNumber = revisionNumber;
        }

        public GetOpenPaymentMethodTypeRevisionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetOpenPaymentMethodTypeRevisionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetOpenPaymentMethodTypeRevisionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetOpenPaymentMethodTypeRevisionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetOpenPaymentMethodTypeRevisionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetOpenPaymentMethodTypeRevisionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.getOpenPaymentMethodTypeRevisionCall(this.paymentMethodTypeName, this.revisionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public OpenPaymentMethodTypeResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomPaymentMethodTypesApi.this.getOpenPaymentMethodTypeRevisionWithHttpInfo(this.paymentMethodTypeName, this.revisionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (OpenPaymentMethodTypeResponse)localVarResp.getData();
        }

        private ApiResponse<OpenPaymentMethodTypeResponse> executeWithHttpInfo() throws ApiException {
            return CustomPaymentMethodTypesApi.this.getOpenPaymentMethodTypeRevisionWithHttpInfo(this.paymentMethodTypeName, this.revisionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<OpenPaymentMethodTypeResponse> _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.getOpenPaymentMethodTypeRevisionAsync(this.paymentMethodTypeName, this.revisionNumber, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class CreateOpenPaymentMethodTypeApi {
        private final CreateOpenPaymentMethodTypeRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private CreateOpenPaymentMethodTypeApi(CreateOpenPaymentMethodTypeRequest request) {
            this.request = request;
        }

        public CreateOpenPaymentMethodTypeApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateOpenPaymentMethodTypeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateOpenPaymentMethodTypeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateOpenPaymentMethodTypeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateOpenPaymentMethodTypeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateOpenPaymentMethodTypeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateOpenPaymentMethodTypeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.createOpenPaymentMethodTypeCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public CreateUpdateOpenPaymentMethodTypeResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomPaymentMethodTypesApi.this.createOpenPaymentMethodTypeWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (CreateUpdateOpenPaymentMethodTypeResponse)localVarResp.getData();
        }

        private ApiResponse<CreateUpdateOpenPaymentMethodTypeResponse> executeWithHttpInfo() throws ApiException {
            return CustomPaymentMethodTypesApi.this.createOpenPaymentMethodTypeWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CreateUpdateOpenPaymentMethodTypeResponse> _callback) throws ApiException {
            return CustomPaymentMethodTypesApi.this.createOpenPaymentMethodTypeAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }
}

