/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Accounting configuration if you have Zuora Revenue enabled.")
public class OrderLineItemRevenue {
    public static final String SERIALIZED_NAME_EXCLUDE_ITEM_BILLING_FROM_REVENUE_ACCOUNTING = "exclude_item_billing_from_revenue_accounting";
    @SerializedName(value="exclude_item_billing_from_revenue_accounting")
    private Boolean excludeItemBillingFromRevenueAccounting;
    public static final String SERIALIZED_NAME_EXCLUDE_ITEM_BOOKING_FROM_REVENUE_ACCOUNTING = "exclude_item_booking_from_revenue_accounting";
    @SerializedName(value="exclude_item_booking_from_revenue_accounting")
    private Boolean excludeItemBookingFromRevenueAccounting;
    public static final String SERIALIZED_NAME_ADJUSTMENT_REVENUE_ACCOUNT = "adjustment_revenue_account";
    @SerializedName(value="adjustment_revenue_account")
    private String adjustmentRevenueAccount;
    public static final String SERIALIZED_NAME_CONTRACT_RECOGNIZED_REVENUE_ACCOUNT = "contract_recognized_revenue_account";
    @SerializedName(value="contract_recognized_revenue_account")
    private String contractRecognizedRevenueAccount;
    public static final String SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNT = "deferred_revenue_account";
    @SerializedName(value="deferred_revenue_account")
    private String deferredRevenueAccount;
    public static final String SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNT = "recognized_revenue_account";
    @SerializedName(value="recognized_revenue_account")
    private String recognizedRevenueAccount;
    public static final String SERIALIZED_NAME_REVENUE_RECOGNITION_RULE_NAME = "revenue_recognition_rule_name";
    @SerializedName(value="revenue_recognition_rule_name")
    private String revenueRecognitionRuleName;

    public OrderLineItemRevenue excludeItemBillingFromRevenueAccounting(Boolean excludeItemBillingFromRevenueAccounting) {
        this.excludeItemBillingFromRevenueAccounting = excludeItemBillingFromRevenueAccounting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, any associated billing document items are excluded from the revenue accounting.")
    public Boolean getExcludeItemBillingFromRevenueAccounting() {
        return this.excludeItemBillingFromRevenueAccounting;
    }

    public void setExcludeItemBillingFromRevenueAccounting(Boolean excludeItemBillingFromRevenueAccounting) {
        this.excludeItemBillingFromRevenueAccounting = excludeItemBillingFromRevenueAccounting;
    }

    public OrderLineItemRevenue excludeItemBookingFromRevenueAccounting(Boolean excludeItemBookingFromRevenueAccounting) {
        this.excludeItemBookingFromRevenueAccounting = excludeItemBookingFromRevenueAccounting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, any associated subscription items are excluded from the revenue accounting.")
    public Boolean getExcludeItemBookingFromRevenueAccounting() {
        return this.excludeItemBookingFromRevenueAccounting;
    }

    public void setExcludeItemBookingFromRevenueAccounting(Boolean excludeItemBookingFromRevenueAccounting) {
        this.excludeItemBookingFromRevenueAccounting = excludeItemBookingFromRevenueAccounting;
    }

    public OrderLineItemRevenue adjustmentRevenueAccount(String adjustmentRevenueAccount) {
        this.adjustmentRevenueAccount = adjustmentRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getAdjustmentRevenueAccount() {
        return this.adjustmentRevenueAccount;
    }

    public void setAdjustmentRevenueAccount(String adjustmentRevenueAccount) {
        this.adjustmentRevenueAccount = adjustmentRevenueAccount;
    }

    public OrderLineItemRevenue contractRecognizedRevenueAccount(String contractRecognizedRevenueAccount) {
        this.contractRecognizedRevenueAccount = contractRecognizedRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getContractRecognizedRevenueAccount() {
        return this.contractRecognizedRevenueAccount;
    }

    public void setContractRecognizedRevenueAccount(String contractRecognizedRevenueAccount) {
        this.contractRecognizedRevenueAccount = contractRecognizedRevenueAccount;
    }

    public OrderLineItemRevenue deferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getDeferredRevenueAccount() {
        return this.deferredRevenueAccount;
    }

    public void setDeferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
    }

    public OrderLineItemRevenue recognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getRecognizedRevenueAccount() {
        return this.recognizedRevenueAccount;
    }

    public void setRecognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
    }

    public OrderLineItemRevenue revenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The revenue recognition rule for the order line item.")
    public String getRevenueRecognitionRuleName() {
        return this.revenueRecognitionRuleName;
    }

    public void setRevenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderLineItemRevenue orderLineItemRevenue = (OrderLineItemRevenue)o;
        return Objects.equals(this.excludeItemBillingFromRevenueAccounting, orderLineItemRevenue.excludeItemBillingFromRevenueAccounting) && Objects.equals(this.excludeItemBookingFromRevenueAccounting, orderLineItemRevenue.excludeItemBookingFromRevenueAccounting) && Objects.equals(this.adjustmentRevenueAccount, orderLineItemRevenue.adjustmentRevenueAccount) && Objects.equals(this.contractRecognizedRevenueAccount, orderLineItemRevenue.contractRecognizedRevenueAccount) && Objects.equals(this.deferredRevenueAccount, orderLineItemRevenue.deferredRevenueAccount) && Objects.equals(this.recognizedRevenueAccount, orderLineItemRevenue.recognizedRevenueAccount) && Objects.equals(this.revenueRecognitionRuleName, orderLineItemRevenue.revenueRecognitionRuleName);
    }

    public int hashCode() {
        return Objects.hash(this.excludeItemBillingFromRevenueAccounting, this.excludeItemBookingFromRevenueAccounting, this.adjustmentRevenueAccount, this.contractRecognizedRevenueAccount, this.deferredRevenueAccount, this.recognizedRevenueAccount, this.revenueRecognitionRuleName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderLineItemRevenue {\n");
        sb.append("    excludeItemBillingFromRevenueAccounting: ").append(this.toIndentedString(this.excludeItemBillingFromRevenueAccounting)).append("\n");
        sb.append("    excludeItemBookingFromRevenueAccounting: ").append(this.toIndentedString(this.excludeItemBookingFromRevenueAccounting)).append("\n");
        sb.append("    adjustmentRevenueAccount: ").append(this.toIndentedString(this.adjustmentRevenueAccount)).append("\n");
        sb.append("    contractRecognizedRevenueAccount: ").append(this.toIndentedString(this.contractRecognizedRevenueAccount)).append("\n");
        sb.append("    deferredRevenueAccount: ").append(this.toIndentedString(this.deferredRevenueAccount)).append("\n");
        sb.append("    recognizedRevenueAccount: ").append(this.toIndentedString(this.recognizedRevenueAccount)).append("\n");
        sb.append("    revenueRecognitionRuleName: ").append(this.toIndentedString(this.revenueRecognitionRuleName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

