/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.internal.pricing;

import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.apis.data.ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier;
import com.zuora.sdk.internal.models.enums.ChargeType;
import com.zuora.sdk.internal.pricing.ChargeModelRule;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class PerUnit
extends ChargeModelRule {
    private static final PriceEnum.ChargeModel chargeModel = PriceEnum.ChargeModel.PER_UNIT;
    private static final EnumSet<ChargeType> chargeTypes = EnumSet.of(ChargeType.RECURRING, ChargeType.ONE_TIME, ChargeType.USAGE);

    @Override
    PriceEnum.ChargeModel getChargeModel() {
        return chargeModel;
    }

    @Override
    EnumSet<ChargeType> getChargeTypes() {
        return chargeTypes;
    }

    @Override
    List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> getZTiers(PriceCreateRequest price) {
        return this.getZTierFromAmount(price.getUnitAmounts(), false);
    }

    @Override
    Double getAmountFromRatePlanCharge(RatePlansBySubscriptionIdQuery.Node2 zTier) {
        return zTier.getPrice();
    }

    @Override
    public boolean check(PriceCreateRequest priceCreateRequest) {
        Map<Currency, Double> unitAmounts = priceCreateRequest.getUnitAmounts();
        if (unitAmounts == null || unitAmounts.isEmpty()) {
            return false;
        }
        return priceCreateRequest.getUnitOfMeasure() != null && !this.hasOverage(priceCreateRequest);
    }
}

