/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.internal.pricing;

import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.apis.data.ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier;
import com.zuora.sdk.internal.models.enums.ChargeType;
import com.zuora.sdk.internal.pricing.ChargeModelRule;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class DiscountPercentage
extends ChargeModelRule {
    private static final PriceEnum.ChargeModel chargeModel = PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE;
    private static final EnumSet<ChargeType> chargeTypes = EnumSet.of(ChargeType.RECURRING, ChargeType.ONE_TIME);

    @Override
    PriceEnum.ChargeModel getChargeModel() {
        return chargeModel;
    }

    @Override
    EnumSet<ChargeType> getChargeTypes() {
        return chargeTypes;
    }

    @Override
    List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> getZTiers(PriceCreateRequest price) {
        return Collections.singletonList(new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().discountPercentage(price.getPercentAmount()));
    }

    @Override
    Double getAmountFromRatePlanCharge(RatePlansBySubscriptionIdQuery.Node2 zTier) {
        return zTier.getDiscountPercentage();
    }

    @Override
    public boolean check(PriceCreateRequest priceCreateRequest) {
        if (!this.isDiscount(priceCreateRequest)) {
            return false;
        }
        return priceCreateRequest.getPercentAmount() != null;
    }
}

