/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.enums;

import com.google.common.base.Strings;
import com.zuora.sdk.internal.exceptions.InvalidRequestException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public enum CardType {
    VISA("Visa"),
    MASTERCARD("MasterCard"),
    AMERICAN_EXPRESS("AmericanExpress"),
    DISCOVER("Discover"),
    JCB("JCB"),
    DINERS("Diners");

    private final String apiValue;

    public static CardType fromApi(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        for (CardType v : CardType.values()) {
            if (!v.apiValue.equals(value)) continue;
            return v;
        }
        throw InvalidRequestException.builder().addViolation(InvalidRequestException.Reason.InvalidValue, "CardType", "invalid value " + value).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private CardType(String apiValue) {
        this.apiValue = apiValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getApiValue() {
        return this.apiValue;
    }
}

