/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Payment;
import com.zuora.sdk.PaymentCreateRequest;
import com.zuora.sdk.Refund;
import com.zuora.sdk.RefundCreateRequest;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.enums.MethodType;
import com.zuora.sdk.enums.RefundState;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.Tools;
import com.zuora.sdk.internal.apis.data.GETARPaymentTypewithSuccess;
import com.zuora.sdk.internal.models.ZPayment;
import com.zuora.sdk.internal.models.ZRefund;
import com.zuora.sdk.internal.models.enums.AccountingCodeType;
import com.zuora.sdk.internal.models.enums.PaymentStatus;
import com.zuora.sdk.internal.models.enums.PaymentType;
import com.zuora.sdk.internal.models.enums.RefundType;
import com.zuora.sdk.internal.models.enums.TransferredToAccounting;
import java.time.LocalDate;
import java.time.ZoneId;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
abstract class TransactionMapper {
    TransactionMapper() {
    }

    @Mappings(value={@Mapping(source="account", target="accountId"), @Mapping(source="statementDescriptor", target="softDescriptor"), @Mapping(expression="java(Boolean.TRUE.equals(refundCreateRequest.getExternal()) ? com.zuora.sdk.internal.models.enums.RefundType.EXTERNAL : com.zuora.sdk.internal.models.enums.RefundType.ELECTRONIC)", target="type"), @Mapping(source="reference", target="referenceId"), @Mapping(source="date", target="refundDate"), @Mapping(source="description", target="comment"), @Mapping(source="reason", target="reasonCode"), @Mapping(source="paymentId", target="paymentId"), @Mapping(expression="java(refundCreateRequest.getType().getApiType())", target="methodType"), @Mapping(source="customFields", target="refundObjectCustomFields")})
    abstract ZRefund.Builder toApi(RefundCreateRequest var1);

    Refund fromApi(ZRefund zRefund, ZuoraClient client) {
        ZoneId tenantZoneId = client.getContext().getEntityProfileInfo().tenantZoneId();
        return Refund.builder().account(zRefund.accountId()).amount(zRefund.amount()).cancelTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zRefund.cancelledOn())).description(zRefund.comment()).createdBy(zRefund.createdById()).createTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zRefund.createdDate())).creditMemo(zRefund.creditMemoId()).transferredToAccounting(zRefund.financeInformation() == null ? null : TransferredToAccounting.getByLabel((String)zRefund.financeInformation().transferredToAccounting())).gateway(zRefund.gatewayId()).id(zRefund.id()).type(MethodType.fromApi(zRefund.methodType())).name(zRefund.number()).paymentMethod(zRefund.paymentMethodId() == null ? null : client.paymentMethods().get(zRefund.paymentMethodId())).paymentMethodSnapshot(zRefund.paymentMethodSnapshotId() == null ? null : client.paymentMethods().get(zRefund.paymentMethodSnapshotId())).payoutId(zRefund.payoutId()).reason(zRefund.reasonCode()).reference(zRefund.referenceId()).date(Tools.toLocalDate((String)zRefund.refundDate())).statementDescriptor(zRefund.softDescriptor()).state(RefundState.fromApi(zRefund.status())).external(RefundType.EXTERNAL.equals((Object)zRefund.type())).updatedBy(zRefund.updatedById()).updateTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zRefund.updatedDate())).customFields(zRefund.refundObjectCustomFields()).build();
    }

    @Mappings(value={@Mapping(source="account", target="accountId"), @Mapping(source="authorisationCode", target="authTransactionId"), @Mapping(source="description", target="comment"), @Mapping(source="date", target="effectiveDate"), @Mapping(source="gateway", target="gatewayId"), @Mapping(source="reference", target="referenceId"), @Mapping(source="statementDescriptor", target="softDescriptor"), @Mapping(source="paymentMethod", target="paymentMethodId"), @Mapping(source="customFields", target="paymentObjectCustomFields"), @Mapping(target="financeInformation", ignore=true)})
    abstract ZPayment.Builder toApi(PaymentCreateRequest var1);

    @Mappings(value={@Mapping(source="id", target="id"), @Mapping(source="account", target="accountId"), @Mapping(source="authorisationCode", target="authTransactionId"), @Mapping(source="description", target="comment"), @Mapping(source="date", target="effectiveDate"), @Mapping(source="gateway", target="gatewayId"), @Mapping(source="reference", target="referenceId"), @Mapping(source="statementDescriptor", target="softDescriptor"), @Mapping(source="paymentMethod.id", target="paymentMethodId"), @Mapping(source="customFields", target="paymentObjectCustomFields"), @Mapping(target="financeInformation", ignore=true)})
    abstract ZPayment.Builder toApi(Payment var1);

    Payment fromApi(ZPayment zPayment, ZuoraClient client) {
        ZoneId tenantZoneId = client.getContext().getEntityProfileInfo().tenantZoneId();
        Payment.PaymentBuilder paymentBuilder = Payment.builder();
        paymentBuilder.id(zPayment.id());
        paymentBuilder.amount(zPayment.amount());
        paymentBuilder.currency(zPayment.currency());
        paymentBuilder.softDescriptorPhone(zPayment.softDescriptorPhone());
        paymentBuilder.secondPaymentReferenceId(zPayment.secondPaymentReferenceId());
        paymentBuilder.payoutId(zPayment.payoutId());
        paymentBuilder.markedForSubmissionOn(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.markedForSubmissionOn()));
        paymentBuilder.gatewayResponseCode(zPayment.gatewayResponseCode());
        paymentBuilder.gatewayReconciliationStatus(zPayment.gatewayReconciliationStatus());
        paymentBuilder.gatewayReconciliationReason(zPayment.gatewayReconciliationReason());
        paymentBuilder.gatewayOrderId(zPayment.gatewayOrderId());
        paymentBuilder.account(zPayment.accountId());
        paymentBuilder.authorisationCode(zPayment.authTransactionId());
        paymentBuilder.description(zPayment.comment());
        paymentBuilder.date(zPayment.effectiveDate() == null ? null : LocalDate.parse(zPayment.effectiveDate()));
        paymentBuilder.gateway(zPayment.gatewayId());
        paymentBuilder.reference(zPayment.referenceId());
        paymentBuilder.statementDescriptor(zPayment.softDescriptor());
        paymentBuilder.customFields(zPayment.paymentObjectCustomFields());
        paymentBuilder.amountApplied(zPayment.appliedAmount());
        paymentBuilder.amountUnapplied(zPayment.unappliedAmount());
        paymentBuilder.name(zPayment.number());
        paymentBuilder.createdBy(zPayment.createdById());
        paymentBuilder.createTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.createdDate()));
        paymentBuilder.updatedBy(zPayment.updatedById());
        paymentBuilder.updateTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.updatedDate()));
        paymentBuilder.state(zPayment.status());
        paymentBuilder.amountRefunded(zPayment.refundAmount());
        paymentBuilder.cancelTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.cancelledOn()));
        paymentBuilder.submitTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.submittedOn()));
        paymentBuilder.external(zPayment.type() == PaymentType.EXTERNAL);
        if (zPayment.Z_FinanceInformation() != null) {
            Payment.PaymentFinanceInformation.PaymentFinanceInformationBuilder paymentFinanceInformation = Payment.PaymentFinanceInformation.builder();
            paymentFinanceInformation.bankAccountAccountingCode(zPayment.Z_FinanceInformation().bankAccountAccountingCode());
            paymentFinanceInformation.transferredToAccounting(TransferredToAccounting.getByLabel((String)zPayment.Z_FinanceInformation().transferredToAccounting()));
            paymentFinanceInformation.unappliedPaymentAccountingCode(zPayment.Z_FinanceInformation().unappliedPaymentAccountingCode());
            paymentFinanceInformation.bankAccountAccountingCodeType(AccountingCodeType.getByLabel((String)zPayment.Z_FinanceInformation().bankAccountAccountingCodeType()));
            paymentFinanceInformation.unappliedPaymentAccountingCodeType(AccountingCodeType.getByLabel((String)zPayment.Z_FinanceInformation().unappliedPaymentAccountingCodeType()));
            paymentBuilder.financeInformation(paymentFinanceInformation.build());
        }
        return paymentBuilder.build();
    }

    Payment fromApi(GETARPaymentTypewithSuccess rawPayment, APIContext context) {
        ZoneId tenantZoneId = context.getEntityProfileInfo().tenantZoneId();
        Payment.PaymentBuilder paymentBuilder = Payment.builder();
        paymentBuilder.id(rawPayment.id());
        paymentBuilder.amount(rawPayment.amount());
        paymentBuilder.currency(rawPayment.currency());
        paymentBuilder.softDescriptorPhone(rawPayment.softDescriptorPhone());
        paymentBuilder.secondPaymentReferenceId(rawPayment.secondPaymentReferenceId());
        paymentBuilder.payoutId(rawPayment.payoutId());
        paymentBuilder.markedForSubmissionOn(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.markedForSubmissionOn()));
        paymentBuilder.gatewayResponseCode(rawPayment.gatewayResponseCode());
        paymentBuilder.gatewayReconciliationStatus(rawPayment.gatewayReconciliationStatus());
        paymentBuilder.gatewayReconciliationReason(rawPayment.gatewayReconciliationReason());
        paymentBuilder.gatewayOrderId(rawPayment.gatewayOrderId());
        paymentBuilder.account(rawPayment.accountId());
        paymentBuilder.authorisationCode(rawPayment.authTransactionId());
        paymentBuilder.description(rawPayment.comment());
        paymentBuilder.date(rawPayment.effectiveDate() == null ? null : LocalDate.parse(rawPayment.effectiveDate()));
        paymentBuilder.gateway(rawPayment.gatewayId());
        paymentBuilder.reference(rawPayment.referenceId());
        paymentBuilder.statementDescriptor(rawPayment.softDescriptor());
        paymentBuilder.customFields(rawPayment.paymentObjectCustomFields());
        paymentBuilder.amountApplied(rawPayment.appliedAmount());
        paymentBuilder.amountUnapplied(rawPayment.unappliedAmount());
        paymentBuilder.name(rawPayment.number());
        paymentBuilder.createdBy(rawPayment.createdById());
        paymentBuilder.createTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.createdDate()));
        paymentBuilder.updatedBy(rawPayment.updatedById());
        paymentBuilder.updateTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.updatedDate()));
        paymentBuilder.state(rawPayment.status() == null ? null : PaymentStatus.getByLabel((String)rawPayment.status()));
        paymentBuilder.amountRefunded(rawPayment.refundAmount());
        paymentBuilder.cancelTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.cancelledOn()));
        paymentBuilder.submitTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.submittedOn()));
        paymentBuilder.external(PaymentType.EXTERNAL.getApiValue().equals(rawPayment.type()));
        if (rawPayment.financeInformation() != null) {
            Payment.PaymentFinanceInformation.PaymentFinanceInformationBuilder paymentFinanceInformation = Payment.PaymentFinanceInformation.builder();
            paymentFinanceInformation.bankAccountAccountingCode(rawPayment.financeInformation().bankAccountAccountingCode());
            paymentFinanceInformation.transferredToAccounting(TransferredToAccounting.getByLabel((String)rawPayment.financeInformation().transferredToAccounting()));
            paymentFinanceInformation.unappliedPaymentAccountingCode(rawPayment.financeInformation().unappliedPaymentAccountingCode());
            paymentFinanceInformation.bankAccountAccountingCodeType(AccountingCodeType.getByLabel((String)rawPayment.financeInformation().bankAccountAccountingCodeType()));
            paymentFinanceInformation.unappliedPaymentAccountingCodeType(AccountingCodeType.getByLabel((String)rawPayment.financeInformation().unappliedPaymentAccountingCodeType()));
            paymentBuilder.financeInformation(paymentFinanceInformation.build());
        }
        return paymentBuilder.build();
    }
}

