/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.EnumMapper;
import com.zuora.sdk.Overage;
import com.zuora.sdk.OverageType;
import com.zuora.sdk.Price;
import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.PriceMapper;
import com.zuora.sdk.Recurring;
import com.zuora.sdk.TierMapper;
import com.zuora.sdk.internal.ProductRatePlanChargesQuery;
import com.zuora.sdk.internal.models.ZProductRatePlanCharge;
import com.zuora.sdk.internal.models.enums.BillingTiming;
import com.zuora.sdk.internal.models.enums.RatingGroup;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.mapstruct.factory.Mappers;

class PriceMapperImpl
extends PriceMapper {
    private final TierMapper tierMapper = new TierMapper();
    private final EnumMapper enumMapper = (EnumMapper)Mappers.getMapper(EnumMapper.class);

    PriceMapperImpl() {
    }

    @Override
    ZProductRatePlanCharge.Builder toApi(PriceCreateRequest price) {
        if (price == null) {
            return null;
        }
        ZProductRatePlanCharge.Builder builder = new ZProductRatePlanCharge.Builder();
        builder.taxMode(this.enumMapper.map(price.isTaxInclusive()));
        builder.triggerEvent(this.enumMapper.mapTriggerEvent(price.getStartEvent()));
        builder.recognizedRevenueAccount(price.getRecognizedRevenueAccountingCode());
        builder.deferredRevenueAccount(price.getDeferredRevenueAccountingCode());
        builder.uOM(price.getUnitOfMeasure());
        builder.defaultQuantity(Double.valueOf(price.getQuantity()));
        builder.productRatePlanId(price.getPlan());
        builder.endDateCondition(this.mapEndDate(price.getRecurring()));
        builder.upToPeriods(this.map(this.priceRecurringDurationIntervalCount(price)));
        builder.upToPeriodsType(this.enumMapper.map(this.priceRecurringDurationInterval(price)));
        builder.ratingGroup(this.ratingGroupToRatingGroup(this.priceRecurringRatingGroup(price)));
        builder.billingTiming(this.priceRecurringTiming(price));
        builder.billingPeriod(this.enumMapper.map(this.priceRecurringInterval(price)));
        builder.specificBillingPeriod(this.map(this.priceRecurringIntervalCount(price)));
        builder.billCycleType(this.enumMapper.mapTo(this.priceRecurringOn(price)));
        builder.billCycleDay(this.enumMapper.mapToSpecificDayOfMonthInt(this.priceRecurringOn(price)));
        builder.weeklyBillCycleDay(this.enumMapper.mapToWeeklyBillCycleDay(this.priceRecurringOn(price)));
        builder.billingPeriodAlignment(this.enumMapper.map(this.priceRecurringAlignment(price)));
        builder.listPriceBase(this.enumMapper.mapListPriceBase(price.getPriceBaseInterval()));
        Map<String, Object> map = price.getCustomFields();
        if (map != null) {
            builder.productRatePlanChargeObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.numberOfPeriod(this.map(this.priceOverageIntervalCount(price)));
        builder.overageCalculationOption(this.enumMapper.map(this.priceOverageApplyAtEndOfSmoothingPeriod(price)));
        builder.overageUnusedUnitsCreditOption(this.enumMapper.mapOverageCredits(this.priceOverageCreditUnusedUnits(price)));
        builder.includedUnits(this.priceOverageIncludedUnits(price));
        builder.smoothingModel(this.enumMapper.toSmoothingModel(this.priceOverageType(price)));
        builder.maxQuantity(Double.valueOf(price.getMaxQuantity()));
        builder.chargeModel(this.enumMapper.map(price.getChargeModel()));
        builder.chargeType(price.getChargeType());
        builder.description(price.getDescription());
        builder.taxCode(price.getTaxCode());
        builder.applyDiscountTo(this.enumMapper.toApi(price.getApplyDiscountTo()));
        builder.discountLevel(this.enumMapper.map(price.getDiscountLevel()));
        builder.name(price.getName());
        builder.minQuantity(Double.valueOf(price.getMinQuantity()));
        this.afterMapping(builder, price);
        return builder;
    }

    @Override
    void toApi(ZProductRatePlanCharge.Builder zProductRatePlanCharge, Price price) {
        if (price == null) {
            return;
        }
        zProductRatePlanCharge.maxQuantity(Double.valueOf(price.getMaxQuantity()));
        zProductRatePlanCharge.chargeModel(this.enumMapper.map(price.getChargeModel()));
        zProductRatePlanCharge.chargeType(price.getChargeType());
        zProductRatePlanCharge.description(price.getDescription());
        zProductRatePlanCharge.taxCode(price.getTaxCode());
        zProductRatePlanCharge.applyDiscountTo(this.enumMapper.toApi(price.getApplyDiscountTo()));
        zProductRatePlanCharge.discountLevel(this.enumMapper.map(price.getDiscountLevel()));
        zProductRatePlanCharge.id(price.getId());
        zProductRatePlanCharge.name(price.getName());
        zProductRatePlanCharge.minQuantity(Double.valueOf(price.getMinQuantity()));
    }

    @Override
    Price.PriceBuilder fromApi(ProductRatePlanChargesQuery.Node productRatePlanCharge) {
        if (productRatePlanCharge == null) {
            return null;
        }
        Price.PriceBuilder priceBuilder = new Price.PriceBuilder();
        priceBuilder.recurring(this.nodeToRecurring(productRatePlanCharge));
        priceBuilder.overage(this.nodeToOverage(productRatePlanCharge));
        if (productRatePlanCharge.getTaxMode() != null) {
            priceBuilder.taxInclusive(Boolean.parseBoolean(productRatePlanCharge.getTaxMode()));
        }
        priceBuilder.startEvent(this.enumMapper.mapTriggerEvent(productRatePlanCharge.getTriggerEvent()));
        priceBuilder.recognizedRevenueAccountingCode(this.productRatePlanChargeRecognizedRevenueAccountingCodeName(productRatePlanCharge));
        priceBuilder.deferredRevenueAccountingCode(this.productRatePlanChargeDeferredRevenueAccountingCodeName(productRatePlanCharge));
        priceBuilder.unitOfMeasure(productRatePlanCharge.getUOM());
        priceBuilder.tiers(this.tierMapper.mapPricing(productRatePlanCharge));
        if (productRatePlanCharge.getDefaultQuantity() != null) {
            priceBuilder.quantity(productRatePlanCharge.getDefaultQuantity());
        }
        priceBuilder.plan(productRatePlanCharge.getProductRatePlanId());
        priceBuilder.priceBaseInterval(this.enumMapper.mapListPriceBase(productRatePlanCharge.getListPriceBase()));
        if (productRatePlanCharge.getCreatedDate() != null) {
            priceBuilder.createTime(ZonedDateTime.parse(productRatePlanCharge.getCreatedDate()));
        }
        if (productRatePlanCharge.getUpdatedDate() != null) {
            priceBuilder.updateTime(ZonedDateTime.parse(productRatePlanCharge.getUpdatedDate()));
        }
        priceBuilder.createdBy(productRatePlanCharge.getCreatedById());
        priceBuilder.updatedBy(productRatePlanCharge.getUpdatedById());
        priceBuilder.chargeModel(this.enumMapper.fromChargeModel(productRatePlanCharge.getChargeModel()));
        priceBuilder.chargeType(this.enumMapper.fromChargeType(productRatePlanCharge.getChargeType()));
        priceBuilder.id(productRatePlanCharge.getId());
        priceBuilder.name(productRatePlanCharge.getName());
        priceBuilder.description(productRatePlanCharge.getDescription());
        priceBuilder.taxCode(productRatePlanCharge.getTaxCode());
        if (productRatePlanCharge.getMinQuantity() != null) {
            priceBuilder.minQuantity(productRatePlanCharge.getMinQuantity());
        }
        if (productRatePlanCharge.getMaxQuantity() != null) {
            priceBuilder.maxQuantity(productRatePlanCharge.getMaxQuantity());
        }
        priceBuilder.applyDiscountTo(this.enumMapper.fromApi(productRatePlanCharge.getApplyDiscountTo()));
        priceBuilder.discountLevel(this.enumMapper.fromDiscountLevel(productRatePlanCharge.getDiscountLevel()));
        this.updateFields(priceBuilder, productRatePlanCharge);
        return priceBuilder;
    }

    private Integer priceRecurringDurationIntervalCount(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Recurring recurring = priceCreateRequest.getRecurring();
        if (recurring == null) {
            return null;
        }
        Integer durationIntervalCount = recurring.getDurationIntervalCount();
        if (durationIntervalCount == null) {
            return null;
        }
        return durationIntervalCount;
    }

    private PriceEnum.DurationInterval priceRecurringDurationInterval(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Recurring recurring = priceCreateRequest.getRecurring();
        if (recurring == null) {
            return null;
        }
        PriceEnum.DurationInterval durationInterval = recurring.getDurationInterval();
        if (durationInterval == null) {
            return null;
        }
        return durationInterval;
    }

    private com.zuora.sdk.enums.RatingGroup priceRecurringRatingGroup(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Recurring recurring = priceCreateRequest.getRecurring();
        if (recurring == null) {
            return null;
        }
        com.zuora.sdk.enums.RatingGroup ratingGroup = recurring.getRatingGroup();
        if (ratingGroup == null) {
            return null;
        }
        return ratingGroup;
    }

    protected RatingGroup ratingGroupToRatingGroup(com.zuora.sdk.enums.RatingGroup ratingGroup) {
        RatingGroup ratingGroup1;
        if (ratingGroup == null) {
            return null;
        }
        switch (ratingGroup) {
            case BY_BILLING_PERIOD: {
                ratingGroup1 = RatingGroup.BY_BILLING_PERIOD;
                break;
            }
            case BY_USAGE_START_DATE: {
                ratingGroup1 = RatingGroup.BY_USAGE_START_DATE;
                break;
            }
            case BY_USAGE_RECORD: {
                ratingGroup1 = RatingGroup.BY_USAGE_RECORD;
                break;
            }
            case BY_USAGE_UPLOAD: {
                ratingGroup1 = RatingGroup.BY_USAGE_UPLOAD;
                break;
            }
            case BY_GROUP_ID: {
                ratingGroup1 = RatingGroup.BY_GROUP_ID;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)ratingGroup));
            }
        }
        return ratingGroup1;
    }

    private BillingTiming priceRecurringTiming(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Recurring recurring = priceCreateRequest.getRecurring();
        if (recurring == null) {
            return null;
        }
        BillingTiming timing = recurring.getTiming();
        if (timing == null) {
            return null;
        }
        return timing;
    }

    private PriceEnum.Interval priceRecurringInterval(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Recurring recurring = priceCreateRequest.getRecurring();
        if (recurring == null) {
            return null;
        }
        PriceEnum.Interval interval = recurring.getInterval();
        if (interval == null) {
            return null;
        }
        return interval;
    }

    private Integer priceRecurringIntervalCount(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Recurring recurring = priceCreateRequest.getRecurring();
        if (recurring == null) {
            return null;
        }
        Integer intervalCount = recurring.getIntervalCount();
        if (intervalCount == null) {
            return null;
        }
        return intervalCount;
    }

    private PriceEnum.RecurringOn priceRecurringOn(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Recurring recurring = priceCreateRequest.getRecurring();
        if (recurring == null) {
            return null;
        }
        PriceEnum.RecurringOn on = recurring.getOn();
        if (on == null) {
            return null;
        }
        return on;
    }

    private PriceEnum.Alignment priceRecurringAlignment(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Recurring recurring = priceCreateRequest.getRecurring();
        if (recurring == null) {
            return null;
        }
        PriceEnum.Alignment alignment = recurring.getAlignment();
        if (alignment == null) {
            return null;
        }
        return alignment;
    }

    private Integer priceOverageIntervalCount(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Overage overage = priceCreateRequest.getOverage();
        if (overage == null) {
            return null;
        }
        Integer intervalCount = overage.getIntervalCount();
        if (intervalCount == null) {
            return null;
        }
        return intervalCount;
    }

    private Boolean priceOverageApplyAtEndOfSmoothingPeriod(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Overage overage = priceCreateRequest.getOverage();
        if (overage == null) {
            return null;
        }
        Boolean applyAtEndOfSmoothingPeriod = overage.getApplyAtEndOfSmoothingPeriod();
        if (applyAtEndOfSmoothingPeriod == null) {
            return null;
        }
        return applyAtEndOfSmoothingPeriod;
    }

    private Boolean priceOverageCreditUnusedUnits(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Overage overage = priceCreateRequest.getOverage();
        if (overage == null) {
            return null;
        }
        Boolean creditUnusedUnits = overage.getCreditUnusedUnits();
        if (creditUnusedUnits == null) {
            return null;
        }
        return creditUnusedUnits;
    }

    private Double priceOverageIncludedUnits(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Overage overage = priceCreateRequest.getOverage();
        if (overage == null) {
            return null;
        }
        Double includedUnits = overage.getIncludedUnits();
        if (includedUnits == null) {
            return null;
        }
        return includedUnits;
    }

    private OverageType priceOverageType(PriceCreateRequest priceCreateRequest) {
        if (priceCreateRequest == null) {
            return null;
        }
        Overage overage = priceCreateRequest.getOverage();
        if (overage == null) {
            return null;
        }
        OverageType type = overage.getType();
        if (type == null) {
            return null;
        }
        return type;
    }

    protected Recurring nodeToRecurring(ProductRatePlanChargesQuery.Node node2) {
        if (node2 == null) {
            return null;
        }
        Recurring.RecurringBuilder recurring = Recurring.builder();
        recurring.alignment(this.enumMapper.mapAlignment(node2.getBillingPeriodAlignment()));
        recurring.durationIntervalCount(this.map(node2.getUpToPeriods()));
        recurring.durationInterval(this.enumMapper.map(node2.getUpToPeriodsType()));
        recurring.ratingGroup(this.enumMapper.fromRatingGroup(node2.getRatingGroup()));
        recurring.interval(this.enumMapper.mapBillingPeriodType(node2.getBillingPeriod()));
        recurring.intervalCount(this.map(node2.getSpecificBillingPeriod()));
        recurring.on(this.toRecurringOn(node2));
        recurring.timing(this.enumMapper.mapBillingTiming(node2.getBillingTiming()));
        return recurring.build();
    }

    protected Overage nodeToOverage(ProductRatePlanChargesQuery.Node node2) {
        if (node2 == null) {
            return null;
        }
        Overage.OverageBuilder overage = Overage.builder();
        if (node2.getNumberOfPeriod() != null) {
            overage.intervalCount(this.map(node2.getNumberOfPeriod()));
        } else {
            overage.intervalCount(this.map(0));
        }
        if (node2.getOverageCalculationOption() != null) {
            overage.applyAtEndOfSmoothingPeriod(Boolean.parseBoolean(node2.getOverageCalculationOption()));
        }
        if (node2.getOverageUnusedUnitsCreditOption() != null) {
            overage.creditUnusedUnits(Boolean.parseBoolean(node2.getOverageUnusedUnitsCreditOption()));
        }
        if (node2.getIncludedUnits() != null) {
            overage.includedUnits(node2.getIncludedUnits());
        }
        if (node2.getSmoothingModel() != null) {
            overage.type(this.enumMapper.fromSmoothingModel(node2.getSmoothingModel()));
        }
        return overage.build();
    }

    private String productRatePlanChargeRecognizedRevenueAccountingCodeName(ProductRatePlanChargesQuery.Node node2) {
        if (node2 == null) {
            return null;
        }
        ProductRatePlanChargesQuery.RecognizedRevenueAccountingCode recognizedRevenueAccountingCode2 = node2.getRecognizedRevenueAccountingCode();
        if (recognizedRevenueAccountingCode2 == null) {
            return null;
        }
        String name = recognizedRevenueAccountingCode2.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private String productRatePlanChargeDeferredRevenueAccountingCodeName(ProductRatePlanChargesQuery.Node node2) {
        if (node2 == null) {
            return null;
        }
        ProductRatePlanChargesQuery.DeferredRevenueAccountingCode deferredRevenueAccountingCode2 = node2.getDeferredRevenueAccountingCode();
        if (deferredRevenueAccountingCode2 == null) {
            return null;
        }
        String name = deferredRevenueAccountingCode2.getName();
        if (name == null) {
            return null;
        }
        return name;
    }
}

