/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Query;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.gson.Gson;
import com.zuora.sdk.EnumMapper;
import com.zuora.sdk.Price;
import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.PriceMapper;
import com.zuora.sdk.TierMapper;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.ApolloClientUtil;
import com.zuora.sdk.internal.HawkClient;
import com.zuora.sdk.internal.ProductRatePlanChargesQuery;
import com.zuora.sdk.internal.apis.ProductRatePlansAPI;
import com.zuora.sdk.internal.apis.data.GETProductRatePlanChargeType;
import com.zuora.sdk.internal.apis.data.GETProductRatePlanType;
import com.zuora.sdk.internal.exceptions.InvalidRequestException;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import com.zuora.sdk.internal.models.ZProductRatePlanCharge;
import com.zuora.sdk.internal.type.ProductrateplanchargeFilterKey;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minidev.json.JSONObject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.mapstruct.factory.Mappers;

public class PriceAPI {
    private final Map<String, Map<String, Object>> uomMap;
    private final HawkClient hawkClient;
    private final ApolloClient gqlClient;
    private final ZuoraClient client;
    private APIContext context;
    private OkHttpClient okHttpClient = new OkHttpClient();
    private PriceMapper priceMapper = (PriceMapper)Mappers.getMapper(PriceMapper.class);

    PriceAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.context.setWsdlVersion("102");
        this.hawkClient = client.getHawkClient();
        this.uomMap = this.getUnitsOfMeasure();
        this.gqlClient = this.hawkClient.getGqlClient();
    }

    /*
     * WARNING - void declaration
     */
    public Price create(PriceCreateRequest priceCreateRequest) throws ZuoraSdkException {
        Meter meter;
        String string;
        Price price;
        Object object;
        long l = System.currentTimeMillis();
        Object object2 = this;
        PriceCreateRequest priceCreateRequest2 = priceCreateRequest;
        try {
            void priceCreateRequest3;
            if (priceCreateRequest2.getUnitOfMeasure() != null) {
                priceCreateRequest2.setPrecision((Double)priceCreateRequest3.uomMap.get(priceCreateRequest2.getUnitOfMeasure()).get("precision"));
                new TierMapper().populateStartingUnits(priceCreateRequest2);
            }
            try {
                object = priceCreateRequest3.priceMapper.toApi(priceCreateRequest2).build().create(priceCreateRequest3.context);
                price = priceCreateRequest3.get((String)object);
            }
            catch (InvalidRequestException invalidRequestException) {
                void e;
                throw InvalidRequestException.builder().message(invalidRequestException.getMessage()).addViolations((Collection)invalidRequestException.getViolations()).addViolation(new InvalidRequestException.Violation(InvalidRequestException.Reason.InvalidValue, "", e.toString())).build();
            }
        }
        catch (Throwable throwable) {
            object2 = null;
        }
        object2 = price;
        priceCreateRequest2 = null;
        object = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string2 = "com.zuora.sdk.PriceAPI".substring("com.zuora.sdk.PriceAPI".lastIndexOf(".") + 1);
        if (null != priceCreateRequest2) {
            string = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{priceCreateRequest2.getClass().getSimpleName(), string2, "create"});
            meter = object.meter(string);
            meter.mark();
        } else {
            string = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string2, "create"});
            meter = object.meter(string);
            meter.mark();
        }
        string = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string2, "create"});
        meter = object.histogram(string);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (priceCreateRequest2 != null) {
            throw priceCreateRequest2;
        }
        return object2;
    }

    public Price get(String priceId) throws ZuoraSdkException {
        try {
            com.apollographql.apollo.api.Response response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductRatePlanChargesQuery(ProductrateplanchargeFilterKey.ID, priceId))).join();
            if (response.getData() == null || ((ProductRatePlanChargesQuery.Data)response.getData()).getProductrateplancharges() == null || ((ProductRatePlanChargesQuery.Data)response.getData()).getProductrateplancharges().getEdges() == null) {
                return null;
            }
            ProductRatePlanChargesQuery.Node nodePrpc = ((ProductRatePlanChargesQuery.Data)response.getData()).getProductrateplancharges().getEdges().get(0).getNode();
            Price price = this.priceMapper.fromApi(nodePrpc).build();
            if (price.getChargeModel() != PriceEnum.ChargeModel.CUSTOM_CHARGE_MODEL) {
                return price;
            }
            this.getCustomChargeModelPrice(price);
            return price;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).build();
        }
    }

    void getCustomChargeModelPrice(Price price) {
        GETProductRatePlanType productRatePlan = ProductRatePlansAPI.fetch((APIContext)this.context, (String)price.getPlan());
        Optional<GETProductRatePlanChargeType> productRatePlanCharge = productRatePlan.productRatePlanCharges().stream().filter(zProductRatePlanCharge -> zProductRatePlanCharge.id().equals(price.getId())).findFirst();
        if (!productRatePlanCharge.isPresent()) {
            throw ZuoraSdkException.builder().message("No Product Rate Plan Charge Found").build();
        }
        GETProductRatePlanChargeType zProductRatePlanCharge2 = productRatePlanCharge.get();
        List chargeModelConfigurations = zProductRatePlanCharge2.chargeModelConfigurations();
        List pricings = zProductRatePlanCharge2.pricing();
        PriceEnum.ChargeModel chargeModel = ((EnumMapper)Mappers.getMapper(EnumMapper.class)).fromChargeModel(productRatePlanCharge.get().model());
        price.setChargeModel(chargeModel);
        this.priceMapper.mapCustomChargeModels(price, chargeModel, chargeModelConfigurations, pricings);
    }

    /*
     * WARNING - void declaration
     */
    public Price update(Price price) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        PriceAPI priceAPI = this;
        Price price2 = price;
        try {
            void zProductRatePlanCharge;
            void price3;
            ZProductRatePlanCharge.Builder builder = new ZProductRatePlanCharge.Builder();
            price3.priceMapper.toApi(builder, (Price)zProductRatePlanCharge);
            builder.build().update(price3.context);
            priceAPI = zProductRatePlanCharge;
            return priceAPI;
        }
        finally {
            price2 = null;
        }
    }

    Map<String, Map<String, Object>> getUnitsOfMeasure() {
        try {
            HashMap<String, Map<String, Object>> uomMap = new HashMap<String, Map<String, Object>>();
            Request request = new Request.Builder().header("Authorization", "Bearer " + this.context.getBearer()).url(this.context.getEndpointBase() + "/settings/units-of-measure/").build();
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.code() == 200 && response.body() != null) {
                Gson gson = new Gson();
                List uoms = (List)((JSONObject)gson.fromJson(response.body().string(), JSONObject.class)).get((Object)"unitsOfMeasure");
                for (Map uom : uoms) {
                    uomMap.put(uom.get("name").toString(), uom);
                }
                return uomMap;
            }
            throw ZuoraSdkException.builder().message(response.message()).operationName("getUnitsOfMeasure").build();
        }
        catch (IOException e) {
            throw ZuoraSdkException.builder().message(e.getMessage()).cause(e.getCause()).operationName("getUnitsOfMeasure").build();
        }
    }
}

