/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.internal.pricing;

import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.apis.data.ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier;
import com.zuora.sdk.internal.models.enums.ChargeType;
import com.zuora.sdk.internal.pricing.ChargeModelRule;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public class Overage
extends ChargeModelRule {
    private static final PriceEnum.ChargeModel chargeModel = PriceEnum.ChargeModel.OVERAGE;
    private static final EnumSet<ChargeType> chargeTypes = EnumSet.of(ChargeType.USAGE);

    @Override
    PriceEnum.ChargeModel getChargeModel() {
        return chargeModel;
    }

    @Override
    EnumSet<ChargeType> getChargeTypes() {
        return chargeTypes;
    }

    @Override
    List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> getZTiers(PriceCreateRequest price) {
        return price.getUnitAmounts().entrySet().stream().map(amount -> new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().currency(((Currency)amount.getKey()).getCurrencyCode()).price((Double)amount.getValue())).collect(Collectors.toList());
    }

    @Override
    Double getAmountFromRatePlanCharge(RatePlansBySubscriptionIdQuery.Node2 zTier) {
        return zTier.getOveragePrice();
    }

    @Override
    public boolean check(PriceCreateRequest priceCreateRequest) {
        return this.hasOverage(priceCreateRequest) && !this.hasTiers(priceCreateRequest);
    }
}

