/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.PaymentMethod;
import com.zuora.sdk.internal.models.enums.AccountingCodeType;
import com.zuora.sdk.internal.models.enums.PaymentGatewayState;
import com.zuora.sdk.internal.models.enums.PaymentStatus;
import com.zuora.sdk.internal.models.enums.TransferredToAccounting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class Payment
extends BaseFacade {
    private final Map<String, Object> customFields;
    private String id;
    private String account;
    @NonNull
    private Double amount;
    private Double amountApplied;
    private Double amountUnapplied;
    private String authorisationCode;
    private String description;
    @NonNull
    private String currency;
    private LocalDate date;
    private String name;
    private String createdBy;
    private String updatedBy;
    private ZonedDateTime updateTime;
    private ZonedDateTime createTime;
    private PaymentStatus state;
    private Double amountRefunded;
    private ZonedDateTime cancelTime;
    private ZonedDateTime submitTime;
    private String secondPaymentReferenceId;
    private String payoutId;
    private PaymentGatewayState gatewayState;
    private ZonedDateTime markedForSubmissionOn;
    private Map<String, String> gatewayOptions;
    private String gatewayResponseCode;
    private String gatewayResponse;
    private String gatewayReconciliationStatus;
    private String gatewayReconciliationReason;
    private PaymentFinanceInformation financeInformation;
    private String gateway;
    private String gatewayOrderId;
    private String reference;
    private String statementDescriptor;
    private String softDescriptorPhone;
    @NonNull
    private boolean external;
    private PaymentMethod paymentMethod;
    private PaymentMethod paymentMethodSnapshot;

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Map<String, Object> $default$customFields() {
        return new HashMap<String, Object>();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Payment(Map<String, Object> customFields, String id, String account2, @NonNull Double amount, Double amountApplied, Double amountUnapplied, String authorisationCode, String description, @NonNull String currency, LocalDate date, String name, String createdBy, String updatedBy, ZonedDateTime updateTime, ZonedDateTime createTime, PaymentStatus state, Double amountRefunded, ZonedDateTime cancelTime, ZonedDateTime submitTime, String secondPaymentReferenceId, String payoutId, PaymentGatewayState gatewayState, ZonedDateTime markedForSubmissionOn, Map<String, String> gatewayOptions, String gatewayResponseCode, String gatewayResponse, String gatewayReconciliationStatus, String gatewayReconciliationReason, PaymentFinanceInformation financeInformation, String gateway, String gatewayOrderId, String reference, String statementDescriptor, String softDescriptorPhone, @NonNull boolean external, PaymentMethod paymentMethod, PaymentMethod paymentMethodSnapshot2) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        this.customFields = customFields;
        this.id = id;
        this.account = account2;
        this.amount = amount;
        this.amountApplied = amountApplied;
        this.amountUnapplied = amountUnapplied;
        this.authorisationCode = authorisationCode;
        this.description = description;
        this.currency = currency;
        this.date = date;
        this.name = name;
        this.createdBy = createdBy;
        this.updatedBy = updatedBy;
        this.updateTime = updateTime;
        this.createTime = createTime;
        this.state = state;
        this.amountRefunded = amountRefunded;
        this.cancelTime = cancelTime;
        this.submitTime = submitTime;
        this.secondPaymentReferenceId = secondPaymentReferenceId;
        this.payoutId = payoutId;
        this.gatewayState = gatewayState;
        this.markedForSubmissionOn = markedForSubmissionOn;
        this.gatewayOptions = gatewayOptions;
        this.gatewayResponseCode = gatewayResponseCode;
        this.gatewayResponse = gatewayResponse;
        this.gatewayReconciliationStatus = gatewayReconciliationStatus;
        this.gatewayReconciliationReason = gatewayReconciliationReason;
        this.financeInformation = financeInformation;
        this.gateway = gateway;
        this.gatewayOrderId = gatewayOrderId;
        this.reference = reference;
        this.statementDescriptor = statementDescriptor;
        this.softDescriptorPhone = softDescriptorPhone;
        this.external = external;
        this.paymentMethod = paymentMethod;
        this.paymentMethodSnapshot = paymentMethodSnapshot2;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static PaymentBuilder builder() {
        return new PaymentBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PaymentBuilder toBuilder() {
        return new PaymentBuilder().customFields(this.customFields).id(this.id).account(this.account).amount(this.amount).amountApplied(this.amountApplied).amountUnapplied(this.amountUnapplied).authorisationCode(this.authorisationCode).description(this.description).currency(this.currency).date(this.date).name(this.name).createdBy(this.createdBy).updatedBy(this.updatedBy).updateTime(this.updateTime).createTime(this.createTime).state(this.state).amountRefunded(this.amountRefunded).cancelTime(this.cancelTime).submitTime(this.submitTime).secondPaymentReferenceId(this.secondPaymentReferenceId).payoutId(this.payoutId).gatewayState(this.gatewayState).markedForSubmissionOn(this.markedForSubmissionOn).gatewayOptions(this.gatewayOptions).gatewayResponseCode(this.gatewayResponseCode).gatewayResponse(this.gatewayResponse).gatewayReconciliationStatus(this.gatewayReconciliationStatus).gatewayReconciliationReason(this.gatewayReconciliationReason).financeInformation(this.financeInformation).gateway(this.gateway).gatewayOrderId(this.gatewayOrderId).reference(this.reference).statementDescriptor(this.statementDescriptor).softDescriptorPhone(this.softDescriptorPhone).external(this.external).paymentMethod(this.paymentMethod).paymentMethodSnapshot(this.paymentMethodSnapshot);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAccount() {
        return this.account;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getAmount() {
        return this.amount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getAmountApplied() {
        return this.amountApplied;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getAmountUnapplied() {
        return this.amountUnapplied;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAuthorisationCode() {
        return this.authorisationCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PaymentStatus getState() {
        return this.state;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getAmountRefunded() {
        return this.amountRefunded;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getCancelTime() {
        return this.cancelTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getSubmitTime() {
        return this.submitTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSecondPaymentReferenceId() {
        return this.secondPaymentReferenceId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPayoutId() {
        return this.payoutId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PaymentGatewayState getGatewayState() {
        return this.gatewayState;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getMarkedForSubmissionOn() {
        return this.markedForSubmissionOn;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getGatewayOptions() {
        return this.gatewayOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getGatewayResponseCode() {
        return this.gatewayResponseCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getGatewayResponse() {
        return this.gatewayResponse;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getGatewayReconciliationStatus() {
        return this.gatewayReconciliationStatus;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getGatewayReconciliationReason() {
        return this.gatewayReconciliationReason;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PaymentFinanceInformation getFinanceInformation() {
        return this.financeInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getGatewayOrderId() {
        return this.gatewayOrderId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getReference() {
        return this.reference;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSoftDescriptorPhone() {
        return this.softDescriptorPhone;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isExternal() {
        return this.external;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PaymentMethod getPaymentMethodSnapshot() {
        return this.paymentMethodSnapshot;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAccount(String account2) {
        this.account = account2;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAmount(@NonNull Double amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.amount = amount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAmountApplied(Double amountApplied) {
        this.amountApplied = amountApplied;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAmountUnapplied(Double amountUnapplied) {
        this.amountUnapplied = amountUnapplied;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAuthorisationCode(String authorisationCode) {
        this.authorisationCode = authorisationCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCurrency(@NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        this.currency = currency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDate(LocalDate date) {
        this.date = date;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCreateTime(ZonedDateTime createTime) {
        this.createTime = createTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setState(PaymentStatus state) {
        this.state = state;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAmountRefunded(Double amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCancelTime(ZonedDateTime cancelTime) {
        this.cancelTime = cancelTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSubmitTime(ZonedDateTime submitTime) {
        this.submitTime = submitTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSecondPaymentReferenceId(String secondPaymentReferenceId) {
        this.secondPaymentReferenceId = secondPaymentReferenceId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPayoutId(String payoutId) {
        this.payoutId = payoutId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGatewayState(PaymentGatewayState gatewayState) {
        this.gatewayState = gatewayState;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMarkedForSubmissionOn(ZonedDateTime markedForSubmissionOn) {
        this.markedForSubmissionOn = markedForSubmissionOn;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGatewayOptions(Map<String, String> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGatewayResponseCode(String gatewayResponseCode) {
        this.gatewayResponseCode = gatewayResponseCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGatewayResponse(String gatewayResponse) {
        this.gatewayResponse = gatewayResponse;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGatewayReconciliationStatus(String gatewayReconciliationStatus) {
        this.gatewayReconciliationStatus = gatewayReconciliationStatus;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGatewayReconciliationReason(String gatewayReconciliationReason) {
        this.gatewayReconciliationReason = gatewayReconciliationReason;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setFinanceInformation(PaymentFinanceInformation financeInformation) {
        this.financeInformation = financeInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setReference(String reference) {
        this.reference = reference;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSoftDescriptorPhone(String softDescriptorPhone) {
        this.softDescriptorPhone = softDescriptorPhone;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setExternal(@NonNull boolean external) {
        this.external = external;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPaymentMethodSnapshot(PaymentMethod paymentMethodSnapshot2) {
        this.paymentMethodSnapshot = paymentMethodSnapshot2;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payment)) {
            return false;
        }
        Payment other = (Payment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExternal() != other.isExternal()) {
            return false;
        }
        Double this$amount = this.getAmount();
        Double other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Double this$amountApplied = this.getAmountApplied();
        Double other$amountApplied = other.getAmountApplied();
        if (this$amountApplied == null ? other$amountApplied != null : !((Object)this$amountApplied).equals(other$amountApplied)) {
            return false;
        }
        Double this$amountUnapplied = this.getAmountUnapplied();
        Double other$amountUnapplied = other.getAmountUnapplied();
        if (this$amountUnapplied == null ? other$amountUnapplied != null : !((Object)this$amountUnapplied).equals(other$amountUnapplied)) {
            return false;
        }
        Double this$amountRefunded = this.getAmountRefunded();
        Double other$amountRefunded = other.getAmountRefunded();
        if (this$amountRefunded == null ? other$amountRefunded != null : !((Object)this$amountRefunded).equals(other$amountRefunded)) {
            return false;
        }
        Map<String, Object> this$customFields = this.getCustomFields();
        Map<String, Object> other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$authorisationCode = this.getAuthorisationCode();
        String other$authorisationCode = other.getAuthorisationCode();
        if (this$authorisationCode == null ? other$authorisationCode != null : !this$authorisationCode.equals(other$authorisationCode)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        ZonedDateTime this$createTime = this.getCreateTime();
        ZonedDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        PaymentStatus this$state = this.getState();
        PaymentStatus other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        ZonedDateTime this$cancelTime = this.getCancelTime();
        ZonedDateTime other$cancelTime = other.getCancelTime();
        if (this$cancelTime == null ? other$cancelTime != null : !((Object)this$cancelTime).equals(other$cancelTime)) {
            return false;
        }
        ZonedDateTime this$submitTime = this.getSubmitTime();
        ZonedDateTime other$submitTime = other.getSubmitTime();
        if (this$submitTime == null ? other$submitTime != null : !((Object)this$submitTime).equals(other$submitTime)) {
            return false;
        }
        String this$secondPaymentReferenceId = this.getSecondPaymentReferenceId();
        String other$secondPaymentReferenceId = other.getSecondPaymentReferenceId();
        if (this$secondPaymentReferenceId == null ? other$secondPaymentReferenceId != null : !this$secondPaymentReferenceId.equals(other$secondPaymentReferenceId)) {
            return false;
        }
        String this$payoutId = this.getPayoutId();
        String other$payoutId = other.getPayoutId();
        if (this$payoutId == null ? other$payoutId != null : !this$payoutId.equals(other$payoutId)) {
            return false;
        }
        PaymentGatewayState this$gatewayState = this.getGatewayState();
        PaymentGatewayState other$gatewayState = other.getGatewayState();
        if (this$gatewayState == null ? other$gatewayState != null : !this$gatewayState.equals(other$gatewayState)) {
            return false;
        }
        ZonedDateTime this$markedForSubmissionOn = this.getMarkedForSubmissionOn();
        ZonedDateTime other$markedForSubmissionOn = other.getMarkedForSubmissionOn();
        if (this$markedForSubmissionOn == null ? other$markedForSubmissionOn != null : !((Object)this$markedForSubmissionOn).equals(other$markedForSubmissionOn)) {
            return false;
        }
        Map<String, String> this$gatewayOptions = this.getGatewayOptions();
        Map<String, String> other$gatewayOptions = other.getGatewayOptions();
        if (this$gatewayOptions == null ? other$gatewayOptions != null : !((Object)this$gatewayOptions).equals(other$gatewayOptions)) {
            return false;
        }
        String this$gatewayResponseCode = this.getGatewayResponseCode();
        String other$gatewayResponseCode = other.getGatewayResponseCode();
        if (this$gatewayResponseCode == null ? other$gatewayResponseCode != null : !this$gatewayResponseCode.equals(other$gatewayResponseCode)) {
            return false;
        }
        String this$gatewayResponse = this.getGatewayResponse();
        String other$gatewayResponse = other.getGatewayResponse();
        if (this$gatewayResponse == null ? other$gatewayResponse != null : !this$gatewayResponse.equals(other$gatewayResponse)) {
            return false;
        }
        String this$gatewayReconciliationStatus = this.getGatewayReconciliationStatus();
        String other$gatewayReconciliationStatus = other.getGatewayReconciliationStatus();
        if (this$gatewayReconciliationStatus == null ? other$gatewayReconciliationStatus != null : !this$gatewayReconciliationStatus.equals(other$gatewayReconciliationStatus)) {
            return false;
        }
        String this$gatewayReconciliationReason = this.getGatewayReconciliationReason();
        String other$gatewayReconciliationReason = other.getGatewayReconciliationReason();
        if (this$gatewayReconciliationReason == null ? other$gatewayReconciliationReason != null : !this$gatewayReconciliationReason.equals(other$gatewayReconciliationReason)) {
            return false;
        }
        PaymentFinanceInformation this$financeInformation = this.getFinanceInformation();
        PaymentFinanceInformation other$financeInformation = other.getFinanceInformation();
        if (this$financeInformation == null ? other$financeInformation != null : !((Object)this$financeInformation).equals(other$financeInformation)) {
            return false;
        }
        String this$gateway = this.getGateway();
        String other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) {
            return false;
        }
        String this$gatewayOrderId = this.getGatewayOrderId();
        String other$gatewayOrderId = other.getGatewayOrderId();
        if (this$gatewayOrderId == null ? other$gatewayOrderId != null : !this$gatewayOrderId.equals(other$gatewayOrderId)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$softDescriptorPhone = this.getSoftDescriptorPhone();
        String other$softDescriptorPhone = other.getSoftDescriptorPhone();
        if (this$softDescriptorPhone == null ? other$softDescriptorPhone != null : !this$softDescriptorPhone.equals(other$softDescriptorPhone)) {
            return false;
        }
        PaymentMethod this$paymentMethod = this.getPaymentMethod();
        PaymentMethod other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !((Object)this$paymentMethod).equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethod this$paymentMethodSnapshot = this.getPaymentMethodSnapshot();
        PaymentMethod other$paymentMethodSnapshot = other.getPaymentMethodSnapshot();
        return !(this$paymentMethodSnapshot == null ? other$paymentMethodSnapshot != null : !((Object)this$paymentMethodSnapshot).equals(other$paymentMethodSnapshot));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Payment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExternal() ? 79 : 97);
        Double $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Double $amountApplied = this.getAmountApplied();
        result = result * 59 + ($amountApplied == null ? 43 : ((Object)$amountApplied).hashCode());
        Double $amountUnapplied = this.getAmountUnapplied();
        result = result * 59 + ($amountUnapplied == null ? 43 : ((Object)$amountUnapplied).hashCode());
        Double $amountRefunded = this.getAmountRefunded();
        result = result * 59 + ($amountRefunded == null ? 43 : ((Object)$amountRefunded).hashCode());
        Map<String, Object> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $authorisationCode = this.getAuthorisationCode();
        result = result * 59 + ($authorisationCode == null ? 43 : $authorisationCode.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        ZonedDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        PaymentStatus $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        ZonedDateTime $cancelTime = this.getCancelTime();
        result = result * 59 + ($cancelTime == null ? 43 : ((Object)$cancelTime).hashCode());
        ZonedDateTime $submitTime = this.getSubmitTime();
        result = result * 59 + ($submitTime == null ? 43 : ((Object)$submitTime).hashCode());
        String $secondPaymentReferenceId = this.getSecondPaymentReferenceId();
        result = result * 59 + ($secondPaymentReferenceId == null ? 43 : $secondPaymentReferenceId.hashCode());
        String $payoutId = this.getPayoutId();
        result = result * 59 + ($payoutId == null ? 43 : $payoutId.hashCode());
        PaymentGatewayState $gatewayState = this.getGatewayState();
        result = result * 59 + ($gatewayState == null ? 43 : $gatewayState.hashCode());
        ZonedDateTime $markedForSubmissionOn = this.getMarkedForSubmissionOn();
        result = result * 59 + ($markedForSubmissionOn == null ? 43 : ((Object)$markedForSubmissionOn).hashCode());
        Map<String, String> $gatewayOptions = this.getGatewayOptions();
        result = result * 59 + ($gatewayOptions == null ? 43 : ((Object)$gatewayOptions).hashCode());
        String $gatewayResponseCode = this.getGatewayResponseCode();
        result = result * 59 + ($gatewayResponseCode == null ? 43 : $gatewayResponseCode.hashCode());
        String $gatewayResponse = this.getGatewayResponse();
        result = result * 59 + ($gatewayResponse == null ? 43 : $gatewayResponse.hashCode());
        String $gatewayReconciliationStatus = this.getGatewayReconciliationStatus();
        result = result * 59 + ($gatewayReconciliationStatus == null ? 43 : $gatewayReconciliationStatus.hashCode());
        String $gatewayReconciliationReason = this.getGatewayReconciliationReason();
        result = result * 59 + ($gatewayReconciliationReason == null ? 43 : $gatewayReconciliationReason.hashCode());
        PaymentFinanceInformation $financeInformation = this.getFinanceInformation();
        result = result * 59 + ($financeInformation == null ? 43 : ((Object)$financeInformation).hashCode());
        String $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        String $gatewayOrderId = this.getGatewayOrderId();
        result = result * 59 + ($gatewayOrderId == null ? 43 : $gatewayOrderId.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $softDescriptorPhone = this.getSoftDescriptorPhone();
        result = result * 59 + ($softDescriptorPhone == null ? 43 : $softDescriptorPhone.hashCode());
        PaymentMethod $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : ((Object)$paymentMethod).hashCode());
        PaymentMethod $paymentMethodSnapshot = this.getPaymentMethodSnapshot();
        result = result * 59 + ($paymentMethodSnapshot == null ? 43 : ((Object)$paymentMethodSnapshot).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Payment(customFields=" + this.getCustomFields() + ", id=" + this.getId() + ", account=" + this.getAccount() + ", amount=" + this.getAmount() + ", amountApplied=" + this.getAmountApplied() + ", amountUnapplied=" + this.getAmountUnapplied() + ", authorisationCode=" + this.getAuthorisationCode() + ", description=" + this.getDescription() + ", currency=" + this.getCurrency() + ", date=" + this.getDate() + ", name=" + this.getName() + ", createdBy=" + this.getCreatedBy() + ", updatedBy=" + this.getUpdatedBy() + ", updateTime=" + this.getUpdateTime() + ", createTime=" + this.getCreateTime() + ", state=" + this.getState() + ", amountRefunded=" + this.getAmountRefunded() + ", cancelTime=" + this.getCancelTime() + ", submitTime=" + this.getSubmitTime() + ", secondPaymentReferenceId=" + this.getSecondPaymentReferenceId() + ", payoutId=" + this.getPayoutId() + ", gatewayState=" + this.getGatewayState() + ", markedForSubmissionOn=" + this.getMarkedForSubmissionOn() + ", gatewayOptions=" + this.getGatewayOptions() + ", gatewayResponseCode=" + this.getGatewayResponseCode() + ", gatewayResponse=" + this.getGatewayResponse() + ", gatewayReconciliationStatus=" + this.getGatewayReconciliationStatus() + ", gatewayReconciliationReason=" + this.getGatewayReconciliationReason() + ", financeInformation=" + this.getFinanceInformation() + ", gateway=" + this.getGateway() + ", gatewayOrderId=" + this.getGatewayOrderId() + ", reference=" + this.getReference() + ", statementDescriptor=" + this.getStatementDescriptor() + ", softDescriptorPhone=" + this.getSoftDescriptorPhone() + ", external=" + this.isExternal() + ", paymentMethod=" + this.getPaymentMethod() + ", paymentMethodSnapshot=" + this.getPaymentMethodSnapshot() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class PaymentBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean customFields$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, Object> customFields$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String account;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double amount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double amountApplied;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double amountUnapplied;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String authorisationCode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String currency;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate date;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String createdBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String updatedBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime updateTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime createTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PaymentStatus state;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double amountRefunded;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime cancelTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime submitTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String secondPaymentReferenceId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String payoutId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PaymentGatewayState gatewayState;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime markedForSubmissionOn;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, String> gatewayOptions;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String gatewayResponseCode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String gatewayResponse;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String gatewayReconciliationStatus;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String gatewayReconciliationReason;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PaymentFinanceInformation financeInformation;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String gateway;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String gatewayOrderId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String reference;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String statementDescriptor;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String softDescriptorPhone;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean external;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PaymentMethod paymentMethod;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PaymentMethod paymentMethodSnapshot;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        PaymentBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder customFields(Map<String, Object> customFields) {
            this.customFields$value = customFields;
            this.customFields$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder account(String account2) {
            this.account = account2;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder amount(@NonNull Double amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder amountApplied(Double amountApplied) {
            this.amountApplied = amountApplied;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder amountUnapplied(Double amountUnapplied) {
            this.amountUnapplied = amountUnapplied;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder authorisationCode(String authorisationCode) {
            this.authorisationCode = authorisationCode;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder currency(@NonNull String currency) {
            if (currency == null) {
                throw new NullPointerException("currency is marked non-null but is null");
            }
            this.currency = currency;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder date(LocalDate date) {
            this.date = date;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder updateTime(ZonedDateTime updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder createTime(ZonedDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder state(PaymentStatus state) {
            this.state = state;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder amountRefunded(Double amountRefunded) {
            this.amountRefunded = amountRefunded;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder cancelTime(ZonedDateTime cancelTime) {
            this.cancelTime = cancelTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder submitTime(ZonedDateTime submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder secondPaymentReferenceId(String secondPaymentReferenceId) {
            this.secondPaymentReferenceId = secondPaymentReferenceId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder payoutId(String payoutId) {
            this.payoutId = payoutId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder gatewayState(PaymentGatewayState gatewayState) {
            this.gatewayState = gatewayState;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder markedForSubmissionOn(ZonedDateTime markedForSubmissionOn) {
            this.markedForSubmissionOn = markedForSubmissionOn;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder gatewayOptions(Map<String, String> gatewayOptions) {
            this.gatewayOptions = gatewayOptions;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder gatewayResponseCode(String gatewayResponseCode) {
            this.gatewayResponseCode = gatewayResponseCode;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder gatewayResponse(String gatewayResponse) {
            this.gatewayResponse = gatewayResponse;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder gatewayReconciliationStatus(String gatewayReconciliationStatus) {
            this.gatewayReconciliationStatus = gatewayReconciliationStatus;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder gatewayReconciliationReason(String gatewayReconciliationReason) {
            this.gatewayReconciliationReason = gatewayReconciliationReason;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder financeInformation(PaymentFinanceInformation financeInformation) {
            this.financeInformation = financeInformation;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder gatewayOrderId(String gatewayOrderId) {
            this.gatewayOrderId = gatewayOrderId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder statementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder softDescriptorPhone(String softDescriptorPhone) {
            this.softDescriptorPhone = softDescriptorPhone;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder external(@NonNull boolean external) {
            this.external = external;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder paymentMethod(PaymentMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentBuilder paymentMethodSnapshot(PaymentMethod paymentMethodSnapshot2) {
            this.paymentMethodSnapshot = paymentMethodSnapshot2;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Payment build() {
            Map customFields$value = this.customFields$value;
            if (!this.customFields$set) {
                customFields$value = Payment.$default$customFields();
            }
            return new Payment(customFields$value, this.id, this.account, this.amount, this.amountApplied, this.amountUnapplied, this.authorisationCode, this.description, this.currency, this.date, this.name, this.createdBy, this.updatedBy, this.updateTime, this.createTime, this.state, this.amountRefunded, this.cancelTime, this.submitTime, this.secondPaymentReferenceId, this.payoutId, this.gatewayState, this.markedForSubmissionOn, this.gatewayOptions, this.gatewayResponseCode, this.gatewayResponse, this.gatewayReconciliationStatus, this.gatewayReconciliationReason, this.financeInformation, this.gateway, this.gatewayOrderId, this.reference, this.statementDescriptor, this.softDescriptorPhone, this.external, this.paymentMethod, this.paymentMethodSnapshot);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Payment.PaymentBuilder(customFields$value=" + this.customFields$value + ", id=" + this.id + ", account=" + this.account + ", amount=" + this.amount + ", amountApplied=" + this.amountApplied + ", amountUnapplied=" + this.amountUnapplied + ", authorisationCode=" + this.authorisationCode + ", description=" + this.description + ", currency=" + this.currency + ", date=" + this.date + ", name=" + this.name + ", createdBy=" + this.createdBy + ", updatedBy=" + this.updatedBy + ", updateTime=" + this.updateTime + ", createTime=" + this.createTime + ", state=" + this.state + ", amountRefunded=" + this.amountRefunded + ", cancelTime=" + this.cancelTime + ", submitTime=" + this.submitTime + ", secondPaymentReferenceId=" + this.secondPaymentReferenceId + ", payoutId=" + this.payoutId + ", gatewayState=" + this.gatewayState + ", markedForSubmissionOn=" + this.markedForSubmissionOn + ", gatewayOptions=" + this.gatewayOptions + ", gatewayResponseCode=" + this.gatewayResponseCode + ", gatewayResponse=" + this.gatewayResponse + ", gatewayReconciliationStatus=" + this.gatewayReconciliationStatus + ", gatewayReconciliationReason=" + this.gatewayReconciliationReason + ", financeInformation=" + this.financeInformation + ", gateway=" + this.gateway + ", gatewayOrderId=" + this.gatewayOrderId + ", reference=" + this.reference + ", statementDescriptor=" + this.statementDescriptor + ", softDescriptorPhone=" + this.softDescriptorPhone + ", external=" + this.external + ", paymentMethod=" + this.paymentMethod + ", paymentMethodSnapshot=" + this.paymentMethodSnapshot + ")";
        }
    }

    public static class PaymentFinanceInformation {
        private TransferredToAccounting transferredToAccounting;
        private String unappliedPaymentAccountingCode;
        private String bankAccountAccountingCode;
        private AccountingCodeType bankAccountAccountingCodeType;
        private AccountingCodeType unappliedPaymentAccountingCodeType;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        PaymentFinanceInformation(TransferredToAccounting transferredToAccounting, String unappliedPaymentAccountingCode, String bankAccountAccountingCode, AccountingCodeType bankAccountAccountingCodeType, AccountingCodeType unappliedPaymentAccountingCodeType) {
            this.transferredToAccounting = transferredToAccounting;
            this.unappliedPaymentAccountingCode = unappliedPaymentAccountingCode;
            this.bankAccountAccountingCode = bankAccountAccountingCode;
            this.bankAccountAccountingCodeType = bankAccountAccountingCodeType;
            this.unappliedPaymentAccountingCodeType = unappliedPaymentAccountingCodeType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static PaymentFinanceInformationBuilder builder() {
            return new PaymentFinanceInformationBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PaymentFinanceInformationBuilder toBuilder() {
            return new PaymentFinanceInformationBuilder().transferredToAccounting(this.transferredToAccounting).unappliedPaymentAccountingCode(this.unappliedPaymentAccountingCode).bankAccountAccountingCode(this.bankAccountAccountingCode).bankAccountAccountingCodeType(this.bankAccountAccountingCodeType).unappliedPaymentAccountingCodeType(this.unappliedPaymentAccountingCodeType);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TransferredToAccounting getTransferredToAccounting() {
            return this.transferredToAccounting;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getUnappliedPaymentAccountingCode() {
            return this.unappliedPaymentAccountingCode;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getBankAccountAccountingCode() {
            return this.bankAccountAccountingCode;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AccountingCodeType getBankAccountAccountingCodeType() {
            return this.bankAccountAccountingCodeType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AccountingCodeType getUnappliedPaymentAccountingCodeType() {
            return this.unappliedPaymentAccountingCodeType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setTransferredToAccounting(TransferredToAccounting transferredToAccounting) {
            this.transferredToAccounting = transferredToAccounting;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setUnappliedPaymentAccountingCode(String unappliedPaymentAccountingCode) {
            this.unappliedPaymentAccountingCode = unappliedPaymentAccountingCode;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setBankAccountAccountingCode(String bankAccountAccountingCode) {
            this.bankAccountAccountingCode = bankAccountAccountingCode;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setBankAccountAccountingCodeType(AccountingCodeType bankAccountAccountingCodeType) {
            this.bankAccountAccountingCodeType = bankAccountAccountingCodeType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setUnappliedPaymentAccountingCodeType(AccountingCodeType unappliedPaymentAccountingCodeType) {
            this.unappliedPaymentAccountingCodeType = unappliedPaymentAccountingCodeType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentFinanceInformation)) {
                return false;
            }
            PaymentFinanceInformation other = (PaymentFinanceInformation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TransferredToAccounting this$transferredToAccounting = this.getTransferredToAccounting();
            TransferredToAccounting other$transferredToAccounting = other.getTransferredToAccounting();
            if (this$transferredToAccounting == null ? other$transferredToAccounting != null : !this$transferredToAccounting.equals(other$transferredToAccounting)) {
                return false;
            }
            String this$unappliedPaymentAccountingCode = this.getUnappliedPaymentAccountingCode();
            String other$unappliedPaymentAccountingCode = other.getUnappliedPaymentAccountingCode();
            if (this$unappliedPaymentAccountingCode == null ? other$unappliedPaymentAccountingCode != null : !this$unappliedPaymentAccountingCode.equals(other$unappliedPaymentAccountingCode)) {
                return false;
            }
            String this$bankAccountAccountingCode = this.getBankAccountAccountingCode();
            String other$bankAccountAccountingCode = other.getBankAccountAccountingCode();
            if (this$bankAccountAccountingCode == null ? other$bankAccountAccountingCode != null : !this$bankAccountAccountingCode.equals(other$bankAccountAccountingCode)) {
                return false;
            }
            AccountingCodeType this$bankAccountAccountingCodeType = this.getBankAccountAccountingCodeType();
            AccountingCodeType other$bankAccountAccountingCodeType = other.getBankAccountAccountingCodeType();
            if (this$bankAccountAccountingCodeType == null ? other$bankAccountAccountingCodeType != null : !this$bankAccountAccountingCodeType.equals(other$bankAccountAccountingCodeType)) {
                return false;
            }
            AccountingCodeType this$unappliedPaymentAccountingCodeType = this.getUnappliedPaymentAccountingCodeType();
            AccountingCodeType other$unappliedPaymentAccountingCodeType = other.getUnappliedPaymentAccountingCodeType();
            return !(this$unappliedPaymentAccountingCodeType == null ? other$unappliedPaymentAccountingCodeType != null : !this$unappliedPaymentAccountingCodeType.equals(other$unappliedPaymentAccountingCodeType));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentFinanceInformation;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TransferredToAccounting $transferredToAccounting = this.getTransferredToAccounting();
            result = result * 59 + ($transferredToAccounting == null ? 43 : $transferredToAccounting.hashCode());
            String $unappliedPaymentAccountingCode = this.getUnappliedPaymentAccountingCode();
            result = result * 59 + ($unappliedPaymentAccountingCode == null ? 43 : $unappliedPaymentAccountingCode.hashCode());
            String $bankAccountAccountingCode = this.getBankAccountAccountingCode();
            result = result * 59 + ($bankAccountAccountingCode == null ? 43 : $bankAccountAccountingCode.hashCode());
            AccountingCodeType $bankAccountAccountingCodeType = this.getBankAccountAccountingCodeType();
            result = result * 59 + ($bankAccountAccountingCodeType == null ? 43 : $bankAccountAccountingCodeType.hashCode());
            AccountingCodeType $unappliedPaymentAccountingCodeType = this.getUnappliedPaymentAccountingCodeType();
            result = result * 59 + ($unappliedPaymentAccountingCodeType == null ? 43 : $unappliedPaymentAccountingCodeType.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Payment.PaymentFinanceInformation(transferredToAccounting=" + this.getTransferredToAccounting() + ", unappliedPaymentAccountingCode=" + this.getUnappliedPaymentAccountingCode() + ", bankAccountAccountingCode=" + this.getBankAccountAccountingCode() + ", bankAccountAccountingCodeType=" + this.getBankAccountAccountingCodeType() + ", unappliedPaymentAccountingCodeType=" + this.getUnappliedPaymentAccountingCodeType() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static class PaymentFinanceInformationBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private TransferredToAccounting transferredToAccounting;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String unappliedPaymentAccountingCode;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String bankAccountAccountingCode;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private AccountingCodeType bankAccountAccountingCodeType;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private AccountingCodeType unappliedPaymentAccountingCodeType;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            PaymentFinanceInformationBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public PaymentFinanceInformationBuilder transferredToAccounting(TransferredToAccounting transferredToAccounting) {
                this.transferredToAccounting = transferredToAccounting;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public PaymentFinanceInformationBuilder unappliedPaymentAccountingCode(String unappliedPaymentAccountingCode) {
                this.unappliedPaymentAccountingCode = unappliedPaymentAccountingCode;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public PaymentFinanceInformationBuilder bankAccountAccountingCode(String bankAccountAccountingCode) {
                this.bankAccountAccountingCode = bankAccountAccountingCode;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public PaymentFinanceInformationBuilder bankAccountAccountingCodeType(AccountingCodeType bankAccountAccountingCodeType) {
                this.bankAccountAccountingCodeType = bankAccountAccountingCodeType;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public PaymentFinanceInformationBuilder unappliedPaymentAccountingCodeType(AccountingCodeType unappliedPaymentAccountingCodeType) {
                this.unappliedPaymentAccountingCodeType = unappliedPaymentAccountingCodeType;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public PaymentFinanceInformation build() {
                return new PaymentFinanceInformation(this.transferredToAccounting, this.unappliedPaymentAccountingCode, this.bankAccountAccountingCode, this.bankAccountAccountingCodeType, this.unappliedPaymentAccountingCodeType);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "Payment.PaymentFinanceInformation.PaymentFinanceInformationBuilder(transferredToAccounting=" + this.transferredToAccounting + ", unappliedPaymentAccountingCode=" + this.unappliedPaymentAccountingCode + ", bankAccountAccountingCode=" + this.bankAccountAccountingCode + ", bankAccountAccountingCodeType=" + this.bankAccountAccountingCodeType + ", unappliedPaymentAccountingCodeType=" + this.unappliedPaymentAccountingCodeType + ")";
            }
        }
    }
}

