/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.enums;

import com.google.common.base.Strings;
import com.zuora.sdk.internal.exceptions.InvalidRequestException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public enum MitProfileAction {
    ACTIVATE("Activate"),
    PERSIST("Persist");

    private String apiValue;

    public static MitProfileAction fromApi(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        for (MitProfileAction v : MitProfileAction.values()) {
            if (!v.apiValue.equalsIgnoreCase(value)) continue;
            return v;
        }
        throw InvalidRequestException.builder().addViolation(InvalidRequestException.Reason.InvalidValue, "MitProfileAction", "invalid value " + value).build();
    }

    public com.zuora.sdk.internal.models.enums.MitProfileAction toApi() {
        switch (this) {
            case ACTIVATE: {
                return com.zuora.sdk.internal.models.enums.MitProfileAction.ACTIVATE;
            }
            case PERSIST: {
                return com.zuora.sdk.internal.models.enums.MitProfileAction.PERSIST;
            }
        }
        return null;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private MitProfileAction(String apiValue) {
        this.apiValue = apiValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getApiValue() {
        return this.apiValue;
    }

    public static class Constants {
        public static final String ACTIVATE = "Activate";
        public static final String PERSIST = "Persist";
    }
}

