/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.PlanMapper;
import com.zuora.sdk.Price;
import com.zuora.sdk.PriceMapper;
import com.zuora.sdk.Product;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.ApolloClientUtil;
import com.zuora.sdk.internal.HawkClient;
import com.zuora.sdk.internal.ProductRatePlanChargesQuery;
import com.zuora.sdk.internal.apis.ProductRatePlansAPI;
import com.zuora.sdk.internal.apis.data.ProxyGetProductRatePlan;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import com.zuora.sdk.internal.models.ZProductRatePlan;
import com.zuora.sdk.internal.type.ProductrateplanchargeFilterKey;
import java.util.List;
import okhttp3.OkHttpClient;
import org.mapstruct.factory.Mappers;

public class PlanAPI {
    private static final Integer BATCH_SIZE = 10;
    private final HawkClient hawkClient;
    private final ApolloClient gqlClient;
    private final ZuoraClient client;
    private APIContext context;
    private OkHttpClient okHttpClient = new OkHttpClient();
    private PriceMapper priceMapper = (PriceMapper)Mappers.getMapper(PriceMapper.class);
    private PlanMapper planMapper = (PlanMapper)Mappers.getMapper(PlanMapper.class);

    PlanAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.hawkClient = client.getHawkClient();
        this.gqlClient = this.hawkClient.getGqlClient();
    }

    public Plan get(String id) throws ZuoraSdkException {
        try {
            ProxyGetProductRatePlan proxyGetProductRatePlan = ProductRatePlansAPI.objectRetrieve((APIContext)this.context, (String)id);
            Plan plan = this.planMapper.fromApi(proxyGetProductRatePlan, this.client.today());
            Response response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductRatePlanChargesQuery(ProductrateplanchargeFilterKey.PRODUCTRATEPLANID, id))).join();
            if (response.getData() == null || ((ProductRatePlanChargesQuery.Data)response.getData()).getProductrateplancharges() == null) {
                return plan;
            }
            List<ProductRatePlanChargesQuery.Edge> ratePlanChargeEdges = ((ProductRatePlanChargesQuery.Data)response.getData()).getProductrateplancharges().getEdges();
            if (ratePlanChargeEdges == null) {
                return plan;
            }
            List<Price> planItems = plan.getItems();
            ratePlanChargeEdges.stream().filter(ratePlanCharge -> ratePlanCharge.getNode() != null).forEach(ratePlanCharge -> planItems.add(this.priceMapper.fromApi(ratePlanCharge.getNode()).setPlan(id).setId(ratePlanCharge.getNode().getId())));
            return plan;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).build();
        }
    }

    public List<Plan> getPlans(Product product) throws ZuoraSdkException {
        Product aProduct = this.client.products().findBySku(product.getSku());
        return aProduct.getPlans();
    }

    /*
     * WARNING - void declaration
     */
    public Plan create(PlanCreateRequest planCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        PlanCreateRequest planCreateRequest2 = planCreateRequest;
        try {
            void newPlanId;
            void plan;
            Object object2 = plan.planMapper.toApi(planCreateRequest2).build().create(plan.context);
            plan.client.customObjects().saveAssociations((BaseFacade)newPlanId, (String)object2);
            object = plan.get((String)object2);
            return object;
        }
        finally {
            planCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Plan update(Plan plan) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Plan plan2 = plan;
        try {
            void plan3;
            plan3.planMapper.toApi(plan2).build().update(plan3.context);
            object = plan3.get(plan2.getId());
            return object;
        }
        finally {
            plan2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void remove(Plan plan) throws ZuoraSdkException {
        Meter meter;
        String string;
        long l = System.currentTimeMillis();
        PlanAPI planAPI = this;
        Plan plan2 = plan;
        try {
            void plan3;
            ZProductRatePlan.delete((APIContext)plan3.context, (String)plan2.getId());
            planAPI = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        plan2 = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string2 = "com.zuora.sdk.PlanAPI".substring("com.zuora.sdk.PlanAPI".lastIndexOf(".") + 1);
        if (null != planAPI) {
            string = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{planAPI.getClass().getSimpleName(), string2, "remove"});
            meter = plan2.meter(string);
            meter.mark();
        } else {
            string = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string2, "remove"});
            meter = plan2.meter(string);
            meter.mark();
        }
        string = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string2, "remove"});
        meter = plan2.histogram(string);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (planAPI != null) {
            throw planAPI;
        }
    }
}

