/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.internal;

import com.google.gson.Gson;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MuranoClient {
    private final APIContext context;
    private final String baseUrl;
    private final OkHttpClient client = new OkHttpClient();

    public MuranoClient(APIContext context) {
        this.context = context;
        this.baseUrl = context.getEndpointBase() + "/objects/";
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Response makeRequest(String path, String method, RequestBody body) throws IOException {
        Request.Builder request = new Request.Builder().header("Authorization", "Bearer " + this.context.getBearer()).header("Accept", "application/json").url(this.baseUrl + path);
        if (method != null) {
            request.method(method, body);
        }
        return this.client.newCall(request.build()).execute();
    }

    private Map handleResponse(Response response, ZuoraSdkException.Builder exception) throws ZuoraSdkException {
        if (response.isSuccessful()) {
            return (Map)new Gson().fromJson(response.body().charStream(), HashMap.class);
        }
        throw exception.message(response.code() + " " + response.message()).build();
    }

    public Map createRecord(Map record, String entityName) throws ZuoraSdkException {
        Response response;
        ZuoraSdkException.Builder exception;
        block5: {
            exception = ZuoraSdkException.builder().operationName("createRecord");
            response = null;
            HashMap<String, Serializable> body = new HashMap<String, Serializable>();
            ArrayList<Map> records = new ArrayList<Map>();
            records.add(record);
            body.put("records", records);
            body.put("allowPartialSuccess", Boolean.valueOf(false));
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)new Gson().toJson(body));
            response = this.makeRequest("records/default/" + entityName, "POST", requestBody);
            Map responseBody = this.handleResponse(response, exception);
            List resRecords = (List)responseBody.get("records");
            if (resRecords.size() <= 0) break block5;
            Map map = (Map)resRecords.get(0);
            MuranoClient.closeQuietly((Closeable)response);
            return map;
        }
        try {
            try {
                throw exception.message("Failed to create record.").build();
            }
            catch (IOException e) {
                throw exception.message(e.getMessage()).build();
            }
        }
        catch (Throwable throwable) {
            MuranoClient.closeQuietly(response);
            throw throwable;
        }
    }

    public Map getRecordById(String recordId, String entityName) throws ZuoraSdkException {
        Map map;
        ZuoraSdkException.Builder exception = ZuoraSdkException.builder().operationName("getRecordById");
        Response response = null;
        try {
            response = this.makeRequest("records/default/" + entityName + "/" + recordId, null, null);
            map = this.handleResponse(response, exception);
        }
        catch (IOException e) {
            try {
                throw exception.message(e.getMessage()).build();
            }
            catch (Throwable throwable) {
                MuranoClient.closeQuietly(response);
                throw throwable;
            }
        }
        MuranoClient.closeQuietly((Closeable)response);
        return map;
    }

    public List<Map> queryRecords(String entityName, String queryString) throws ZuoraSdkException {
        List list;
        ZuoraSdkException.Builder exception = ZuoraSdkException.builder().operationName("filterRecords");
        Response response = null;
        try {
            List records;
            response = this.makeRequest("records/default/" + entityName + "?q=" + queryString, null, null);
            Map responseBody = this.handleResponse(response, exception);
            list = records = (List)responseBody.get("records");
        }
        catch (IOException e) {
            try {
                throw exception.message(e.getMessage()).build();
            }
            catch (Throwable throwable) {
                MuranoClient.closeQuietly(response);
                throw throwable;
            }
        }
        MuranoClient.closeQuietly((Closeable)response);
        return list;
    }

    public Map updateRecord(String recordId, Map record, String entityName) throws ZuoraSdkException {
        Map map;
        ZuoraSdkException.Builder exception = ZuoraSdkException.builder().operationName("updateRecord");
        Response response = null;
        record.remove("Id");
        record.remove("CreatedById");
        record.remove("UpdateById");
        record.remove("CreatedDate");
        record.remove("UpdatedDate");
        record.remove("type");
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/merge-patch+json; charset=utf-8"), (String)new Gson().toJson((Object)record));
        try {
            response = this.makeRequest("records/default/" + entityName + "/" + recordId, "PATCH", requestBody);
            map = this.handleResponse(response, exception);
        }
        catch (IOException e) {
            try {
                throw exception.message(e.getMessage()).build();
            }
            catch (Throwable throwable) {
                MuranoClient.closeQuietly(response);
                throw throwable;
            }
        }
        MuranoClient.closeQuietly((Closeable)response);
        return map;
    }

    public void deleteRecord(String recordId, String entityName) throws ZuoraSdkException {
        ZuoraSdkException.Builder exception = ZuoraSdkException.builder().operationName("deleteRecord");
        Response response = null;
        HashMap body = new HashMap();
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("type", "delete");
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(recordId);
        action.put("ids", ids);
        body.put("action", action);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)new Gson().toJson(body));
        try {
            response = this.makeRequest("batch/default/" + entityName, "POST", requestBody);
            Map responseBody = this.handleResponse(response, exception);
            if (responseBody != null) {
                throw exception.build();
            }
        }
        catch (IOException e) {
            try {
                throw exception.message(e.getMessage()).build();
            }
            catch (Throwable throwable) {
                MuranoClient.closeQuietly(response);
                throw throwable;
            }
        }
        MuranoClient.closeQuietly((Closeable)response);
    }
}

