/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.TierMapper;
import com.zuora.sdk.internal.apis.data.ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class AmountsMapper {
    AmountsMapper() {
    }

    private static List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> mapAmountMapToZPRCTier(Map<Currency, Double> amountMap, PriceEnum.ChargeModel chargeModel) {
        return amountMap.entrySet().stream().map(amount -> {
            ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier zTier = new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier();
            zTier.currency(((Currency)amount.getKey()).getCurrencyCode());
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE)) {
                zTier.discountPercentage((Double)amount.getValue());
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT)) {
                zTier.discountAmount((Double)amount.getValue());
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.PER_UNIT)) {
                zTier.priceFormat("Per Unit").price((Double)amount.getValue());
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.FLAT_FEE)) {
                zTier.price((Double)amount.getValue()).priceFormat("Flat Fee");
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.TIERED_WITH_OVERAGE) || chargeModel.equals((Object)PriceEnum.ChargeModel.OVERAGE)) {
                zTier.price((Double)amount.getValue()).isOveragePrice(Boolean.valueOf(true));
            }
            return zTier;
        }).collect(Collectors.toList());
    }

    List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> mapAmountsToZPRCTier(PriceCreateRequest price) {
        PriceEnum.ChargeModel chargeModel = price.getChargeModel();
        if (PriceEnum.ChargeModel.getTieredModels().contains((Object)chargeModel)) {
            List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> tiers = new TierMapper().fromTiers(price.getTiers());
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.TIERED_WITH_OVERAGE)) {
                tiers.addAll(AmountsMapper.mapAmountMapToZPRCTier(price.getUnitAmounts(), chargeModel));
            }
            return tiers;
        }
        if (chargeModel.equals((Object)PriceEnum.ChargeModel.FLAT_FEE) || chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT)) {
            return AmountsMapper.mapAmountMapToZPRCTier(price.getAmounts(), chargeModel);
        }
        if (chargeModel.equals((Object)PriceEnum.ChargeModel.PER_UNIT) || chargeModel.equals((Object)PriceEnum.ChargeModel.OVERAGE)) {
            return AmountsMapper.mapAmountMapToZPRCTier(price.getUnitAmounts(), chargeModel);
        }
        if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE)) {
            return Collections.singletonList(new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().discountPercentage(price.getPercentAmount()));
        }
        return null;
    }
}

