/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public class Tier {
    private final Integer tier;
    private final Double upTo;
    private Map<Currency, Double> amounts;
    private Map<Currency, Double> unitAmounts;
    private Double startingUnit;

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Tier(Integer tier, Double upTo, Map<Currency, Double> amounts, Map<Currency, Double> unitAmounts, Double startingUnit) {
        this.tier = tier;
        this.upTo = upTo;
        this.amounts = amounts;
        this.unitAmounts = unitAmounts;
        this.startingUnit = startingUnit;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static TierBuilder builder() {
        return new TierBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TierBuilder toBuilder() {
        TierBuilder builder = new TierBuilder().tier(this.tier).upTo(this.upTo).startingUnit(this.startingUnit);
        if (this.amounts != null) {
            builder.amounts(this.amounts);
        }
        if (this.unitAmounts != null) {
            builder.unitAmounts(this.unitAmounts);
        }
        return builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Tier(tier=" + this.getTier() + ", upTo=" + this.getUpTo() + ", amounts=" + this.getAmounts() + ", unitAmounts=" + this.getUnitAmounts() + ", startingUnit=" + this.getStartingUnit() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getTier() {
        return this.tier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getUpTo() {
        return this.upTo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Currency, Double> getAmounts() {
        return this.amounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Currency, Double> getUnitAmounts() {
        return this.unitAmounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getStartingUnit() {
        return this.startingUnit;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAmounts(Map<Currency, Double> amounts) {
        this.amounts = amounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUnitAmounts(Map<Currency, Double> unitAmounts) {
        this.unitAmounts = unitAmounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStartingUnit(Double startingUnit) {
        this.startingUnit = startingUnit;
    }

    public static class TierBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer tier;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double upTo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Currency> amounts$key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Double> amounts$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Currency> unitAmounts$key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Double> unitAmounts$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double startingUnit;

        public TierBuilder startingUnit(Double startingUnit) {
            this.startingUnit = startingUnit;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        TierBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TierBuilder tier(Integer tier) {
            this.tier = tier;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TierBuilder upTo(Double upTo) {
            this.upTo = upTo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TierBuilder amount(Currency amountKey, Double amountValue) {
            if (this.amounts$key == null) {
                this.amounts$key = new ArrayList();
                this.amounts$value = new ArrayList();
            }
            this.amounts$key.add(amountKey);
            this.amounts$value.add(amountValue);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TierBuilder amounts(Map<? extends Currency, ? extends Double> amounts) {
            if (amounts == null) {
                throw new NullPointerException("amounts cannot be null");
            }
            if (this.amounts$key == null) {
                this.amounts$key = new ArrayList();
                this.amounts$value = new ArrayList();
            }
            for (Map.Entry<? extends Currency, ? extends Double> $lombokEntry : amounts.entrySet()) {
                this.amounts$key.add($lombokEntry.getKey());
                this.amounts$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TierBuilder clearAmounts() {
            if (this.amounts$key != null) {
                this.amounts$key.clear();
                this.amounts$value.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TierBuilder unitAmount(Currency unitAmountKey, Double unitAmountValue) {
            if (this.unitAmounts$key == null) {
                this.unitAmounts$key = new ArrayList();
                this.unitAmounts$value = new ArrayList();
            }
            this.unitAmounts$key.add(unitAmountKey);
            this.unitAmounts$value.add(unitAmountValue);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TierBuilder unitAmounts(Map<? extends Currency, ? extends Double> unitAmounts) {
            if (unitAmounts == null) {
                throw new NullPointerException("unitAmounts cannot be null");
            }
            if (this.unitAmounts$key == null) {
                this.unitAmounts$key = new ArrayList();
                this.unitAmounts$value = new ArrayList();
            }
            for (Map.Entry<? extends Currency, ? extends Double> $lombokEntry : unitAmounts.entrySet()) {
                this.unitAmounts$key.add($lombokEntry.getKey());
                this.unitAmounts$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TierBuilder clearUnitAmounts() {
            if (this.unitAmounts$key != null) {
                this.unitAmounts$key.clear();
                this.unitAmounts$value.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Tier build() {
            Map<Currency, Double> unitAmounts;
            Map<Currency, Double> amounts;
            switch (this.amounts$key == null ? 0 : this.amounts$key.size()) {
                case 0: {
                    amounts = Collections.emptyMap();
                    break;
                }
                case 1: {
                    amounts = Collections.singletonMap(this.amounts$key.get(0), this.amounts$value.get(0));
                    break;
                }
                default: {
                    amounts = new LinkedHashMap(this.amounts$key.size() < 0x40000000 ? 1 + this.amounts$key.size() + (this.amounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.amounts$key.size(); ++$i) {
                        amounts.put(this.amounts$key.get($i), this.amounts$value.get($i));
                    }
                    amounts = Collections.unmodifiableMap(amounts);
                }
            }
            switch (this.unitAmounts$key == null ? 0 : this.unitAmounts$key.size()) {
                case 0: {
                    unitAmounts = Collections.emptyMap();
                    break;
                }
                case 1: {
                    unitAmounts = Collections.singletonMap(this.unitAmounts$key.get(0), this.unitAmounts$value.get(0));
                    break;
                }
                default: {
                    unitAmounts = new LinkedHashMap(this.unitAmounts$key.size() < 0x40000000 ? 1 + this.unitAmounts$key.size() + (this.unitAmounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.unitAmounts$key.size(); ++$i) {
                        unitAmounts.put(this.unitAmounts$key.get($i), this.unitAmounts$value.get($i));
                    }
                    unitAmounts = Collections.unmodifiableMap(unitAmounts);
                }
            }
            return new Tier(this.tier, this.upTo, amounts, unitAmounts, this.startingUnit);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Tier.TierBuilder(tier=" + this.tier + ", upTo=" + this.upTo + ", amounts$key=" + this.amounts$key + ", amounts$value=" + this.amounts$value + ", unitAmounts$key=" + this.unitAmounts$key + ", unitAmounts$value=" + this.unitAmounts$value + ", startingUnit=" + this.startingUnit + ")";
        }
    }
}

