/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.collect.Lists;
import com.zuora.sdk.ApiMapper;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.Price;
import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceMapper;
import com.zuora.sdk.Product;
import com.zuora.sdk.ProductCreateRequest;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.ApolloClientUtil;
import com.zuora.sdk.internal.HawkClient;
import com.zuora.sdk.internal.ProductBySkuQuery;
import com.zuora.sdk.internal.ProductRatePlanChargesQuery;
import com.zuora.sdk.internal.ProductsQuery;
import com.zuora.sdk.internal.apis.ProductRatePlansAPI;
import com.zuora.sdk.internal.apis.data.ProxyGetProductRatePlan;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import com.zuora.sdk.internal.models.ZProduct;
import com.zuora.sdk.internal.models.ZProductRatePlan;
import com.zuora.sdk.internal.type.ProductFilterKey;
import com.zuora.sdk.internal.type.ProductrateplanchargeFilterKey;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import okhttp3.OkHttpClient;
import org.mapstruct.factory.Mappers;

public class ProductAPI {
    private static final Integer BATCH_SIZE = 10;
    private final HawkClient hawkClient;
    private final ApolloClient gqlClient;
    private final ZuoraClient client;
    private APIContext context;
    private OkHttpClient okHttpClient = new OkHttpClient();
    private PriceMapper priceMapper = (PriceMapper)Mappers.getMapper(PriceMapper.class);

    ProductAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.hawkClient = client.getHawkClient();
        this.gqlClient = this.hawkClient.getGqlClient();
    }

    /*
     * WARNING - void declaration
     */
    public Product create(ProductCreateRequest productCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        ProductCreateRequest productCreateRequest2 = productCreateRequest;
        try {
            void zProduct;
            void product;
            ZProduct zProduct2 = ApiMapper.Mapper.toApi(productCreateRequest2).build();
            String string = zProduct2.create(product.context);
            product.client.customObjects().saveAssociations((BaseFacade)zProduct, string);
            zProduct.getPlans().forEach(productPlan -> {
                productPlan.setProduct(string);
                Plan plan = this.createPlan((PlanCreateRequest)productPlan);
                this.client.customObjects().saveAssociations((BaseFacade)productPlan, plan.getId());
                productPlan.getPrices().forEach(planItem -> {
                    planItem.setPlan(plan.getId());
                    this.client.prices().create((PriceCreateRequest)planItem);
                });
            });
            object = product.get(string);
            return object;
        }
        finally {
            productCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void delete(Product product) throws ZuoraSdkException {
        Meter meter;
        String string;
        long l = System.currentTimeMillis();
        ProductAPI productAPI = this;
        Product product2 = product;
        try {
            void product3;
            ZProduct.delete((APIContext)product3.context, (String)product2.getId());
            productAPI = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        product2 = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string2 = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != productAPI) {
            string = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{productAPI.getClass().getSimpleName(), string2, "delete"});
            meter = product2.meter(string);
            meter.mark();
        } else {
            string = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string2, "delete"});
            meter = product2.meter(string);
            meter.mark();
        }
        string = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string2, "delete"});
        meter = product2.histogram(string);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (productAPI != null) {
            throw productAPI;
        }
    }

    public Product get(String productId) throws ZuoraSdkException {
        try {
            CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductBySkuQuery(ProductFilterKey.ID, productId)));
            if (response.get().getData() == null || ((ProductBySkuQuery.Data)response.get().getData()).getProducts().getEdges().isEmpty()) {
                return null;
            }
            Product product = this.mapNestedProduct(((ProductBySkuQuery.Data)response.get().getData()).getProducts().getEdges().get(0).getNode());
            ZProduct zProduct = ZProduct.get((APIContext)this.context, (String)productId);
            product = product.toBuilder().customFields(zProduct.productObjectCustomFields()).build();
            return product;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).message(e.getMessage()).build();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Stream<Product> stream() throws ZuoraSdkException {
        Meter meter;
        Stream<Product> stream;
        Object object;
        String string;
        Object object2;
        LinkedBlockingQueue linkedBlockingQueue;
        long l = System.currentTimeMillis();
        Object object3 = this;
        try {
            try {
                void response;
                void queue;
                linkedBlockingQueue = new LinkedBlockingQueue(1000);
                object2 = ApolloClientUtil.toCompletableFuture(queue.gqlClient.query((Query)new ProductsQuery()));
                string = (Response)((CompletableFuture)object2).join();
                object = CompletableFuture.runAsync(() -> ((ProductAPI)queue).lambda$stream$4((Response)string, (BlockingQueue)response));
                stream = StreamSupport.stream(new Spliterators.AbstractSpliterator<Product>(Long.MAX_VALUE, 16, (BlockingQueue)response){
                    final /* synthetic */ BlockingQueue val$queue;
                    {
                        this.val$queue = blockingQueue;
                        super(x0, x1);
                    }

                    @Override
                    public boolean tryAdvance(Consumer<? super Product> action) {
                        try {
                            if (object.isDone()) {
                                return false;
                            }
                            Product value = (Product)this.val$queue.poll(5000L, TimeUnit.MILLISECONDS);
                            if (value != null) {
                                action.accept(value);
                                return true;
                            }
                            if (object.isDone()) {
                                return !object.isDone();
                            }
                            throw ZuoraSdkException.builder().message("Query time out.").build();
                        }
                        catch (InterruptedException e) {
                            throw ZuoraSdkException.builder().cause((Throwable)e).message("Internal error occur.").build();
                        }
                    }
                }, false);
            }
            catch (Exception exception) {
                throw ZuoraSdkException.builder().cause((Throwable)exception).message(exception.getMessage()).build();
            }
        }
        catch (Throwable throwable) {
            object3 = null;
        }
        object3 = stream;
        linkedBlockingQueue = null;
        object2 = SharedMetricRegistries.getOrCreate((String)"zuora");
        string = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != linkedBlockingQueue) {
            object = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{linkedBlockingQueue.getClass().getSimpleName(), string, "stream"});
            meter = object2.meter((String)object);
            meter.mark();
        } else {
            object = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string, "stream"});
            meter = object2.meter((String)object);
            meter.mark();
        }
        object = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string, "stream"});
        meter = object2.histogram((String)object);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (linkedBlockingQueue != null) {
            throw linkedBlockingQueue;
        }
        return object3;
    }

    private Product mapNestedProduct(ProductBySkuQuery.Node productResp) {
        LocalDate now = LocalDate.now(this.context.getEntityProfileInfo().tenantZoneId());
        LocalDate startDate = LocalDate.parse(productResp.getEffectiveStartDate());
        LocalDate endDate = LocalDate.parse(productResp.getEffectiveEndDate());
        ZonedDateTime createTime = ZonedDateTime.parse(productResp.getCreatedDate());
        ZonedDateTime updateTime = ZonedDateTime.parse(productResp.getUpdatedDate());
        boolean active = !(!now.isEqual(startDate) && !now.isAfter(startDate) || !now.isEqual(endDate) && !now.isBefore(endDate));
        Product product = Product.builder().id(productResp.getId()).name(productResp.getName()).sku(productResp.getSKU()).startDate(startDate).endDate(endDate).description(productResp.getDescription()).createdBy(productResp.getCreatedById()).createTime(createTime).updatedBy(productResp.getUpdatedById()).updateTime(updateTime).active(active).build();
        if (productResp.getProductrateplans() != null) {
            product.toBuilder().plans(productResp.getProductrateplans().getEdges().stream().map(ratePlan -> {
                Plan plan = this.getPlan(ratePlan.getNode().getId());
                product.addPlan(plan);
                return plan;
            }).collect(Collectors.toList()));
        }
        return product;
    }

    /*
     * WARNING - void declaration
     */
    public Product findBySku(String string) throws ZuoraSdkException {
        Meter meter;
        String string2;
        Product product;
        Object object;
        long l = System.currentTimeMillis();
        ProductAPI productAPI = this;
        String string3 = string;
        try {
            try {
                void sku;
                object = ApolloClientUtil.toCompletableFuture(sku.gqlClient.query((Query)new ProductBySkuQuery(ProductFilterKey.SKU, string3)));
                product = ((Response)((CompletableFuture)object).get()).getData() == null || ((ProductBySkuQuery.Data)((Response)((CompletableFuture)object).get()).getData()).getProducts().getEdges().isEmpty() ? null : super.mapNestedProduct(((ProductBySkuQuery.Data)((Response)((CompletableFuture)object).get()).getData()).getProducts().getEdges().get(0).getNode());
            }
            catch (Exception exception) {
                throw ZuoraSdkException.builder().cause(exception.getCause()).message(exception.toString()).build();
            }
        }
        catch (Throwable throwable) {
            productAPI = null;
        }
        productAPI = product;
        string3 = null;
        object = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string4 = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != string3) {
            string2 = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{string3.getClass().getSimpleName(), string4, "findBySku"});
            meter = object.meter(string2);
            meter.mark();
        } else {
            string2 = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string4, "findBySku"});
            meter = object.meter(string2);
            meter.mark();
        }
        string2 = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string4, "findBySku"});
        meter = object.histogram(string2);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (string3 != null) {
            throw string3;
        }
        return productAPI;
    }

    public Plan getPlan(String id) throws ZuoraSdkException {
        try {
            ProxyGetProductRatePlan proxyGetProductRatePlan = ProductRatePlansAPI.objectRetrieve((APIContext)this.context, (String)id);
            LocalDate today = this.client.today();
            LocalDate planStartDate = LocalDate.parse(proxyGetProductRatePlan.effectiveStartDate());
            LocalDate planEndDate = LocalDate.parse(proxyGetProductRatePlan.effectiveEndDate());
            ZonedDateTime createTime = ZonedDateTime.parse(proxyGetProductRatePlan.createdDate());
            ZonedDateTime updateTime = ZonedDateTime.parse(proxyGetProductRatePlan.updatedDate());
            boolean planActive = today.isEqual(planStartDate) || today.isAfter(planStartDate) && (today.isEqual(planEndDate) || today.isBefore(planEndDate));
            Plan plan = Plan.builder().id(proxyGetProductRatePlan.id()).active(planActive).name(proxyGetProductRatePlan.name()).updatedBy(proxyGetProductRatePlan.updatedById()).updateTime(updateTime).createdBy(proxyGetProductRatePlan.createdById()).createTime(createTime).startDate(planStartDate).endDate(planEndDate).activeCurrencies(proxyGetProductRatePlan.activeCurrencies()).customFields(proxyGetProductRatePlan.productRatePlanObjectCustomFields()).description(proxyGetProductRatePlan.description()).build();
            Response response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductRatePlanChargesQuery(ProductrateplanchargeFilterKey.PRODUCTRATEPLANID, id))).join();
            if (response.getData() != null && ((ProductRatePlanChargesQuery.Data)response.getData()).getProductrateplancharges() != null) {
                List<ProductRatePlanChargesQuery.Edge> ratePlanChargeEdges = ((ProductRatePlanChargesQuery.Data)response.getData()).getProductrateplancharges().getEdges();
                List<Price> planItems = plan.getItems();
                if (ratePlanChargeEdges != null) {
                    ratePlanChargeEdges.stream().filter(ratePlanCharge -> ratePlanCharge.getNode() != null).forEach(ratePlanCharge -> planItems.add(this.priceMapper.fromApi(ratePlanCharge.getNode()).setPlan(id).setId(ratePlanCharge.getNode().getId())));
                }
            }
            return plan;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).build();
        }
    }

    public List<Plan> getPlans(Product product) throws ZuoraSdkException {
        Product aProduct = this.findBySku(product.getSku());
        return aProduct.getPlans();
    }

    /*
     * WARNING - void declaration
     */
    public Plan createPlan(PlanCreateRequest planCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        PlanCreateRequest planCreateRequest2 = planCreateRequest;
        try {
            void plan;
            Object object2 = ApiMapper.Mapper.toApi(planCreateRequest2).build().create(plan.context);
            object = plan.getPlan((String)object2);
            return object;
        }
        finally {
            planCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Plan updatePlan(Plan plan) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Plan plan2 = plan;
        try {
            void plan3;
            ApiMapper.Mapper.toApi(plan2).build().update(plan3.context);
            object = plan2;
            return object;
        }
        finally {
            plan2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Plan removePlan(Plan plan) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Plan plan2 = plan;
        try {
            void plan3;
            ApiMapper.Mapper.toApi(plan2).build();
            ZProductRatePlan.delete((APIContext)plan3.context, (String)plan2.getId());
            object = plan2;
            return object;
        }
        finally {
            plan2 = null;
        }
    }

    private /* synthetic */ void lambda$stream$4(Response result, BlockingQueue queue) {
        if (result.getData() != null && !((ProductsQuery.Data)result.getData()).getProducts().getEdges().isEmpty()) {
            for (List edges2 : Lists.partition(Arrays.asList(((ProductsQuery.Data)result.getData()).getProducts().getEdges().toArray()), (int)BATCH_SIZE)) {
                ArrayList futures = new ArrayList();
                edges2.forEach(edge -> {
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        try {
                            queue.put(this.get(((ProductsQuery.Edge)edge).getNode().getId()));
                        }
                        catch (InterruptedException e) {
                            throw ZuoraSdkException.builder().cause((Throwable)e).message("Internal error occur.").build();
                        }
                    });
                    futures.add(future);
                });
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            }
        }
    }
}

