/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.OverageType;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.enums.ApplyDiscountTo;
import com.zuora.sdk.enums.RatingGroup;
import com.zuora.sdk.internal.models.enums.ApplyType;
import com.zuora.sdk.internal.models.enums.BillCycleType;
import com.zuora.sdk.internal.models.enums.BillingPeriodAlignment;
import com.zuora.sdk.internal.models.enums.BillingPeriodType;
import com.zuora.sdk.internal.models.enums.BillingTiming;
import com.zuora.sdk.internal.models.enums.ChargeModel;
import com.zuora.sdk.internal.models.enums.ChargeType;
import com.zuora.sdk.internal.models.enums.DiscountLevel;
import com.zuora.sdk.internal.models.enums.ListPriceBase;
import com.zuora.sdk.internal.models.enums.OverageCalculationOption;
import com.zuora.sdk.internal.models.enums.OverageUnusedUnitsCreditOption;
import com.zuora.sdk.internal.models.enums.TaxMode;
import com.zuora.sdk.internal.models.enums.TriggerEvent;
import com.zuora.sdk.internal.models.enums.UpToPeriodsType;
import com.zuora.sdk.internal.models.enums.WeeklyBillCycleDay;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.mapstruct.EnumMapping;
import org.mapstruct.InheritInverseConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.ValueMapping;
import org.mapstruct.ValueMappings;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
abstract class EnumMapper {
    EnumMapper() {
    }

    @ValueMappings(value={@ValueMapping(source="HIGH_WATERMARK_VOLUME", target="HIGH_WATERMARK_VOLUME_PRICING"), @ValueMapping(source="HIGH_WATERMARK_TIERED", target="HIGHWATERMARKTIEREDPRICING")})
    abstract ChargeModel map(PriceEnum.ChargeModel var1);

    @ValueMappings(value={@ValueMapping(source="DAY", target="DAYS"), @ValueMapping(source="WEEK", target="WEEKS"), @ValueMapping(source="MONTH", target="MONTHS"), @ValueMapping(source="YEAR", target="YEARS"), @ValueMapping(source="<NULL>", target="BILLING_PERIODS")})
    abstract UpToPeriodsType map(PriceEnum.DurationInterval var1);

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(source="Days", target="DAY"), @ValueMapping(source="Weeks", target="WEEK"), @ValueMapping(source="Months", target="MONTH"), @ValueMapping(source="Years", target="YEAR"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.DurationInterval map(String var1);

    @ValueMappings(value={@ValueMapping(source="SUBSCRIPTION_START", target="ALIGN_TO_SUBSCRIPTION_START"), @ValueMapping(source="TERM_START", target="ALIGN_TO_TERM_START"), @ValueMapping(source="SUBSCRIPTION_PLAN_ITEM", target="ALIGN_TO_CHARGE")})
    abstract BillingPeriodAlignment map(PriceEnum.Alignment var1);

    @ValueMappings(value={@ValueMapping(source="AlignToSubscriptionStart", target="SUBSCRIPTION_START"), @ValueMapping(source="AlignToTermStart", target="TERM_START"), @ValueMapping(source="AlignToCharge", target="SUBSCRIPTION_PLAN_ITEM"), @ValueMapping(source="<ANY_REMAINING>", target="SUBSCRIPTION_PLAN_ITEM")})
    abstract PriceEnum.Alignment mapAlignment(String var1);

    @ValueMappings(value={@ValueMapping(source="YEAR", target="ANNUAL"), @ValueMapping(source="SPECIFIC_MONTH", target="SPECIFIC_MONTHS"), @ValueMapping(source="SPECIFIC_WEEK", target="SPECIFIC_WEEKS")})
    abstract BillingPeriodType map(PriceEnum.Interval var1);

    @ValueMappings(value={@ValueMapping(source="PLAN", target="RATE_PLAN"), @ValueMapping(source="ACCOUNT", target="ACCOUNT"), @ValueMapping(source="SUBSCRIPTION", target="SUBSCRIPTION")})
    abstract DiscountLevel map(PriceEnum.DiscountLevel var1);

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(source="rateplan", target="PLAN"), @ValueMapping(source="subscription", target="SUBSCRIPTION"), @ValueMapping(source="account", target="ACCOUNT"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.DiscountLevel fromDiscountLevel(String var1);

    @InheritInverseConfiguration
    abstract PriceEnum.DiscountLevel map(DiscountLevel var1);

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(target="MONTH", source="Month"), @ValueMapping(target="QUARTER", source="Quarter"), @ValueMapping(target="YEAR", source="Annual"), @ValueMapping(target="MONTH", source="Semi-Annual"), @ValueMapping(target="SPECIFIC_MONTH", source="Specific Months"), @ValueMapping(target="SUBSCRIPTION_TERM", source="Subscription Term"), @ValueMapping(target="WEEK", source="Week"), @ValueMapping(target="SPECIFIC_WEEK", source="Specific Weeks"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.Interval mapBillingPeriodType(String var1);

    @ValueMappings(value={@ValueMapping(source="ACCOUNT_CYCLE_DATE", target="DEFAULT_FROM_CUSTOMER"), @ValueMapping(source="SUBSCRIPTION_START_DAY", target="SUBSCRIPTION_STAR_TDAY"), @ValueMapping(source="SUBSCRIPTION_PLAN_ITEM_DAY", target="CHARGE_TRIGGER_DAY"), @ValueMapping(source="MONDAY", target="SPECIFIC_DAY_OF_WEEK"), @ValueMapping(source="TUESDAY", target="SPECIFIC_DAY_OF_WEEK"), @ValueMapping(source="WEDNESDAY", target="SPECIFIC_DAY_OF_WEEK"), @ValueMapping(source="THURSDAY", target="SPECIFIC_DAY_OF_WEEK"), @ValueMapping(source="FRIDAY", target="SPECIFIC_DAY_OF_WEEK"), @ValueMapping(source="SATURDAY", target="SPECIFIC_DAY_OF_WEEK"), @ValueMapping(source="SUNDAY", target="SPECIFIC_DAY_OF_WEEK"), @ValueMapping(source="<ANY_REMAINING>", target="SPECIFIC_DAY_OF_MONTH")})
    abstract BillCycleType mapTo(PriceEnum.RecurringOn var1);

    PriceEnum.RecurringOn map(String ZBillCycleType, String weeklyBillCycleDay, Object specificDayOfMonth) {
        BillCycleType billCycleType = BillCycleType.getByLabel((String)ZBillCycleType);
        if (billCycleType.equals((Object)BillCycleType.SPECIFIC_DAY_OF_WEEK) && weeklyBillCycleDay != null) {
            return this.mapSpecificWeek(weeklyBillCycleDay);
        }
        if (billCycleType.equals((Object)BillCycleType.SPECIFIC_DAY_OF_MONTH) && specificDayOfMonth != null) {
            return this.mapSpecificDayOfMonth(specificDayOfMonth.toString());
        }
        return this.mapFrom(billCycleType);
    }

    @ValueMappings(value={@ValueMapping(source="DEFAULT_FROM_CUSTOMER", target="ACCOUNT_CYCLE_DATE"), @ValueMapping(source="SUBSCRIPTION_STAR_TDAY", target="SUBSCRIPTION_START_DAY"), @ValueMapping(source="CHARGE_TRIGGER_DAY", target="SUBSCRIPTION_PLAN_ITEM_DAY"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.RecurringOn mapFrom(BillCycleType var1);

    @ValueMappings(value={@ValueMapping(target="MONDAY", source="Monday"), @ValueMapping(target="TUESDAY", source="Tuesday"), @ValueMapping(target="WEDNESDAY", source="Wednesday"), @ValueMapping(target="THURSDAY", source="Thursday"), @ValueMapping(target="FRIDAY", source="Friday"), @ValueMapping(target="SATURDAY", source="Saturday"), @ValueMapping(target="SUNDAY", source="Sunday"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.RecurringOn mapSpecificWeek(String var1);

    @ValueMappings(value={@ValueMapping(target="_1", source="1"), @ValueMapping(target="_2", source="2"), @ValueMapping(target="_3", source="3"), @ValueMapping(target="_4", source="4"), @ValueMapping(target="_5", source="5"), @ValueMapping(target="_6", source="6"), @ValueMapping(target="_7", source="7"), @ValueMapping(target="_8", source="8"), @ValueMapping(target="_9", source="9"), @ValueMapping(target="_10", source="10"), @ValueMapping(target="_11", source="11"), @ValueMapping(target="_12", source="12"), @ValueMapping(target="_13", source="13"), @ValueMapping(target="_14", source="14"), @ValueMapping(target="_15", source="15"), @ValueMapping(target="_16", source="16"), @ValueMapping(target="_17", source="17"), @ValueMapping(target="_18", source="18"), @ValueMapping(target="_19", source="19"), @ValueMapping(target="_20", source="20"), @ValueMapping(target="_21", source="21"), @ValueMapping(target="_22", source="22"), @ValueMapping(target="_23", source="23"), @ValueMapping(target="_24", source="24"), @ValueMapping(target="_25", source="25"), @ValueMapping(target="_26", source="26"), @ValueMapping(target="_27", source="27"), @ValueMapping(target="_28", source="28"), @ValueMapping(target="_29", source="29"), @ValueMapping(target="_30", source="30"), @ValueMapping(target="_31", source="31"), @ValueMapping(source="<ANY_UNMAPPED>", target="<NULL>")})
    abstract PriceEnum.RecurringOn mapSpecificDayOfMonth(String var1);

    @InheritInverseConfiguration(name="mapSpecificDayOfMonth")
    @ValueMapping(source="<ANY_UNMAPPED>", target="<NULL>")
    abstract String mapToSpecificDayOfMonth(PriceEnum.RecurringOn var1);

    Integer mapToSpecificDayOfMonthInt(PriceEnum.RecurringOn on) {
        String specificDay = this.mapToSpecificDayOfMonth(on);
        if (specificDay == null) {
            return null;
        }
        return Integer.valueOf(this.mapToSpecificDayOfMonth(on));
    }

    @InheritInverseConfiguration
    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    abstract WeeklyBillCycleDay mapToWeeklyBillCycleDay(PriceEnum.RecurringOn var1);

    OverageCalculationOption map(Boolean applyAtEndOfSmoothingPeriod) {
        if (applyAtEndOfSmoothingPeriod == null) {
            return null;
        }
        return applyAtEndOfSmoothingPeriod != false ? OverageCalculationOption.END_OF_SMOOTHING_PERIOD : OverageCalculationOption.PER_BILLING_PERIOD;
    }

    OverageUnusedUnitsCreditOption mapOverageCredits(Boolean creditUnusedUnits) {
        if (creditUnusedUnits == null) {
            return null;
        }
        return creditUnusedUnits != false ? OverageUnusedUnitsCreditOption.CREDIT_BY_SPECIFIC_RATE : OverageUnusedUnitsCreditOption.NO_CREDIT;
    }

    TaxMode map(boolean taxInclusive) {
        return taxInclusive ? TaxMode.TAX_INCLUSIVE : TaxMode.TAX_EXCLUSIVE;
    }

    ApplyType toApi(EnumSet<ApplyDiscountTo> applyDiscountTos) {
        if (applyDiscountTos == null) {
            return null;
        }
        String applyType = applyDiscountTos.stream().sorted().map(Enum::name).collect(Collectors.joining());
        return ApplyType.getByLabel((String)applyType);
    }

    EnumSet<ApplyDiscountTo> fromApi(String applyDiscountTo) {
        if (applyDiscountTo == null) {
            return null;
        }
        return EnumSet.copyOf(Arrays.stream(ApplyDiscountTo.values()).filter(value -> applyDiscountTo.contains(value.name().replace("_", ""))).collect(Collectors.toSet()));
    }

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(source="In Advance", target="IN_ADVANCE"), @ValueMapping(source="In Arrears", target="IN_ARREARS"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract BillingTiming mapBillingTiming(String var1);

    @ValueMappings(value={@ValueMapping(source="CONTRACT_EFFECTIVE", target="CONTRACT_EFFECTIVE"), @ValueMapping(source="SERVICE_ACTIVATION", target="SERVICE_ACTIVATION"), @ValueMapping(source="CUSTOMER_ACCEPTANCE", target="CUSTOMER_ACCEPTANCE"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract TriggerEvent mapTriggerEvent(PriceEnum.Event var1);

    @ValueMappings(value={@ValueMapping(target="ContractEffective", source="CONTRACT_EFFECTIVE"), @ValueMapping(target="ServiceActivation", source="SERVICE_ACTIVATION"), @ValueMapping(target="CustomerAcceptance", source="CUSTOMER_ACCEPTANCE")})
    abstract String map(PriceEnum.Event var1);

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(source="ContractEffective", target="CONTRACT_EFFECTIVE"), @ValueMapping(source="ServiceActivation", target="SERVICE_ACTIVATION"), @ValueMapping(source="CustomerAcceptance", target="CUSTOMER_ACCEPTANCE"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.Event mapTriggerEvent(String var1);

    @EnumMapping(nameTransformationStrategy="prefix", configuration="PER_")
    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    abstract ListPriceBase mapListPriceBase(PriceEnum.PriceBaseInterval var1);

    @ValueMappings(value={@ValueMapping(source="BILLING_PERIOD", target="Per_Billing_Period"), @ValueMapping(source="MONTH", target="Per_Month"), @ValueMapping(source="WEEK", target="Per_Week")})
    abstract String mapSubscriptionListPriceBase(PriceEnum.PriceBaseInterval var1);

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(target="BILLING_PERIOD", source="Per Billing Period"), @ValueMapping(target="MONTH", source="Per Month"), @ValueMapping(target="WEEK", source="Per Week"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.PriceBaseInterval mapListPriceBase(String var1);

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(target="DISCOUNT_FIXED_AMOUNT", source="Discount-Fixed Amount"), @ValueMapping(target="DISCOUNT_PERCENTAGE", source="Discount-Percentage"), @ValueMapping(target="FLAT_FEE", source="Flat Fee Pricing"), @ValueMapping(target="PER_UNIT", source="Per Unit Pricing"), @ValueMapping(target="OVERAGE", source="Overage Pricing"), @ValueMapping(target="TIERED", source="Tiered Pricing"), @ValueMapping(target="TIERED_WITH_OVERAGE", source="Tiered with Overage Pricing"), @ValueMapping(target="VOLUME", source="Volume Pricing"), @ValueMapping(target="CUSTOM_CHARGE_MODEL", source="Custom Charge Model Pricing"), @ValueMapping(target="MULTI_ATTRIBUTE_PRICING", source="MultiAttributePricing"), @ValueMapping(target="PRERATED_PER_UNIT", source="PreratedPerUnit"), @ValueMapping(target="PRERATED_PRICING", source="PreratedPricing"), @ValueMapping(target="HIGH_WATERMARK_VOLUME", source="HighWatermarkVolumePricing"), @ValueMapping(target="HIGH_WATERMARK_TIERED", source="HighWatermarkTieredPricing"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.ChargeModel fromChargeModel(String var1);

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(source="Recurring", target="RECURRING"), @ValueMapping(source="OneTime", target="ONE_TIME"), @ValueMapping(source="Usage", target="USAGE"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract ChargeType fromChargeType(String var1);

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(target="BY_BILLING_PERIOD", source="ByBillingPeriod"), @ValueMapping(target="BY_USAGE_START_DATE", source="ByUsageStartDate"), @ValueMapping(target="BY_USAGE_RECORD", source="ByUsageRecord"), @ValueMapping(target="BY_USAGE_UPLOAD", source="ByUsageUpload"), @ValueMapping(target="BY_GROUP_ID", source="ByGroupId"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract RatingGroup fromRatingGroup(String var1);

    @ValueMappings(value={@ValueMapping(source="ROLLOVER", target="Rollover"), @ValueMapping(source="ROLLING_WINDOW", target="Rolling Window")})
    abstract String toSmoothingModel(OverageType var1);

    @InheritInverseConfiguration
    @ValueMappings(value={@ValueMapping(source="Rollover", target="ROLLOVER"), @ValueMapping(source="Rolling Window", target="ROLLING_WINDOW"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract OverageType fromSmoothingModel(String var1);
}

