/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.enums;

import com.google.common.base.Strings;
import com.zuora.sdk.core.exceptions.InvalidRequestException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public enum BankAccountType {
    BUSINESS("BusinessChecking"),
    CHECKING("Checking"),
    SAVING("Saving");

    private final String apiValue;

    public static BankAccountType fromApi(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        for (BankAccountType v : BankAccountType.values()) {
            if (!v.apiValue.equals(value)) continue;
            return v;
        }
        throw InvalidRequestException.builder().addViolation(InvalidRequestException.Reason.InvalidValue, "BankAccountType", "invalid value " + value).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private BankAccountType(String apiValue) {
        this.apiValue = apiValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getApiValue() {
        return this.apiValue;
    }
}

