/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.google.common.base.Strings;
import com.zuora.sdk.Account;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.HydratedZuoraObject;
import com.zuora.sdk.SubscriptionPlan;
import com.zuora.sdk.SubscriptionUpdateRequest;
import com.zuora.sdk.Term;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.ZuoraObject;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

@ZuoraObject(name="subscription", namespace="com_zuora")
public final class Subscription
extends BaseFacade
implements HydratedZuoraObject {
    final LocalDate startDate;
    final Term initialTerm;
    final Term renewalTerm;
    final String key;
    final State state;
    final LocalDate endDate;
    final String id;
    final LocalDate termStartDate;
    final LocalDate termEndDate;
    final Account invoiceAccount;
    final Boolean invoiceSeparately;
    final String description;
    final Account account;
    final LocalDate contractEffective;
    final LocalDate serviceActivation;
    final LocalDate customerAcceptance;
    final boolean autoRenew;
    final String createdBy;
    final ZonedDateTime createTime;
    final String updatedBy;
    final ZonedDateTime updateTime;
    final Double mrr;
    final Double tcv;
    final Integer version;
    final Term currentTerm;
    final boolean cancelAtPeriodEnd;
    final LocalDate canceledDate;
    final LocalDate suspendedDate;
    private final Map<String, Object> customFields;
    @NonNull
    private final ZuoraClient client;

    public List<SubscriptionPlan> getSubscriptionPlans() throws ZuoraSdkException {
        return this.client.subscriptions().getSubscriptionPlans(this.id);
    }

    public void removePlan(SubscriptionPlan subscriptionPlan) {
        this.client.subscriptions().removeSubscriptionPlan(this, subscriptionPlan);
    }

    public Subscription update(SubscriptionUpdateRequest subscriptionUpdateRequest) {
        return this.client.subscriptions().update(this, subscriptionUpdateRequest);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Map<String, Object> $default$customFields() {
        return new HashMap<String, Object>();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Subscription(LocalDate startDate, Term initialTerm, Term renewalTerm, String key, State state, LocalDate endDate, String id, LocalDate termStartDate, LocalDate termEndDate, Account invoiceAccount, Boolean invoiceSeparately, String description, Account account2, LocalDate contractEffective, LocalDate serviceActivation, LocalDate customerAcceptance, boolean autoRenew, String createdBy, ZonedDateTime createTime, String updatedBy, ZonedDateTime updateTime, Double mrr, Double tcv, Integer version, Term currentTerm, boolean cancelAtPeriodEnd, LocalDate canceledDate, LocalDate suspendedDate, Map<String, Object> customFields, @NonNull ZuoraClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.startDate = startDate;
        this.initialTerm = initialTerm;
        this.renewalTerm = renewalTerm;
        this.key = key;
        this.state = state;
        this.endDate = endDate;
        this.id = id;
        this.termStartDate = termStartDate;
        this.termEndDate = termEndDate;
        this.invoiceAccount = invoiceAccount;
        this.invoiceSeparately = invoiceSeparately;
        this.description = description;
        this.account = account2;
        this.contractEffective = contractEffective;
        this.serviceActivation = serviceActivation;
        this.customerAcceptance = customerAcceptance;
        this.autoRenew = autoRenew;
        this.createdBy = createdBy;
        this.createTime = createTime;
        this.updatedBy = updatedBy;
        this.updateTime = updateTime;
        this.mrr = mrr;
        this.tcv = tcv;
        this.version = version;
        this.currentTerm = currentTerm;
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
        this.canceledDate = canceledDate;
        this.suspendedDate = suspendedDate;
        this.customFields = customFields;
        this.client = client;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    static SubscriptionBuilder builder() {
        return new SubscriptionBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    SubscriptionBuilder toBuilder() {
        return new SubscriptionBuilder().startDate(this.startDate).initialTerm(this.initialTerm).renewalTerm(this.renewalTerm).key(this.key).state(this.state).endDate(this.endDate).id(this.id).termStartDate(this.termStartDate).termEndDate(this.termEndDate).invoiceAccount(this.invoiceAccount).invoiceSeparately(this.invoiceSeparately).description(this.description).account(this.account).contractEffective(this.contractEffective).serviceActivation(this.serviceActivation).customerAcceptance(this.customerAcceptance).autoRenew(this.autoRenew).createdBy(this.createdBy).createTime(this.createTime).updatedBy(this.updatedBy).updateTime(this.updateTime).mrr(this.mrr).tcv(this.tcv).version(this.version).currentTerm(this.currentTerm).cancelAtPeriodEnd(this.cancelAtPeriodEnd).canceledDate(this.canceledDate).suspendedDate(this.suspendedDate).customFields(this.customFields).client(this.client);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Term getInitialTerm() {
        return this.initialTerm;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Term getRenewalTerm() {
        return this.renewalTerm;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public State getState() {
        return this.state;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getTermStartDate() {
        return this.termStartDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getTermEndDate() {
        return this.termEndDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Account getInvoiceAccount() {
        return this.invoiceAccount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getInvoiceSeparately() {
        return this.invoiceSeparately;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Account getAccount() {
        return this.account;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getContractEffective() {
        return this.contractEffective;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getServiceActivation() {
        return this.serviceActivation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getCustomerAcceptance() {
        return this.customerAcceptance;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getMrr() {
        return this.mrr;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getTcv() {
        return this.tcv;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Term getCurrentTerm() {
        return this.currentTerm;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getCanceledDate() {
        return this.canceledDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getSuspendedDate() {
        return this.suspendedDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZuoraClient getClient() {
        return this.client;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoRenew() != other.isAutoRenew()) {
            return false;
        }
        if (this.isCancelAtPeriodEnd() != other.isCancelAtPeriodEnd()) {
            return false;
        }
        Boolean this$invoiceSeparately = this.getInvoiceSeparately();
        Boolean other$invoiceSeparately = other.getInvoiceSeparately();
        if (this$invoiceSeparately == null ? other$invoiceSeparately != null : !((Object)this$invoiceSeparately).equals(other$invoiceSeparately)) {
            return false;
        }
        Double this$mrr = this.getMrr();
        Double other$mrr = other.getMrr();
        if (this$mrr == null ? other$mrr != null : !((Object)this$mrr).equals(other$mrr)) {
            return false;
        }
        Double this$tcv = this.getTcv();
        Double other$tcv = other.getTcv();
        if (this$tcv == null ? other$tcv != null : !((Object)this$tcv).equals(other$tcv)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Term this$initialTerm = this.getInitialTerm();
        Term other$initialTerm = other.getInitialTerm();
        if (this$initialTerm == null ? other$initialTerm != null : !((Object)this$initialTerm).equals(other$initialTerm)) {
            return false;
        }
        Term this$renewalTerm = this.getRenewalTerm();
        Term other$renewalTerm = other.getRenewalTerm();
        if (this$renewalTerm == null ? other$renewalTerm != null : !((Object)this$renewalTerm).equals(other$renewalTerm)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LocalDate this$termStartDate = this.getTermStartDate();
        LocalDate other$termStartDate = other.getTermStartDate();
        if (this$termStartDate == null ? other$termStartDate != null : !((Object)this$termStartDate).equals(other$termStartDate)) {
            return false;
        }
        LocalDate this$termEndDate = this.getTermEndDate();
        LocalDate other$termEndDate = other.getTermEndDate();
        if (this$termEndDate == null ? other$termEndDate != null : !((Object)this$termEndDate).equals(other$termEndDate)) {
            return false;
        }
        Account this$invoiceAccount = this.getInvoiceAccount();
        Account other$invoiceAccount = other.getInvoiceAccount();
        if (this$invoiceAccount == null ? other$invoiceAccount != null : !((Object)this$invoiceAccount).equals(other$invoiceAccount)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Account this$account = this.getAccount();
        Account other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        LocalDate this$contractEffective = this.getContractEffective();
        LocalDate other$contractEffective = other.getContractEffective();
        if (this$contractEffective == null ? other$contractEffective != null : !((Object)this$contractEffective).equals(other$contractEffective)) {
            return false;
        }
        LocalDate this$serviceActivation = this.getServiceActivation();
        LocalDate other$serviceActivation = other.getServiceActivation();
        if (this$serviceActivation == null ? other$serviceActivation != null : !((Object)this$serviceActivation).equals(other$serviceActivation)) {
            return false;
        }
        LocalDate this$customerAcceptance = this.getCustomerAcceptance();
        LocalDate other$customerAcceptance = other.getCustomerAcceptance();
        if (this$customerAcceptance == null ? other$customerAcceptance != null : !((Object)this$customerAcceptance).equals(other$customerAcceptance)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        ZonedDateTime this$createTime = this.getCreateTime();
        ZonedDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Term this$currentTerm = this.getCurrentTerm();
        Term other$currentTerm = other.getCurrentTerm();
        if (this$currentTerm == null ? other$currentTerm != null : !((Object)this$currentTerm).equals(other$currentTerm)) {
            return false;
        }
        LocalDate this$canceledDate = this.getCanceledDate();
        LocalDate other$canceledDate = other.getCanceledDate();
        if (this$canceledDate == null ? other$canceledDate != null : !((Object)this$canceledDate).equals(other$canceledDate)) {
            return false;
        }
        LocalDate this$suspendedDate = this.getSuspendedDate();
        LocalDate other$suspendedDate = other.getSuspendedDate();
        if (this$suspendedDate == null ? other$suspendedDate != null : !((Object)this$suspendedDate).equals(other$suspendedDate)) {
            return false;
        }
        Map<String, Object> this$customFields = this.getCustomFields();
        Map<String, Object> other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        ZuoraClient this$client = this.getClient();
        ZuoraClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoRenew() ? 79 : 97);
        result = result * 59 + (this.isCancelAtPeriodEnd() ? 79 : 97);
        Boolean $invoiceSeparately = this.getInvoiceSeparately();
        result = result * 59 + ($invoiceSeparately == null ? 43 : ((Object)$invoiceSeparately).hashCode());
        Double $mrr = this.getMrr();
        result = result * 59 + ($mrr == null ? 43 : ((Object)$mrr).hashCode());
        Double $tcv = this.getTcv();
        result = result * 59 + ($tcv == null ? 43 : ((Object)$tcv).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Term $initialTerm = this.getInitialTerm();
        result = result * 59 + ($initialTerm == null ? 43 : ((Object)$initialTerm).hashCode());
        Term $renewalTerm = this.getRenewalTerm();
        result = result * 59 + ($renewalTerm == null ? 43 : ((Object)$renewalTerm).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LocalDate $termStartDate = this.getTermStartDate();
        result = result * 59 + ($termStartDate == null ? 43 : ((Object)$termStartDate).hashCode());
        LocalDate $termEndDate = this.getTermEndDate();
        result = result * 59 + ($termEndDate == null ? 43 : ((Object)$termEndDate).hashCode());
        Account $invoiceAccount = this.getInvoiceAccount();
        result = result * 59 + ($invoiceAccount == null ? 43 : ((Object)$invoiceAccount).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Account $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        LocalDate $contractEffective = this.getContractEffective();
        result = result * 59 + ($contractEffective == null ? 43 : ((Object)$contractEffective).hashCode());
        LocalDate $serviceActivation = this.getServiceActivation();
        result = result * 59 + ($serviceActivation == null ? 43 : ((Object)$serviceActivation).hashCode());
        LocalDate $customerAcceptance = this.getCustomerAcceptance();
        result = result * 59 + ($customerAcceptance == null ? 43 : ((Object)$customerAcceptance).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        ZonedDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Term $currentTerm = this.getCurrentTerm();
        result = result * 59 + ($currentTerm == null ? 43 : ((Object)$currentTerm).hashCode());
        LocalDate $canceledDate = this.getCanceledDate();
        result = result * 59 + ($canceledDate == null ? 43 : ((Object)$canceledDate).hashCode());
        LocalDate $suspendedDate = this.getSuspendedDate();
        result = result * 59 + ($suspendedDate == null ? 43 : ((Object)$suspendedDate).hashCode());
        Map<String, Object> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        ZuoraClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Subscription(startDate=" + this.getStartDate() + ", initialTerm=" + this.getInitialTerm() + ", renewalTerm=" + this.getRenewalTerm() + ", key=" + this.getKey() + ", state=" + (Object)((Object)this.getState()) + ", endDate=" + this.getEndDate() + ", id=" + this.getId() + ", termStartDate=" + this.getTermStartDate() + ", termEndDate=" + this.getTermEndDate() + ", invoiceAccount=" + this.getInvoiceAccount() + ", invoiceSeparately=" + this.getInvoiceSeparately() + ", description=" + this.getDescription() + ", account=" + this.getAccount() + ", contractEffective=" + this.getContractEffective() + ", serviceActivation=" + this.getServiceActivation() + ", customerAcceptance=" + this.getCustomerAcceptance() + ", autoRenew=" + this.isAutoRenew() + ", createdBy=" + this.getCreatedBy() + ", createTime=" + this.getCreateTime() + ", updatedBy=" + this.getUpdatedBy() + ", updateTime=" + this.getUpdateTime() + ", mrr=" + this.getMrr() + ", tcv=" + this.getTcv() + ", version=" + this.getVersion() + ", currentTerm=" + this.getCurrentTerm() + ", cancelAtPeriodEnd=" + this.isCancelAtPeriodEnd() + ", canceledDate=" + this.getCanceledDate() + ", suspendedDate=" + this.getSuspendedDate() + ", customFields=" + this.getCustomFields() + ", client=" + this.getClient() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    static class SubscriptionBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate startDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Term initialTerm;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Term renewalTerm;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private State state;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate endDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate termStartDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate termEndDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Account invoiceAccount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean invoiceSeparately;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Account account;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate contractEffective;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate serviceActivation;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate customerAcceptance;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean autoRenew;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String createdBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime createTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String updatedBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime updateTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double mrr;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double tcv;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer version;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Term currentTerm;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean cancelAtPeriodEnd;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate canceledDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate suspendedDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean customFields$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, Object> customFields$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZuoraClient client;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder initialTerm(Term initialTerm) {
            this.initialTerm = initialTerm;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder renewalTerm(Term renewalTerm) {
            this.renewalTerm = renewalTerm;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder key(String key) {
            this.key = key;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder state(State state) {
            this.state = state;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder endDate(LocalDate endDate) {
            this.endDate = endDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder termStartDate(LocalDate termStartDate) {
            this.termStartDate = termStartDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder termEndDate(LocalDate termEndDate) {
            this.termEndDate = termEndDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder invoiceAccount(Account invoiceAccount) {
            this.invoiceAccount = invoiceAccount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder invoiceSeparately(Boolean invoiceSeparately) {
            this.invoiceSeparately = invoiceSeparately;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder account(Account account2) {
            this.account = account2;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder contractEffective(LocalDate contractEffective) {
            this.contractEffective = contractEffective;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder serviceActivation(LocalDate serviceActivation) {
            this.serviceActivation = serviceActivation;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder customerAcceptance(LocalDate customerAcceptance) {
            this.customerAcceptance = customerAcceptance;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder autoRenew(boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder createTime(ZonedDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder updateTime(ZonedDateTime updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder mrr(Double mrr) {
            this.mrr = mrr;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder tcv(Double tcv) {
            this.tcv = tcv;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder currentTerm(Term currentTerm) {
            this.currentTerm = currentTerm;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder cancelAtPeriodEnd(boolean cancelAtPeriodEnd) {
            this.cancelAtPeriodEnd = cancelAtPeriodEnd;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder canceledDate(LocalDate canceledDate) {
            this.canceledDate = canceledDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder suspendedDate(LocalDate suspendedDate) {
            this.suspendedDate = suspendedDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder customFields(Map<String, Object> customFields) {
            this.customFields$value = customFields;
            this.customFields$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionBuilder client(@NonNull ZuoraClient client) {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.client = client;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Subscription build() {
            Map customFields$value = this.customFields$value;
            if (!this.customFields$set) {
                customFields$value = Subscription.$default$customFields();
            }
            return new Subscription(this.startDate, this.initialTerm, this.renewalTerm, this.key, this.state, this.endDate, this.id, this.termStartDate, this.termEndDate, this.invoiceAccount, this.invoiceSeparately, this.description, this.account, this.contractEffective, this.serviceActivation, this.customerAcceptance, this.autoRenew, this.createdBy, this.createTime, this.updatedBy, this.updateTime, this.mrr, this.tcv, this.version, this.currentTerm, this.cancelAtPeriodEnd, this.canceledDate, this.suspendedDate, customFields$value, this.client);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Subscription.SubscriptionBuilder(startDate=" + this.startDate + ", initialTerm=" + this.initialTerm + ", renewalTerm=" + this.renewalTerm + ", key=" + this.key + ", state=" + (Object)((Object)this.state) + ", endDate=" + this.endDate + ", id=" + this.id + ", termStartDate=" + this.termStartDate + ", termEndDate=" + this.termEndDate + ", invoiceAccount=" + this.invoiceAccount + ", invoiceSeparately=" + this.invoiceSeparately + ", description=" + this.description + ", account=" + this.account + ", contractEffective=" + this.contractEffective + ", serviceActivation=" + this.serviceActivation + ", customerAcceptance=" + this.customerAcceptance + ", autoRenew=" + this.autoRenew + ", createdBy=" + this.createdBy + ", createTime=" + this.createTime + ", updatedBy=" + this.updatedBy + ", updateTime=" + this.updateTime + ", mrr=" + this.mrr + ", tcv=" + this.tcv + ", version=" + this.version + ", currentTerm=" + this.currentTerm + ", cancelAtPeriodEnd=" + this.cancelAtPeriodEnd + ", canceledDate=" + this.canceledDate + ", suspendedDate=" + this.suspendedDate + ", customFields$value=" + this.customFields$value + ", client=" + this.client + ")";
        }
    }

    public static enum TermType {
        EVERGREEN,
        TERMED;

    }

    public static enum State {
        DRAFT("Draft"),
        PENDING_ACTIVATION("Pending Activation"),
        PENDING_ACCEPTANCE("Pending Acceptance"),
        ACTIVE("Active"),
        EXPIRED("Expired"),
        CANCELED("Cancelled"),
        SUSPENDED("Suspended");

        private final String label;

        public static State getByLabel(String label) {
            if (Strings.isNullOrEmpty((String)label)) {
                return null;
            }
            for (State s : State.values()) {
                if (!label.equals(s.label)) continue;
                return s;
            }
            return null;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private State(String label) {
            this.label = label;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getLabel() {
            return this.label;
        }
    }
}

