/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.zuora.sdk.ApiMapper;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.Product;
import com.zuora.sdk.ProductBySkuQuery;
import com.zuora.sdk.ProductCreateRequest;
import com.zuora.sdk.ProductRatePlanByIdQuery;
import com.zuora.sdk.ProductRatePlanChargeByIdQuery;
import com.zuora.sdk.ProductsQuery;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.core.APIContext;
import com.zuora.sdk.core.apis.ProductRatePlansAPI;
import com.zuora.sdk.core.apis.data.ProxyGetProductRatePlan;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.core.models.ZProduct;
import com.zuora.sdk.core.models.ZProductRatePlan;
import com.zuora.sdk.planitems.PlanItem;
import com.zuora.sdk.planitems.PlanItemCreateRequest;
import com.zuora.sdk.planitems.PlanItemEnum;
import com.zuora.sdk.type.ProductFilterKey;
import com.zuora.sdk.utils.ApolloClientUtil;
import com.zuora.sdk.utils.HawkClient;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minidev.json.JSONObject;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class ProductAPI {
    private final Map<String, Object> uomMap;
    private final HawkClient hawkClient;
    private final ApolloClient gqlClient;
    private final ZuoraClient client;
    private APIContext context;
    private OkHttpClient okHttpClient = new OkHttpClient();
    private static final Integer BATCH_SIZE = 10;

    ProductAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.hawkClient = client.getHawkClient();
        this.uomMap = this.getUnitsOfMeasure();
        this.gqlClient = this.hawkClient.getGqlClient();
    }

    /*
     * WARNING - void declaration
     */
    public Product create(ProductCreateRequest productCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        ProductCreateRequest productCreateRequest2 = productCreateRequest;
        try {
            void zProduct;
            void product;
            ZProduct zProduct2 = ApiMapper.Mapper.toApi(productCreateRequest2).build();
            String string = zProduct2.create(product.context);
            product.client.customObjects().saveAssociations((BaseFacade)zProduct, string);
            zProduct.getPlans().forEach(productPlan -> {
                productPlan.setProduct(string);
                Plan plan = this.createPlan((PlanCreateRequest)productPlan);
                this.client.customObjects().saveAssociations((BaseFacade)productPlan, plan.getId());
                productPlan.getPlanItems().forEach(planItem -> {
                    planItem.setPlan(plan.getId());
                    this.createPlanItem((PlanItemCreateRequest)planItem);
                });
            });
            object = product.get(string);
            return object;
        }
        finally {
            productCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void delete(Product product) throws ZuoraSdkException {
        Meter meter;
        String string;
        long l = System.currentTimeMillis();
        ProductAPI productAPI = this;
        Product product2 = product;
        try {
            void product3;
            ZProduct.delete((APIContext)product3.context, (String)product2.getId());
            productAPI = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        product2 = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string2 = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != productAPI) {
            string = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{productAPI.getClass().getSimpleName(), string2, "delete"});
            meter = product2.meter(string);
            meter.mark();
        } else {
            string = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string2, "delete"});
            meter = product2.meter(string);
            meter.mark();
        }
        string = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string2, "delete"});
        meter = product2.histogram(string);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (productAPI != null) {
            throw productAPI;
        }
    }

    public Product get(String productId) throws ZuoraSdkException {
        try {
            CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductBySkuQuery(ProductFilterKey.ID, productId)));
            if (response.get().getData() == null || ((ProductBySkuQuery.Data)response.get().getData()).getProducts().getEdges().isEmpty()) {
                return null;
            }
            Product product = this.mapNestedProduct(((ProductBySkuQuery.Data)response.get().getData()).getProducts().getEdges().get(0).getNode());
            ZProduct zProduct = ZProduct.get((APIContext)this.context, (String)productId);
            product = product.toBuilder().customFields(zProduct.productObjectCustomFields()).build();
            return product;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).message(e.getMessage()).build();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Stream<Product> stream() throws ZuoraSdkException {
        Meter meter;
        Stream<Product> stream;
        Object object;
        String string;
        Object object2;
        LinkedBlockingQueue linkedBlockingQueue;
        long l = System.currentTimeMillis();
        Object object3 = this;
        try {
            try {
                void response;
                void queue;
                linkedBlockingQueue = new LinkedBlockingQueue(1000);
                object2 = ApolloClientUtil.toCompletableFuture(queue.gqlClient.query((Query)new ProductsQuery()));
                string = (Response)((CompletableFuture)object2).join();
                object = CompletableFuture.runAsync(() -> ((ProductAPI)queue).lambda$stream$4((Response)string, (BlockingQueue)response));
                stream = StreamSupport.stream(new Spliterators.AbstractSpliterator<Product>(Long.MAX_VALUE, 16, (BlockingQueue)response){
                    final /* synthetic */ BlockingQueue val$queue;
                    {
                        this.val$queue = blockingQueue;
                        super(x0, x1);
                    }

                    @Override
                    public boolean tryAdvance(Consumer<? super Product> action) {
                        try {
                            if (object.isDone()) {
                                return false;
                            }
                            Product value = (Product)this.val$queue.poll(5000L, TimeUnit.MILLISECONDS);
                            if (value != null) {
                                action.accept(value);
                                return true;
                            }
                            if (object.isDone()) {
                                return !object.isDone();
                            }
                            throw ZuoraSdkException.builder().message("Query time out.").build();
                        }
                        catch (InterruptedException e) {
                            throw ZuoraSdkException.builder().cause((Throwable)e).message("Internal error occur.").build();
                        }
                    }
                }, false);
            }
            catch (Exception exception) {
                throw ZuoraSdkException.builder().cause((Throwable)exception).message(exception.getMessage()).build();
            }
        }
        catch (Throwable throwable) {
            object3 = null;
        }
        object3 = stream;
        linkedBlockingQueue = null;
        object2 = SharedMetricRegistries.getOrCreate((String)"zuora");
        string = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != linkedBlockingQueue) {
            object = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{linkedBlockingQueue.getClass().getSimpleName(), string, "stream"});
            meter = object2.meter((String)object);
            meter.mark();
        } else {
            object = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string, "stream"});
            meter = object2.meter((String)object);
            meter.mark();
        }
        object = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string, "stream"});
        meter = object2.histogram((String)object);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (linkedBlockingQueue != null) {
            throw linkedBlockingQueue;
        }
        return object3;
    }

    private Product mapNestedProduct(ProductBySkuQuery.Node productResp) {
        LocalDate now = LocalDate.now(this.context.getEntityProfileInfo().tenantZoneId());
        LocalDate startDate = LocalDate.parse(productResp.getEffectiveStartDate());
        LocalDate endDate = LocalDate.parse(productResp.getEffectiveEndDate());
        ZonedDateTime createTime = ZonedDateTime.parse(productResp.getCreatedDate());
        ZonedDateTime updateTime = ZonedDateTime.parse(productResp.getUpdatedDate());
        boolean active = !(!now.isEqual(startDate) && !now.isAfter(startDate) || !now.isEqual(endDate) && !now.isBefore(endDate));
        Product product = Product.builder().id(productResp.getId()).name(productResp.getName()).sku(productResp.getSKU()).startDate(startDate).endDate(endDate).description(productResp.getDescription()).createdBy(productResp.getCreatedById()).createTime(createTime).updatedBy(productResp.getUpdatedById()).updateTime(updateTime).active(active).build();
        if (productResp.getProductrateplans() != null) {
            product.toBuilder().plans(productResp.getProductrateplans().getEdges().stream().map(ratePlan -> {
                LocalDate planStartDate = LocalDate.parse(ratePlan.getNode().getEffectiveStartDate());
                LocalDate planEndDate = LocalDate.parse(ratePlan.getNode().getEffectiveEndDate());
                boolean planActive = now.isEqual(planStartDate) || now.isAfter(planStartDate) && (now.isEqual(planEndDate) || now.isBefore(planEndDate));
                String planId = ratePlan.getNode().getId();
                Plan plan = Plan.builder().id(planId).name(ratePlan.getNode().getName()).startDate(LocalDate.parse(ratePlan.getNode().getEffectiveStartDate())).endDate(LocalDate.parse(ratePlan.getNode().getEffectiveEndDate())).product(product.getId()).createdBy(ratePlan.getNode().getCreatedById()).createTime(ZonedDateTime.parse(ratePlan.getNode().getCreatedDate())).updatedBy(ratePlan.getNode().getUpdatedById()).updateTime(ZonedDateTime.parse(ratePlan.getNode().getUpdatedDate())).description(ratePlan.getNode().getDescription()).active(planActive).build();
                ZProductRatePlan productRatePlan = ZProductRatePlan.get((APIContext)this.context, (String)planId);
                plan = plan.toBuilder().activeCurrencies(productRatePlan.activeCurrencies()).customFields(productRatePlan.productRatePlanObjectCustomFields()).build();
                ArrayList planItems = new ArrayList();
                ratePlan.getNode().getProductrateplancharges().getEdges().stream().filter(ratePlanCharge -> ratePlanCharge.getNode().getId() != null && PlanItemEnum.ChargeModel.getChargeModelByName(ratePlanCharge.getNode().getChargeModel()) != null).forEach(ratePlanCharge -> planItems.add(ApiMapper.Mapper.fromProductBySkuQuery(ratePlanCharge.getNode()).setPlan(planId).setId(ratePlanCharge.getNode().getId())));
                plan.getItems().addAll(planItems);
                product.addPlan(plan);
                return plan;
            }).collect(Collectors.toList()));
        }
        return product;
    }

    /*
     * WARNING - void declaration
     */
    public Product findBySku(String string) throws ZuoraSdkException {
        Meter meter;
        String string2;
        Product product;
        Object object;
        long l = System.currentTimeMillis();
        ProductAPI productAPI = this;
        String string3 = string;
        try {
            try {
                void sku;
                object = ApolloClientUtil.toCompletableFuture(sku.gqlClient.query((Query)new ProductBySkuQuery(ProductFilterKey.SKU, string3)));
                product = ((Response)((CompletableFuture)object).get()).getData() == null || ((ProductBySkuQuery.Data)((Response)((CompletableFuture)object).get()).getData()).getProducts().getEdges().isEmpty() ? null : super.mapNestedProduct(((ProductBySkuQuery.Data)((Response)((CompletableFuture)object).get()).getData()).getProducts().getEdges().get(0).getNode());
            }
            catch (Exception exception) {
                throw ZuoraSdkException.builder().cause(exception.getCause()).message(exception.toString()).build();
            }
        }
        catch (Throwable throwable) {
            productAPI = null;
        }
        productAPI = product;
        string3 = null;
        object = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string4 = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != string3) {
            string2 = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{string3.getClass().getSimpleName(), string4, "findBySku"});
            meter = object.meter(string2);
            meter.mark();
        } else {
            string2 = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string4, "findBySku"});
            meter = object.meter(string2);
            meter.mark();
        }
        string2 = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string4, "findBySku"});
        meter = object.histogram(string2);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (string3 != null) {
            throw string3;
        }
        return productAPI;
    }

    public Plan getPlan(String id) throws ZuoraSdkException {
        try {
            CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductRatePlanByIdQuery(id)));
            if (response.get().getData() == null) {
                return null;
            }
            ProductRatePlanByIdQuery.ProductrateplanById productRatePlanResp = ((ProductRatePlanByIdQuery.Data)response.get().getData()).getProductrateplanById();
            Plan plan = ApiMapper.Mapper.fromApi(productRatePlanResp);
            String planId = plan.getId();
            ProxyGetProductRatePlan proxyGetProductRatePlan = ProductRatePlansAPI.objectRetrieve((APIContext)this.context, (String)planId);
            plan = plan.toBuilder().activeCurrencies(proxyGetProductRatePlan.activeCurrencies()).customFields(proxyGetProductRatePlan.productRatePlanObjectCustomFields()).build();
            if (productRatePlanResp.getProductrateplancharges() != null) {
                List planItems = productRatePlanResp.getProductrateplancharges().getEdges().stream().filter(ratePlanCharge -> ratePlanCharge.getNode().getId() != null).map(ratePlanCharge -> ApiMapper.Mapper.fromProductRatePlanCharge(ratePlanCharge.getNode()).setPlan(planId).setId(ratePlanCharge.getNode().getId())).collect(Collectors.toList());
                plan.getItems().addAll(planItems);
            }
            return plan;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).build();
        }
    }

    public List<Plan> getPlans(Product product) throws ZuoraSdkException {
        Product aProduct = this.findBySku(product.getSku());
        return aProduct.getPlans();
    }

    /*
     * WARNING - void declaration
     */
    public Plan createPlan(PlanCreateRequest planCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        PlanCreateRequest planCreateRequest2 = planCreateRequest;
        try {
            void plan;
            Object object2 = ApiMapper.Mapper.toApi(planCreateRequest2).build().create(plan.context);
            object = plan.getPlan((String)object2);
            return object;
        }
        finally {
            planCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Plan updatePlan(Plan plan) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Plan plan2 = plan;
        try {
            void plan3;
            ApiMapper.Mapper.toApi(plan2).build().update(plan3.context);
            object = plan2;
            return object;
        }
        finally {
            plan2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Plan removePlan(Plan plan) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Plan plan2 = plan;
        try {
            void plan3;
            ApiMapper.Mapper.toApi(plan2).build();
            ZProductRatePlan.delete((APIContext)plan3.context, (String)plan2.getId());
            object = plan2;
            return object;
        }
        finally {
            plan2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public PlanItem createPlanItem(PlanItemCreateRequest planItemCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        PlanItemCreateRequest planItemCreateRequest2 = planItemCreateRequest;
        try {
            void planItem;
            Object object2 = ApiMapper.Mapper.toApi(planItemCreateRequest2, planItem.uomMap).create(planItem.context);
            object = planItem.getPlanItem((String)object2);
            return object;
        }
        finally {
            planItemCreateRequest2 = null;
        }
    }

    public PlanItem getPlanItem(String id) throws ZuoraSdkException {
        try {
            CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductRatePlanChargeByIdQuery(id)));
            if (response.get().getData() == null) {
                return null;
            }
            return ApiMapper.Mapper.fromProductRatePlanCharge(((ProductRatePlanChargeByIdQuery.Data)response.get().getData()).getProductrateplanchargeById());
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).build();
        }
    }

    /*
     * WARNING - void declaration
     */
    public PlanItem updatePlanItem(PlanItem planItem) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        PlanItem planItem2 = planItem;
        try {
            void planItem3;
            ApiMapper.Mapper.toApi(planItem2, planItem3.uomMap).update(planItem3.context);
            object = planItem2;
            return object;
        }
        finally {
            planItem2 = null;
        }
    }

    Map<String, Object> getUnitsOfMeasure() {
        try {
            HashMap<String, Object> uomMap = new HashMap<String, Object>();
            Request request = new Request.Builder().header("Authorization", "Bearer " + this.context.getBearer()).url(this.context.getEndpointBase() + "/settings/units-of-measure/").build();
            okhttp3.Response response = this.okHttpClient.newCall(request).execute();
            if (response.code() == 200 && response.body() != null) {
                Gson gson = new Gson();
                ArrayList uoms = (ArrayList)((JSONObject)gson.fromJson(response.body().string(), JSONObject.class)).get((Object)"unitsOfMeasure");
                for (Map uom : uoms) {
                    uomMap.put(uom.get("name").toString(), uom);
                }
                return uomMap;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private /* synthetic */ void lambda$stream$4(Response result, BlockingQueue queue) {
        if (result.getData() != null && !((ProductsQuery.Data)result.getData()).getProducts().getEdges().isEmpty()) {
            for (List edges2 : Lists.partition(Arrays.asList(((ProductsQuery.Data)result.getData()).getProducts().getEdges().toArray()), (int)BATCH_SIZE)) {
                ArrayList futures = new ArrayList();
                edges2.forEach(edge -> {
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        try {
                            queue.put(this.get(((ProductsQuery.Edge)edge).getNode().getId()));
                        }
                        catch (InterruptedException e) {
                            throw ZuoraSdkException.builder().cause((Throwable)e).message("Internal error occur.").build();
                        }
                    });
                    futures.add(future);
                });
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            }
        }
    }
}

