/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.zuora.sdk.PaymentMethod;
import com.zuora.sdk.PaymentMethodCreateRequest;
import com.zuora.sdk.PaymentMethodMapper;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.core.APIContext;
import com.zuora.sdk.core.apis.PaymentMethodsAPI;
import com.zuora.sdk.core.apis.data.GETPaymentMethodResponse;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.core.models.ZPaymentMethod;
import java.util.NoSuchElementException;

public class PaymentMethodAPI {
    private final APIContext context;

    PaymentMethodAPI(ZuoraClient client) {
        this.context = client.getContext();
    }

    public PaymentMethod get(String id) throws ZuoraSdkException {
        GETPaymentMethodResponse rawResult = (GETPaymentMethodResponse)new PaymentMethodsAPI.PaymentMethodRetrieveRequest(this.context, id).execute().head();
        if (rawResult == null) {
            throw new NoSuchElementException();
        }
        PaymentMethod.PaymentMethodBuilder paymentMethod = PaymentMethodMapper.Mapper.fromApi(rawResult);
        return paymentMethod.build();
    }

    /*
     * WARNING - void declaration
     */
    public PaymentMethod create(PaymentMethodCreateRequest paymentMethodCreateRequest) {
        long l = System.currentTimeMillis();
        Object object = this;
        PaymentMethodCreateRequest paymentMethodCreateRequest2 = paymentMethodCreateRequest;
        try {
            void paymentMethodCreateRequest3;
            ZPaymentMethod zPaymentMethod = PaymentMethodMapper.Mapper.toApi(paymentMethodCreateRequest2).build();
            String string = zPaymentMethod.create(paymentMethodCreateRequest3.context);
            object = paymentMethodCreateRequest3.get(string);
            return object;
        }
        finally {
            paymentMethodCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void delete(PaymentMethod paymentMethod) {
        Meter meter;
        String string;
        long l = System.currentTimeMillis();
        PaymentMethodAPI paymentMethodAPI = this;
        PaymentMethod paymentMethod2 = paymentMethod;
        try {
            void paymentMethod3;
            ZPaymentMethod.delete((APIContext)paymentMethod3.context, (String)paymentMethod2.getId());
            paymentMethodAPI = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        paymentMethod2 = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string2 = "com.zuora.sdk.PaymentMethodAPI".substring("com.zuora.sdk.PaymentMethodAPI".lastIndexOf(".") + 1);
        if (null != paymentMethodAPI) {
            string = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{paymentMethodAPI.getClass().getSimpleName(), string2, "delete"});
            meter = paymentMethod2.meter(string);
            meter.mark();
        } else {
            string = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string2, "delete"});
            meter = paymentMethod2.meter(string);
            meter.mark();
        }
        string = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string2, "delete"});
        meter = paymentMethod2.histogram(string);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (paymentMethodAPI != null) {
            throw paymentMethodAPI;
        }
    }
}

