/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.planitems;

import com.zuora.sdk.chargemodels.ChargeModelInterface;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.core.models.enums.BillingTiming;
import com.zuora.sdk.planitems.PlanItemCreateRequest;
import com.zuora.sdk.planitems.PlanItemEnum;
import com.zuora.sdk.planitems.PlanItemType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumSet;
import lombok.Generated;

public final class RecurringPlanItem
extends PlanItemCreateRequest
implements PlanItemType {
    final PlanItemEnum.RecurringOn on;
    final PlanItemEnum.Interval interval;
    final Integer intervalCount;
    final PlanItemEnum.Alignment alignment;
    private final PlanItemEnum.Interval durationInterval;
    private final Integer durationIntervalCount;

    public RecurringPlanItem(String accountingCode, PlanItemEnum.Event startEvent, String name, PlanItemType.ItemType planItemType, String plan, String description, String taxCode, boolean taxInclusive, PlanItemEnum.RecurringOn on, PlanItemEnum.Interval interval, Integer intervalCount, PlanItemEnum.Alignment alignment, ChargeModelInterface chargeModel, BillingTiming timing, PlanItemEnum.Interval durationInterval, Integer durationIntervalCount) {
        super(accountingCode, startEvent, chargeModel, name, PlanItemType.ItemType.RECURRING, timing, plan, description, taxCode, taxInclusive);
        this.on = on == null ? PlanItemEnum.RecurringOn.ACCOUNT_CYCLE_DATE : on;
        this.interval = interval == null ? PlanItemEnum.Interval.MONTH : interval;
        this.intervalCount = intervalCount == null ? 1 : intervalCount;
        this.alignment = alignment == null ? PlanItemEnum.Alignment.SUBSCRIPTION_PLAN_ITEM : alignment;
        this.durationInterval = durationInterval;
        this.durationIntervalCount = durationIntervalCount;
    }

    @Override
    public PlanItemType.ItemType getType() {
        return PlanItemType.ItemType.RECURRING;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static RecurringPlanItemBuilder recurringBuilder() {
        return new RecurringPlanItemBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RecurringPlanItemBuilder toBuilder() {
        return new RecurringPlanItemBuilder().accountingCode(this.accountingCode).startEvent(this.startEvent).name(this.name).planItemType(this.planItemType).plan(this.plan).description(this.description).taxCode(this.taxCode).taxInclusive(this.taxInclusive).on(this.on).interval(this.interval).intervalCount(this.intervalCount).alignment(this.alignment).chargeModel(this.chargeModel).timing(this.timing).durationInterval(this.durationInterval).durationIntervalCount(this.durationIntervalCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PlanItemEnum.RecurringOn getOn() {
        return this.on;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PlanItemEnum.Interval getInterval() {
        return this.interval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getIntervalCount() {
        return this.intervalCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PlanItemEnum.Alignment getAlignment() {
        return this.alignment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PlanItemEnum.Interval getDurationInterval() {
        return this.durationInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getDurationIntervalCount() {
        return this.durationIntervalCount;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "RecurringPlanItem(super=" + super.toString() + ", on=" + (Object)((Object)this.getOn()) + ", interval=" + (Object)((Object)this.getInterval()) + ", intervalCount=" + this.getIntervalCount() + ", alignment=" + (Object)((Object)this.getAlignment()) + ", durationInterval=" + (Object)((Object)this.getDurationInterval()) + ", durationIntervalCount=" + this.getDurationIntervalCount() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecurringPlanItem)) {
            return false;
        }
        RecurringPlanItem other = (RecurringPlanItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$intervalCount = this.getIntervalCount();
        Integer other$intervalCount = other.getIntervalCount();
        if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
            return false;
        }
        Integer this$durationIntervalCount = this.getDurationIntervalCount();
        Integer other$durationIntervalCount = other.getDurationIntervalCount();
        if (this$durationIntervalCount == null ? other$durationIntervalCount != null : !((Object)this$durationIntervalCount).equals(other$durationIntervalCount)) {
            return false;
        }
        PlanItemEnum.RecurringOn this$on = this.getOn();
        PlanItemEnum.RecurringOn other$on = other.getOn();
        if (this$on == null ? other$on != null : !((Object)((Object)this$on)).equals((Object)other$on)) {
            return false;
        }
        PlanItemEnum.Interval this$interval = this.getInterval();
        PlanItemEnum.Interval other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)((Object)this$interval)).equals((Object)other$interval)) {
            return false;
        }
        PlanItemEnum.Alignment this$alignment = this.getAlignment();
        PlanItemEnum.Alignment other$alignment = other.getAlignment();
        if (this$alignment == null ? other$alignment != null : !((Object)((Object)this$alignment)).equals((Object)other$alignment)) {
            return false;
        }
        PlanItemEnum.Interval this$durationInterval = this.getDurationInterval();
        PlanItemEnum.Interval other$durationInterval = other.getDurationInterval();
        return !(this$durationInterval == null ? other$durationInterval != null : !((Object)((Object)this$durationInterval)).equals((Object)other$durationInterval));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecurringPlanItem;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $intervalCount = this.getIntervalCount();
        result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
        Integer $durationIntervalCount = this.getDurationIntervalCount();
        result = result * 59 + ($durationIntervalCount == null ? 43 : ((Object)$durationIntervalCount).hashCode());
        PlanItemEnum.RecurringOn $on = this.getOn();
        result = result * 59 + ($on == null ? 43 : ((Object)((Object)$on)).hashCode());
        PlanItemEnum.Interval $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)((Object)$interval)).hashCode());
        PlanItemEnum.Alignment $alignment = this.getAlignment();
        result = result * 59 + ($alignment == null ? 43 : ((Object)((Object)$alignment)).hashCode());
        PlanItemEnum.Interval $durationInterval = this.getDurationInterval();
        result = result * 59 + ($durationInterval == null ? 43 : ((Object)((Object)$durationInterval)).hashCode());
        return result;
    }

    public static class RecurringPlanItemBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String accountingCode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PlanItemEnum.Event startEvent;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PlanItemType.ItemType planItemType;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String plan;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String taxCode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean taxInclusive;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PlanItemEnum.RecurringOn on;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PlanItemEnum.Interval interval;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer intervalCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PlanItemEnum.Alignment alignment;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ChargeModelInterface chargeModel;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private BillingTiming timing;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PlanItemEnum.Interval durationInterval;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer durationIntervalCount;
        private final EnumSet<ChargeModelInterface.Type> chargeModels = EnumSet.of(ChargeModelInterface.Type.FLAT_FEE, new ChargeModelInterface.Type[]{ChargeModelInterface.Type.PER_UNIT, ChargeModelInterface.Type.TIERED, ChargeModelInterface.Type.VOLUME, ChargeModelInterface.Type.DISCOUNT_PERCENTAGE, ChargeModelInterface.Type.DISCOUNT_AMOUNT});

        public RecurringPlanItemBuilder duration(PlanItemEnum.Interval endInterval, Integer endIntervalCount) {
            this.durationInterval = endInterval;
            this.durationIntervalCount = endIntervalCount;
            return this;
        }

        public RecurringPlanItemBuilder chargeModel(ChargeModelInterface chargeModel) {
            if (chargeModel != null && !this.chargeModels.contains((Object)chargeModel.getType())) {
                throw ZuoraSdkException.builder().message("Invalid Charge Model").build();
            }
            this.chargeModel = chargeModel;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder accountingCode(String accountingCode) {
            this.accountingCode = accountingCode;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder startEvent(PlanItemEnum.Event startEvent) {
            this.startEvent = startEvent;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder planItemType(PlanItemType.ItemType planItemType) {
            this.planItemType = planItemType;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder taxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder taxInclusive(boolean taxInclusive) {
            this.taxInclusive = taxInclusive;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder on(PlanItemEnum.RecurringOn on) {
            this.on = on;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder interval(PlanItemEnum.Interval interval) {
            this.interval = interval;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder intervalCount(Integer intervalCount) {
            this.intervalCount = intervalCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder alignment(PlanItemEnum.Alignment alignment) {
            this.alignment = alignment;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder timing(BillingTiming timing) {
            this.timing = timing;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder durationInterval(PlanItemEnum.Interval durationInterval) {
            this.durationInterval = durationInterval;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItemBuilder durationIntervalCount(Integer durationIntervalCount) {
            this.durationIntervalCount = durationIntervalCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RecurringPlanItem build() {
            return new RecurringPlanItem(this.accountingCode, this.startEvent, this.name, this.planItemType, this.plan, this.description, this.taxCode, this.taxInclusive, this.on, this.interval, this.intervalCount, this.alignment, this.chargeModel, this.timing, this.durationInterval, this.durationIntervalCount);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "RecurringPlanItem.RecurringPlanItemBuilder(accountingCode=" + this.accountingCode + ", startEvent=" + (Object)((Object)this.startEvent) + ", name=" + this.name + ", planItemType=" + (Object)((Object)this.planItemType) + ", plan=" + this.plan + ", description=" + this.description + ", taxCode=" + this.taxCode + ", taxInclusive=" + this.taxInclusive + ", on=" + (Object)((Object)this.on) + ", interval=" + (Object)((Object)this.interval) + ", intervalCount=" + this.intervalCount + ", alignment=" + (Object)((Object)this.alignment) + ", chargeModel=" + this.chargeModel + ", timing=" + this.timing + ", durationInterval=" + (Object)((Object)this.durationInterval) + ", durationIntervalCount=" + this.durationIntervalCount + ")";
        }
    }
}

