/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.BillingDocument;
import com.zuora.sdk.BillingDocumentSettings;
import com.zuora.sdk.Contact;
import com.zuora.sdk.HydratedZuoraObject;
import com.zuora.sdk.Payment;
import com.zuora.sdk.PaymentMethod;
import com.zuora.sdk.Subscription;
import com.zuora.sdk.TaxCertificate;
import com.zuora.sdk.TaxIdentifier;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.ZuoraObject;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

@ZuoraObject(name="account", namespace="com_zuora")
public final class Account
extends BaseFacade
implements HydratedZuoraObject {
    private final boolean enabled;
    private static final int MAX_RETURNED_OBJECTS = 1000;
    @NonNull
    private final String id;
    @NonNull
    private final String accountKey;
    private String name;
    private BillCycleDay billCycleDay;
    private final String currency;
    private Boolean autoPay;
    @NonNull
    private Contact billTo;
    private Contact soldTo;
    private String parentAccount;
    private String crmId;
    private String paymentTerms;
    private String description;
    private String batch;
    private final String balance;
    private final String contractedMrr;
    private final String creditBalance;
    private final String totalDebitMemoBalance;
    private final String totalInvoiceBalance;
    private final String unappliedCreditMemoAmount;
    private final String unappliedPaymentAmount;
    private final TaxIdentifier taxIdentifier;
    private final TaxCertificate taxCertificate;
    private final BillingDocumentSettings billingDocumentSettings;
    @NonNull
    final ZuoraClient client;
    private final Map<String, Object> customFields;

    public List<BillingDocument> getInvoices() throws ZuoraSdkException {
        return this.client.accounts().getInvoices(this);
    }

    public List<Subscription> getSubscriptions() throws ZuoraSdkException {
        return this.client.accounts().getSubscriptions(this);
    }

    public List<Payment> getPayments() {
        return this.client.accounts().getPayments(this, 1000);
    }

    public List<PaymentMethod> getPaymentMethods() {
        return this.client.accounts().getPaymentMethods(this);
    }

    public void update() {
        this.client.accounts().update(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Map<String, Object> $default$customFields() {
        return new HashMap<String, Object>();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Account(boolean enabled, @NonNull String id, @NonNull String accountKey, String name, BillCycleDay billCycleDay, String currency, Boolean autoPay, @NonNull Contact billTo, Contact soldTo, String parentAccount, String crmId, String paymentTerms, String description, String batch, String balance, String contractedMrr, String creditBalance, String totalDebitMemoBalance, String totalInvoiceBalance, String unappliedCreditMemoAmount, String unappliedPaymentAmount, TaxIdentifier taxIdentifier, TaxCertificate taxCertificate, BillingDocumentSettings billingDocumentSettings, @NonNull ZuoraClient client, Map<String, Object> customFields) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (accountKey == null) {
            throw new NullPointerException("accountKey is marked non-null but is null");
        }
        if (billTo == null) {
            throw new NullPointerException("billTo is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.enabled = enabled;
        this.id = id;
        this.accountKey = accountKey;
        this.name = name;
        this.billCycleDay = billCycleDay;
        this.currency = currency;
        this.autoPay = autoPay;
        this.billTo = billTo;
        this.soldTo = soldTo;
        this.parentAccount = parentAccount;
        this.crmId = crmId;
        this.paymentTerms = paymentTerms;
        this.description = description;
        this.batch = batch;
        this.balance = balance;
        this.contractedMrr = contractedMrr;
        this.creditBalance = creditBalance;
        this.totalDebitMemoBalance = totalDebitMemoBalance;
        this.totalInvoiceBalance = totalInvoiceBalance;
        this.unappliedCreditMemoAmount = unappliedCreditMemoAmount;
        this.unappliedPaymentAmount = unappliedPaymentAmount;
        this.taxIdentifier = taxIdentifier;
        this.taxCertificate = taxCertificate;
        this.billingDocumentSettings = billingDocumentSettings;
        this.client = client;
        this.customFields = customFields;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    static AccountBuilder builder() {
        return new AccountBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    AccountBuilder toBuilder() {
        return new AccountBuilder().enabled(this.enabled).id(this.id).accountKey(this.accountKey).name(this.name).billCycleDay(this.billCycleDay).currency(this.currency).autoPay(this.autoPay).billTo(this.billTo).soldTo(this.soldTo).parentAccount(this.parentAccount).crmId(this.crmId).paymentTerms(this.paymentTerms).description(this.description).batch(this.batch).balance(this.balance).contractedMrr(this.contractedMrr).creditBalance(this.creditBalance).totalDebitMemoBalance(this.totalDebitMemoBalance).totalInvoiceBalance(this.totalInvoiceBalance).unappliedCreditMemoAmount(this.unappliedCreditMemoAmount).unappliedPaymentAmount(this.unappliedPaymentAmount).taxIdentifier(this.taxIdentifier).taxCertificate(this.taxCertificate).billingDocumentSettings(this.billingDocumentSettings).client(this.client).customFields(this.customFields);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAccountKey() {
        return this.accountKey;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BillCycleDay getBillCycleDay() {
        return this.billCycleDay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getAutoPay() {
        return this.autoPay;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Contact getBillTo() {
        return this.billTo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Contact getSoldTo() {
        return this.soldTo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getParentAccount() {
        return this.parentAccount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCrmId() {
        return this.crmId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getBatch() {
        return this.batch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getBalance() {
        return this.balance;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getContractedMrr() {
        return this.contractedMrr;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCreditBalance() {
        return this.creditBalance;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTotalDebitMemoBalance() {
        return this.totalDebitMemoBalance;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTotalInvoiceBalance() {
        return this.totalInvoiceBalance;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUnappliedCreditMemoAmount() {
        return this.unappliedCreditMemoAmount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUnappliedPaymentAmount() {
        return this.unappliedPaymentAmount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TaxIdentifier getTaxIdentifier() {
        return this.taxIdentifier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TaxCertificate getTaxCertificate() {
        return this.taxCertificate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BillingDocumentSettings getBillingDocumentSettings() {
        return this.billingDocumentSettings;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZuoraClient getClient() {
        return this.client;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Boolean this$autoPay = this.getAutoPay();
        Boolean other$autoPay = other.getAutoPay();
        if (this$autoPay == null ? other$autoPay != null : !((Object)this$autoPay).equals(other$autoPay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$accountKey = this.getAccountKey();
        String other$accountKey = other.getAccountKey();
        if (this$accountKey == null ? other$accountKey != null : !this$accountKey.equals(other$accountKey)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BillCycleDay this$billCycleDay = this.getBillCycleDay();
        BillCycleDay other$billCycleDay = other.getBillCycleDay();
        if (this$billCycleDay == null ? other$billCycleDay != null : !((Object)((Object)this$billCycleDay)).equals((Object)other$billCycleDay)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Contact this$billTo = this.getBillTo();
        Contact other$billTo = other.getBillTo();
        if (this$billTo == null ? other$billTo != null : !((Object)this$billTo).equals(other$billTo)) {
            return false;
        }
        Contact this$soldTo = this.getSoldTo();
        Contact other$soldTo = other.getSoldTo();
        if (this$soldTo == null ? other$soldTo != null : !((Object)this$soldTo).equals(other$soldTo)) {
            return false;
        }
        String this$parentAccount = this.getParentAccount();
        String other$parentAccount = other.getParentAccount();
        if (this$parentAccount == null ? other$parentAccount != null : !this$parentAccount.equals(other$parentAccount)) {
            return false;
        }
        String this$crmId = this.getCrmId();
        String other$crmId = other.getCrmId();
        if (this$crmId == null ? other$crmId != null : !this$crmId.equals(other$crmId)) {
            return false;
        }
        String this$paymentTerms = this.getPaymentTerms();
        String other$paymentTerms = other.getPaymentTerms();
        if (this$paymentTerms == null ? other$paymentTerms != null : !this$paymentTerms.equals(other$paymentTerms)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$batch = this.getBatch();
        String other$batch = other.getBatch();
        if (this$batch == null ? other$batch != null : !this$batch.equals(other$batch)) {
            return false;
        }
        String this$balance = this.getBalance();
        String other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) {
            return false;
        }
        String this$contractedMrr = this.getContractedMrr();
        String other$contractedMrr = other.getContractedMrr();
        if (this$contractedMrr == null ? other$contractedMrr != null : !this$contractedMrr.equals(other$contractedMrr)) {
            return false;
        }
        String this$creditBalance = this.getCreditBalance();
        String other$creditBalance = other.getCreditBalance();
        if (this$creditBalance == null ? other$creditBalance != null : !this$creditBalance.equals(other$creditBalance)) {
            return false;
        }
        String this$totalDebitMemoBalance = this.getTotalDebitMemoBalance();
        String other$totalDebitMemoBalance = other.getTotalDebitMemoBalance();
        if (this$totalDebitMemoBalance == null ? other$totalDebitMemoBalance != null : !this$totalDebitMemoBalance.equals(other$totalDebitMemoBalance)) {
            return false;
        }
        String this$totalInvoiceBalance = this.getTotalInvoiceBalance();
        String other$totalInvoiceBalance = other.getTotalInvoiceBalance();
        if (this$totalInvoiceBalance == null ? other$totalInvoiceBalance != null : !this$totalInvoiceBalance.equals(other$totalInvoiceBalance)) {
            return false;
        }
        String this$unappliedCreditMemoAmount = this.getUnappliedCreditMemoAmount();
        String other$unappliedCreditMemoAmount = other.getUnappliedCreditMemoAmount();
        if (this$unappliedCreditMemoAmount == null ? other$unappliedCreditMemoAmount != null : !this$unappliedCreditMemoAmount.equals(other$unappliedCreditMemoAmount)) {
            return false;
        }
        String this$unappliedPaymentAmount = this.getUnappliedPaymentAmount();
        String other$unappliedPaymentAmount = other.getUnappliedPaymentAmount();
        if (this$unappliedPaymentAmount == null ? other$unappliedPaymentAmount != null : !this$unappliedPaymentAmount.equals(other$unappliedPaymentAmount)) {
            return false;
        }
        TaxIdentifier this$taxIdentifier = this.getTaxIdentifier();
        TaxIdentifier other$taxIdentifier = other.getTaxIdentifier();
        if (this$taxIdentifier == null ? other$taxIdentifier != null : !((Object)this$taxIdentifier).equals(other$taxIdentifier)) {
            return false;
        }
        TaxCertificate this$taxCertificate = this.getTaxCertificate();
        TaxCertificate other$taxCertificate = other.getTaxCertificate();
        if (this$taxCertificate == null ? other$taxCertificate != null : !((Object)this$taxCertificate).equals(other$taxCertificate)) {
            return false;
        }
        BillingDocumentSettings this$billingDocumentSettings = this.getBillingDocumentSettings();
        BillingDocumentSettings other$billingDocumentSettings = other.getBillingDocumentSettings();
        if (this$billingDocumentSettings == null ? other$billingDocumentSettings != null : !((Object)this$billingDocumentSettings).equals(other$billingDocumentSettings)) {
            return false;
        }
        ZuoraClient this$client = this.getClient();
        ZuoraClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        Map<String, Object> this$customFields = this.getCustomFields();
        Map<String, Object> other$customFields = other.getCustomFields();
        return !(this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Boolean $autoPay = this.getAutoPay();
        result = result * 59 + ($autoPay == null ? 43 : ((Object)$autoPay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $accountKey = this.getAccountKey();
        result = result * 59 + ($accountKey == null ? 43 : $accountKey.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BillCycleDay $billCycleDay = this.getBillCycleDay();
        result = result * 59 + ($billCycleDay == null ? 43 : ((Object)((Object)$billCycleDay)).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Contact $billTo = this.getBillTo();
        result = result * 59 + ($billTo == null ? 43 : ((Object)$billTo).hashCode());
        Contact $soldTo = this.getSoldTo();
        result = result * 59 + ($soldTo == null ? 43 : ((Object)$soldTo).hashCode());
        String $parentAccount = this.getParentAccount();
        result = result * 59 + ($parentAccount == null ? 43 : $parentAccount.hashCode());
        String $crmId = this.getCrmId();
        result = result * 59 + ($crmId == null ? 43 : $crmId.hashCode());
        String $paymentTerms = this.getPaymentTerms();
        result = result * 59 + ($paymentTerms == null ? 43 : $paymentTerms.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $batch = this.getBatch();
        result = result * 59 + ($batch == null ? 43 : $batch.hashCode());
        String $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : $balance.hashCode());
        String $contractedMrr = this.getContractedMrr();
        result = result * 59 + ($contractedMrr == null ? 43 : $contractedMrr.hashCode());
        String $creditBalance = this.getCreditBalance();
        result = result * 59 + ($creditBalance == null ? 43 : $creditBalance.hashCode());
        String $totalDebitMemoBalance = this.getTotalDebitMemoBalance();
        result = result * 59 + ($totalDebitMemoBalance == null ? 43 : $totalDebitMemoBalance.hashCode());
        String $totalInvoiceBalance = this.getTotalInvoiceBalance();
        result = result * 59 + ($totalInvoiceBalance == null ? 43 : $totalInvoiceBalance.hashCode());
        String $unappliedCreditMemoAmount = this.getUnappliedCreditMemoAmount();
        result = result * 59 + ($unappliedCreditMemoAmount == null ? 43 : $unappliedCreditMemoAmount.hashCode());
        String $unappliedPaymentAmount = this.getUnappliedPaymentAmount();
        result = result * 59 + ($unappliedPaymentAmount == null ? 43 : $unappliedPaymentAmount.hashCode());
        TaxIdentifier $taxIdentifier = this.getTaxIdentifier();
        result = result * 59 + ($taxIdentifier == null ? 43 : ((Object)$taxIdentifier).hashCode());
        TaxCertificate $taxCertificate = this.getTaxCertificate();
        result = result * 59 + ($taxCertificate == null ? 43 : ((Object)$taxCertificate).hashCode());
        BillingDocumentSettings $billingDocumentSettings = this.getBillingDocumentSettings();
        result = result * 59 + ($billingDocumentSettings == null ? 43 : ((Object)$billingDocumentSettings).hashCode());
        ZuoraClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        Map<String, Object> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Account(enabled=" + this.isEnabled() + ", id=" + this.getId() + ", accountKey=" + this.getAccountKey() + ", name=" + this.getName() + ", billCycleDay=" + (Object)((Object)this.getBillCycleDay()) + ", currency=" + this.getCurrency() + ", autoPay=" + this.getAutoPay() + ", billTo=" + this.getBillTo() + ", soldTo=" + this.getSoldTo() + ", parentAccount=" + this.getParentAccount() + ", crmId=" + this.getCrmId() + ", paymentTerms=" + this.getPaymentTerms() + ", description=" + this.getDescription() + ", batch=" + this.getBatch() + ", balance=" + this.getBalance() + ", contractedMrr=" + this.getContractedMrr() + ", creditBalance=" + this.getCreditBalance() + ", totalDebitMemoBalance=" + this.getTotalDebitMemoBalance() + ", totalInvoiceBalance=" + this.getTotalInvoiceBalance() + ", unappliedCreditMemoAmount=" + this.getUnappliedCreditMemoAmount() + ", unappliedPaymentAmount=" + this.getUnappliedPaymentAmount() + ", taxIdentifier=" + this.getTaxIdentifier() + ", taxCertificate=" + this.getTaxCertificate() + ", billingDocumentSettings=" + this.getBillingDocumentSettings() + ", client=" + this.getClient() + ", customFields=" + this.getCustomFields() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setBillCycleDay(BillCycleDay billCycleDay) {
        this.billCycleDay = billCycleDay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAutoPay(Boolean autoPay) {
        this.autoPay = autoPay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setBillTo(@NonNull Contact billTo) {
        if (billTo == null) {
            throw new NullPointerException("billTo is marked non-null but is null");
        }
        this.billTo = billTo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSoldTo(Contact soldTo) {
        this.soldTo = soldTo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setParentAccount(String parentAccount) {
        this.parentAccount = parentAccount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCrmId(String crmId) {
        this.crmId = crmId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setBatch(String batch) {
        this.batch = batch;
    }

    public static enum BillCycleDay {
        AUTO_SET(0),
        _1(1),
        _2(2),
        _3(3),
        _4(4),
        _5(5),
        _6(6),
        _7(7),
        _8(8),
        _9(9),
        _10(10),
        _11(11),
        _12(12),
        _13(13),
        _14(14),
        _15(15),
        _16(16),
        _17(17),
        _18(18),
        _19(19),
        _20(20),
        _21(21),
        _22(22),
        _23(23),
        _24(24),
        _25(25),
        _26(26),
        _27(27),
        _28(28),
        _29(29),
        _30(30),
        _31(31);

        private final int value;

        private BillCycleDay(int value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getValue() {
            return this.value;
        }
    }

    public static class AccountBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enabled;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String accountKey;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private BillCycleDay billCycleDay;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String currency;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean autoPay;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Contact billTo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Contact soldTo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String parentAccount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String crmId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String paymentTerms;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String batch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String balance;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String contractedMrr;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String creditBalance;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String totalDebitMemoBalance;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String totalInvoiceBalance;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String unappliedCreditMemoAmount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String unappliedPaymentAmount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private TaxIdentifier taxIdentifier;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private TaxCertificate taxCertificate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private BillingDocumentSettings billingDocumentSettings;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZuoraClient client;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean customFields$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, Object> customFields$value;

        AccountBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder accountKey(@NonNull String accountKey) {
            if (accountKey == null) {
                throw new NullPointerException("accountKey is marked non-null but is null");
            }
            this.accountKey = accountKey;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder billCycleDay(BillCycleDay billCycleDay) {
            this.billCycleDay = billCycleDay;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder autoPay(Boolean autoPay) {
            this.autoPay = autoPay;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder billTo(@NonNull Contact billTo) {
            if (billTo == null) {
                throw new NullPointerException("billTo is marked non-null but is null");
            }
            this.billTo = billTo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder soldTo(Contact soldTo) {
            this.soldTo = soldTo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder parentAccount(String parentAccount) {
            this.parentAccount = parentAccount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder crmId(String crmId) {
            this.crmId = crmId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder paymentTerms(String paymentTerms) {
            this.paymentTerms = paymentTerms;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder batch(String batch) {
            this.batch = batch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder balance(String balance) {
            this.balance = balance;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder contractedMrr(String contractedMrr) {
            this.contractedMrr = contractedMrr;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder creditBalance(String creditBalance) {
            this.creditBalance = creditBalance;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder totalDebitMemoBalance(String totalDebitMemoBalance) {
            this.totalDebitMemoBalance = totalDebitMemoBalance;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder totalInvoiceBalance(String totalInvoiceBalance) {
            this.totalInvoiceBalance = totalInvoiceBalance;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder unappliedCreditMemoAmount(String unappliedCreditMemoAmount) {
            this.unappliedCreditMemoAmount = unappliedCreditMemoAmount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder unappliedPaymentAmount(String unappliedPaymentAmount) {
            this.unappliedPaymentAmount = unappliedPaymentAmount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder taxIdentifier(TaxIdentifier taxIdentifier) {
            this.taxIdentifier = taxIdentifier;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder taxCertificate(TaxCertificate taxCertificate) {
            this.taxCertificate = taxCertificate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder billingDocumentSettings(BillingDocumentSettings billingDocumentSettings) {
            this.billingDocumentSettings = billingDocumentSettings;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder client(@NonNull ZuoraClient client) {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.client = client;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AccountBuilder customFields(Map<String, Object> customFields) {
            this.customFields$value = customFields;
            this.customFields$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Account build() {
            Map customFields$value = this.customFields$value;
            if (!this.customFields$set) {
                customFields$value = Account.$default$customFields();
            }
            return new Account(this.enabled, this.id, this.accountKey, this.name, this.billCycleDay, this.currency, this.autoPay, this.billTo, this.soldTo, this.parentAccount, this.crmId, this.paymentTerms, this.description, this.batch, this.balance, this.contractedMrr, this.creditBalance, this.totalDebitMemoBalance, this.totalInvoiceBalance, this.unappliedCreditMemoAmount, this.unappliedPaymentAmount, this.taxIdentifier, this.taxCertificate, this.billingDocumentSettings, this.client, customFields$value);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Account.AccountBuilder(enabled=" + this.enabled + ", id=" + this.id + ", accountKey=" + this.accountKey + ", name=" + this.name + ", billCycleDay=" + (Object)((Object)this.billCycleDay) + ", currency=" + this.currency + ", autoPay=" + this.autoPay + ", billTo=" + this.billTo + ", soldTo=" + this.soldTo + ", parentAccount=" + this.parentAccount + ", crmId=" + this.crmId + ", paymentTerms=" + this.paymentTerms + ", description=" + this.description + ", batch=" + this.batch + ", balance=" + this.balance + ", contractedMrr=" + this.contractedMrr + ", creditBalance=" + this.creditBalance + ", totalDebitMemoBalance=" + this.totalDebitMemoBalance + ", totalInvoiceBalance=" + this.totalInvoiceBalance + ", unappliedCreditMemoAmount=" + this.unappliedCreditMemoAmount + ", unappliedPaymentAmount=" + this.unappliedPaymentAmount + ", taxIdentifier=" + this.taxIdentifier + ", taxCertificate=" + this.taxCertificate + ", billingDocumentSettings=" + this.billingDocumentSettings + ", client=" + this.client + ", customFields$value=" + this.customFields$value + ")";
        }
    }
}

