/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CreatePaymentMethodUpdaterBatchRequest;
import com.zuora.model.CreatePaymentMethodUpdaterBatchResponse;
import com.zuora.model.PaymentMethodUpdaterInstancesResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PaymentMethodUpdaterApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentMethodUpdaterApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentMethodUpdaterApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createPaymentMethodUpdaterBatchCall(CreatePaymentMethodUpdaterBatchRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePaymentMethodUpdaterBatchRequest localVarPostBody = request;
        String localVarPath = "/v1/payment-method-updaters/batches";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentMethodUpdaterBatchValidateBeforeCall(CreatePaymentMethodUpdaterBatchRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createPaymentMethodUpdaterBatch(Async)");
        }
        return this.createPaymentMethodUpdaterBatchCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected CreatePaymentMethodUpdaterBatchResponse createPaymentMethodUpdaterBatch(CreatePaymentMethodUpdaterBatchRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<CreatePaymentMethodUpdaterBatchResponse> localVarResp = this.createPaymentMethodUpdaterBatchWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<CreatePaymentMethodUpdaterBatchResponse> createPaymentMethodUpdaterBatchWithHttpInfo(CreatePaymentMethodUpdaterBatchRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.createPaymentMethodUpdaterBatchValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<CreatePaymentMethodUpdaterBatchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createPaymentMethodUpdaterBatchAsync(CreatePaymentMethodUpdaterBatchRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<CreatePaymentMethodUpdaterBatchResponse> _callback) throws ApiException {
        Call localVarCall = this.createPaymentMethodUpdaterBatchValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<CreatePaymentMethodUpdaterBatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentMethodUpdaterBatchApi createPaymentMethodUpdaterBatchApi(CreatePaymentMethodUpdaterBatchRequest request) {
        return new CreatePaymentMethodUpdaterBatchApi(request);
    }

    private Call getPaymentMethodUpdaterInstancesCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-method-updaters";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentMethodUpdaterInstancesValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        return this.getPaymentMethodUpdaterInstancesCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected PaymentMethodUpdaterInstancesResponse getPaymentMethodUpdaterInstances(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<PaymentMethodUpdaterInstancesResponse> localVarResp = this.getPaymentMethodUpdaterInstancesWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentMethodUpdaterInstancesResponse> getPaymentMethodUpdaterInstancesWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getPaymentMethodUpdaterInstancesValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<PaymentMethodUpdaterInstancesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentMethodUpdaterInstancesAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<PaymentMethodUpdaterInstancesResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentMethodUpdaterInstancesValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethodUpdaterInstancesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentMethodUpdaterInstancesApi getPaymentMethodUpdaterInstancesApi() {
        return new GetPaymentMethodUpdaterInstancesApi();
    }

    public class GetPaymentMethodUpdaterInstancesApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetPaymentMethodUpdaterInstancesApi() {
        }

        public GetPaymentMethodUpdaterInstancesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentMethodUpdaterInstancesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentMethodUpdaterInstancesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentMethodUpdaterInstancesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentMethodUpdaterInstancesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentMethodUpdaterInstancesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentMethodUpdaterInstancesApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetPaymentMethodUpdaterInstancesApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodUpdaterApi.this.getPaymentMethodUpdaterInstancesCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public PaymentMethodUpdaterInstancesResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentMethodUpdaterApi.this.getPaymentMethodUpdaterInstancesWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (PaymentMethodUpdaterInstancesResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentMethodUpdaterInstancesResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodUpdaterApi.this.getPaymentMethodUpdaterInstancesWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<PaymentMethodUpdaterInstancesResponse> _callback) throws ApiException {
            return PaymentMethodUpdaterApi.this.getPaymentMethodUpdaterInstancesAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class CreatePaymentMethodUpdaterBatchApi {
        private final CreatePaymentMethodUpdaterBatchRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private CreatePaymentMethodUpdaterBatchApi(CreatePaymentMethodUpdaterBatchRequest request) {
            this.request = request;
        }

        public CreatePaymentMethodUpdaterBatchApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreatePaymentMethodUpdaterBatchApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreatePaymentMethodUpdaterBatchApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreatePaymentMethodUpdaterBatchApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreatePaymentMethodUpdaterBatchApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreatePaymentMethodUpdaterBatchApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreatePaymentMethodUpdaterBatchApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreatePaymentMethodUpdaterBatchApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public CreatePaymentMethodUpdaterBatchApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodUpdaterApi.this.createPaymentMethodUpdaterBatchCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public CreatePaymentMethodUpdaterBatchResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentMethodUpdaterApi.this.createPaymentMethodUpdaterBatchWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (CreatePaymentMethodUpdaterBatchResponse)localVarResp.getData();
        }

        private ApiResponse<CreatePaymentMethodUpdaterBatchResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodUpdaterApi.this.createPaymentMethodUpdaterBatchWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<CreatePaymentMethodUpdaterBatchResponse> _callback) throws ApiException {
            return PaymentMethodUpdaterApi.this.createPaymentMethodUpdaterBatchAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }
}

